# coding: utf-8
# Copyright (c) 2016, 2026, Oracle and/or its affiliates.  All rights reserved.
# This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.

# NOTE: This class is auto generated by OracleSDKGenerator. DO NOT EDIT. API Version: 20200131


from oci.util import formatted_flat_dict, NONE_SENTINEL, value_allowed_none_or_none_sentinel  # noqa: F401
from oci.decorators import init_model_state_from_kwargs


@init_model_state_from_kwargs
class AdhocQueryResultSummary(object):
    """
    Adhoc query result resource from running on a resource.
    """

    #: A constant which can be used with the state property of a AdhocQueryResultSummary.
    #: This constant has a value of "ACCEPTED"
    STATE_ACCEPTED = "ACCEPTED"

    #: A constant which can be used with the state property of a AdhocQueryResultSummary.
    #: This constant has a value of "CREATED"
    STATE_CREATED = "CREATED"

    #: A constant which can be used with the state property of a AdhocQueryResultSummary.
    #: This constant has a value of "IN_PROGRESS"
    STATE_IN_PROGRESS = "IN_PROGRESS"

    #: A constant which can be used with the state property of a AdhocQueryResultSummary.
    #: This constant has a value of "COMPLETED"
    STATE_COMPLETED = "COMPLETED"

    #: A constant which can be used with the state property of a AdhocQueryResultSummary.
    #: This constant has a value of "PARTIALLY_COMPLETED"
    STATE_PARTIALLY_COMPLETED = "PARTIALLY_COMPLETED"

    #: A constant which can be used with the state property of a AdhocQueryResultSummary.
    #: This constant has a value of "FAILED"
    STATE_FAILED = "FAILED"

    #: A constant which can be used with the state property of a AdhocQueryResultSummary.
    #: This constant has a value of "EXPIRED"
    STATE_EXPIRED = "EXPIRED"

    def __init__(self, **kwargs):
        """
        Initializes a new AdhocQueryResultSummary object with values from keyword arguments.
        The following keyword arguments are supported (corresponding to the getters/setters of this class):

        :param host_id:
            The value to assign to the host_id property of this AdhocQueryResultSummary.
        :type host_id: str

        :param state:
            The value to assign to the state property of this AdhocQueryResultSummary.
            Allowed values for this property are: "ACCEPTED", "CREATED", "IN_PROGRESS", "COMPLETED", "PARTIALLY_COMPLETED", "FAILED", "EXPIRED", 'UNKNOWN_ENUM_VALUE'.
            Any unrecognized values returned by a service will be mapped to 'UNKNOWN_ENUM_VALUE'.
        :type state: str

        :param region:
            The value to assign to the region property of this AdhocQueryResultSummary.
        :type region: str

        :param time_submitted:
            The value to assign to the time_submitted property of this AdhocQueryResultSummary.
        :type time_submitted: datetime

        :param error_message:
            The value to assign to the error_message property of this AdhocQueryResultSummary.
        :type error_message: str

        :param result_count:
            The value to assign to the result_count property of this AdhocQueryResultSummary.
        :type result_count: int

        :param result:
            The value to assign to the result property of this AdhocQueryResultSummary.
        :type result: list[dict(str, str)]

        :param freeform_tags:
            The value to assign to the freeform_tags property of this AdhocQueryResultSummary.
        :type freeform_tags: dict(str, str)

        :param defined_tags:
            The value to assign to the defined_tags property of this AdhocQueryResultSummary.
        :type defined_tags: dict(str, dict(str, object))

        :param system_tags:
            The value to assign to the system_tags property of this AdhocQueryResultSummary.
        :type system_tags: dict(str, dict(str, object))

        """
        self.swagger_types = {
            'host_id': 'str',
            'state': 'str',
            'region': 'str',
            'time_submitted': 'datetime',
            'error_message': 'str',
            'result_count': 'int',
            'result': 'list[dict(str, str)]',
            'freeform_tags': 'dict(str, str)',
            'defined_tags': 'dict(str, dict(str, object))',
            'system_tags': 'dict(str, dict(str, object))'
        }
        self.attribute_map = {
            'host_id': 'hostId',
            'state': 'state',
            'region': 'region',
            'time_submitted': 'timeSubmitted',
            'error_message': 'errorMessage',
            'result_count': 'resultCount',
            'result': 'result',
            'freeform_tags': 'freeformTags',
            'defined_tags': 'definedTags',
            'system_tags': 'systemTags'
        }
        self._host_id = None
        self._state = None
        self._region = None
        self._time_submitted = None
        self._error_message = None
        self._result_count = None
        self._result = None
        self._freeform_tags = None
        self._defined_tags = None
        self._system_tags = None

    @property
    def host_id(self):
        """
        **[Required]** Gets the host_id of this AdhocQueryResultSummary.
        Resource this result belongs to


        :return: The host_id of this AdhocQueryResultSummary.
        :rtype: str
        """
        return self._host_id

    @host_id.setter
    def host_id(self, host_id):
        """
        Sets the host_id of this AdhocQueryResultSummary.
        Resource this result belongs to


        :param host_id: The host_id of this AdhocQueryResultSummary.
        :type: str
        """
        self._host_id = host_id

    @property
    def state(self):
        """
        **[Required]** Gets the state of this AdhocQueryResultSummary.
        Status of the query

        Allowed values for this property are: "ACCEPTED", "CREATED", "IN_PROGRESS", "COMPLETED", "PARTIALLY_COMPLETED", "FAILED", "EXPIRED", 'UNKNOWN_ENUM_VALUE'.
        Any unrecognized values returned by a service will be mapped to 'UNKNOWN_ENUM_VALUE'.


        :return: The state of this AdhocQueryResultSummary.
        :rtype: str
        """
        return self._state

    @state.setter
    def state(self, state):
        """
        Sets the state of this AdhocQueryResultSummary.
        Status of the query


        :param state: The state of this AdhocQueryResultSummary.
        :type: str
        """
        allowed_values = ["ACCEPTED", "CREATED", "IN_PROGRESS", "COMPLETED", "PARTIALLY_COMPLETED", "FAILED", "EXPIRED"]
        if not value_allowed_none_or_none_sentinel(state, allowed_values):
            state = 'UNKNOWN_ENUM_VALUE'
        self._state = state

    @property
    def region(self):
        """
        **[Required]** Gets the region of this AdhocQueryResultSummary.
        The region this adhoc work request is running in, needed for tracking when work request is synced to reporting region


        :return: The region of this AdhocQueryResultSummary.
        :rtype: str
        """
        return self._region

    @region.setter
    def region(self, region):
        """
        Sets the region of this AdhocQueryResultSummary.
        The region this adhoc work request is running in, needed for tracking when work request is synced to reporting region


        :param region: The region of this AdhocQueryResultSummary.
        :type: str
        """
        self._region = region

    @property
    def time_submitted(self):
        """
        Gets the time_submitted of this AdhocQueryResultSummary.
        The time the adhoc result was submitted. An RFC3339 formatted datetime string


        :return: The time_submitted of this AdhocQueryResultSummary.
        :rtype: datetime
        """
        return self._time_submitted

    @time_submitted.setter
    def time_submitted(self, time_submitted):
        """
        Sets the time_submitted of this AdhocQueryResultSummary.
        The time the adhoc result was submitted. An RFC3339 formatted datetime string


        :param time_submitted: The time_submitted of this AdhocQueryResultSummary.
        :type: datetime
        """
        self._time_submitted = time_submitted

    @property
    def error_message(self):
        """
        Gets the error_message of this AdhocQueryResultSummary.
        Optional error message


        :return: The error_message of this AdhocQueryResultSummary.
        :rtype: str
        """
        return self._error_message

    @error_message.setter
    def error_message(self, error_message):
        """
        Sets the error_message of this AdhocQueryResultSummary.
        Optional error message


        :param error_message: The error_message of this AdhocQueryResultSummary.
        :type: str
        """
        self._error_message = error_message

    @property
    def result_count(self):
        """
        Gets the result_count of this AdhocQueryResultSummary.
        Number of records returned for the query results on this host


        :return: The result_count of this AdhocQueryResultSummary.
        :rtype: int
        """
        return self._result_count

    @result_count.setter
    def result_count(self, result_count):
        """
        Sets the result_count of this AdhocQueryResultSummary.
        Number of records returned for the query results on this host


        :param result_count: The result_count of this AdhocQueryResultSummary.
        :type: int
        """
        self._result_count = result_count

    @property
    def result(self):
        """
        Gets the result of this AdhocQueryResultSummary.
        Result of the adhoc query this result resource is associated with


        :return: The result of this AdhocQueryResultSummary.
        :rtype: list[dict(str, str)]
        """
        return self._result

    @result.setter
    def result(self, result):
        """
        Sets the result of this AdhocQueryResultSummary.
        Result of the adhoc query this result resource is associated with


        :param result: The result of this AdhocQueryResultSummary.
        :type: list[dict(str, str)]
        """
        self._result = result

    @property
    def freeform_tags(self):
        """
        Gets the freeform_tags of this AdhocQueryResultSummary.
        Simple key-value pair that is applied without any predefined name, type or scope. Exists for cross-compatibility only.
        Example: `{\"bar-key\": \"value\"}`

        Avoid entering confidential information.


        :return: The freeform_tags of this AdhocQueryResultSummary.
        :rtype: dict(str, str)
        """
        return self._freeform_tags

    @freeform_tags.setter
    def freeform_tags(self, freeform_tags):
        """
        Sets the freeform_tags of this AdhocQueryResultSummary.
        Simple key-value pair that is applied without any predefined name, type or scope. Exists for cross-compatibility only.
        Example: `{\"bar-key\": \"value\"}`

        Avoid entering confidential information.


        :param freeform_tags: The freeform_tags of this AdhocQueryResultSummary.
        :type: dict(str, str)
        """
        self._freeform_tags = freeform_tags

    @property
    def defined_tags(self):
        """
        Gets the defined_tags of this AdhocQueryResultSummary.
        Defined tags for this resource. Each key is predefined and scoped to a namespace.
        Example: `{\"foo-namespace\": {\"bar-key\": \"value\"}}`


        :return: The defined_tags of this AdhocQueryResultSummary.
        :rtype: dict(str, dict(str, object))
        """
        return self._defined_tags

    @defined_tags.setter
    def defined_tags(self, defined_tags):
        """
        Sets the defined_tags of this AdhocQueryResultSummary.
        Defined tags for this resource. Each key is predefined and scoped to a namespace.
        Example: `{\"foo-namespace\": {\"bar-key\": \"value\"}}`


        :param defined_tags: The defined_tags of this AdhocQueryResultSummary.
        :type: dict(str, dict(str, object))
        """
        self._defined_tags = defined_tags

    @property
    def system_tags(self):
        """
        Gets the system_tags of this AdhocQueryResultSummary.
        System tags for this resource. Each key is predefined and scoped to a namespace.
        For more information, see `Resource Tags`__.
        System tags can be viewed by users, but can only be created by the system.

        Example: `{\"orcl-cloud\": {\"free-tier-retained\": \"true\"}}`

        __ https://docs.cloud.oracle.com/Content/General/Concepts/resourcetags.htm


        :return: The system_tags of this AdhocQueryResultSummary.
        :rtype: dict(str, dict(str, object))
        """
        return self._system_tags

    @system_tags.setter
    def system_tags(self, system_tags):
        """
        Sets the system_tags of this AdhocQueryResultSummary.
        System tags for this resource. Each key is predefined and scoped to a namespace.
        For more information, see `Resource Tags`__.
        System tags can be viewed by users, but can only be created by the system.

        Example: `{\"orcl-cloud\": {\"free-tier-retained\": \"true\"}}`

        __ https://docs.cloud.oracle.com/Content/General/Concepts/resourcetags.htm


        :param system_tags: The system_tags of this AdhocQueryResultSummary.
        :type: dict(str, dict(str, object))
        """
        self._system_tags = system_tags

    def __repr__(self):
        return formatted_flat_dict(self)

    def __eq__(self, other):
        if other is None:
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not self == other
