# coding: utf-8
# Copyright (c) 2016, 2026, Oracle and/or its affiliates.  All rights reserved.
# This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.

# NOTE: This class is auto generated by OracleSDKGenerator. DO NOT EDIT. API Version: 20160918


from oci.util import formatted_flat_dict, NONE_SENTINEL, value_allowed_none_or_none_sentinel  # noqa: F401
from oci.decorators import init_model_state_from_kwargs


@init_model_state_from_kwargs
class ModifyIpv4SubnetCidrDetails(object):
    """
    Details object for updating the specified Ipv4 CIDR block of a Subnet.
    """

    def __init__(self, **kwargs):
        """
        Initializes a new ModifyIpv4SubnetCidrDetails object with values from keyword arguments.
        The following keyword arguments are supported (corresponding to the getters/setters of this class):

        :param ipv4_cidr_block:
            The value to assign to the ipv4_cidr_block property of this ModifyIpv4SubnetCidrDetails.
        :type ipv4_cidr_block: str

        :param updated_ipv4_cidr_block:
            The value to assign to the updated_ipv4_cidr_block property of this ModifyIpv4SubnetCidrDetails.
        :type updated_ipv4_cidr_block: str

        """
        self.swagger_types = {
            'ipv4_cidr_block': 'str',
            'updated_ipv4_cidr_block': 'str'
        }
        self.attribute_map = {
            'ipv4_cidr_block': 'ipv4CidrBlock',
            'updated_ipv4_cidr_block': 'updatedIpv4CidrBlock'
        }
        self._ipv4_cidr_block = None
        self._updated_ipv4_cidr_block = None

    @property
    def ipv4_cidr_block(self):
        """
        **[Required]** Gets the ipv4_cidr_block of this ModifyIpv4SubnetCidrDetails.
        The Ipv4 CIDR IP address to update.


        :return: The ipv4_cidr_block of this ModifyIpv4SubnetCidrDetails.
        :rtype: str
        """
        return self._ipv4_cidr_block

    @ipv4_cidr_block.setter
    def ipv4_cidr_block(self, ipv4_cidr_block):
        """
        Sets the ipv4_cidr_block of this ModifyIpv4SubnetCidrDetails.
        The Ipv4 CIDR IP address to update.


        :param ipv4_cidr_block: The ipv4_cidr_block of this ModifyIpv4SubnetCidrDetails.
        :type: str
        """
        self._ipv4_cidr_block = ipv4_cidr_block

    @property
    def updated_ipv4_cidr_block(self):
        """
        **[Required]** Gets the updated_ipv4_cidr_block of this ModifyIpv4SubnetCidrDetails.
        The new Ipv4 CIDR IP address.


        :return: The updated_ipv4_cidr_block of this ModifyIpv4SubnetCidrDetails.
        :rtype: str
        """
        return self._updated_ipv4_cidr_block

    @updated_ipv4_cidr_block.setter
    def updated_ipv4_cidr_block(self, updated_ipv4_cidr_block):
        """
        Sets the updated_ipv4_cidr_block of this ModifyIpv4SubnetCidrDetails.
        The new Ipv4 CIDR IP address.


        :param updated_ipv4_cidr_block: The updated_ipv4_cidr_block of this ModifyIpv4SubnetCidrDetails.
        :type: str
        """
        self._updated_ipv4_cidr_block = updated_ipv4_cidr_block

    def __repr__(self):
        return formatted_flat_dict(self)

    def __eq__(self, other):
        if other is None:
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not self == other
