# coding: utf-8
# Copyright (c) 2016, 2026, Oracle and/or its affiliates.  All rights reserved.
# This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.

# NOTE: This class is auto generated by OracleSDKGenerator. DO NOT EDIT. API Version: 20160918


from oci.util import formatted_flat_dict, NONE_SENTINEL, value_allowed_none_or_none_sentinel  # noqa: F401
from oci.decorators import init_model_state_from_kwargs


@init_model_state_from_kwargs
class PlatformVersions(object):
    """
    A platform's pinned firmware versions.
    """

    def __init__(self, **kwargs):
        """
        Initializes a new PlatformVersions object with values from keyword arguments.
        The following keyword arguments are supported (corresponding to the getters/setters of this class):

        :param platform:
            The value to assign to the platform property of this PlatformVersions.
        :type platform: str

        :param versions:
            The value to assign to the versions property of this PlatformVersions.
        :type versions: list[oci.core.models.ComponentVersion]

        """
        self.swagger_types = {
            'platform': 'str',
            'versions': 'list[ComponentVersion]'
        }
        self.attribute_map = {
            'platform': 'platform',
            'versions': 'versions'
        }
        self._platform = None
        self._versions = None

    @property
    def platform(self):
        """
        Gets the platform of this PlatformVersions.
        The name of the platform supported by this bundle.


        :return: The platform of this PlatformVersions.
        :rtype: str
        """
        return self._platform

    @platform.setter
    def platform(self, platform):
        """
        Sets the platform of this PlatformVersions.
        The name of the platform supported by this bundle.


        :param platform: The platform of this PlatformVersions.
        :type: str
        """
        self._platform = platform

    @property
    def versions(self):
        """
        Gets the versions of this PlatformVersions.
        An array of pinned components and their respective firmware versions.


        :return: The versions of this PlatformVersions.
        :rtype: list[oci.core.models.ComponentVersion]
        """
        return self._versions

    @versions.setter
    def versions(self, versions):
        """
        Sets the versions of this PlatformVersions.
        An array of pinned components and their respective firmware versions.


        :param versions: The versions of this PlatformVersions.
        :type: list[oci.core.models.ComponentVersion]
        """
        self._versions = versions

    def __repr__(self):
        return formatted_flat_dict(self)

    def __eq__(self, other):
        if other is None:
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not self == other
