# coding: utf-8
# Copyright (c) 2016, 2026, Oracle and/or its affiliates.  All rights reserved.
# This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.

# NOTE: This class is auto generated by OracleSDKGenerator. DO NOT EDIT. API Version: 20160918


from oci.util import formatted_flat_dict, NONE_SENTINEL, value_allowed_none_or_none_sentinel  # noqa: F401
from oci.decorators import init_model_state_from_kwargs


@init_model_state_from_kwargs
class UpdateInstanceDetails(object):
    """
    UpdateInstanceDetails model.
    """

    #: A constant which can be used with the update_operation_constraint property of a UpdateInstanceDetails.
    #: This constant has a value of "ALLOW_DOWNTIME"
    UPDATE_OPERATION_CONSTRAINT_ALLOW_DOWNTIME = "ALLOW_DOWNTIME"

    #: A constant which can be used with the update_operation_constraint property of a UpdateInstanceDetails.
    #: This constant has a value of "AVOID_DOWNTIME"
    UPDATE_OPERATION_CONSTRAINT_AVOID_DOWNTIME = "AVOID_DOWNTIME"

    def __init__(self, **kwargs):
        """
        Initializes a new UpdateInstanceDetails object with values from keyword arguments.
        The following keyword arguments are supported (corresponding to the getters/setters of this class):

        :param is_ai_enterprise_enabled:
            The value to assign to the is_ai_enterprise_enabled property of this UpdateInstanceDetails.
        :type is_ai_enterprise_enabled: bool

        :param capacity_reservation_id:
            The value to assign to the capacity_reservation_id property of this UpdateInstanceDetails.
        :type capacity_reservation_id: str

        :param defined_tags:
            The value to assign to the defined_tags property of this UpdateInstanceDetails.
        :type defined_tags: dict(str, dict(str, object))

        :param security_attributes:
            The value to assign to the security_attributes property of this UpdateInstanceDetails.
        :type security_attributes: dict(str, dict(str, object))

        :param display_name:
            The value to assign to the display_name property of this UpdateInstanceDetails.
        :type display_name: str

        :param freeform_tags:
            The value to assign to the freeform_tags property of this UpdateInstanceDetails.
        :type freeform_tags: dict(str, str)

        :param agent_config:
            The value to assign to the agent_config property of this UpdateInstanceDetails.
        :type agent_config: oci.core.models.UpdateInstanceAgentConfigDetails

        :param metadata:
            The value to assign to the metadata property of this UpdateInstanceDetails.
        :type metadata: dict(str, str)

        :param extended_metadata:
            The value to assign to the extended_metadata property of this UpdateInstanceDetails.
        :type extended_metadata: dict(str, object)

        :param shape:
            The value to assign to the shape property of this UpdateInstanceDetails.
        :type shape: str

        :param shape_config:
            The value to assign to the shape_config property of this UpdateInstanceDetails.
        :type shape_config: oci.core.models.UpdateInstanceShapeConfigDetails

        :param source_details:
            The value to assign to the source_details property of this UpdateInstanceDetails.
        :type source_details: oci.core.models.UpdateInstanceSourceDetails

        :param update_operation_constraint:
            The value to assign to the update_operation_constraint property of this UpdateInstanceDetails.
            Allowed values for this property are: "ALLOW_DOWNTIME", "AVOID_DOWNTIME"
        :type update_operation_constraint: str

        :param instance_options:
            The value to assign to the instance_options property of this UpdateInstanceDetails.
        :type instance_options: oci.core.models.InstanceOptions

        :param fault_domain:
            The value to assign to the fault_domain property of this UpdateInstanceDetails.
        :type fault_domain: str

        :param launch_options:
            The value to assign to the launch_options property of this UpdateInstanceDetails.
        :type launch_options: oci.core.models.UpdateLaunchOptions

        :param availability_config:
            The value to assign to the availability_config property of this UpdateInstanceDetails.
        :type availability_config: oci.core.models.UpdateInstanceAvailabilityConfigDetails

        :param time_maintenance_reboot_due:
            The value to assign to the time_maintenance_reboot_due property of this UpdateInstanceDetails.
        :type time_maintenance_reboot_due: datetime

        :param dedicated_vm_host_id:
            The value to assign to the dedicated_vm_host_id property of this UpdateInstanceDetails.
        :type dedicated_vm_host_id: str

        :param platform_config:
            The value to assign to the platform_config property of this UpdateInstanceDetails.
        :type platform_config: oci.core.models.UpdateInstancePlatformConfig

        :param licensing_configs:
            The value to assign to the licensing_configs property of this UpdateInstanceDetails.
        :type licensing_configs: list[oci.core.models.UpdateInstanceLicensingConfig]

        """
        self.swagger_types = {
            'is_ai_enterprise_enabled': 'bool',
            'capacity_reservation_id': 'str',
            'defined_tags': 'dict(str, dict(str, object))',
            'security_attributes': 'dict(str, dict(str, object))',
            'display_name': 'str',
            'freeform_tags': 'dict(str, str)',
            'agent_config': 'UpdateInstanceAgentConfigDetails',
            'metadata': 'dict(str, str)',
            'extended_metadata': 'dict(str, object)',
            'shape': 'str',
            'shape_config': 'UpdateInstanceShapeConfigDetails',
            'source_details': 'UpdateInstanceSourceDetails',
            'update_operation_constraint': 'str',
            'instance_options': 'InstanceOptions',
            'fault_domain': 'str',
            'launch_options': 'UpdateLaunchOptions',
            'availability_config': 'UpdateInstanceAvailabilityConfigDetails',
            'time_maintenance_reboot_due': 'datetime',
            'dedicated_vm_host_id': 'str',
            'platform_config': 'UpdateInstancePlatformConfig',
            'licensing_configs': 'list[UpdateInstanceLicensingConfig]'
        }
        self.attribute_map = {
            'is_ai_enterprise_enabled': 'isAIEnterpriseEnabled',
            'capacity_reservation_id': 'capacityReservationId',
            'defined_tags': 'definedTags',
            'security_attributes': 'securityAttributes',
            'display_name': 'displayName',
            'freeform_tags': 'freeformTags',
            'agent_config': 'agentConfig',
            'metadata': 'metadata',
            'extended_metadata': 'extendedMetadata',
            'shape': 'shape',
            'shape_config': 'shapeConfig',
            'source_details': 'sourceDetails',
            'update_operation_constraint': 'updateOperationConstraint',
            'instance_options': 'instanceOptions',
            'fault_domain': 'faultDomain',
            'launch_options': 'launchOptions',
            'availability_config': 'availabilityConfig',
            'time_maintenance_reboot_due': 'timeMaintenanceRebootDue',
            'dedicated_vm_host_id': 'dedicatedVmHostId',
            'platform_config': 'platformConfig',
            'licensing_configs': 'licensingConfigs'
        }
        self._is_ai_enterprise_enabled = None
        self._capacity_reservation_id = None
        self._defined_tags = None
        self._security_attributes = None
        self._display_name = None
        self._freeform_tags = None
        self._agent_config = None
        self._metadata = None
        self._extended_metadata = None
        self._shape = None
        self._shape_config = None
        self._source_details = None
        self._update_operation_constraint = None
        self._instance_options = None
        self._fault_domain = None
        self._launch_options = None
        self._availability_config = None
        self._time_maintenance_reboot_due = None
        self._dedicated_vm_host_id = None
        self._platform_config = None
        self._licensing_configs = None

    @property
    def is_ai_enterprise_enabled(self):
        """
        Gets the is_ai_enterprise_enabled of this UpdateInstanceDetails.
        Whether to enable AI enterprise on the instance.


        :return: The is_ai_enterprise_enabled of this UpdateInstanceDetails.
        :rtype: bool
        """
        return self._is_ai_enterprise_enabled

    @is_ai_enterprise_enabled.setter
    def is_ai_enterprise_enabled(self, is_ai_enterprise_enabled):
        """
        Sets the is_ai_enterprise_enabled of this UpdateInstanceDetails.
        Whether to enable AI enterprise on the instance.


        :param is_ai_enterprise_enabled: The is_ai_enterprise_enabled of this UpdateInstanceDetails.
        :type: bool
        """
        self._is_ai_enterprise_enabled = is_ai_enterprise_enabled

    @property
    def capacity_reservation_id(self):
        """
        Gets the capacity_reservation_id of this UpdateInstanceDetails.
        The OCID of the compute capacity reservation this instance is launched under.
        You can remove the instance from a reservation by specifying an empty string as input for this field.
        For more information, see `Capacity Reservations`__.

        __ https://docs.cloud.oracle.com/iaas/Content/Compute/Tasks/reserve-capacity.htm#default


        :return: The capacity_reservation_id of this UpdateInstanceDetails.
        :rtype: str
        """
        return self._capacity_reservation_id

    @capacity_reservation_id.setter
    def capacity_reservation_id(self, capacity_reservation_id):
        """
        Sets the capacity_reservation_id of this UpdateInstanceDetails.
        The OCID of the compute capacity reservation this instance is launched under.
        You can remove the instance from a reservation by specifying an empty string as input for this field.
        For more information, see `Capacity Reservations`__.

        __ https://docs.cloud.oracle.com/iaas/Content/Compute/Tasks/reserve-capacity.htm#default


        :param capacity_reservation_id: The capacity_reservation_id of this UpdateInstanceDetails.
        :type: str
        """
        self._capacity_reservation_id = capacity_reservation_id

    @property
    def defined_tags(self):
        """
        Gets the defined_tags of this UpdateInstanceDetails.
        Defined tags for this resource. Each key is predefined and scoped to a
        namespace. For more information, see `Resource Tags`__.

        Example: `{\"Operations\": {\"CostCenter\": \"42\"}}`

        __ https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm


        :return: The defined_tags of this UpdateInstanceDetails.
        :rtype: dict(str, dict(str, object))
        """
        return self._defined_tags

    @defined_tags.setter
    def defined_tags(self, defined_tags):
        """
        Sets the defined_tags of this UpdateInstanceDetails.
        Defined tags for this resource. Each key is predefined and scoped to a
        namespace. For more information, see `Resource Tags`__.

        Example: `{\"Operations\": {\"CostCenter\": \"42\"}}`

        __ https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm


        :param defined_tags: The defined_tags of this UpdateInstanceDetails.
        :type: dict(str, dict(str, object))
        """
        self._defined_tags = defined_tags

    @property
    def security_attributes(self):
        """
        Gets the security_attributes of this UpdateInstanceDetails.
        `Security attributes`__ are labels
        for a resource that can be referenced in a `Zero Trust Packet Routing`__
        (ZPR) policy to control access to ZPR-supported resources.

        Example: `{\"Oracle-DataSecurity-ZPR\": {\"MaxEgressCount\": {\"value\":\"42\",\"mode\":\"audit\"}}}`

        __ https://docs.cloud.oracle.com/iaas/Content/zero-trust-packet-routing/zpr-artifacts.htm#security-attributes
        __ https://docs.cloud.oracle.com/iaas/Content/zero-trust-packet-routing/overview.htm


        :return: The security_attributes of this UpdateInstanceDetails.
        :rtype: dict(str, dict(str, object))
        """
        return self._security_attributes

    @security_attributes.setter
    def security_attributes(self, security_attributes):
        """
        Sets the security_attributes of this UpdateInstanceDetails.
        `Security attributes`__ are labels
        for a resource that can be referenced in a `Zero Trust Packet Routing`__
        (ZPR) policy to control access to ZPR-supported resources.

        Example: `{\"Oracle-DataSecurity-ZPR\": {\"MaxEgressCount\": {\"value\":\"42\",\"mode\":\"audit\"}}}`

        __ https://docs.cloud.oracle.com/iaas/Content/zero-trust-packet-routing/zpr-artifacts.htm#security-attributes
        __ https://docs.cloud.oracle.com/iaas/Content/zero-trust-packet-routing/overview.htm


        :param security_attributes: The security_attributes of this UpdateInstanceDetails.
        :type: dict(str, dict(str, object))
        """
        self._security_attributes = security_attributes

    @property
    def display_name(self):
        """
        Gets the display_name of this UpdateInstanceDetails.
        A user-friendly name. Does not have to be unique, and it's changeable.
        Avoid entering confidential information.


        :return: The display_name of this UpdateInstanceDetails.
        :rtype: str
        """
        return self._display_name

    @display_name.setter
    def display_name(self, display_name):
        """
        Sets the display_name of this UpdateInstanceDetails.
        A user-friendly name. Does not have to be unique, and it's changeable.
        Avoid entering confidential information.


        :param display_name: The display_name of this UpdateInstanceDetails.
        :type: str
        """
        self._display_name = display_name

    @property
    def freeform_tags(self):
        """
        Gets the freeform_tags of this UpdateInstanceDetails.
        Free-form tags for this resource. Each tag is a simple key-value pair with no
        predefined name, type, or namespace. For more information, see `Resource Tags`__.

        Example: `{\"Department\": \"Finance\"}`

        __ https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm


        :return: The freeform_tags of this UpdateInstanceDetails.
        :rtype: dict(str, str)
        """
        return self._freeform_tags

    @freeform_tags.setter
    def freeform_tags(self, freeform_tags):
        """
        Sets the freeform_tags of this UpdateInstanceDetails.
        Free-form tags for this resource. Each tag is a simple key-value pair with no
        predefined name, type, or namespace. For more information, see `Resource Tags`__.

        Example: `{\"Department\": \"Finance\"}`

        __ https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm


        :param freeform_tags: The freeform_tags of this UpdateInstanceDetails.
        :type: dict(str, str)
        """
        self._freeform_tags = freeform_tags

    @property
    def agent_config(self):
        """
        Gets the agent_config of this UpdateInstanceDetails.

        :return: The agent_config of this UpdateInstanceDetails.
        :rtype: oci.core.models.UpdateInstanceAgentConfigDetails
        """
        return self._agent_config

    @agent_config.setter
    def agent_config(self, agent_config):
        """
        Sets the agent_config of this UpdateInstanceDetails.

        :param agent_config: The agent_config of this UpdateInstanceDetails.
        :type: oci.core.models.UpdateInstanceAgentConfigDetails
        """
        self._agent_config = agent_config

    @property
    def metadata(self):
        """
        Gets the metadata of this UpdateInstanceDetails.
        Custom metadata key/value string pairs that you provide. Any set of key/value pairs
        provided here will completely replace the current set of key/value pairs in the `metadata`
        field on the instance.

        The \"user_data\" field and the \"ssh_authorized_keys\" field cannot be changed after an instance
        has launched. Any request that updates, removes, or adds either of these fields will be
        rejected. You must provide the same values for \"user_data\" and \"ssh_authorized_keys\" that
        already exist on the instance.

        The combined size of the `metadata` and `extendedMetadata` objects can be a maximum of
        32,000 bytes.


        :return: The metadata of this UpdateInstanceDetails.
        :rtype: dict(str, str)
        """
        return self._metadata

    @metadata.setter
    def metadata(self, metadata):
        """
        Sets the metadata of this UpdateInstanceDetails.
        Custom metadata key/value string pairs that you provide. Any set of key/value pairs
        provided here will completely replace the current set of key/value pairs in the `metadata`
        field on the instance.

        The \"user_data\" field and the \"ssh_authorized_keys\" field cannot be changed after an instance
        has launched. Any request that updates, removes, or adds either of these fields will be
        rejected. You must provide the same values for \"user_data\" and \"ssh_authorized_keys\" that
        already exist on the instance.

        The combined size of the `metadata` and `extendedMetadata` objects can be a maximum of
        32,000 bytes.


        :param metadata: The metadata of this UpdateInstanceDetails.
        :type: dict(str, str)
        """
        self._metadata = metadata

    @property
    def extended_metadata(self):
        """
        Gets the extended_metadata of this UpdateInstanceDetails.
        Additional metadata key/value pairs that you provide. They serve the same purpose and
        functionality as fields in the `metadata` object.

        They are distinguished from `metadata` fields in that these can be nested JSON objects
        (whereas `metadata` fields are string/string maps only).

        The \"user_data\" field and the \"ssh_authorized_keys\" field cannot be changed after an instance
        has launched. Any request that updates, removes, or adds either of these fields will be
        rejected. You must provide the same values for \"user_data\" and \"ssh_authorized_keys\" that
        already exist on the instance.

        The combined size of the `metadata` and `extendedMetadata` objects can be a maximum of
        32,000 bytes.


        :return: The extended_metadata of this UpdateInstanceDetails.
        :rtype: dict(str, object)
        """
        return self._extended_metadata

    @extended_metadata.setter
    def extended_metadata(self, extended_metadata):
        """
        Sets the extended_metadata of this UpdateInstanceDetails.
        Additional metadata key/value pairs that you provide. They serve the same purpose and
        functionality as fields in the `metadata` object.

        They are distinguished from `metadata` fields in that these can be nested JSON objects
        (whereas `metadata` fields are string/string maps only).

        The \"user_data\" field and the \"ssh_authorized_keys\" field cannot be changed after an instance
        has launched. Any request that updates, removes, or adds either of these fields will be
        rejected. You must provide the same values for \"user_data\" and \"ssh_authorized_keys\" that
        already exist on the instance.

        The combined size of the `metadata` and `extendedMetadata` objects can be a maximum of
        32,000 bytes.


        :param extended_metadata: The extended_metadata of this UpdateInstanceDetails.
        :type: dict(str, object)
        """
        self._extended_metadata = extended_metadata

    @property
    def shape(self):
        """
        Gets the shape of this UpdateInstanceDetails.
        The shape of the instance. The shape determines the number of CPUs and the amount of memory
        allocated to the instance. For more information about how to change shapes, and a list of
        shapes that are supported, see
        `Editing an Instance`__.

        For details about the CPUs, memory, and other properties of each shape, see
        `Compute Shapes`__.

        The new shape must be compatible with the image that was used to launch the instance. You
        can enumerate all available shapes and determine image compatibility by calling
        :func:`list_shapes`.

        To determine whether capacity is available for a specific shape before you change the shape of an instance,
        use the :func:`create_compute_capacity_report`
        operation.

        If the instance is running when you change the shape, the instance is rebooted.

        Example: `VM.Standard2.1`

        __ https://docs.cloud.oracle.com/iaas/Content/Compute/Tasks/resizinginstances.htm
        __ https://docs.cloud.oracle.com/iaas/Content/Compute/References/computeshapes.htm


        :return: The shape of this UpdateInstanceDetails.
        :rtype: str
        """
        return self._shape

    @shape.setter
    def shape(self, shape):
        """
        Sets the shape of this UpdateInstanceDetails.
        The shape of the instance. The shape determines the number of CPUs and the amount of memory
        allocated to the instance. For more information about how to change shapes, and a list of
        shapes that are supported, see
        `Editing an Instance`__.

        For details about the CPUs, memory, and other properties of each shape, see
        `Compute Shapes`__.

        The new shape must be compatible with the image that was used to launch the instance. You
        can enumerate all available shapes and determine image compatibility by calling
        :func:`list_shapes`.

        To determine whether capacity is available for a specific shape before you change the shape of an instance,
        use the :func:`create_compute_capacity_report`
        operation.

        If the instance is running when you change the shape, the instance is rebooted.

        Example: `VM.Standard2.1`

        __ https://docs.cloud.oracle.com/iaas/Content/Compute/Tasks/resizinginstances.htm
        __ https://docs.cloud.oracle.com/iaas/Content/Compute/References/computeshapes.htm


        :param shape: The shape of this UpdateInstanceDetails.
        :type: str
        """
        self._shape = shape

    @property
    def shape_config(self):
        """
        Gets the shape_config of this UpdateInstanceDetails.

        :return: The shape_config of this UpdateInstanceDetails.
        :rtype: oci.core.models.UpdateInstanceShapeConfigDetails
        """
        return self._shape_config

    @shape_config.setter
    def shape_config(self, shape_config):
        """
        Sets the shape_config of this UpdateInstanceDetails.

        :param shape_config: The shape_config of this UpdateInstanceDetails.
        :type: oci.core.models.UpdateInstanceShapeConfigDetails
        """
        self._shape_config = shape_config

    @property
    def source_details(self):
        """
        Gets the source_details of this UpdateInstanceDetails.

        :return: The source_details of this UpdateInstanceDetails.
        :rtype: oci.core.models.UpdateInstanceSourceDetails
        """
        return self._source_details

    @source_details.setter
    def source_details(self, source_details):
        """
        Sets the source_details of this UpdateInstanceDetails.

        :param source_details: The source_details of this UpdateInstanceDetails.
        :type: oci.core.models.UpdateInstanceSourceDetails
        """
        self._source_details = source_details

    @property
    def update_operation_constraint(self):
        """
        Gets the update_operation_constraint of this UpdateInstanceDetails.
        The parameter acts as a fail-safe to prevent unwanted downtime when updating a running instance.
        The default is ALLOW_DOWNTIME.
        * `ALLOW_DOWNTIME` - Compute might reboot the instance while updating the instance if a reboot is required.
        * `AVOID_DOWNTIME` - If the instance is in running state, Compute tries to update the instance without rebooting
                          it. If the instance requires a reboot to be updated, an error is returned and the instance
                          is not updated. If the instance is stopped, it is updated and remains in the stopped state.

        Allowed values for this property are: "ALLOW_DOWNTIME", "AVOID_DOWNTIME"


        :return: The update_operation_constraint of this UpdateInstanceDetails.
        :rtype: str
        """
        return self._update_operation_constraint

    @update_operation_constraint.setter
    def update_operation_constraint(self, update_operation_constraint):
        """
        Sets the update_operation_constraint of this UpdateInstanceDetails.
        The parameter acts as a fail-safe to prevent unwanted downtime when updating a running instance.
        The default is ALLOW_DOWNTIME.
        * `ALLOW_DOWNTIME` - Compute might reboot the instance while updating the instance if a reboot is required.
        * `AVOID_DOWNTIME` - If the instance is in running state, Compute tries to update the instance without rebooting
                          it. If the instance requires a reboot to be updated, an error is returned and the instance
                          is not updated. If the instance is stopped, it is updated and remains in the stopped state.


        :param update_operation_constraint: The update_operation_constraint of this UpdateInstanceDetails.
        :type: str
        """
        allowed_values = ["ALLOW_DOWNTIME", "AVOID_DOWNTIME"]
        if not value_allowed_none_or_none_sentinel(update_operation_constraint, allowed_values):
            raise ValueError(
                f"Invalid value for `update_operation_constraint`, must be None or one of {allowed_values}"
            )
        self._update_operation_constraint = update_operation_constraint

    @property
    def instance_options(self):
        """
        Gets the instance_options of this UpdateInstanceDetails.

        :return: The instance_options of this UpdateInstanceDetails.
        :rtype: oci.core.models.InstanceOptions
        """
        return self._instance_options

    @instance_options.setter
    def instance_options(self, instance_options):
        """
        Sets the instance_options of this UpdateInstanceDetails.

        :param instance_options: The instance_options of this UpdateInstanceDetails.
        :type: oci.core.models.InstanceOptions
        """
        self._instance_options = instance_options

    @property
    def fault_domain(self):
        """
        Gets the fault_domain of this UpdateInstanceDetails.
        A fault domain is a grouping of hardware and infrastructure within an availability domain.
        Each availability domain contains three fault domains. Fault domains let you distribute your
        instances so that they are not on the same physical hardware within a single availability domain.
        A hardware failure or Compute hardware maintenance that affects one fault domain does not affect
        instances in other fault domains.

        To get a list of fault domains, use the
        :func:`list_fault_domains` operation in the
        Identity and Access Management Service API.

        Example: `FAULT-DOMAIN-1`


        :return: The fault_domain of this UpdateInstanceDetails.
        :rtype: str
        """
        return self._fault_domain

    @fault_domain.setter
    def fault_domain(self, fault_domain):
        """
        Sets the fault_domain of this UpdateInstanceDetails.
        A fault domain is a grouping of hardware and infrastructure within an availability domain.
        Each availability domain contains three fault domains. Fault domains let you distribute your
        instances so that they are not on the same physical hardware within a single availability domain.
        A hardware failure or Compute hardware maintenance that affects one fault domain does not affect
        instances in other fault domains.

        To get a list of fault domains, use the
        :func:`list_fault_domains` operation in the
        Identity and Access Management Service API.

        Example: `FAULT-DOMAIN-1`


        :param fault_domain: The fault_domain of this UpdateInstanceDetails.
        :type: str
        """
        self._fault_domain = fault_domain

    @property
    def launch_options(self):
        """
        Gets the launch_options of this UpdateInstanceDetails.

        :return: The launch_options of this UpdateInstanceDetails.
        :rtype: oci.core.models.UpdateLaunchOptions
        """
        return self._launch_options

    @launch_options.setter
    def launch_options(self, launch_options):
        """
        Sets the launch_options of this UpdateInstanceDetails.

        :param launch_options: The launch_options of this UpdateInstanceDetails.
        :type: oci.core.models.UpdateLaunchOptions
        """
        self._launch_options = launch_options

    @property
    def availability_config(self):
        """
        Gets the availability_config of this UpdateInstanceDetails.

        :return: The availability_config of this UpdateInstanceDetails.
        :rtype: oci.core.models.UpdateInstanceAvailabilityConfigDetails
        """
        return self._availability_config

    @availability_config.setter
    def availability_config(self, availability_config):
        """
        Sets the availability_config of this UpdateInstanceDetails.

        :param availability_config: The availability_config of this UpdateInstanceDetails.
        :type: oci.core.models.UpdateInstanceAvailabilityConfigDetails
        """
        self._availability_config = availability_config

    @property
    def time_maintenance_reboot_due(self):
        """
        Gets the time_maintenance_reboot_due of this UpdateInstanceDetails.
        For a VM instance, resets the scheduled time that the instance will be reboot migrated for
        infrastructure maintenance, in the format defined by `RFC3339`__.
        If the instance hasn't been rebooted after this date, Oracle reboots the instance within 24 hours of the time
        and date that maintenance is due.

        To get the maximum possible date that a maintenance reboot can be extended,
        use :func:`get_instance_maintenance_reboot`.

        Regardless of how the instance is stopped, this flag is reset to empty as soon as the instance reaches the
        Stopped state.

        To reboot migrate a bare metal instance, use the :func:`instance_action` operation.

        For more information, see
        `Infrastructure Maintenance`__.

        Example: `2018-05-25T21:10:29.600Z`

        __ https://tools.ietf.org/html/rfc3339
        __ https://docs.cloud.oracle.com/iaas/Content/Compute/References/infrastructure-maintenance.htm


        :return: The time_maintenance_reboot_due of this UpdateInstanceDetails.
        :rtype: datetime
        """
        return self._time_maintenance_reboot_due

    @time_maintenance_reboot_due.setter
    def time_maintenance_reboot_due(self, time_maintenance_reboot_due):
        """
        Sets the time_maintenance_reboot_due of this UpdateInstanceDetails.
        For a VM instance, resets the scheduled time that the instance will be reboot migrated for
        infrastructure maintenance, in the format defined by `RFC3339`__.
        If the instance hasn't been rebooted after this date, Oracle reboots the instance within 24 hours of the time
        and date that maintenance is due.

        To get the maximum possible date that a maintenance reboot can be extended,
        use :func:`get_instance_maintenance_reboot`.

        Regardless of how the instance is stopped, this flag is reset to empty as soon as the instance reaches the
        Stopped state.

        To reboot migrate a bare metal instance, use the :func:`instance_action` operation.

        For more information, see
        `Infrastructure Maintenance`__.

        Example: `2018-05-25T21:10:29.600Z`

        __ https://tools.ietf.org/html/rfc3339
        __ https://docs.cloud.oracle.com/iaas/Content/Compute/References/infrastructure-maintenance.htm


        :param time_maintenance_reboot_due: The time_maintenance_reboot_due of this UpdateInstanceDetails.
        :type: datetime
        """
        self._time_maintenance_reboot_due = time_maintenance_reboot_due

    @property
    def dedicated_vm_host_id(self):
        """
        Gets the dedicated_vm_host_id of this UpdateInstanceDetails.
        The OCID of the dedicated virtual machine host to place the instance on.
        Supported only if this VM instance was already placed on a dedicated virtual machine host
        - that is, you can't move an instance from on-demand capacity to dedicated capacity,
        nor can you move an instance from dedicated capacity to on-demand capacity.


        :return: The dedicated_vm_host_id of this UpdateInstanceDetails.
        :rtype: str
        """
        return self._dedicated_vm_host_id

    @dedicated_vm_host_id.setter
    def dedicated_vm_host_id(self, dedicated_vm_host_id):
        """
        Sets the dedicated_vm_host_id of this UpdateInstanceDetails.
        The OCID of the dedicated virtual machine host to place the instance on.
        Supported only if this VM instance was already placed on a dedicated virtual machine host
        - that is, you can't move an instance from on-demand capacity to dedicated capacity,
        nor can you move an instance from dedicated capacity to on-demand capacity.


        :param dedicated_vm_host_id: The dedicated_vm_host_id of this UpdateInstanceDetails.
        :type: str
        """
        self._dedicated_vm_host_id = dedicated_vm_host_id

    @property
    def platform_config(self):
        """
        Gets the platform_config of this UpdateInstanceDetails.

        :return: The platform_config of this UpdateInstanceDetails.
        :rtype: oci.core.models.UpdateInstancePlatformConfig
        """
        return self._platform_config

    @platform_config.setter
    def platform_config(self, platform_config):
        """
        Sets the platform_config of this UpdateInstanceDetails.

        :param platform_config: The platform_config of this UpdateInstanceDetails.
        :type: oci.core.models.UpdateInstancePlatformConfig
        """
        self._platform_config = platform_config

    @property
    def licensing_configs(self):
        """
        Gets the licensing_configs of this UpdateInstanceDetails.
        The list of liscensing configurations with target update values.


        :return: The licensing_configs of this UpdateInstanceDetails.
        :rtype: list[oci.core.models.UpdateInstanceLicensingConfig]
        """
        return self._licensing_configs

    @licensing_configs.setter
    def licensing_configs(self, licensing_configs):
        """
        Sets the licensing_configs of this UpdateInstanceDetails.
        The list of liscensing configurations with target update values.


        :param licensing_configs: The licensing_configs of this UpdateInstanceDetails.
        :type: list[oci.core.models.UpdateInstanceLicensingConfig]
        """
        self._licensing_configs = licensing_configs

    def __repr__(self):
        return formatted_flat_dict(self)

    def __eq__(self, other):
        if other is None:
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not self == other
