# coding: utf-8
# Copyright (c) 2016, 2026, Oracle and/or its affiliates.  All rights reserved.
# This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.

# NOTE: This class is auto generated by OracleSDKGenerator. DO NOT EDIT. API Version: 20200430

from .connection_details import ConnectionDetails
from oci.util import formatted_flat_dict, NONE_SENTINEL, value_allowed_none_or_none_sentinel  # noqa: F401
from oci.decorators import init_model_state_from_kwargs


@init_model_state_from_kwargs
class ConnectionFromOAuth2Details(ConnectionDetails):
    """
    The connection details for a OAuth connection.
    """

    #: A constant which can be used with the grant_type property of a ConnectionFromOAuth2Details.
    #: This constant has a value of "CLIENT_CREDENTIALS"
    GRANT_TYPE_CLIENT_CREDENTIALS = "CLIENT_CREDENTIALS"

    def __init__(self, **kwargs):
        """
        Initializes a new ConnectionFromOAuth2Details object with values from keyword arguments. The default value of the :py:attr:`~oci.data_integration.models.ConnectionFromOAuth2Details.model_type` attribute
        of this class is ``OAUTH2_CONNECTION`` and it should not be changed.
        The following keyword arguments are supported (corresponding to the getters/setters of this class):

        :param model_type:
            The value to assign to the model_type property of this ConnectionFromOAuth2Details.
            Allowed values for this property are: "ORACLE_ADWC_CONNECTION", "ORACLE_ATP_CONNECTION", "ORACLE_OBJECT_STORAGE_CONNECTION", "ORACLEDB_CONNECTION", "MYSQL_CONNECTION", "GENERIC_JDBC_CONNECTION", "BICC_CONNECTION", "AMAZON_S3_CONNECTION", "BIP_CONNECTION", "LAKE_CONNECTION", "ORACLE_PEOPLESOFT_CONNECTION", "ORACLE_EBS_CONNECTION", "ORACLE_SIEBEL_CONNECTION", "HDFS_CONNECTION", "MYSQL_HEATWAVE_CONNECTION", "REST_NO_AUTH_CONNECTION", "REST_BASIC_AUTH_CONNECTION", "OAUTH2_CONNECTION", 'UNKNOWN_ENUM_VALUE'.
            Any unrecognized values returned by a service will be mapped to 'UNKNOWN_ENUM_VALUE'.
        :type model_type: str

        :param key:
            The value to assign to the key property of this ConnectionFromOAuth2Details.
        :type key: str

        :param model_version:
            The value to assign to the model_version property of this ConnectionFromOAuth2Details.
        :type model_version: str

        :param parent_ref:
            The value to assign to the parent_ref property of this ConnectionFromOAuth2Details.
        :type parent_ref: oci.data_integration.models.ParentReference

        :param name:
            The value to assign to the name property of this ConnectionFromOAuth2Details.
        :type name: str

        :param description:
            The value to assign to the description property of this ConnectionFromOAuth2Details.
        :type description: str

        :param object_version:
            The value to assign to the object_version property of this ConnectionFromOAuth2Details.
        :type object_version: int

        :param object_status:
            The value to assign to the object_status property of this ConnectionFromOAuth2Details.
        :type object_status: int

        :param identifier:
            The value to assign to the identifier property of this ConnectionFromOAuth2Details.
        :type identifier: str

        :param primary_schema:
            The value to assign to the primary_schema property of this ConnectionFromOAuth2Details.
        :type primary_schema: oci.data_integration.models.Schema

        :param connection_properties:
            The value to assign to the connection_properties property of this ConnectionFromOAuth2Details.
        :type connection_properties: list[oci.data_integration.models.ConnectionProperty]

        :param is_default:
            The value to assign to the is_default property of this ConnectionFromOAuth2Details.
        :type is_default: bool

        :param metadata:
            The value to assign to the metadata property of this ConnectionFromOAuth2Details.
        :type metadata: oci.data_integration.models.ObjectMetadata

        :param access_token_url:
            The value to assign to the access_token_url property of this ConnectionFromOAuth2Details.
        :type access_token_url: str

        :param client_id:
            The value to assign to the client_id property of this ConnectionFromOAuth2Details.
        :type client_id: str

        :param client_secret:
            The value to assign to the client_secret property of this ConnectionFromOAuth2Details.
        :type client_secret: oci.data_integration.models.SensitiveAttribute

        :param scope:
            The value to assign to the scope property of this ConnectionFromOAuth2Details.
        :type scope: str

        :param grant_type:
            The value to assign to the grant_type property of this ConnectionFromOAuth2Details.
            Allowed values for this property are: "CLIENT_CREDENTIALS", 'UNKNOWN_ENUM_VALUE'.
            Any unrecognized values returned by a service will be mapped to 'UNKNOWN_ENUM_VALUE'.
        :type grant_type: str

        """
        self.swagger_types = {
            'model_type': 'str',
            'key': 'str',
            'model_version': 'str',
            'parent_ref': 'ParentReference',
            'name': 'str',
            'description': 'str',
            'object_version': 'int',
            'object_status': 'int',
            'identifier': 'str',
            'primary_schema': 'Schema',
            'connection_properties': 'list[ConnectionProperty]',
            'is_default': 'bool',
            'metadata': 'ObjectMetadata',
            'access_token_url': 'str',
            'client_id': 'str',
            'client_secret': 'SensitiveAttribute',
            'scope': 'str',
            'grant_type': 'str'
        }
        self.attribute_map = {
            'model_type': 'modelType',
            'key': 'key',
            'model_version': 'modelVersion',
            'parent_ref': 'parentRef',
            'name': 'name',
            'description': 'description',
            'object_version': 'objectVersion',
            'object_status': 'objectStatus',
            'identifier': 'identifier',
            'primary_schema': 'primarySchema',
            'connection_properties': 'connectionProperties',
            'is_default': 'isDefault',
            'metadata': 'metadata',
            'access_token_url': 'accessTokenUrl',
            'client_id': 'clientId',
            'client_secret': 'clientSecret',
            'scope': 'scope',
            'grant_type': 'grantType'
        }
        self._model_type = None
        self._key = None
        self._model_version = None
        self._parent_ref = None
        self._name = None
        self._description = None
        self._object_version = None
        self._object_status = None
        self._identifier = None
        self._primary_schema = None
        self._connection_properties = None
        self._is_default = None
        self._metadata = None
        self._access_token_url = None
        self._client_id = None
        self._client_secret = None
        self._scope = None
        self._grant_type = None
        self._model_type = 'OAUTH2_CONNECTION'

    @property
    def access_token_url(self):
        """
        **[Required]** Gets the access_token_url of this ConnectionFromOAuth2Details.
        Specifies the endpoint used to exchange authentication credentials for access tokens


        :return: The access_token_url of this ConnectionFromOAuth2Details.
        :rtype: str
        """
        return self._access_token_url

    @access_token_url.setter
    def access_token_url(self, access_token_url):
        """
        Sets the access_token_url of this ConnectionFromOAuth2Details.
        Specifies the endpoint used to exchange authentication credentials for access tokens


        :param access_token_url: The access_token_url of this ConnectionFromOAuth2Details.
        :type: str
        """
        self._access_token_url = access_token_url

    @property
    def client_id(self):
        """
        Gets the client_id of this ConnectionFromOAuth2Details.
        Specifies the client ID key for specific application


        :return: The client_id of this ConnectionFromOAuth2Details.
        :rtype: str
        """
        return self._client_id

    @client_id.setter
    def client_id(self, client_id):
        """
        Sets the client_id of this ConnectionFromOAuth2Details.
        Specifies the client ID key for specific application


        :param client_id: The client_id of this ConnectionFromOAuth2Details.
        :type: str
        """
        self._client_id = client_id

    @property
    def client_secret(self):
        """
        Gets the client_secret of this ConnectionFromOAuth2Details.

        :return: The client_secret of this ConnectionFromOAuth2Details.
        :rtype: oci.data_integration.models.SensitiveAttribute
        """
        return self._client_secret

    @client_secret.setter
    def client_secret(self, client_secret):
        """
        Sets the client_secret of this ConnectionFromOAuth2Details.

        :param client_secret: The client_secret of this ConnectionFromOAuth2Details.
        :type: oci.data_integration.models.SensitiveAttribute
        """
        self._client_secret = client_secret

    @property
    def scope(self):
        """
        Gets the scope of this ConnectionFromOAuth2Details.
        Specifies the OAuth scopes that limit the permissions granted by an access token.


        :return: The scope of this ConnectionFromOAuth2Details.
        :rtype: str
        """
        return self._scope

    @scope.setter
    def scope(self, scope):
        """
        Sets the scope of this ConnectionFromOAuth2Details.
        Specifies the OAuth scopes that limit the permissions granted by an access token.


        :param scope: The scope of this ConnectionFromOAuth2Details.
        :type: str
        """
        self._scope = scope

    @property
    def grant_type(self):
        """
        Gets the grant_type of this ConnectionFromOAuth2Details.
        Specifies the OAuth2 grant mechanism. Example CLIENT_CREDENTIALS, Implicit Flow etc.

        Allowed values for this property are: "CLIENT_CREDENTIALS", 'UNKNOWN_ENUM_VALUE'.
        Any unrecognized values returned by a service will be mapped to 'UNKNOWN_ENUM_VALUE'.


        :return: The grant_type of this ConnectionFromOAuth2Details.
        :rtype: str
        """
        return self._grant_type

    @grant_type.setter
    def grant_type(self, grant_type):
        """
        Sets the grant_type of this ConnectionFromOAuth2Details.
        Specifies the OAuth2 grant mechanism. Example CLIENT_CREDENTIALS, Implicit Flow etc.


        :param grant_type: The grant_type of this ConnectionFromOAuth2Details.
        :type: str
        """
        allowed_values = ["CLIENT_CREDENTIALS"]
        if not value_allowed_none_or_none_sentinel(grant_type, allowed_values):
            grant_type = 'UNKNOWN_ENUM_VALUE'
        self._grant_type = grant_type

    def __repr__(self):
        return formatted_flat_dict(self)

    def __eq__(self, other):
        if other is None:
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not self == other
