# coding: utf-8
# Copyright (c) 2016, 2026, Oracle and/or its affiliates.  All rights reserved.
# This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.

# NOTE: This class is auto generated by OracleSDKGenerator. DO NOT EDIT. API Version: 20181201


from oci.util import formatted_flat_dict, NONE_SENTINEL, value_allowed_none_or_none_sentinel  # noqa: F401
from oci.decorators import init_model_state_from_kwargs


@init_model_state_from_kwargs
class BulkCreateUnifiedAuditPolicyDetails(object):
    """
    The details required to bulk create unified audit policies.
    """

    def __init__(self, **kwargs):
        """
        Initializes a new BulkCreateUnifiedAuditPolicyDetails object with values from keyword arguments.
        The following keyword arguments are supported (corresponding to the getters/setters of this class):

        :param security_policy_id:
            The value to assign to the security_policy_id property of this BulkCreateUnifiedAuditPolicyDetails.
        :type security_policy_id: str

        :param target_id:
            The value to assign to the target_id property of this BulkCreateUnifiedAuditPolicyDetails.
        :type target_id: str

        :param unified_audit_policy_definition_ids:
            The value to assign to the unified_audit_policy_definition_ids property of this BulkCreateUnifiedAuditPolicyDetails.
        :type unified_audit_policy_definition_ids: list[str]

        :param policy_names:
            The value to assign to the policy_names property of this BulkCreateUnifiedAuditPolicyDetails.
        :type policy_names: list[str]

        :param compartment_id:
            The value to assign to the compartment_id property of this BulkCreateUnifiedAuditPolicyDetails.
        :type compartment_id: str

        :param should_preserve_casing:
            The value to assign to the should_preserve_casing property of this BulkCreateUnifiedAuditPolicyDetails.
        :type should_preserve_casing: bool

        """
        self.swagger_types = {
            'security_policy_id': 'str',
            'target_id': 'str',
            'unified_audit_policy_definition_ids': 'list[str]',
            'policy_names': 'list[str]',
            'compartment_id': 'str',
            'should_preserve_casing': 'bool'
        }
        self.attribute_map = {
            'security_policy_id': 'securityPolicyId',
            'target_id': 'targetId',
            'unified_audit_policy_definition_ids': 'unifiedAuditPolicyDefinitionIds',
            'policy_names': 'policyNames',
            'compartment_id': 'compartmentId',
            'should_preserve_casing': 'shouldPreserveCasing'
        }
        self._security_policy_id = None
        self._target_id = None
        self._unified_audit_policy_definition_ids = None
        self._policy_names = None
        self._compartment_id = None
        self._should_preserve_casing = None

    @property
    def security_policy_id(self):
        """
        **[Required]** Gets the security_policy_id of this BulkCreateUnifiedAuditPolicyDetails.
        The OCID of the security policy corresponding to the unified audit policy.


        :return: The security_policy_id of this BulkCreateUnifiedAuditPolicyDetails.
        :rtype: str
        """
        return self._security_policy_id

    @security_policy_id.setter
    def security_policy_id(self, security_policy_id):
        """
        Sets the security_policy_id of this BulkCreateUnifiedAuditPolicyDetails.
        The OCID of the security policy corresponding to the unified audit policy.


        :param security_policy_id: The security_policy_id of this BulkCreateUnifiedAuditPolicyDetails.
        :type: str
        """
        self._security_policy_id = security_policy_id

    @property
    def target_id(self):
        """
        **[Required]** Gets the target_id of this BulkCreateUnifiedAuditPolicyDetails.
        The OCID of the target database.


        :return: The target_id of this BulkCreateUnifiedAuditPolicyDetails.
        :rtype: str
        """
        return self._target_id

    @target_id.setter
    def target_id(self, target_id):
        """
        Sets the target_id of this BulkCreateUnifiedAuditPolicyDetails.
        The OCID of the target database.


        :param target_id: The target_id of this BulkCreateUnifiedAuditPolicyDetails.
        :type: str
        """
        self._target_id = target_id

    @property
    def unified_audit_policy_definition_ids(self):
        """
        Gets the unified_audit_policy_definition_ids of this BulkCreateUnifiedAuditPolicyDetails.
        The list of unified audit policy definition ocids.
        If unified audit policy definition ids are provided, the imported
        audit policy will be associated to the specified unified audit policy
        definition based on the policy name.
        Else, for every audit policy that gets imported,
        a new unified audit policy definition will be created.


        :return: The unified_audit_policy_definition_ids of this BulkCreateUnifiedAuditPolicyDetails.
        :rtype: list[str]
        """
        return self._unified_audit_policy_definition_ids

    @unified_audit_policy_definition_ids.setter
    def unified_audit_policy_definition_ids(self, unified_audit_policy_definition_ids):
        """
        Sets the unified_audit_policy_definition_ids of this BulkCreateUnifiedAuditPolicyDetails.
        The list of unified audit policy definition ocids.
        If unified audit policy definition ids are provided, the imported
        audit policy will be associated to the specified unified audit policy
        definition based on the policy name.
        Else, for every audit policy that gets imported,
        a new unified audit policy definition will be created.


        :param unified_audit_policy_definition_ids: The unified_audit_policy_definition_ids of this BulkCreateUnifiedAuditPolicyDetails.
        :type: list[str]
        """
        self._unified_audit_policy_definition_ids = unified_audit_policy_definition_ids

    @property
    def policy_names(self):
        """
        Gets the policy_names of this BulkCreateUnifiedAuditPolicyDetails.
        The list of unified audit policy names to be imported.


        :return: The policy_names of this BulkCreateUnifiedAuditPolicyDetails.
        :rtype: list[str]
        """
        return self._policy_names

    @policy_names.setter
    def policy_names(self, policy_names):
        """
        Sets the policy_names of this BulkCreateUnifiedAuditPolicyDetails.
        The list of unified audit policy names to be imported.


        :param policy_names: The policy_names of this BulkCreateUnifiedAuditPolicyDetails.
        :type: list[str]
        """
        self._policy_names = policy_names

    @property
    def compartment_id(self):
        """
        **[Required]** Gets the compartment_id of this BulkCreateUnifiedAuditPolicyDetails.
        The OCID of the compartment in which to create the unified audit policy.


        :return: The compartment_id of this BulkCreateUnifiedAuditPolicyDetails.
        :rtype: str
        """
        return self._compartment_id

    @compartment_id.setter
    def compartment_id(self, compartment_id):
        """
        Sets the compartment_id of this BulkCreateUnifiedAuditPolicyDetails.
        The OCID of the compartment in which to create the unified audit policy.


        :param compartment_id: The compartment_id of this BulkCreateUnifiedAuditPolicyDetails.
        :type: str
        """
        self._compartment_id = compartment_id

    @property
    def should_preserve_casing(self):
        """
        Gets the should_preserve_casing of this BulkCreateUnifiedAuditPolicyDetails.
        Indicates whether the casing of the policy names provided in the request payload should be preserved during creation.
        By default all policy names will be converted to upper case.


        :return: The should_preserve_casing of this BulkCreateUnifiedAuditPolicyDetails.
        :rtype: bool
        """
        return self._should_preserve_casing

    @should_preserve_casing.setter
    def should_preserve_casing(self, should_preserve_casing):
        """
        Sets the should_preserve_casing of this BulkCreateUnifiedAuditPolicyDetails.
        Indicates whether the casing of the policy names provided in the request payload should be preserved during creation.
        By default all policy names will be converted to upper case.


        :param should_preserve_casing: The should_preserve_casing of this BulkCreateUnifiedAuditPolicyDetails.
        :type: bool
        """
        self._should_preserve_casing = should_preserve_casing

    def __repr__(self):
        return formatted_flat_dict(self)

    def __eq__(self, other):
        if other is None:
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not self == other
