# coding: utf-8
# Copyright (c) 2016, 2026, Oracle and/or its affiliates.  All rights reserved.
# This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.

# NOTE: This class is auto generated by OracleSDKGenerator. DO NOT EDIT. API Version: 20181201


from oci.util import formatted_flat_dict, NONE_SENTINEL, value_allowed_none_or_none_sentinel  # noqa: F401
from oci.decorators import init_model_state_from_kwargs


@init_model_state_from_kwargs
class CreateAttributeSetDetails(object):
    """
    The details for an attribute set.
    """

    def __init__(self, **kwargs):
        """
        Initializes a new CreateAttributeSetDetails object with values from keyword arguments.
        The following keyword arguments are supported (corresponding to the getters/setters of this class):

        :param display_name:
            The value to assign to the display_name property of this CreateAttributeSetDetails.
        :type display_name: str

        :param description:
            The value to assign to the description property of this CreateAttributeSetDetails.
        :type description: str

        :param compartment_id:
            The value to assign to the compartment_id property of this CreateAttributeSetDetails.
        :type compartment_id: str

        :param attribute_set_type:
            The value to assign to the attribute_set_type property of this CreateAttributeSetDetails.
        :type attribute_set_type: str

        :param attribute_set_values:
            The value to assign to the attribute_set_values property of this CreateAttributeSetDetails.
        :type attribute_set_values: list[str]

        :param freeform_tags:
            The value to assign to the freeform_tags property of this CreateAttributeSetDetails.
        :type freeform_tags: dict(str, str)

        :param defined_tags:
            The value to assign to the defined_tags property of this CreateAttributeSetDetails.
        :type defined_tags: dict(str, dict(str, object))

        """
        self.swagger_types = {
            'display_name': 'str',
            'description': 'str',
            'compartment_id': 'str',
            'attribute_set_type': 'str',
            'attribute_set_values': 'list[str]',
            'freeform_tags': 'dict(str, str)',
            'defined_tags': 'dict(str, dict(str, object))'
        }
        self.attribute_map = {
            'display_name': 'displayName',
            'description': 'description',
            'compartment_id': 'compartmentId',
            'attribute_set_type': 'attributeSetType',
            'attribute_set_values': 'attributeSetValues',
            'freeform_tags': 'freeformTags',
            'defined_tags': 'definedTags'
        }
        self._display_name = None
        self._description = None
        self._compartment_id = None
        self._attribute_set_type = None
        self._attribute_set_values = None
        self._freeform_tags = None
        self._defined_tags = None

    @property
    def display_name(self):
        """
        **[Required]** Gets the display_name of this CreateAttributeSetDetails.
        The display name of the attribute set. The name is unique and changeable.


        :return: The display_name of this CreateAttributeSetDetails.
        :rtype: str
        """
        return self._display_name

    @display_name.setter
    def display_name(self, display_name):
        """
        Sets the display_name of this CreateAttributeSetDetails.
        The display name of the attribute set. The name is unique and changeable.


        :param display_name: The display_name of this CreateAttributeSetDetails.
        :type: str
        """
        self._display_name = display_name

    @property
    def description(self):
        """
        Gets the description of this CreateAttributeSetDetails.
        Description of the attribute set.


        :return: The description of this CreateAttributeSetDetails.
        :rtype: str
        """
        return self._description

    @description.setter
    def description(self, description):
        """
        Sets the description of this CreateAttributeSetDetails.
        Description of the attribute set.


        :param description: The description of this CreateAttributeSetDetails.
        :type: str
        """
        self._description = description

    @property
    def compartment_id(self):
        """
        **[Required]** Gets the compartment_id of this CreateAttributeSetDetails.
        The OCID of the compartment that contains the attribute set.


        :return: The compartment_id of this CreateAttributeSetDetails.
        :rtype: str
        """
        return self._compartment_id

    @compartment_id.setter
    def compartment_id(self, compartment_id):
        """
        Sets the compartment_id of this CreateAttributeSetDetails.
        The OCID of the compartment that contains the attribute set.


        :param compartment_id: The compartment_id of this CreateAttributeSetDetails.
        :type: str
        """
        self._compartment_id = compartment_id

    @property
    def attribute_set_type(self):
        """
        **[Required]** Gets the attribute_set_type of this CreateAttributeSetDetails.
        The type of attribute set.


        :return: The attribute_set_type of this CreateAttributeSetDetails.
        :rtype: str
        """
        return self._attribute_set_type

    @attribute_set_type.setter
    def attribute_set_type(self, attribute_set_type):
        """
        Sets the attribute_set_type of this CreateAttributeSetDetails.
        The type of attribute set.


        :param attribute_set_type: The attribute_set_type of this CreateAttributeSetDetails.
        :type: str
        """
        self._attribute_set_type = attribute_set_type

    @property
    def attribute_set_values(self):
        """
        **[Required]** Gets the attribute_set_values of this CreateAttributeSetDetails.
        The list of values in an attribute set


        :return: The attribute_set_values of this CreateAttributeSetDetails.
        :rtype: list[str]
        """
        return self._attribute_set_values

    @attribute_set_values.setter
    def attribute_set_values(self, attribute_set_values):
        """
        Sets the attribute_set_values of this CreateAttributeSetDetails.
        The list of values in an attribute set


        :param attribute_set_values: The attribute_set_values of this CreateAttributeSetDetails.
        :type: list[str]
        """
        self._attribute_set_values = attribute_set_values

    @property
    def freeform_tags(self):
        """
        Gets the freeform_tags of this CreateAttributeSetDetails.
        Free-form tags for this resource. Each tag is a simple key-value pair with no predefined name, type, or namespace. For more information, see `Resource Tags`__

        Example: `{\"Department\": \"Finance\"}`

        __ https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm


        :return: The freeform_tags of this CreateAttributeSetDetails.
        :rtype: dict(str, str)
        """
        return self._freeform_tags

    @freeform_tags.setter
    def freeform_tags(self, freeform_tags):
        """
        Sets the freeform_tags of this CreateAttributeSetDetails.
        Free-form tags for this resource. Each tag is a simple key-value pair with no predefined name, type, or namespace. For more information, see `Resource Tags`__

        Example: `{\"Department\": \"Finance\"}`

        __ https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm


        :param freeform_tags: The freeform_tags of this CreateAttributeSetDetails.
        :type: dict(str, str)
        """
        self._freeform_tags = freeform_tags

    @property
    def defined_tags(self):
        """
        Gets the defined_tags of this CreateAttributeSetDetails.
        Defined tags for this resource. Each key is predefined and scoped to a namespace. For more information, see `Resource Tags`__
        Example: `{\"Operations\": {\"CostCenter\": \"42\"}}`

        __ https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm


        :return: The defined_tags of this CreateAttributeSetDetails.
        :rtype: dict(str, dict(str, object))
        """
        return self._defined_tags

    @defined_tags.setter
    def defined_tags(self, defined_tags):
        """
        Sets the defined_tags of this CreateAttributeSetDetails.
        Defined tags for this resource. Each key is predefined and scoped to a namespace. For more information, see `Resource Tags`__
        Example: `{\"Operations\": {\"CostCenter\": \"42\"}}`

        __ https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm


        :param defined_tags: The defined_tags of this CreateAttributeSetDetails.
        :type: dict(str, dict(str, object))
        """
        self._defined_tags = defined_tags

    def __repr__(self):
        return formatted_flat_dict(self)

    def __eq__(self, other):
        if other is None:
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not self == other
