# coding: utf-8
# Copyright (c) 2016, 2026, Oracle and/or its affiliates.  All rights reserved.
# This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.

# NOTE: This class is auto generated by OracleSDKGenerator. DO NOT EDIT. API Version: 20190101

from .model_group_details import ModelGroupDetails
from oci.util import formatted_flat_dict, NONE_SENTINEL, value_allowed_none_or_none_sentinel  # noqa: F401
from oci.decorators import init_model_state_from_kwargs


@init_model_state_from_kwargs
class HomogeneousModelGroupDetails(ModelGroupDetails):
    """
    Homogeneous model group type.
    """

    def __init__(self, **kwargs):
        """
        Initializes a new HomogeneousModelGroupDetails object with values from keyword arguments. The default value of the :py:attr:`~oci.data_science.models.HomogeneousModelGroupDetails.type` attribute
        of this class is ``HOMOGENEOUS`` and it should not be changed.
        The following keyword arguments are supported (corresponding to the getters/setters of this class):

        :param type:
            The value to assign to the type property of this HomogeneousModelGroupDetails.
            Allowed values for this property are: "HOMOGENEOUS", "HETEROGENEOUS", "STACKED"
        :type type: str

        :param custom_metadata_list:
            The value to assign to the custom_metadata_list property of this HomogeneousModelGroupDetails.
        :type custom_metadata_list: list[oci.data_science.models.CustomMetadata]

        """
        self.swagger_types = {
            'type': 'str',
            'custom_metadata_list': 'list[CustomMetadata]'
        }
        self.attribute_map = {
            'type': 'type',
            'custom_metadata_list': 'customMetadataList'
        }
        self._type = None
        self._custom_metadata_list = None
        self._type = 'HOMOGENEOUS'

    def __repr__(self):
        return formatted_flat_dict(self)

    def __eq__(self, other):
        if other is None:
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not self == other
