# coding: utf-8
# Copyright (c) 2016, 2026, Oracle and/or its affiliates.  All rights reserved.
# This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.

# NOTE: This class is auto generated by OracleSDKGenerator. DO NOT EDIT. API Version: 20190101

from .workload_configuration_details import WorkloadConfigurationDetails
from oci.util import formatted_flat_dict, NONE_SENTINEL, value_allowed_none_or_none_sentinel  # noqa: F401
from oci.decorators import init_model_state_from_kwargs


@init_model_state_from_kwargs
class JobRunWorkloadConfigurationDetails(WorkloadConfigurationDetails):
    """
    The job run workload configuration.
    """

    def __init__(self, **kwargs):
        """
        Initializes a new JobRunWorkloadConfigurationDetails object with values from keyword arguments. The default value of the :py:attr:`~oci.data_science.models.JobRunWorkloadConfigurationDetails.workload_type` attribute
        of this class is ``JOB_RUN`` and it should not be changed.
        The following keyword arguments are supported (corresponding to the getters/setters of this class):

        :param workload_type:
            The value to assign to the workload_type property of this JobRunWorkloadConfigurationDetails.
            Allowed values for this property are: "MODEL_DEPLOYMENT", "JOB_RUN"
        :type workload_type: str

        :param use_case_configuration:
            The value to assign to the use_case_configuration property of this JobRunWorkloadConfigurationDetails.
        :type use_case_configuration: oci.data_science.models.JobRunUseCaseConfigurationDetails

        """
        self.swagger_types = {
            'workload_type': 'str',
            'use_case_configuration': 'JobRunUseCaseConfigurationDetails'
        }
        self.attribute_map = {
            'workload_type': 'workloadType',
            'use_case_configuration': 'useCaseConfiguration'
        }
        self._workload_type = None
        self._use_case_configuration = None
        self._workload_type = 'JOB_RUN'

    @property
    def use_case_configuration(self):
        """
        Gets the use_case_configuration of this JobRunWorkloadConfigurationDetails.

        :return: The use_case_configuration of this JobRunWorkloadConfigurationDetails.
        :rtype: oci.data_science.models.JobRunUseCaseConfigurationDetails
        """
        return self._use_case_configuration

    @use_case_configuration.setter
    def use_case_configuration(self, use_case_configuration):
        """
        Sets the use_case_configuration of this JobRunWorkloadConfigurationDetails.

        :param use_case_configuration: The use_case_configuration of this JobRunWorkloadConfigurationDetails.
        :type: oci.data_science.models.JobRunUseCaseConfigurationDetails
        """
        self._use_case_configuration = use_case_configuration

    def __repr__(self):
        return formatted_flat_dict(self)

    def __eq__(self, other):
        if other is None:
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not self == other
