# coding: utf-8
# Copyright (c) 2016, 2026, Oracle and/or its affiliates.  All rights reserved.
# This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.

# NOTE: This class is auto generated by OracleSDKGenerator. DO NOT EDIT. API Version: 20190101


from oci.util import formatted_flat_dict, NONE_SENTINEL, value_allowed_none_or_none_sentinel  # noqa: F401
from oci.decorators import init_model_state_from_kwargs


@init_model_state_from_kwargs
class ModelGroupSummary(object):
    """
    Summary information for a modelGroup.
    """

    #: A constant which can be used with the lifecycle_state property of a ModelGroupSummary.
    #: This constant has a value of "CREATING"
    LIFECYCLE_STATE_CREATING = "CREATING"

    #: A constant which can be used with the lifecycle_state property of a ModelGroupSummary.
    #: This constant has a value of "ACTIVE"
    LIFECYCLE_STATE_ACTIVE = "ACTIVE"

    #: A constant which can be used with the lifecycle_state property of a ModelGroupSummary.
    #: This constant has a value of "FAILED"
    LIFECYCLE_STATE_FAILED = "FAILED"

    #: A constant which can be used with the lifecycle_state property of a ModelGroupSummary.
    #: This constant has a value of "INACTIVE"
    LIFECYCLE_STATE_INACTIVE = "INACTIVE"

    #: A constant which can be used with the lifecycle_state property of a ModelGroupSummary.
    #: This constant has a value of "DELETING"
    LIFECYCLE_STATE_DELETING = "DELETING"

    #: A constant which can be used with the lifecycle_state property of a ModelGroupSummary.
    #: This constant has a value of "DELETED"
    LIFECYCLE_STATE_DELETED = "DELETED"

    def __init__(self, **kwargs):
        """
        Initializes a new ModelGroupSummary object with values from keyword arguments.
        The following keyword arguments are supported (corresponding to the getters/setters of this class):

        :param id:
            The value to assign to the id property of this ModelGroupSummary.
        :type id: str

        :param compartment_id:
            The value to assign to the compartment_id property of this ModelGroupSummary.
        :type compartment_id: str

        :param project_id:
            The value to assign to the project_id property of this ModelGroupSummary.
        :type project_id: str

        :param display_name:
            The value to assign to the display_name property of this ModelGroupSummary.
        :type display_name: str

        :param created_by:
            The value to assign to the created_by property of this ModelGroupSummary.
        :type created_by: str

        :param time_created:
            The value to assign to the time_created property of this ModelGroupSummary.
        :type time_created: datetime

        :param time_updated:
            The value to assign to the time_updated property of this ModelGroupSummary.
        :type time_updated: datetime

        :param lifecycle_state:
            The value to assign to the lifecycle_state property of this ModelGroupSummary.
            Allowed values for this property are: "CREATING", "ACTIVE", "FAILED", "INACTIVE", "DELETING", "DELETED", 'UNKNOWN_ENUM_VALUE'.
            Any unrecognized values returned by a service will be mapped to 'UNKNOWN_ENUM_VALUE'.
        :type lifecycle_state: str

        :param lifecycle_details:
            The value to assign to the lifecycle_details property of this ModelGroupSummary.
        :type lifecycle_details: str

        :param model_group_version_history_id:
            The value to assign to the model_group_version_history_id property of this ModelGroupSummary.
        :type model_group_version_history_id: str

        :param model_group_version_history_name:
            The value to assign to the model_group_version_history_name property of this ModelGroupSummary.
        :type model_group_version_history_name: str

        :param version_label:
            The value to assign to the version_label property of this ModelGroupSummary.
        :type version_label: str

        :param version_id:
            The value to assign to the version_id property of this ModelGroupSummary.
        :type version_id: int

        :param model_group_details:
            The value to assign to the model_group_details property of this ModelGroupSummary.
        :type model_group_details: oci.data_science.models.ModelGroupDetails

        :param freeform_tags:
            The value to assign to the freeform_tags property of this ModelGroupSummary.
        :type freeform_tags: dict(str, str)

        :param defined_tags:
            The value to assign to the defined_tags property of this ModelGroupSummary.
        :type defined_tags: dict(str, dict(str, object))

        :param system_tags:
            The value to assign to the system_tags property of this ModelGroupSummary.
        :type system_tags: dict(str, dict(str, object))

        """
        self.swagger_types = {
            'id': 'str',
            'compartment_id': 'str',
            'project_id': 'str',
            'display_name': 'str',
            'created_by': 'str',
            'time_created': 'datetime',
            'time_updated': 'datetime',
            'lifecycle_state': 'str',
            'lifecycle_details': 'str',
            'model_group_version_history_id': 'str',
            'model_group_version_history_name': 'str',
            'version_label': 'str',
            'version_id': 'int',
            'model_group_details': 'ModelGroupDetails',
            'freeform_tags': 'dict(str, str)',
            'defined_tags': 'dict(str, dict(str, object))',
            'system_tags': 'dict(str, dict(str, object))'
        }
        self.attribute_map = {
            'id': 'id',
            'compartment_id': 'compartmentId',
            'project_id': 'projectId',
            'display_name': 'displayName',
            'created_by': 'createdBy',
            'time_created': 'timeCreated',
            'time_updated': 'timeUpdated',
            'lifecycle_state': 'lifecycleState',
            'lifecycle_details': 'lifecycleDetails',
            'model_group_version_history_id': 'modelGroupVersionHistoryId',
            'model_group_version_history_name': 'modelGroupVersionHistoryName',
            'version_label': 'versionLabel',
            'version_id': 'versionId',
            'model_group_details': 'modelGroupDetails',
            'freeform_tags': 'freeformTags',
            'defined_tags': 'definedTags',
            'system_tags': 'systemTags'
        }
        self._id = None
        self._compartment_id = None
        self._project_id = None
        self._display_name = None
        self._created_by = None
        self._time_created = None
        self._time_updated = None
        self._lifecycle_state = None
        self._lifecycle_details = None
        self._model_group_version_history_id = None
        self._model_group_version_history_name = None
        self._version_label = None
        self._version_id = None
        self._model_group_details = None
        self._freeform_tags = None
        self._defined_tags = None
        self._system_tags = None

    @property
    def id(self):
        """
        **[Required]** Gets the id of this ModelGroupSummary.
        The `OCID`__ of the modelGroup.

        __ https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm


        :return: The id of this ModelGroupSummary.
        :rtype: str
        """
        return self._id

    @id.setter
    def id(self, id):
        """
        Sets the id of this ModelGroupSummary.
        The `OCID`__ of the modelGroup.

        __ https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm


        :param id: The id of this ModelGroupSummary.
        :type: str
        """
        self._id = id

    @property
    def compartment_id(self):
        """
        **[Required]** Gets the compartment_id of this ModelGroupSummary.
        The `OCID`__ of the modelGroup's compartment.

        __ https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm


        :return: The compartment_id of this ModelGroupSummary.
        :rtype: str
        """
        return self._compartment_id

    @compartment_id.setter
    def compartment_id(self, compartment_id):
        """
        Sets the compartment_id of this ModelGroupSummary.
        The `OCID`__ of the modelGroup's compartment.

        __ https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm


        :param compartment_id: The compartment_id of this ModelGroupSummary.
        :type: str
        """
        self._compartment_id = compartment_id

    @property
    def project_id(self):
        """
        **[Required]** Gets the project_id of this ModelGroupSummary.
        The `OCID`__ of the project associated with the modelGroup.

        __ https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm


        :return: The project_id of this ModelGroupSummary.
        :rtype: str
        """
        return self._project_id

    @project_id.setter
    def project_id(self, project_id):
        """
        Sets the project_id of this ModelGroupSummary.
        The `OCID`__ of the project associated with the modelGroup.

        __ https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm


        :param project_id: The project_id of this ModelGroupSummary.
        :type: str
        """
        self._project_id = project_id

    @property
    def display_name(self):
        """
        **[Required]** Gets the display_name of this ModelGroupSummary.
        A user-friendly display name for the resource. It does not have to be unique and can be modified. Avoid entering confidential information.


        :return: The display_name of this ModelGroupSummary.
        :rtype: str
        """
        return self._display_name

    @display_name.setter
    def display_name(self, display_name):
        """
        Sets the display_name of this ModelGroupSummary.
        A user-friendly display name for the resource. It does not have to be unique and can be modified. Avoid entering confidential information.


        :param display_name: The display_name of this ModelGroupSummary.
        :type: str
        """
        self._display_name = display_name

    @property
    def created_by(self):
        """
        **[Required]** Gets the created_by of this ModelGroupSummary.
        The `OCID`__ of the user who created the modelGroup.

        __ https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm


        :return: The created_by of this ModelGroupSummary.
        :rtype: str
        """
        return self._created_by

    @created_by.setter
    def created_by(self, created_by):
        """
        Sets the created_by of this ModelGroupSummary.
        The `OCID`__ of the user who created the modelGroup.

        __ https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm


        :param created_by: The created_by of this ModelGroupSummary.
        :type: str
        """
        self._created_by = created_by

    @property
    def time_created(self):
        """
        **[Required]** Gets the time_created of this ModelGroupSummary.
        The date and time the resource was created in the timestamp format defined by `RFC3339`__.
        Example: 2019-08-25T21:10:29.41Z

        __ https://tools.ietf.org/html/rfc3339


        :return: The time_created of this ModelGroupSummary.
        :rtype: datetime
        """
        return self._time_created

    @time_created.setter
    def time_created(self, time_created):
        """
        Sets the time_created of this ModelGroupSummary.
        The date and time the resource was created in the timestamp format defined by `RFC3339`__.
        Example: 2019-08-25T21:10:29.41Z

        __ https://tools.ietf.org/html/rfc3339


        :param time_created: The time_created of this ModelGroupSummary.
        :type: datetime
        """
        self._time_created = time_created

    @property
    def time_updated(self):
        """
        **[Required]** Gets the time_updated of this ModelGroupSummary.
        The date and time the resource was last updated in the timestamp format defined by `RFC3339`__.
        Example: 2019-08-25T21:10:29.41Z

        __ https://tools.ietf.org/html/rfc3339


        :return: The time_updated of this ModelGroupSummary.
        :rtype: datetime
        """
        return self._time_updated

    @time_updated.setter
    def time_updated(self, time_updated):
        """
        Sets the time_updated of this ModelGroupSummary.
        The date and time the resource was last updated in the timestamp format defined by `RFC3339`__.
        Example: 2019-08-25T21:10:29.41Z

        __ https://tools.ietf.org/html/rfc3339


        :param time_updated: The time_updated of this ModelGroupSummary.
        :type: datetime
        """
        self._time_updated = time_updated

    @property
    def lifecycle_state(self):
        """
        **[Required]** Gets the lifecycle_state of this ModelGroupSummary.
        The state of the model.

        Allowed values for this property are: "CREATING", "ACTIVE", "FAILED", "INACTIVE", "DELETING", "DELETED", 'UNKNOWN_ENUM_VALUE'.
        Any unrecognized values returned by a service will be mapped to 'UNKNOWN_ENUM_VALUE'.


        :return: The lifecycle_state of this ModelGroupSummary.
        :rtype: str
        """
        return self._lifecycle_state

    @lifecycle_state.setter
    def lifecycle_state(self, lifecycle_state):
        """
        Sets the lifecycle_state of this ModelGroupSummary.
        The state of the model.


        :param lifecycle_state: The lifecycle_state of this ModelGroupSummary.
        :type: str
        """
        allowed_values = ["CREATING", "ACTIVE", "FAILED", "INACTIVE", "DELETING", "DELETED"]
        if not value_allowed_none_or_none_sentinel(lifecycle_state, allowed_values):
            lifecycle_state = 'UNKNOWN_ENUM_VALUE'
        self._lifecycle_state = lifecycle_state

    @property
    def lifecycle_details(self):
        """
        Gets the lifecycle_details of this ModelGroupSummary.
        Details about the lifecycle state of the model group.


        :return: The lifecycle_details of this ModelGroupSummary.
        :rtype: str
        """
        return self._lifecycle_details

    @lifecycle_details.setter
    def lifecycle_details(self, lifecycle_details):
        """
        Sets the lifecycle_details of this ModelGroupSummary.
        Details about the lifecycle state of the model group.


        :param lifecycle_details: The lifecycle_details of this ModelGroupSummary.
        :type: str
        """
        self._lifecycle_details = lifecycle_details

    @property
    def model_group_version_history_id(self):
        """
        Gets the model_group_version_history_id of this ModelGroupSummary.
        The `OCID`__ of the model group version history to which the modelGroup is associated.

        __ https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm


        :return: The model_group_version_history_id of this ModelGroupSummary.
        :rtype: str
        """
        return self._model_group_version_history_id

    @model_group_version_history_id.setter
    def model_group_version_history_id(self, model_group_version_history_id):
        """
        Sets the model_group_version_history_id of this ModelGroupSummary.
        The `OCID`__ of the model group version history to which the modelGroup is associated.

        __ https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm


        :param model_group_version_history_id: The model_group_version_history_id of this ModelGroupSummary.
        :type: str
        """
        self._model_group_version_history_id = model_group_version_history_id

    @property
    def model_group_version_history_name(self):
        """
        Gets the model_group_version_history_name of this ModelGroupSummary.
        The name of the model group version history to which the model group is associated.


        :return: The model_group_version_history_name of this ModelGroupSummary.
        :rtype: str
        """
        return self._model_group_version_history_name

    @model_group_version_history_name.setter
    def model_group_version_history_name(self, model_group_version_history_name):
        """
        Sets the model_group_version_history_name of this ModelGroupSummary.
        The name of the model group version history to which the model group is associated.


        :param model_group_version_history_name: The model_group_version_history_name of this ModelGroupSummary.
        :type: str
        """
        self._model_group_version_history_name = model_group_version_history_name

    @property
    def version_label(self):
        """
        Gets the version_label of this ModelGroupSummary.
        An additional description of the lifecycle state of the model group.


        :return: The version_label of this ModelGroupSummary.
        :rtype: str
        """
        return self._version_label

    @version_label.setter
    def version_label(self, version_label):
        """
        Sets the version_label of this ModelGroupSummary.
        An additional description of the lifecycle state of the model group.


        :param version_label: The version_label of this ModelGroupSummary.
        :type: str
        """
        self._version_label = version_label

    @property
    def version_id(self):
        """
        Gets the version_id of this ModelGroupSummary.
        Unique identifier assigned to each version of the model group. It would be auto-incremented number generated by service.


        :return: The version_id of this ModelGroupSummary.
        :rtype: int
        """
        return self._version_id

    @version_id.setter
    def version_id(self, version_id):
        """
        Sets the version_id of this ModelGroupSummary.
        Unique identifier assigned to each version of the model group. It would be auto-incremented number generated by service.


        :param version_id: The version_id of this ModelGroupSummary.
        :type: int
        """
        self._version_id = version_id

    @property
    def model_group_details(self):
        """
        **[Required]** Gets the model_group_details of this ModelGroupSummary.

        :return: The model_group_details of this ModelGroupSummary.
        :rtype: oci.data_science.models.ModelGroupDetails
        """
        return self._model_group_details

    @model_group_details.setter
    def model_group_details(self, model_group_details):
        """
        Sets the model_group_details of this ModelGroupSummary.

        :param model_group_details: The model_group_details of this ModelGroupSummary.
        :type: oci.data_science.models.ModelGroupDetails
        """
        self._model_group_details = model_group_details

    @property
    def freeform_tags(self):
        """
        Gets the freeform_tags of this ModelGroupSummary.
        Free-form tags for this resource. Each tag is a simple key-value pair with no predefined name, type, or namespace. See `Resource Tags`__.
        Example: `{\"Department\": \"Finance\"}`

        __ https://docs.cloud.oracle.com/Content/General/Concepts/resourcetags.htm


        :return: The freeform_tags of this ModelGroupSummary.
        :rtype: dict(str, str)
        """
        return self._freeform_tags

    @freeform_tags.setter
    def freeform_tags(self, freeform_tags):
        """
        Sets the freeform_tags of this ModelGroupSummary.
        Free-form tags for this resource. Each tag is a simple key-value pair with no predefined name, type, or namespace. See `Resource Tags`__.
        Example: `{\"Department\": \"Finance\"}`

        __ https://docs.cloud.oracle.com/Content/General/Concepts/resourcetags.htm


        :param freeform_tags: The freeform_tags of this ModelGroupSummary.
        :type: dict(str, str)
        """
        self._freeform_tags = freeform_tags

    @property
    def defined_tags(self):
        """
        Gets the defined_tags of this ModelGroupSummary.
        Defined tags for this resource. Each key is predefined and scoped to a namespace. See `Resource Tags`__.
        Example: `{\"Operations\": {\"CostCenter\": \"42\"}}`

        __ https://docs.cloud.oracle.com/Content/General/Concepts/resourcetags.htm


        :return: The defined_tags of this ModelGroupSummary.
        :rtype: dict(str, dict(str, object))
        """
        return self._defined_tags

    @defined_tags.setter
    def defined_tags(self, defined_tags):
        """
        Sets the defined_tags of this ModelGroupSummary.
        Defined tags for this resource. Each key is predefined and scoped to a namespace. See `Resource Tags`__.
        Example: `{\"Operations\": {\"CostCenter\": \"42\"}}`

        __ https://docs.cloud.oracle.com/Content/General/Concepts/resourcetags.htm


        :param defined_tags: The defined_tags of this ModelGroupSummary.
        :type: dict(str, dict(str, object))
        """
        self._defined_tags = defined_tags

    @property
    def system_tags(self):
        """
        Gets the system_tags of this ModelGroupSummary.
        Usage of system tag keys. These predefined keys are scoped to namespaces.
        Example: `{\"orcl-cloud\": {\"free-tier-retained\": \"true\"}}`


        :return: The system_tags of this ModelGroupSummary.
        :rtype: dict(str, dict(str, object))
        """
        return self._system_tags

    @system_tags.setter
    def system_tags(self, system_tags):
        """
        Sets the system_tags of this ModelGroupSummary.
        Usage of system tag keys. These predefined keys are scoped to namespaces.
        Example: `{\"orcl-cloud\": {\"free-tier-retained\": \"true\"}}`


        :param system_tags: The system_tags of this ModelGroupSummary.
        :type: dict(str, dict(str, object))
        """
        self._system_tags = system_tags

    def __repr__(self):
        return formatted_flat_dict(self)

    def __eq__(self, other):
        if other is None:
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not self == other
