# coding: utf-8
# Copyright (c) 2016, 2026, Oracle and/or its affiliates.  All rights reserved.
# This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.

# NOTE: This class is auto generated by OracleSDKGenerator. DO NOT EDIT. API Version: 20190101

from .pipeline_step_update_details import PipelineStepUpdateDetails
from oci.util import formatted_flat_dict, NONE_SENTINEL, value_allowed_none_or_none_sentinel  # noqa: F401
from oci.decorators import init_model_state_from_kwargs


@init_model_state_from_kwargs
class PipelineContainerStepUpdateDetails(PipelineStepUpdateDetails):
    """
    Update the details for a container step type.
    """

    def __init__(self, **kwargs):
        """
        Initializes a new PipelineContainerStepUpdateDetails object with values from keyword arguments. The default value of the :py:attr:`~oci.data_science.models.PipelineContainerStepUpdateDetails.step_type` attribute
        of this class is ``CONTAINER`` and it should not be changed.
        The following keyword arguments are supported (corresponding to the getters/setters of this class):

        :param step_type:
            The value to assign to the step_type property of this PipelineContainerStepUpdateDetails.
            Allowed values for this property are: "ML_JOB", "CUSTOM_SCRIPT", "CONTAINER", "DATAFLOW"
        :type step_type: str

        :param step_name:
            The value to assign to the step_name property of this PipelineContainerStepUpdateDetails.
        :type step_name: str

        :param description:
            The value to assign to the description property of this PipelineContainerStepUpdateDetails.
        :type description: str

        :param step_configuration_details:
            The value to assign to the step_configuration_details property of this PipelineContainerStepUpdateDetails.
        :type step_configuration_details: oci.data_science.models.PipelineStepConfigurationDetails

        :param step_infrastructure_configuration_details:
            The value to assign to the step_infrastructure_configuration_details property of this PipelineContainerStepUpdateDetails.
        :type step_infrastructure_configuration_details: oci.data_science.models.PipelineInfrastructureConfigurationDetails

        :param step_storage_mount_configuration_details_list:
            The value to assign to the step_storage_mount_configuration_details_list property of this PipelineContainerStepUpdateDetails.
        :type step_storage_mount_configuration_details_list: list[oci.data_science.models.StorageMountConfigurationDetails]

        :param step_parameters:
            The value to assign to the step_parameters property of this PipelineContainerStepUpdateDetails.
        :type step_parameters: oci.data_science.models.PipelineStepParameterDetails

        """
        self.swagger_types = {
            'step_type': 'str',
            'step_name': 'str',
            'description': 'str',
            'step_configuration_details': 'PipelineStepConfigurationDetails',
            'step_infrastructure_configuration_details': 'PipelineInfrastructureConfigurationDetails',
            'step_storage_mount_configuration_details_list': 'list[StorageMountConfigurationDetails]',
            'step_parameters': 'PipelineStepParameterDetails'
        }
        self.attribute_map = {
            'step_type': 'stepType',
            'step_name': 'stepName',
            'description': 'description',
            'step_configuration_details': 'stepConfigurationDetails',
            'step_infrastructure_configuration_details': 'stepInfrastructureConfigurationDetails',
            'step_storage_mount_configuration_details_list': 'stepStorageMountConfigurationDetailsList',
            'step_parameters': 'stepParameters'
        }
        self._step_type = None
        self._step_name = None
        self._description = None
        self._step_configuration_details = None
        self._step_infrastructure_configuration_details = None
        self._step_storage_mount_configuration_details_list = None
        self._step_parameters = None
        self._step_type = 'CONTAINER'

    @property
    def step_infrastructure_configuration_details(self):
        """
        Gets the step_infrastructure_configuration_details of this PipelineContainerStepUpdateDetails.

        :return: The step_infrastructure_configuration_details of this PipelineContainerStepUpdateDetails.
        :rtype: oci.data_science.models.PipelineInfrastructureConfigurationDetails
        """
        return self._step_infrastructure_configuration_details

    @step_infrastructure_configuration_details.setter
    def step_infrastructure_configuration_details(self, step_infrastructure_configuration_details):
        """
        Sets the step_infrastructure_configuration_details of this PipelineContainerStepUpdateDetails.

        :param step_infrastructure_configuration_details: The step_infrastructure_configuration_details of this PipelineContainerStepUpdateDetails.
        :type: oci.data_science.models.PipelineInfrastructureConfigurationDetails
        """
        self._step_infrastructure_configuration_details = step_infrastructure_configuration_details

    @property
    def step_storage_mount_configuration_details_list(self):
        """
        Gets the step_storage_mount_configuration_details_list of this PipelineContainerStepUpdateDetails.
        The storage mount details to mount to the instance running the pipeline step.


        :return: The step_storage_mount_configuration_details_list of this PipelineContainerStepUpdateDetails.
        :rtype: list[oci.data_science.models.StorageMountConfigurationDetails]
        """
        return self._step_storage_mount_configuration_details_list

    @step_storage_mount_configuration_details_list.setter
    def step_storage_mount_configuration_details_list(self, step_storage_mount_configuration_details_list):
        """
        Sets the step_storage_mount_configuration_details_list of this PipelineContainerStepUpdateDetails.
        The storage mount details to mount to the instance running the pipeline step.


        :param step_storage_mount_configuration_details_list: The step_storage_mount_configuration_details_list of this PipelineContainerStepUpdateDetails.
        :type: list[oci.data_science.models.StorageMountConfigurationDetails]
        """
        self._step_storage_mount_configuration_details_list = step_storage_mount_configuration_details_list

    @property
    def step_parameters(self):
        """
        Gets the step_parameters of this PipelineContainerStepUpdateDetails.

        :return: The step_parameters of this PipelineContainerStepUpdateDetails.
        :rtype: oci.data_science.models.PipelineStepParameterDetails
        """
        return self._step_parameters

    @step_parameters.setter
    def step_parameters(self, step_parameters):
        """
        Sets the step_parameters of this PipelineContainerStepUpdateDetails.

        :param step_parameters: The step_parameters of this PipelineContainerStepUpdateDetails.
        :type: oci.data_science.models.PipelineStepParameterDetails
        """
        self._step_parameters = step_parameters

    def __repr__(self):
        return formatted_flat_dict(self)

    def __eq__(self, other):
        if other is None:
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not self == other
