# coding: utf-8
# Copyright (c) 2016, 2026, Oracle and/or its affiliates.  All rights reserved.
# This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.

# NOTE: This class is auto generated by OracleSDKGenerator. DO NOT EDIT. API Version: 20160918


from oci.util import formatted_flat_dict, NONE_SENTINEL, value_allowed_none_or_none_sentinel  # noqa: F401
from oci.decorators import init_model_state_from_kwargs


@init_model_state_from_kwargs
class ActionParamValuesSummary(object):
    """
    Details of the action parameter and its possible values that is used in listParamsForActionType.
    """

    #: A constant which can be used with the parameter_type property of a ActionParamValuesSummary.
    #: This constant has a value of "BOOLEAN"
    PARAMETER_TYPE_BOOLEAN = "BOOLEAN"

    #: A constant which can be used with the parameter_type property of a ActionParamValuesSummary.
    #: This constant has a value of "STRING"
    PARAMETER_TYPE_STRING = "STRING"

    #: A constant which can be used with the parameter_type property of a ActionParamValuesSummary.
    #: This constant has a value of "INTEGER"
    PARAMETER_TYPE_INTEGER = "INTEGER"

    def __init__(self, **kwargs):
        """
        Initializes a new ActionParamValuesSummary object with values from keyword arguments.
        The following keyword arguments are supported (corresponding to the getters/setters of this class):

        :param parameter_name:
            The value to assign to the parameter_name property of this ActionParamValuesSummary.
        :type parameter_name: str

        :param parameter_type:
            The value to assign to the parameter_type property of this ActionParamValuesSummary.
            Allowed values for this property are: "BOOLEAN", "STRING", "INTEGER", 'UNKNOWN_ENUM_VALUE'.
            Any unrecognized values returned by a service will be mapped to 'UNKNOWN_ENUM_VALUE'.
        :type parameter_type: str

        :param parameter_values:
            The value to assign to the parameter_values property of this ActionParamValuesSummary.
        :type parameter_values: list[str]

        :param default_value:
            The value to assign to the default_value property of this ActionParamValuesSummary.
        :type default_value: str

        :param is_required:
            The value to assign to the is_required property of this ActionParamValuesSummary.
        :type is_required: bool

        """
        self.swagger_types = {
            'parameter_name': 'str',
            'parameter_type': 'str',
            'parameter_values': 'list[str]',
            'default_value': 'str',
            'is_required': 'bool'
        }
        self.attribute_map = {
            'parameter_name': 'parameterName',
            'parameter_type': 'parameterType',
            'parameter_values': 'parameterValues',
            'default_value': 'defaultValue',
            'is_required': 'isRequired'
        }
        self._parameter_name = None
        self._parameter_type = None
        self._parameter_values = None
        self._default_value = None
        self._is_required = None

    @property
    def parameter_name(self):
        """
        **[Required]** Gets the parameter_name of this ActionParamValuesSummary.
        The name of this parameter.


        :return: The parameter_name of this ActionParamValuesSummary.
        :rtype: str
        """
        return self._parameter_name

    @parameter_name.setter
    def parameter_name(self, parameter_name):
        """
        Sets the parameter_name of this ActionParamValuesSummary.
        The name of this parameter.


        :param parameter_name: The parameter_name of this ActionParamValuesSummary.
        :type: str
        """
        self._parameter_name = parameter_name

    @property
    def parameter_type(self):
        """
        **[Required]** Gets the parameter_type of this ActionParamValuesSummary.
        The type of the parameter.

        Allowed values for this property are: "BOOLEAN", "STRING", "INTEGER", 'UNKNOWN_ENUM_VALUE'.
        Any unrecognized values returned by a service will be mapped to 'UNKNOWN_ENUM_VALUE'.


        :return: The parameter_type of this ActionParamValuesSummary.
        :rtype: str
        """
        return self._parameter_type

    @parameter_type.setter
    def parameter_type(self, parameter_type):
        """
        Sets the parameter_type of this ActionParamValuesSummary.
        The type of the parameter.


        :param parameter_type: The parameter_type of this ActionParamValuesSummary.
        :type: str
        """
        allowed_values = ["BOOLEAN", "STRING", "INTEGER"]
        if not value_allowed_none_or_none_sentinel(parameter_type, allowed_values):
            parameter_type = 'UNKNOWN_ENUM_VALUE'
        self._parameter_type = parameter_type

    @property
    def parameter_values(self):
        """
        **[Required]** Gets the parameter_values of this ActionParamValuesSummary.
        Possible values for this parameter. In case of integer it's min and max values.


        :return: The parameter_values of this ActionParamValuesSummary.
        :rtype: list[str]
        """
        return self._parameter_values

    @parameter_values.setter
    def parameter_values(self, parameter_values):
        """
        Sets the parameter_values of this ActionParamValuesSummary.
        Possible values for this parameter. In case of integer it's min and max values.


        :param parameter_values: The parameter_values of this ActionParamValuesSummary.
        :type: list[str]
        """
        self._parameter_values = parameter_values

    @property
    def default_value(self):
        """
        Gets the default_value of this ActionParamValuesSummary.
        The default value for this parameter.


        :return: The default_value of this ActionParamValuesSummary.
        :rtype: str
        """
        return self._default_value

    @default_value.setter
    def default_value(self, default_value):
        """
        Sets the default_value of this ActionParamValuesSummary.
        The default value for this parameter.


        :param default_value: The default_value of this ActionParamValuesSummary.
        :type: str
        """
        self._default_value = default_value

    @property
    def is_required(self):
        """
        **[Required]** Gets the is_required of this ActionParamValuesSummary.
        Whether this parameter is required or not for this action type.\u3001


        :return: The is_required of this ActionParamValuesSummary.
        :rtype: bool
        """
        return self._is_required

    @is_required.setter
    def is_required(self, is_required):
        """
        Sets the is_required of this ActionParamValuesSummary.
        Whether this parameter is required or not for this action type.\u3001


        :param is_required: The is_required of this ActionParamValuesSummary.
        :type: bool
        """
        self._is_required = is_required

    def __repr__(self):
        return formatted_flat_dict(self)

    def __eq__(self, other):
        if other is None:
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not self == other
