# coding: utf-8
# Copyright (c) 2016, 2026, Oracle and/or its affiliates.  All rights reserved.
# This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.

# NOTE: This class is auto generated by OracleSDKGenerator. DO NOT EDIT. API Version: 20160918


from oci.util import formatted_flat_dict, NONE_SENTINEL, value_allowed_none_or_none_sentinel  # noqa: F401
from oci.decorators import init_model_state_from_kwargs


@init_model_state_from_kwargs
class DataPatchOptions(object):
    """
    Options for run database dataPatch operation
    """

    def __init__(self, **kwargs):
        """
        Initializes a new DataPatchOptions object with values from keyword arguments.
        The following keyword arguments are supported (corresponding to the getters/setters of this class):

        :param should_skip_closed_pdbs:
            The value to assign to the should_skip_closed_pdbs property of this DataPatchOptions.
        :type should_skip_closed_pdbs: bool

        """
        self.swagger_types = {
            'should_skip_closed_pdbs': 'bool'
        }
        self.attribute_map = {
            'should_skip_closed_pdbs': 'shouldSkipClosedPdbs'
        }
        self._should_skip_closed_pdbs = None

    @property
    def should_skip_closed_pdbs(self):
        """
        Gets the should_skip_closed_pdbs of this DataPatchOptions.
        Skip running datapatch on PDBs in closed state


        :return: The should_skip_closed_pdbs of this DataPatchOptions.
        :rtype: bool
        """
        return self._should_skip_closed_pdbs

    @should_skip_closed_pdbs.setter
    def should_skip_closed_pdbs(self, should_skip_closed_pdbs):
        """
        Sets the should_skip_closed_pdbs of this DataPatchOptions.
        Skip running datapatch on PDBs in closed state


        :param should_skip_closed_pdbs: The should_skip_closed_pdbs of this DataPatchOptions.
        :type: bool
        """
        self._should_skip_closed_pdbs = should_skip_closed_pdbs

    def __repr__(self):
        return formatted_flat_dict(self)

    def __eq__(self, other):
        if other is None:
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not self == other
