# coding: utf-8
# Copyright (c) 2016, 2026, Oracle and/or its affiliates.  All rights reserved.
# This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.

# NOTE: This class is auto generated by OracleSDKGenerator. DO NOT EDIT. API Version: 20201101


from oci.util import formatted_flat_dict, NONE_SENTINEL, value_allowed_none_or_none_sentinel  # noqa: F401
from oci.decorators import init_model_state_from_kwargs


@init_model_state_from_kwargs
class CreateCloudDbSystemDiscoveryDetails(object):
    """
    The details required to create a cloud DB system discovery resource.
    """

    #: A constant which can be used with the deployment_type property of a CreateCloudDbSystemDiscoveryDetails.
    #: This constant has a value of "VM"
    DEPLOYMENT_TYPE_VM = "VM"

    #: A constant which can be used with the deployment_type property of a CreateCloudDbSystemDiscoveryDetails.
    #: This constant has a value of "EXADATA"
    DEPLOYMENT_TYPE_EXADATA = "EXADATA"

    #: A constant which can be used with the deployment_type property of a CreateCloudDbSystemDiscoveryDetails.
    #: This constant has a value of "EXADATA_CC"
    DEPLOYMENT_TYPE_EXADATA_CC = "EXADATA_CC"

    #: A constant which can be used with the deployment_type property of a CreateCloudDbSystemDiscoveryDetails.
    #: This constant has a value of "EXADATA_XS"
    DEPLOYMENT_TYPE_EXADATA_XS = "EXADATA_XS"

    def __init__(self, **kwargs):
        """
        Initializes a new CreateCloudDbSystemDiscoveryDetails object with values from keyword arguments.
        The following keyword arguments are supported (corresponding to the getters/setters of this class):

        :param display_name:
            The value to assign to the display_name property of this CreateCloudDbSystemDiscoveryDetails.
        :type display_name: str

        :param agent_id:
            The value to assign to the agent_id property of this CreateCloudDbSystemDiscoveryDetails.
        :type agent_id: str

        :param compartment_id:
            The value to assign to the compartment_id property of this CreateCloudDbSystemDiscoveryDetails.
        :type compartment_id: str

        :param dbaas_parent_infrastructure_id:
            The value to assign to the dbaas_parent_infrastructure_id property of this CreateCloudDbSystemDiscoveryDetails.
        :type dbaas_parent_infrastructure_id: str

        :param deployment_type:
            The value to assign to the deployment_type property of this CreateCloudDbSystemDiscoveryDetails.
            Allowed values for this property are: "VM", "EXADATA", "EXADATA_CC", "EXADATA_XS"
        :type deployment_type: str

        :param freeform_tags:
            The value to assign to the freeform_tags property of this CreateCloudDbSystemDiscoveryDetails.
        :type freeform_tags: dict(str, str)

        :param defined_tags:
            The value to assign to the defined_tags property of this CreateCloudDbSystemDiscoveryDetails.
        :type defined_tags: dict(str, dict(str, object))

        """
        self.swagger_types = {
            'display_name': 'str',
            'agent_id': 'str',
            'compartment_id': 'str',
            'dbaas_parent_infrastructure_id': 'str',
            'deployment_type': 'str',
            'freeform_tags': 'dict(str, str)',
            'defined_tags': 'dict(str, dict(str, object))'
        }
        self.attribute_map = {
            'display_name': 'displayName',
            'agent_id': 'agentId',
            'compartment_id': 'compartmentId',
            'dbaas_parent_infrastructure_id': 'dbaasParentInfrastructureId',
            'deployment_type': 'deploymentType',
            'freeform_tags': 'freeformTags',
            'defined_tags': 'definedTags'
        }
        self._display_name = None
        self._agent_id = None
        self._compartment_id = None
        self._dbaas_parent_infrastructure_id = None
        self._deployment_type = None
        self._freeform_tags = None
        self._defined_tags = None

    @property
    def display_name(self):
        """
        Gets the display_name of this CreateCloudDbSystemDiscoveryDetails.
        The user-friendly name for the DB system. The name does not have to be unique.


        :return: The display_name of this CreateCloudDbSystemDiscoveryDetails.
        :rtype: str
        """
        return self._display_name

    @display_name.setter
    def display_name(self, display_name):
        """
        Sets the display_name of this CreateCloudDbSystemDiscoveryDetails.
        The user-friendly name for the DB system. The name does not have to be unique.


        :param display_name: The display_name of this CreateCloudDbSystemDiscoveryDetails.
        :type: str
        """
        self._display_name = display_name

    @property
    def agent_id(self):
        """
        **[Required]** Gets the agent_id of this CreateCloudDbSystemDiscoveryDetails.
        The `OCID`__ of the management agent
        used for the cloud DB system discovery.

        __ https://docs.cloud.oracle.com/Content/General/Concepts/identifiers.htm


        :return: The agent_id of this CreateCloudDbSystemDiscoveryDetails.
        :rtype: str
        """
        return self._agent_id

    @agent_id.setter
    def agent_id(self, agent_id):
        """
        Sets the agent_id of this CreateCloudDbSystemDiscoveryDetails.
        The `OCID`__ of the management agent
        used for the cloud DB system discovery.

        __ https://docs.cloud.oracle.com/Content/General/Concepts/identifiers.htm


        :param agent_id: The agent_id of this CreateCloudDbSystemDiscoveryDetails.
        :type: str
        """
        self._agent_id = agent_id

    @property
    def compartment_id(self):
        """
        **[Required]** Gets the compartment_id of this CreateCloudDbSystemDiscoveryDetails.
        The `OCID`__ of the compartment in which the cloud DB system resides.

        __ https://docs.cloud.oracle.com/Content/General/Concepts/identifiers.htm


        :return: The compartment_id of this CreateCloudDbSystemDiscoveryDetails.
        :rtype: str
        """
        return self._compartment_id

    @compartment_id.setter
    def compartment_id(self, compartment_id):
        """
        Sets the compartment_id of this CreateCloudDbSystemDiscoveryDetails.
        The `OCID`__ of the compartment in which the cloud DB system resides.

        __ https://docs.cloud.oracle.com/Content/General/Concepts/identifiers.htm


        :param compartment_id: The compartment_id of this CreateCloudDbSystemDiscoveryDetails.
        :type: str
        """
        self._compartment_id = compartment_id

    @property
    def dbaas_parent_infrastructure_id(self):
        """
        **[Required]** Gets the dbaas_parent_infrastructure_id of this CreateCloudDbSystemDiscoveryDetails.
        The `OCID`__ of the parent cloud DB Infrastructure. For VM Dbsystems ,
        it will be the DBSystem Id. For ExaCS and ExaCC,  it will be the cloudVmClusterId and vmClusterId respectively.

        __ https://docs.cloud.oracle.com/Content/General/Concepts/identifiers.htm


        :return: The dbaas_parent_infrastructure_id of this CreateCloudDbSystemDiscoveryDetails.
        :rtype: str
        """
        return self._dbaas_parent_infrastructure_id

    @dbaas_parent_infrastructure_id.setter
    def dbaas_parent_infrastructure_id(self, dbaas_parent_infrastructure_id):
        """
        Sets the dbaas_parent_infrastructure_id of this CreateCloudDbSystemDiscoveryDetails.
        The `OCID`__ of the parent cloud DB Infrastructure. For VM Dbsystems ,
        it will be the DBSystem Id. For ExaCS and ExaCC,  it will be the cloudVmClusterId and vmClusterId respectively.

        __ https://docs.cloud.oracle.com/Content/General/Concepts/identifiers.htm


        :param dbaas_parent_infrastructure_id: The dbaas_parent_infrastructure_id of this CreateCloudDbSystemDiscoveryDetails.
        :type: str
        """
        self._dbaas_parent_infrastructure_id = dbaas_parent_infrastructure_id

    @property
    def deployment_type(self):
        """
        **[Required]** Gets the deployment_type of this CreateCloudDbSystemDiscoveryDetails.
        The deployment type of cloud dbsystem.

        Allowed values for this property are: "VM", "EXADATA", "EXADATA_CC", "EXADATA_XS"


        :return: The deployment_type of this CreateCloudDbSystemDiscoveryDetails.
        :rtype: str
        """
        return self._deployment_type

    @deployment_type.setter
    def deployment_type(self, deployment_type):
        """
        Sets the deployment_type of this CreateCloudDbSystemDiscoveryDetails.
        The deployment type of cloud dbsystem.


        :param deployment_type: The deployment_type of this CreateCloudDbSystemDiscoveryDetails.
        :type: str
        """
        allowed_values = ["VM", "EXADATA", "EXADATA_CC", "EXADATA_XS"]
        if not value_allowed_none_or_none_sentinel(deployment_type, allowed_values):
            raise ValueError(
                f"Invalid value for `deployment_type`, must be None or one of {allowed_values}"
            )
        self._deployment_type = deployment_type

    @property
    def freeform_tags(self):
        """
        Gets the freeform_tags of this CreateCloudDbSystemDiscoveryDetails.
        Free-form tags for this resource. Each tag is a simple key-value pair with no predefined name, type, or namespace.
        For more information, see `Resource Tags`__.
        Example: `{\"Department\": \"Finance\"}`

        __ https://docs.cloud.oracle.com/Content/General/Concepts/resourcetags.htm


        :return: The freeform_tags of this CreateCloudDbSystemDiscoveryDetails.
        :rtype: dict(str, str)
        """
        return self._freeform_tags

    @freeform_tags.setter
    def freeform_tags(self, freeform_tags):
        """
        Sets the freeform_tags of this CreateCloudDbSystemDiscoveryDetails.
        Free-form tags for this resource. Each tag is a simple key-value pair with no predefined name, type, or namespace.
        For more information, see `Resource Tags`__.
        Example: `{\"Department\": \"Finance\"}`

        __ https://docs.cloud.oracle.com/Content/General/Concepts/resourcetags.htm


        :param freeform_tags: The freeform_tags of this CreateCloudDbSystemDiscoveryDetails.
        :type: dict(str, str)
        """
        self._freeform_tags = freeform_tags

    @property
    def defined_tags(self):
        """
        Gets the defined_tags of this CreateCloudDbSystemDiscoveryDetails.
        Defined tags for this resource. Each key is predefined and scoped to a namespace.
        For more information, see `Resource Tags`__.
        Example: `{\"Operations\": {\"CostCenter\": \"42\"}}`

        __ https://docs.cloud.oracle.com/Content/General/Concepts/resourcetags.htm


        :return: The defined_tags of this CreateCloudDbSystemDiscoveryDetails.
        :rtype: dict(str, dict(str, object))
        """
        return self._defined_tags

    @defined_tags.setter
    def defined_tags(self, defined_tags):
        """
        Sets the defined_tags of this CreateCloudDbSystemDiscoveryDetails.
        Defined tags for this resource. Each key is predefined and scoped to a namespace.
        For more information, see `Resource Tags`__.
        Example: `{\"Operations\": {\"CostCenter\": \"42\"}}`

        __ https://docs.cloud.oracle.com/Content/General/Concepts/resourcetags.htm


        :param defined_tags: The defined_tags of this CreateCloudDbSystemDiscoveryDetails.
        :type: dict(str, dict(str, object))
        """
        self._defined_tags = defined_tags

    def __repr__(self):
        return formatted_flat_dict(self)

    def __eq__(self, other):
        if other is None:
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not self == other
