# coding: utf-8
# Copyright (c) 2016, 2026, Oracle and/or its affiliates.  All rights reserved.
# This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.

# NOTE: This class is auto generated by OracleSDKGenerator. DO NOT EDIT. API Version: 20201101


from oci.util import formatted_flat_dict, NONE_SENTINEL, value_allowed_none_or_none_sentinel  # noqa: F401
from oci.decorators import init_model_state_from_kwargs


@init_model_state_from_kwargs
class ExadataInfrastructureLifecycleStateValues(object):
    """
    the lifecycle state values for the Exadata infrastructure.
    """

    #: A constant which can be used with the state property of a ExadataInfrastructureLifecycleStateValues.
    #: This constant has a value of "CREATING"
    STATE_CREATING = "CREATING"

    #: A constant which can be used with the state property of a ExadataInfrastructureLifecycleStateValues.
    #: This constant has a value of "ACTIVE"
    STATE_ACTIVE = "ACTIVE"

    #: A constant which can be used with the state property of a ExadataInfrastructureLifecycleStateValues.
    #: This constant has a value of "INACTIVE"
    STATE_INACTIVE = "INACTIVE"

    #: A constant which can be used with the state property of a ExadataInfrastructureLifecycleStateValues.
    #: This constant has a value of "UPDATING"
    STATE_UPDATING = "UPDATING"

    #: A constant which can be used with the state property of a ExadataInfrastructureLifecycleStateValues.
    #: This constant has a value of "DELETING"
    STATE_DELETING = "DELETING"

    #: A constant which can be used with the state property of a ExadataInfrastructureLifecycleStateValues.
    #: This constant has a value of "DELETED"
    STATE_DELETED = "DELETED"

    #: A constant which can be used with the state property of a ExadataInfrastructureLifecycleStateValues.
    #: This constant has a value of "FAILED"
    STATE_FAILED = "FAILED"

    #: A constant which can be used with the state property of a ExadataInfrastructureLifecycleStateValues.
    #: This constant has a value of "UNKNOWN"
    STATE_UNKNOWN = "UNKNOWN"

    def __init__(self, **kwargs):
        """
        Initializes a new ExadataInfrastructureLifecycleStateValues object with values from keyword arguments.
        The following keyword arguments are supported (corresponding to the getters/setters of this class):

        :param state:
            The value to assign to the state property of this ExadataInfrastructureLifecycleStateValues.
            Allowed values for this property are: "CREATING", "ACTIVE", "INACTIVE", "UPDATING", "DELETING", "DELETED", "FAILED", "UNKNOWN"
        :type state: str

        """
        self.swagger_types = {
            'state': 'str'
        }
        self.attribute_map = {
            'state': 'state'
        }
        self._state = None

    @property
    def state(self):
        """
        Gets the state of this ExadataInfrastructureLifecycleStateValues.
        The current lifecycle state of the Exadata infrastructure resource.

        Allowed values for this property are: "CREATING", "ACTIVE", "INACTIVE", "UPDATING", "DELETING", "DELETED", "FAILED", "UNKNOWN"


        :return: The state of this ExadataInfrastructureLifecycleStateValues.
        :rtype: str
        """
        return self._state

    @state.setter
    def state(self, state):
        """
        Sets the state of this ExadataInfrastructureLifecycleStateValues.
        The current lifecycle state of the Exadata infrastructure resource.


        :param state: The state of this ExadataInfrastructureLifecycleStateValues.
        :type: str
        """
        allowed_values = ["CREATING", "ACTIVE", "INACTIVE", "UPDATING", "DELETING", "DELETED", "FAILED", "UNKNOWN"]
        if not value_allowed_none_or_none_sentinel(state, allowed_values):
            raise ValueError(
                f"Invalid value for `state`, must be None or one of {allowed_values}"
            )
        self._state = state

    def __repr__(self):
        return formatted_flat_dict(self)

    def __eq__(self, other):
        if other is None:
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not self == other
