# coding: utf-8
# Copyright (c) 2016, 2026, Oracle and/or its affiliates.  All rights reserved.
# This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.

# NOTE: This class is auto generated by OracleSDKGenerator. DO NOT EDIT. API Version: 20201101


from oci.util import formatted_flat_dict, NONE_SENTINEL, value_allowed_none_or_none_sentinel  # noqa: F401
from oci.decorators import init_model_state_from_kwargs


@init_model_state_from_kwargs
class HeatWaveClusterUsageMetrics(object):
    """
    The list of aggregated metrics for a HeatWave cluster in the fleet.
    """

    #: A constant which can be used with the status property of a HeatWaveClusterUsageMetrics.
    #: This constant has a value of "UP"
    STATUS_UP = "UP"

    #: A constant which can be used with the status property of a HeatWaveClusterUsageMetrics.
    #: This constant has a value of "DOWN"
    STATUS_DOWN = "DOWN"

    #: A constant which can be used with the status property of a HeatWaveClusterUsageMetrics.
    #: This constant has a value of "UNKNOWN"
    STATUS_UNKNOWN = "UNKNOWN"

    def __init__(self, **kwargs):
        """
        Initializes a new HeatWaveClusterUsageMetrics object with values from keyword arguments.
        The following keyword arguments are supported (corresponding to the getters/setters of this class):

        :param status:
            The value to assign to the status property of this HeatWaveClusterUsageMetrics.
            Allowed values for this property are: "UP", "DOWN", "UNKNOWN", 'UNKNOWN_ENUM_VALUE'.
            Any unrecognized values returned by a service will be mapped to 'UNKNOWN_ENUM_VALUE'.
        :type status: str

        :param db_system_id:
            The value to assign to the db_system_id property of this HeatWaveClusterUsageMetrics.
        :type db_system_id: str

        :param db_system_name:
            The value to assign to the db_system_name property of this HeatWaveClusterUsageMetrics.
        :type db_system_name: str

        :param heat_wave_cluster_display_name:
            The value to assign to the heat_wave_cluster_display_name property of this HeatWaveClusterUsageMetrics.
        :type heat_wave_cluster_display_name: str

        :param node_count:
            The value to assign to the node_count property of this HeatWaveClusterUsageMetrics.
        :type node_count: int

        :param is_lakehouse_enabled:
            The value to assign to the is_lakehouse_enabled property of this HeatWaveClusterUsageMetrics.
        :type is_lakehouse_enabled: bool

        :param heat_wave_node_shape:
            The value to assign to the heat_wave_node_shape property of this HeatWaveClusterUsageMetrics.
        :type heat_wave_node_shape: str

        :param memory_size:
            The value to assign to the memory_size property of this HeatWaveClusterUsageMetrics.
        :type memory_size: int

        :param metrics:
            The value to assign to the metrics property of this HeatWaveClusterUsageMetrics.
        :type metrics: list[oci.database_management.models.HeatWaveFleetMetricDefinition]

        """
        self.swagger_types = {
            'status': 'str',
            'db_system_id': 'str',
            'db_system_name': 'str',
            'heat_wave_cluster_display_name': 'str',
            'node_count': 'int',
            'is_lakehouse_enabled': 'bool',
            'heat_wave_node_shape': 'str',
            'memory_size': 'int',
            'metrics': 'list[HeatWaveFleetMetricDefinition]'
        }
        self.attribute_map = {
            'status': 'status',
            'db_system_id': 'dbSystemId',
            'db_system_name': 'dbSystemName',
            'heat_wave_cluster_display_name': 'heatWaveClusterDisplayName',
            'node_count': 'nodeCount',
            'is_lakehouse_enabled': 'isLakehouseEnabled',
            'heat_wave_node_shape': 'heatWaveNodeShape',
            'memory_size': 'memorySize',
            'metrics': 'metrics'
        }
        self._status = None
        self._db_system_id = None
        self._db_system_name = None
        self._heat_wave_cluster_display_name = None
        self._node_count = None
        self._is_lakehouse_enabled = None
        self._heat_wave_node_shape = None
        self._memory_size = None
        self._metrics = None

    @property
    def status(self):
        """
        **[Required]** Gets the status of this HeatWaveClusterUsageMetrics.
        The status of the HeatWave cluster. Indicates whether the status of the cluster is UP, DOWN, or UNKNOWN at the current time.

        Allowed values for this property are: "UP", "DOWN", "UNKNOWN", 'UNKNOWN_ENUM_VALUE'.
        Any unrecognized values returned by a service will be mapped to 'UNKNOWN_ENUM_VALUE'.


        :return: The status of this HeatWaveClusterUsageMetrics.
        :rtype: str
        """
        return self._status

    @status.setter
    def status(self, status):
        """
        Sets the status of this HeatWaveClusterUsageMetrics.
        The status of the HeatWave cluster. Indicates whether the status of the cluster is UP, DOWN, or UNKNOWN at the current time.


        :param status: The status of this HeatWaveClusterUsageMetrics.
        :type: str
        """
        allowed_values = ["UP", "DOWN", "UNKNOWN"]
        if not value_allowed_none_or_none_sentinel(status, allowed_values):
            status = 'UNKNOWN_ENUM_VALUE'
        self._status = status

    @property
    def db_system_id(self):
        """
        **[Required]** Gets the db_system_id of this HeatWaveClusterUsageMetrics.
        The OCID of the MySQL Database System associated with the HeatWave cluster.


        :return: The db_system_id of this HeatWaveClusterUsageMetrics.
        :rtype: str
        """
        return self._db_system_id

    @db_system_id.setter
    def db_system_id(self, db_system_id):
        """
        Sets the db_system_id of this HeatWaveClusterUsageMetrics.
        The OCID of the MySQL Database System associated with the HeatWave cluster.


        :param db_system_id: The db_system_id of this HeatWaveClusterUsageMetrics.
        :type: str
        """
        self._db_system_id = db_system_id

    @property
    def db_system_name(self):
        """
        **[Required]** Gets the db_system_name of this HeatWaveClusterUsageMetrics.
        The name of the MySQL Database System associated with the HeatWave cluster.


        :return: The db_system_name of this HeatWaveClusterUsageMetrics.
        :rtype: str
        """
        return self._db_system_name

    @db_system_name.setter
    def db_system_name(self, db_system_name):
        """
        Sets the db_system_name of this HeatWaveClusterUsageMetrics.
        The name of the MySQL Database System associated with the HeatWave cluster.


        :param db_system_name: The db_system_name of this HeatWaveClusterUsageMetrics.
        :type: str
        """
        self._db_system_name = db_system_name

    @property
    def heat_wave_cluster_display_name(self):
        """
        **[Required]** Gets the heat_wave_cluster_display_name of this HeatWaveClusterUsageMetrics.
        The name of the HeatWave cluster.


        :return: The heat_wave_cluster_display_name of this HeatWaveClusterUsageMetrics.
        :rtype: str
        """
        return self._heat_wave_cluster_display_name

    @heat_wave_cluster_display_name.setter
    def heat_wave_cluster_display_name(self, heat_wave_cluster_display_name):
        """
        Sets the heat_wave_cluster_display_name of this HeatWaveClusterUsageMetrics.
        The name of the HeatWave cluster.


        :param heat_wave_cluster_display_name: The heat_wave_cluster_display_name of this HeatWaveClusterUsageMetrics.
        :type: str
        """
        self._heat_wave_cluster_display_name = heat_wave_cluster_display_name

    @property
    def node_count(self):
        """
        **[Required]** Gets the node_count of this HeatWaveClusterUsageMetrics.
        The number of nodes in the HeatWave cluster.


        :return: The node_count of this HeatWaveClusterUsageMetrics.
        :rtype: int
        """
        return self._node_count

    @node_count.setter
    def node_count(self, node_count):
        """
        Sets the node_count of this HeatWaveClusterUsageMetrics.
        The number of nodes in the HeatWave cluster.


        :param node_count: The node_count of this HeatWaveClusterUsageMetrics.
        :type: int
        """
        self._node_count = node_count

    @property
    def is_lakehouse_enabled(self):
        """
        **[Required]** Gets the is_lakehouse_enabled of this HeatWaveClusterUsageMetrics.
        Indicates whether Lakehouse is enabled for the HeatWave cluster or not.


        :return: The is_lakehouse_enabled of this HeatWaveClusterUsageMetrics.
        :rtype: bool
        """
        return self._is_lakehouse_enabled

    @is_lakehouse_enabled.setter
    def is_lakehouse_enabled(self, is_lakehouse_enabled):
        """
        Sets the is_lakehouse_enabled of this HeatWaveClusterUsageMetrics.
        Indicates whether Lakehouse is enabled for the HeatWave cluster or not.


        :param is_lakehouse_enabled: The is_lakehouse_enabled of this HeatWaveClusterUsageMetrics.
        :type: bool
        """
        self._is_lakehouse_enabled = is_lakehouse_enabled

    @property
    def heat_wave_node_shape(self):
        """
        **[Required]** Gets the heat_wave_node_shape of this HeatWaveClusterUsageMetrics.
        The shape of the nodes in the HeatWave cluster.


        :return: The heat_wave_node_shape of this HeatWaveClusterUsageMetrics.
        :rtype: str
        """
        return self._heat_wave_node_shape

    @heat_wave_node_shape.setter
    def heat_wave_node_shape(self, heat_wave_node_shape):
        """
        Sets the heat_wave_node_shape of this HeatWaveClusterUsageMetrics.
        The shape of the nodes in the HeatWave cluster.


        :param heat_wave_node_shape: The heat_wave_node_shape of this HeatWaveClusterUsageMetrics.
        :type: str
        """
        self._heat_wave_node_shape = heat_wave_node_shape

    @property
    def memory_size(self):
        """
        **[Required]** Gets the memory_size of this HeatWaveClusterUsageMetrics.
        The total memory belonging to the HeatWave cluster in GBs.


        :return: The memory_size of this HeatWaveClusterUsageMetrics.
        :rtype: int
        """
        return self._memory_size

    @memory_size.setter
    def memory_size(self, memory_size):
        """
        Sets the memory_size of this HeatWaveClusterUsageMetrics.
        The total memory belonging to the HeatWave cluster in GBs.


        :param memory_size: The memory_size of this HeatWaveClusterUsageMetrics.
        :type: int
        """
        self._memory_size = memory_size

    @property
    def metrics(self):
        """
        **[Required]** Gets the metrics of this HeatWaveClusterUsageMetrics.
        A list of the HeatWave cluster health metrics like CPU and Memory.


        :return: The metrics of this HeatWaveClusterUsageMetrics.
        :rtype: list[oci.database_management.models.HeatWaveFleetMetricDefinition]
        """
        return self._metrics

    @metrics.setter
    def metrics(self, metrics):
        """
        Sets the metrics of this HeatWaveClusterUsageMetrics.
        A list of the HeatWave cluster health metrics like CPU and Memory.


        :param metrics: The metrics of this HeatWaveClusterUsageMetrics.
        :type: list[oci.database_management.models.HeatWaveFleetMetricDefinition]
        """
        self._metrics = metrics

    def __repr__(self):
        return formatted_flat_dict(self)

    def __eq__(self, other):
        if other is None:
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not self == other
