# coding: utf-8
# Copyright (c) 2016, 2026, Oracle and/or its affiliates.  All rights reserved.
# This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.

# NOTE: This class is auto generated by OracleSDKGenerator. DO NOT EDIT. API Version: 20230518

from .create_migration_details import CreateMigrationDetails
from oci.util import formatted_flat_dict, NONE_SENTINEL, value_allowed_none_or_none_sentinel  # noqa: F401
from oci.decorators import init_model_state_from_kwargs


@init_model_state_from_kwargs
class CreateOracleMigrationDetails(CreateMigrationDetails):
    """
    Create Migration resource parameters.
    """

    def __init__(self, **kwargs):
        """
        Initializes a new CreateOracleMigrationDetails object with values from keyword arguments. The default value of the :py:attr:`~oci.database_migration.models.CreateOracleMigrationDetails.database_combination` attribute
        of this class is ``ORACLE`` and it should not be changed.
        The following keyword arguments are supported (corresponding to the getters/setters of this class):

        :param description:
            The value to assign to the description property of this CreateOracleMigrationDetails.
        :type description: str

        :param compartment_id:
            The value to assign to the compartment_id property of this CreateOracleMigrationDetails.
        :type compartment_id: str

        :param database_combination:
            The value to assign to the database_combination property of this CreateOracleMigrationDetails.
            Allowed values for this property are: "MYSQL", "ORACLE"
        :type database_combination: str

        :param type:
            The value to assign to the type property of this CreateOracleMigrationDetails.
            Allowed values for this property are: "ONLINE", "OFFLINE"
        :type type: str

        :param display_name:
            The value to assign to the display_name property of this CreateOracleMigrationDetails.
        :type display_name: str

        :param source_database_connection_id:
            The value to assign to the source_database_connection_id property of this CreateOracleMigrationDetails.
        :type source_database_connection_id: str

        :param target_database_connection_id:
            The value to assign to the target_database_connection_id property of this CreateOracleMigrationDetails.
        :type target_database_connection_id: str

        :param freeform_tags:
            The value to assign to the freeform_tags property of this CreateOracleMigrationDetails.
        :type freeform_tags: dict(str, str)

        :param defined_tags:
            The value to assign to the defined_tags property of this CreateOracleMigrationDetails.
        :type defined_tags: dict(str, dict(str, object))

        :param data_transfer_medium_details:
            The value to assign to the data_transfer_medium_details property of this CreateOracleMigrationDetails.
        :type data_transfer_medium_details: oci.database_migration.models.CreateOracleDataTransferMediumDetails

        :param initial_load_settings:
            The value to assign to the initial_load_settings property of this CreateOracleMigrationDetails.
        :type initial_load_settings: oci.database_migration.models.CreateOracleInitialLoadSettings

        :param advisor_settings:
            The value to assign to the advisor_settings property of this CreateOracleMigrationDetails.
        :type advisor_settings: oci.database_migration.models.CreateOracleAdvisorSettings

        :param hub_details:
            The value to assign to the hub_details property of this CreateOracleMigrationDetails.
        :type hub_details: oci.database_migration.models.CreateGoldenGateHubDetails

        :param ggs_details:
            The value to assign to the ggs_details property of this CreateOracleMigrationDetails.
        :type ggs_details: oci.database_migration.models.CreateOracleGgsDeploymentDetails

        :param advanced_parameters:
            The value to assign to the advanced_parameters property of this CreateOracleMigrationDetails.
        :type advanced_parameters: list[oci.database_migration.models.MigrationParameterDetails]

        :param source_container_database_connection_id:
            The value to assign to the source_container_database_connection_id property of this CreateOracleMigrationDetails.
        :type source_container_database_connection_id: str

        :param source_standby_database_connection_id:
            The value to assign to the source_standby_database_connection_id property of this CreateOracleMigrationDetails.
        :type source_standby_database_connection_id: str

        :param exclude_objects:
            The value to assign to the exclude_objects property of this CreateOracleMigrationDetails.
        :type exclude_objects: list[oci.database_migration.models.OracleDatabaseObject]

        :param include_objects:
            The value to assign to the include_objects property of this CreateOracleMigrationDetails.
        :type include_objects: list[oci.database_migration.models.OracleDatabaseObject]

        :param bulk_include_exclude_data:
            The value to assign to the bulk_include_exclude_data property of this CreateOracleMigrationDetails.
        :type bulk_include_exclude_data: str

        """
        self.swagger_types = {
            'description': 'str',
            'compartment_id': 'str',
            'database_combination': 'str',
            'type': 'str',
            'display_name': 'str',
            'source_database_connection_id': 'str',
            'target_database_connection_id': 'str',
            'freeform_tags': 'dict(str, str)',
            'defined_tags': 'dict(str, dict(str, object))',
            'data_transfer_medium_details': 'CreateOracleDataTransferMediumDetails',
            'initial_load_settings': 'CreateOracleInitialLoadSettings',
            'advisor_settings': 'CreateOracleAdvisorSettings',
            'hub_details': 'CreateGoldenGateHubDetails',
            'ggs_details': 'CreateOracleGgsDeploymentDetails',
            'advanced_parameters': 'list[MigrationParameterDetails]',
            'source_container_database_connection_id': 'str',
            'source_standby_database_connection_id': 'str',
            'exclude_objects': 'list[OracleDatabaseObject]',
            'include_objects': 'list[OracleDatabaseObject]',
            'bulk_include_exclude_data': 'str'
        }
        self.attribute_map = {
            'description': 'description',
            'compartment_id': 'compartmentId',
            'database_combination': 'databaseCombination',
            'type': 'type',
            'display_name': 'displayName',
            'source_database_connection_id': 'sourceDatabaseConnectionId',
            'target_database_connection_id': 'targetDatabaseConnectionId',
            'freeform_tags': 'freeformTags',
            'defined_tags': 'definedTags',
            'data_transfer_medium_details': 'dataTransferMediumDetails',
            'initial_load_settings': 'initialLoadSettings',
            'advisor_settings': 'advisorSettings',
            'hub_details': 'hubDetails',
            'ggs_details': 'ggsDetails',
            'advanced_parameters': 'advancedParameters',
            'source_container_database_connection_id': 'sourceContainerDatabaseConnectionId',
            'source_standby_database_connection_id': 'sourceStandbyDatabaseConnectionId',
            'exclude_objects': 'excludeObjects',
            'include_objects': 'includeObjects',
            'bulk_include_exclude_data': 'bulkIncludeExcludeData'
        }
        self._description = None
        self._compartment_id = None
        self._database_combination = None
        self._type = None
        self._display_name = None
        self._source_database_connection_id = None
        self._target_database_connection_id = None
        self._freeform_tags = None
        self._defined_tags = None
        self._data_transfer_medium_details = None
        self._initial_load_settings = None
        self._advisor_settings = None
        self._hub_details = None
        self._ggs_details = None
        self._advanced_parameters = None
        self._source_container_database_connection_id = None
        self._source_standby_database_connection_id = None
        self._exclude_objects = None
        self._include_objects = None
        self._bulk_include_exclude_data = None
        self._database_combination = 'ORACLE'

    @property
    def data_transfer_medium_details(self):
        """
        Gets the data_transfer_medium_details of this CreateOracleMigrationDetails.

        :return: The data_transfer_medium_details of this CreateOracleMigrationDetails.
        :rtype: oci.database_migration.models.CreateOracleDataTransferMediumDetails
        """
        return self._data_transfer_medium_details

    @data_transfer_medium_details.setter
    def data_transfer_medium_details(self, data_transfer_medium_details):
        """
        Sets the data_transfer_medium_details of this CreateOracleMigrationDetails.

        :param data_transfer_medium_details: The data_transfer_medium_details of this CreateOracleMigrationDetails.
        :type: oci.database_migration.models.CreateOracleDataTransferMediumDetails
        """
        self._data_transfer_medium_details = data_transfer_medium_details

    @property
    def initial_load_settings(self):
        """
        Gets the initial_load_settings of this CreateOracleMigrationDetails.

        :return: The initial_load_settings of this CreateOracleMigrationDetails.
        :rtype: oci.database_migration.models.CreateOracleInitialLoadSettings
        """
        return self._initial_load_settings

    @initial_load_settings.setter
    def initial_load_settings(self, initial_load_settings):
        """
        Sets the initial_load_settings of this CreateOracleMigrationDetails.

        :param initial_load_settings: The initial_load_settings of this CreateOracleMigrationDetails.
        :type: oci.database_migration.models.CreateOracleInitialLoadSettings
        """
        self._initial_load_settings = initial_load_settings

    @property
    def advisor_settings(self):
        """
        Gets the advisor_settings of this CreateOracleMigrationDetails.

        :return: The advisor_settings of this CreateOracleMigrationDetails.
        :rtype: oci.database_migration.models.CreateOracleAdvisorSettings
        """
        return self._advisor_settings

    @advisor_settings.setter
    def advisor_settings(self, advisor_settings):
        """
        Sets the advisor_settings of this CreateOracleMigrationDetails.

        :param advisor_settings: The advisor_settings of this CreateOracleMigrationDetails.
        :type: oci.database_migration.models.CreateOracleAdvisorSettings
        """
        self._advisor_settings = advisor_settings

    @property
    def hub_details(self):
        """
        Gets the hub_details of this CreateOracleMigrationDetails.

        :return: The hub_details of this CreateOracleMigrationDetails.
        :rtype: oci.database_migration.models.CreateGoldenGateHubDetails
        """
        return self._hub_details

    @hub_details.setter
    def hub_details(self, hub_details):
        """
        Sets the hub_details of this CreateOracleMigrationDetails.

        :param hub_details: The hub_details of this CreateOracleMigrationDetails.
        :type: oci.database_migration.models.CreateGoldenGateHubDetails
        """
        self._hub_details = hub_details

    @property
    def ggs_details(self):
        """
        Gets the ggs_details of this CreateOracleMigrationDetails.

        :return: The ggs_details of this CreateOracleMigrationDetails.
        :rtype: oci.database_migration.models.CreateOracleGgsDeploymentDetails
        """
        return self._ggs_details

    @ggs_details.setter
    def ggs_details(self, ggs_details):
        """
        Sets the ggs_details of this CreateOracleMigrationDetails.

        :param ggs_details: The ggs_details of this CreateOracleMigrationDetails.
        :type: oci.database_migration.models.CreateOracleGgsDeploymentDetails
        """
        self._ggs_details = ggs_details

    @property
    def advanced_parameters(self):
        """
        Gets the advanced_parameters of this CreateOracleMigrationDetails.
        List of Migration Parameter objects.


        :return: The advanced_parameters of this CreateOracleMigrationDetails.
        :rtype: list[oci.database_migration.models.MigrationParameterDetails]
        """
        return self._advanced_parameters

    @advanced_parameters.setter
    def advanced_parameters(self, advanced_parameters):
        """
        Sets the advanced_parameters of this CreateOracleMigrationDetails.
        List of Migration Parameter objects.


        :param advanced_parameters: The advanced_parameters of this CreateOracleMigrationDetails.
        :type: list[oci.database_migration.models.MigrationParameterDetails]
        """
        self._advanced_parameters = advanced_parameters

    @property
    def source_container_database_connection_id(self):
        """
        Gets the source_container_database_connection_id of this CreateOracleMigrationDetails.
        The OCID of the resource being referenced.


        :return: The source_container_database_connection_id of this CreateOracleMigrationDetails.
        :rtype: str
        """
        return self._source_container_database_connection_id

    @source_container_database_connection_id.setter
    def source_container_database_connection_id(self, source_container_database_connection_id):
        """
        Sets the source_container_database_connection_id of this CreateOracleMigrationDetails.
        The OCID of the resource being referenced.


        :param source_container_database_connection_id: The source_container_database_connection_id of this CreateOracleMigrationDetails.
        :type: str
        """
        self._source_container_database_connection_id = source_container_database_connection_id

    @property
    def source_standby_database_connection_id(self):
        """
        Gets the source_standby_database_connection_id of this CreateOracleMigrationDetails.
        The OCID of the resource being referenced.


        :return: The source_standby_database_connection_id of this CreateOracleMigrationDetails.
        :rtype: str
        """
        return self._source_standby_database_connection_id

    @source_standby_database_connection_id.setter
    def source_standby_database_connection_id(self, source_standby_database_connection_id):
        """
        Sets the source_standby_database_connection_id of this CreateOracleMigrationDetails.
        The OCID of the resource being referenced.


        :param source_standby_database_connection_id: The source_standby_database_connection_id of this CreateOracleMigrationDetails.
        :type: str
        """
        self._source_standby_database_connection_id = source_standby_database_connection_id

    @property
    def exclude_objects(self):
        """
        Gets the exclude_objects of this CreateOracleMigrationDetails.
        Database objects to exclude from migration, cannot be specified alongside 'includeObjects'


        :return: The exclude_objects of this CreateOracleMigrationDetails.
        :rtype: list[oci.database_migration.models.OracleDatabaseObject]
        """
        return self._exclude_objects

    @exclude_objects.setter
    def exclude_objects(self, exclude_objects):
        """
        Sets the exclude_objects of this CreateOracleMigrationDetails.
        Database objects to exclude from migration, cannot be specified alongside 'includeObjects'


        :param exclude_objects: The exclude_objects of this CreateOracleMigrationDetails.
        :type: list[oci.database_migration.models.OracleDatabaseObject]
        """
        self._exclude_objects = exclude_objects

    @property
    def include_objects(self):
        """
        Gets the include_objects of this CreateOracleMigrationDetails.
        Database objects to include from migration, cannot be specified alongside 'excludeObjects'


        :return: The include_objects of this CreateOracleMigrationDetails.
        :rtype: list[oci.database_migration.models.OracleDatabaseObject]
        """
        return self._include_objects

    @include_objects.setter
    def include_objects(self, include_objects):
        """
        Sets the include_objects of this CreateOracleMigrationDetails.
        Database objects to include from migration, cannot be specified alongside 'excludeObjects'


        :param include_objects: The include_objects of this CreateOracleMigrationDetails.
        :type: list[oci.database_migration.models.OracleDatabaseObject]
        """
        self._include_objects = include_objects

    @property
    def bulk_include_exclude_data(self):
        """
        Gets the bulk_include_exclude_data of this CreateOracleMigrationDetails.
        Specifies the database objects to be excluded from the migration in bulk.
        The definition accepts input in a CSV format, newline separated for each entry.
        More details can be found in the documentation.


        :return: The bulk_include_exclude_data of this CreateOracleMigrationDetails.
        :rtype: str
        """
        return self._bulk_include_exclude_data

    @bulk_include_exclude_data.setter
    def bulk_include_exclude_data(self, bulk_include_exclude_data):
        """
        Sets the bulk_include_exclude_data of this CreateOracleMigrationDetails.
        Specifies the database objects to be excluded from the migration in bulk.
        The definition accepts input in a CSV format, newline separated for each entry.
        More details can be found in the documentation.


        :param bulk_include_exclude_data: The bulk_include_exclude_data of this CreateOracleMigrationDetails.
        :type: str
        """
        self._bulk_include_exclude_data = bulk_include_exclude_data

    def __repr__(self):
        return formatted_flat_dict(self)

    def __eq__(self, other):
        if other is None:
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not self == other
