# coding: utf-8
# Copyright (c) 2016, 2026, Oracle and/or its affiliates.  All rights reserved.
# This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.

# NOTE: This class is auto generated by OracleSDKGenerator. DO NOT EDIT. API Version: 20201005

from .database_tools_identity_summary import DatabaseToolsIdentitySummary
from oci.util import formatted_flat_dict, NONE_SENTINEL, value_allowed_none_or_none_sentinel  # noqa: F401
from oci.decorators import init_model_state_from_kwargs


@init_model_state_from_kwargs
class DatabaseToolsIdentityOracleDatabaseResourcePrincipalSummary(DatabaseToolsIdentitySummary):
    """
    Summary of the Database Tools identity for the Oracle Database Resource Principal Identity type.
    """

    def __init__(self, **kwargs):
        """
        Initializes a new DatabaseToolsIdentityOracleDatabaseResourcePrincipalSummary object with values from keyword arguments. The default value of the :py:attr:`~oci.database_tools.models.DatabaseToolsIdentityOracleDatabaseResourcePrincipalSummary.type` attribute
        of this class is ``ORACLE_DATABASE_RESOURCE_PRINCIPAL`` and it should not be changed.
        The following keyword arguments are supported (corresponding to the getters/setters of this class):

        :param id:
            The value to assign to the id property of this DatabaseToolsIdentityOracleDatabaseResourcePrincipalSummary.
        :type id: str

        :param type:
            The value to assign to the type property of this DatabaseToolsIdentityOracleDatabaseResourcePrincipalSummary.
            Allowed values for this property are: "ORACLE_DATABASE_RESOURCE_PRINCIPAL"
        :type type: str

        :param compartment_id:
            The value to assign to the compartment_id property of this DatabaseToolsIdentityOracleDatabaseResourcePrincipalSummary.
        :type compartment_id: str

        :param display_name:
            The value to assign to the display_name property of this DatabaseToolsIdentityOracleDatabaseResourcePrincipalSummary.
        :type display_name: str

        :param database_tools_connection_id:
            The value to assign to the database_tools_connection_id property of this DatabaseToolsIdentityOracleDatabaseResourcePrincipalSummary.
        :type database_tools_connection_id: str

        :param lifecycle_state:
            The value to assign to the lifecycle_state property of this DatabaseToolsIdentityOracleDatabaseResourcePrincipalSummary.
            Allowed values for this property are: "CREATING", "UPDATING", "ACTIVE", "DELETING", "DELETED", "FAILED", "NEEDS_ATTENTION"
        :type lifecycle_state: str

        :param lifecycle_details:
            The value to assign to the lifecycle_details property of this DatabaseToolsIdentityOracleDatabaseResourcePrincipalSummary.
        :type lifecycle_details: str

        :param time_created:
            The value to assign to the time_created property of this DatabaseToolsIdentityOracleDatabaseResourcePrincipalSummary.
        :type time_created: datetime

        :param time_updated:
            The value to assign to the time_updated property of this DatabaseToolsIdentityOracleDatabaseResourcePrincipalSummary.
        :type time_updated: datetime

        :param defined_tags:
            The value to assign to the defined_tags property of this DatabaseToolsIdentityOracleDatabaseResourcePrincipalSummary.
        :type defined_tags: dict(str, dict(str, object))

        :param freeform_tags:
            The value to assign to the freeform_tags property of this DatabaseToolsIdentityOracleDatabaseResourcePrincipalSummary.
        :type freeform_tags: dict(str, str)

        :param system_tags:
            The value to assign to the system_tags property of this DatabaseToolsIdentityOracleDatabaseResourcePrincipalSummary.
        :type system_tags: dict(str, dict(str, object))

        :param locks:
            The value to assign to the locks property of this DatabaseToolsIdentityOracleDatabaseResourcePrincipalSummary.
        :type locks: list[oci.database_tools.models.ResourceLock]

        :param credential_key:
            The value to assign to the credential_key property of this DatabaseToolsIdentityOracleDatabaseResourcePrincipalSummary.
        :type credential_key: str

        """
        self.swagger_types = {
            'id': 'str',
            'type': 'str',
            'compartment_id': 'str',
            'display_name': 'str',
            'database_tools_connection_id': 'str',
            'lifecycle_state': 'str',
            'lifecycle_details': 'str',
            'time_created': 'datetime',
            'time_updated': 'datetime',
            'defined_tags': 'dict(str, dict(str, object))',
            'freeform_tags': 'dict(str, str)',
            'system_tags': 'dict(str, dict(str, object))',
            'locks': 'list[ResourceLock]',
            'credential_key': 'str'
        }
        self.attribute_map = {
            'id': 'id',
            'type': 'type',
            'compartment_id': 'compartmentId',
            'display_name': 'displayName',
            'database_tools_connection_id': 'databaseToolsConnectionId',
            'lifecycle_state': 'lifecycleState',
            'lifecycle_details': 'lifecycleDetails',
            'time_created': 'timeCreated',
            'time_updated': 'timeUpdated',
            'defined_tags': 'definedTags',
            'freeform_tags': 'freeformTags',
            'system_tags': 'systemTags',
            'locks': 'locks',
            'credential_key': 'credentialKey'
        }
        self._id = None
        self._type = None
        self._compartment_id = None
        self._display_name = None
        self._database_tools_connection_id = None
        self._lifecycle_state = None
        self._lifecycle_details = None
        self._time_created = None
        self._time_updated = None
        self._defined_tags = None
        self._freeform_tags = None
        self._system_tags = None
        self._locks = None
        self._credential_key = None
        self._type = 'ORACLE_DATABASE_RESOURCE_PRINCIPAL'

    @property
    def credential_key(self):
        """
        **[Required]** Gets the credential_key of this DatabaseToolsIdentityOracleDatabaseResourcePrincipalSummary.
        The name of the credential object created in the Oracle Database.


        :return: The credential_key of this DatabaseToolsIdentityOracleDatabaseResourcePrincipalSummary.
        :rtype: str
        """
        return self._credential_key

    @credential_key.setter
    def credential_key(self, credential_key):
        """
        Sets the credential_key of this DatabaseToolsIdentityOracleDatabaseResourcePrincipalSummary.
        The name of the credential object created in the Oracle Database.


        :param credential_key: The credential_key of this DatabaseToolsIdentityOracleDatabaseResourcePrincipalSummary.
        :type: str
        """
        self._credential_key = credential_key

    def __repr__(self):
        return formatted_flat_dict(self)

    def __eq__(self, other):
        if other is None:
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not self == other
