# coding: utf-8
# Copyright (c) 2016, 2026, Oracle and/or its affiliates.  All rights reserved.
# This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.

# NOTE: This class is auto generated by OracleSDKGenerator. DO NOT EDIT. API Version: 20240102


from oci.util import formatted_flat_dict, NONE_SENTINEL, value_allowed_none_or_none_sentinel  # noqa: F401
from oci.decorators import init_model_state_from_kwargs


@init_model_state_from_kwargs
class PatchRecommendationsDetailsSummary(object):
    """
    Summary of patch recommendations for databases.
    """

    def __init__(self, **kwargs):
        """
        Initializes a new PatchRecommendationsDetailsSummary object with values from keyword arguments.
        The following keyword arguments are supported (corresponding to the getters/setters of this class):

        :param patch_name:
            The value to assign to the patch_name property of this PatchRecommendationsDetailsSummary.
        :type patch_name: str

        :param abstract_text:
            The value to assign to the abstract_text property of this PatchRecommendationsDetailsSummary.
        :type abstract_text: str

        :param classification_name:
            The value to assign to the classification_name property of this PatchRecommendationsDetailsSummary.
        :type classification_name: str

        :param time_evaluated:
            The value to assign to the time_evaluated property of this PatchRecommendationsDetailsSummary.
        :type time_evaluated: datetime

        :param has_fix_for_cve:
            The value to assign to the has_fix_for_cve property of this PatchRecommendationsDetailsSummary.
        :type has_fix_for_cve: bool

        :param time_released:
            The value to assign to the time_released property of this PatchRecommendationsDetailsSummary.
        :type time_released: datetime

        """
        self.swagger_types = {
            'patch_name': 'str',
            'abstract_text': 'str',
            'classification_name': 'str',
            'time_evaluated': 'datetime',
            'has_fix_for_cve': 'bool',
            'time_released': 'datetime'
        }
        self.attribute_map = {
            'patch_name': 'patchName',
            'abstract_text': 'abstractText',
            'classification_name': 'classificationName',
            'time_evaluated': 'timeEvaluated',
            'has_fix_for_cve': 'hasFixForCve',
            'time_released': 'timeReleased'
        }
        self._patch_name = None
        self._abstract_text = None
        self._classification_name = None
        self._time_evaluated = None
        self._has_fix_for_cve = None
        self._time_released = None

    @property
    def patch_name(self):
        """
        **[Required]** Gets the patch_name of this PatchRecommendationsDetailsSummary.
        Name of the patch recommendation.


        :return: The patch_name of this PatchRecommendationsDetailsSummary.
        :rtype: str
        """
        return self._patch_name

    @patch_name.setter
    def patch_name(self, patch_name):
        """
        Sets the patch_name of this PatchRecommendationsDetailsSummary.
        Name of the patch recommendation.


        :param patch_name: The patch_name of this PatchRecommendationsDetailsSummary.
        :type: str
        """
        self._patch_name = patch_name

    @property
    def abstract_text(self):
        """
        **[Required]** Gets the abstract_text of this PatchRecommendationsDetailsSummary.
        Description of the patch recommendation.


        :return: The abstract_text of this PatchRecommendationsDetailsSummary.
        :rtype: str
        """
        return self._abstract_text

    @abstract_text.setter
    def abstract_text(self, abstract_text):
        """
        Sets the abstract_text of this PatchRecommendationsDetailsSummary.
        Description of the patch recommendation.


        :param abstract_text: The abstract_text of this PatchRecommendationsDetailsSummary.
        :type: str
        """
        self._abstract_text = abstract_text

    @property
    def classification_name(self):
        """
        **[Required]** Gets the classification_name of this PatchRecommendationsDetailsSummary.
        Classification of the patch recommendation.


        :return: The classification_name of this PatchRecommendationsDetailsSummary.
        :rtype: str
        """
        return self._classification_name

    @classification_name.setter
    def classification_name(self, classification_name):
        """
        Sets the classification_name of this PatchRecommendationsDetailsSummary.
        Classification of the patch recommendation.


        :param classification_name: The classification_name of this PatchRecommendationsDetailsSummary.
        :type: str
        """
        self._classification_name = classification_name

    @property
    def time_evaluated(self):
        """
        **[Required]** Gets the time_evaluated of this PatchRecommendationsDetailsSummary.
        Evaluation date for the patch recommendation.


        :return: The time_evaluated of this PatchRecommendationsDetailsSummary.
        :rtype: datetime
        """
        return self._time_evaluated

    @time_evaluated.setter
    def time_evaluated(self, time_evaluated):
        """
        Sets the time_evaluated of this PatchRecommendationsDetailsSummary.
        Evaluation date for the patch recommendation.


        :param time_evaluated: The time_evaluated of this PatchRecommendationsDetailsSummary.
        :type: datetime
        """
        self._time_evaluated = time_evaluated

    @property
    def has_fix_for_cve(self):
        """
        **[Required]** Gets the has_fix_for_cve of this PatchRecommendationsDetailsSummary.
        If the patch has a fix for a CVE.


        :return: The has_fix_for_cve of this PatchRecommendationsDetailsSummary.
        :rtype: bool
        """
        return self._has_fix_for_cve

    @has_fix_for_cve.setter
    def has_fix_for_cve(self, has_fix_for_cve):
        """
        Sets the has_fix_for_cve of this PatchRecommendationsDetailsSummary.
        If the patch has a fix for a CVE.


        :param has_fix_for_cve: The has_fix_for_cve of this PatchRecommendationsDetailsSummary.
        :type: bool
        """
        self._has_fix_for_cve = has_fix_for_cve

    @property
    def time_released(self):
        """
        **[Required]** Gets the time_released of this PatchRecommendationsDetailsSummary.
        Release date for the patch.


        :return: The time_released of this PatchRecommendationsDetailsSummary.
        :rtype: datetime
        """
        return self._time_released

    @time_released.setter
    def time_released(self, time_released):
        """
        Sets the time_released of this PatchRecommendationsDetailsSummary.
        Release date for the patch.


        :param time_released: The time_released of this PatchRecommendationsDetailsSummary.
        :type: datetime
        """
        self._time_released = time_released

    def __repr__(self):
        return formatted_flat_dict(self)

    def __eq__(self, other):
        if other is None:
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not self == other
