# coding: utf-8
# Copyright (c) 2016, 2026, Oracle and/or its affiliates.  All rights reserved.
# This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.

# NOTE: This class is auto generated by OracleSDKGenerator. DO NOT EDIT. API Version: 20240501


from oci.util import formatted_flat_dict, NONE_SENTINEL, value_allowed_none_or_none_sentinel  # noqa: F401
from oci.decorators import init_model_state_from_kwargs


@init_model_state_from_kwargs
class CreateOracleDbAwsKeyDetails(object):
    """
    Create Oracle DB AWS Key object.
    """

    def __init__(self, **kwargs):
        """
        Initializes a new CreateOracleDbAwsKeyDetails object with values from keyword arguments.
        The following keyword arguments are supported (corresponding to the getters/setters of this class):

        :param compartment_id:
            The value to assign to the compartment_id property of this CreateOracleDbAwsKeyDetails.
        :type compartment_id: str

        :param oracle_db_connector_id:
            The value to assign to the oracle_db_connector_id property of this CreateOracleDbAwsKeyDetails.
        :type oracle_db_connector_id: str

        :param display_name:
            The value to assign to the display_name property of this CreateOracleDbAwsKeyDetails.
        :type display_name: str

        :param aws_key_arn:
            The value to assign to the aws_key_arn property of this CreateOracleDbAwsKeyDetails.
        :type aws_key_arn: str

        :param aws_account_id:
            The value to assign to the aws_account_id property of this CreateOracleDbAwsKeyDetails.
        :type aws_account_id: str

        :param type:
            The value to assign to the type property of this CreateOracleDbAwsKeyDetails.
        :type type: str

        :param location:
            The value to assign to the location property of this CreateOracleDbAwsKeyDetails.
        :type location: str

        :param is_aws_key_enabled:
            The value to assign to the is_aws_key_enabled property of this CreateOracleDbAwsKeyDetails.
        :type is_aws_key_enabled: bool

        :param properties:
            The value to assign to the properties property of this CreateOracleDbAwsKeyDetails.
        :type properties: dict(str, str)

        :param freeform_tags:
            The value to assign to the freeform_tags property of this CreateOracleDbAwsKeyDetails.
        :type freeform_tags: dict(str, str)

        :param defined_tags:
            The value to assign to the defined_tags property of this CreateOracleDbAwsKeyDetails.
        :type defined_tags: dict(str, dict(str, object))

        """
        self.swagger_types = {
            'compartment_id': 'str',
            'oracle_db_connector_id': 'str',
            'display_name': 'str',
            'aws_key_arn': 'str',
            'aws_account_id': 'str',
            'type': 'str',
            'location': 'str',
            'is_aws_key_enabled': 'bool',
            'properties': 'dict(str, str)',
            'freeform_tags': 'dict(str, str)',
            'defined_tags': 'dict(str, dict(str, object))'
        }
        self.attribute_map = {
            'compartment_id': 'compartmentId',
            'oracle_db_connector_id': 'oracleDbConnectorId',
            'display_name': 'displayName',
            'aws_key_arn': 'awsKeyArn',
            'aws_account_id': 'awsAccountId',
            'type': 'type',
            'location': 'location',
            'is_aws_key_enabled': 'isAwsKeyEnabled',
            'properties': 'properties',
            'freeform_tags': 'freeformTags',
            'defined_tags': 'definedTags'
        }
        self._compartment_id = None
        self._oracle_db_connector_id = None
        self._display_name = None
        self._aws_key_arn = None
        self._aws_account_id = None
        self._type = None
        self._location = None
        self._is_aws_key_enabled = None
        self._properties = None
        self._freeform_tags = None
        self._defined_tags = None

    @property
    def compartment_id(self):
        """
        **[Required]** Gets the compartment_id of this CreateOracleDbAwsKeyDetails.
        The `OCID`__ of the compartment that contains Oracle DB AWS Key resource.

        __ https://docs.cloud.oracle.com/Content/General/Concepts/identifiers.htm


        :return: The compartment_id of this CreateOracleDbAwsKeyDetails.
        :rtype: str
        """
        return self._compartment_id

    @compartment_id.setter
    def compartment_id(self, compartment_id):
        """
        Sets the compartment_id of this CreateOracleDbAwsKeyDetails.
        The `OCID`__ of the compartment that contains Oracle DB AWS Key resource.

        __ https://docs.cloud.oracle.com/Content/General/Concepts/identifiers.htm


        :param compartment_id: The compartment_id of this CreateOracleDbAwsKeyDetails.
        :type: str
        """
        self._compartment_id = compartment_id

    @property
    def oracle_db_connector_id(self):
        """
        **[Required]** Gets the oracle_db_connector_id of this CreateOracleDbAwsKeyDetails.
        The `OCID`__ of the Oracle DB Connector resource.

        __ https://docs.cloud.oracle.com/Content/General/Concepts/identifiers.htm


        :return: The oracle_db_connector_id of this CreateOracleDbAwsKeyDetails.
        :rtype: str
        """
        return self._oracle_db_connector_id

    @oracle_db_connector_id.setter
    def oracle_db_connector_id(self, oracle_db_connector_id):
        """
        Sets the oracle_db_connector_id of this CreateOracleDbAwsKeyDetails.
        The `OCID`__ of the Oracle DB Connector resource.

        __ https://docs.cloud.oracle.com/Content/General/Concepts/identifiers.htm


        :param oracle_db_connector_id: The oracle_db_connector_id of this CreateOracleDbAwsKeyDetails.
        :type: str
        """
        self._oracle_db_connector_id = oracle_db_connector_id

    @property
    def display_name(self):
        """
        **[Required]** Gets the display_name of this CreateOracleDbAwsKeyDetails.
        Oracle DB AWS Key resource name.


        :return: The display_name of this CreateOracleDbAwsKeyDetails.
        :rtype: str
        """
        return self._display_name

    @display_name.setter
    def display_name(self, display_name):
        """
        Sets the display_name of this CreateOracleDbAwsKeyDetails.
        Oracle DB AWS Key resource name.


        :param display_name: The display_name of this CreateOracleDbAwsKeyDetails.
        :type: str
        """
        self._display_name = display_name

    @property
    def aws_key_arn(self):
        """
        Gets the aws_key_arn of this CreateOracleDbAwsKeyDetails.
        Amazon resource name of AWS Key.


        :return: The aws_key_arn of this CreateOracleDbAwsKeyDetails.
        :rtype: str
        """
        return self._aws_key_arn

    @aws_key_arn.setter
    def aws_key_arn(self, aws_key_arn):
        """
        Sets the aws_key_arn of this CreateOracleDbAwsKeyDetails.
        Amazon resource name of AWS Key.


        :param aws_key_arn: The aws_key_arn of this CreateOracleDbAwsKeyDetails.
        :type: str
        """
        self._aws_key_arn = aws_key_arn

    @property
    def aws_account_id(self):
        """
        Gets the aws_account_id of this CreateOracleDbAwsKeyDetails.
        AWS Account ID.


        :return: The aws_account_id of this CreateOracleDbAwsKeyDetails.
        :rtype: str
        """
        return self._aws_account_id

    @aws_account_id.setter
    def aws_account_id(self, aws_account_id):
        """
        Sets the aws_account_id of this CreateOracleDbAwsKeyDetails.
        AWS Account ID.


        :param aws_account_id: The aws_account_id of this CreateOracleDbAwsKeyDetails.
        :type: str
        """
        self._aws_account_id = aws_account_id

    @property
    def type(self):
        """
        Gets the type of this CreateOracleDbAwsKeyDetails.
        AWS Key resource type.


        :return: The type of this CreateOracleDbAwsKeyDetails.
        :rtype: str
        """
        return self._type

    @type.setter
    def type(self, type):
        """
        Sets the type of this CreateOracleDbAwsKeyDetails.
        AWS Key resource type.


        :param type: The type of this CreateOracleDbAwsKeyDetails.
        :type: str
        """
        self._type = type

    @property
    def location(self):
        """
        Gets the location of this CreateOracleDbAwsKeyDetails.
        AWS Key resource Location.


        :return: The location of this CreateOracleDbAwsKeyDetails.
        :rtype: str
        """
        return self._location

    @location.setter
    def location(self, location):
        """
        Sets the location of this CreateOracleDbAwsKeyDetails.
        AWS Key resource Location.


        :param location: The location of this CreateOracleDbAwsKeyDetails.
        :type: str
        """
        self._location = location

    @property
    def is_aws_key_enabled(self):
        """
        Gets the is_aws_key_enabled of this CreateOracleDbAwsKeyDetails.
        The Oracle AWS Key resource is enabled or disabled at AWS.


        :return: The is_aws_key_enabled of this CreateOracleDbAwsKeyDetails.
        :rtype: bool
        """
        return self._is_aws_key_enabled

    @is_aws_key_enabled.setter
    def is_aws_key_enabled(self, is_aws_key_enabled):
        """
        Sets the is_aws_key_enabled of this CreateOracleDbAwsKeyDetails.
        The Oracle AWS Key resource is enabled or disabled at AWS.


        :param is_aws_key_enabled: The is_aws_key_enabled of this CreateOracleDbAwsKeyDetails.
        :type: bool
        """
        self._is_aws_key_enabled = is_aws_key_enabled

    @property
    def properties(self):
        """
        Gets the properties of this CreateOracleDbAwsKeyDetails.
        AWS Key resource's properties.


        :return: The properties of this CreateOracleDbAwsKeyDetails.
        :rtype: dict(str, str)
        """
        return self._properties

    @properties.setter
    def properties(self, properties):
        """
        Sets the properties of this CreateOracleDbAwsKeyDetails.
        AWS Key resource's properties.


        :param properties: The properties of this CreateOracleDbAwsKeyDetails.
        :type: dict(str, str)
        """
        self._properties = properties

    @property
    def freeform_tags(self):
        """
        Gets the freeform_tags of this CreateOracleDbAwsKeyDetails.
        Free-form tags for this resource. Each tag is a simple key-value pair with no predefined name, type, or namespace.
        For more information, see `Resource Tags`__.

        Example: `{\"Department\": \"Finance\"}`

        __ https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm


        :return: The freeform_tags of this CreateOracleDbAwsKeyDetails.
        :rtype: dict(str, str)
        """
        return self._freeform_tags

    @freeform_tags.setter
    def freeform_tags(self, freeform_tags):
        """
        Sets the freeform_tags of this CreateOracleDbAwsKeyDetails.
        Free-form tags for this resource. Each tag is a simple key-value pair with no predefined name, type, or namespace.
        For more information, see `Resource Tags`__.

        Example: `{\"Department\": \"Finance\"}`

        __ https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm


        :param freeform_tags: The freeform_tags of this CreateOracleDbAwsKeyDetails.
        :type: dict(str, str)
        """
        self._freeform_tags = freeform_tags

    @property
    def defined_tags(self):
        """
        Gets the defined_tags of this CreateOracleDbAwsKeyDetails.
        Defined tags for this resource. Each key is predefined and scoped to a namespace.
        For more information, see `Resource Tags`__.

        Example: `{\"Operations\": {\"CostCenter\": \"42\"}}`

        __ https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm


        :return: The defined_tags of this CreateOracleDbAwsKeyDetails.
        :rtype: dict(str, dict(str, object))
        """
        return self._defined_tags

    @defined_tags.setter
    def defined_tags(self, defined_tags):
        """
        Sets the defined_tags of this CreateOracleDbAwsKeyDetails.
        Defined tags for this resource. Each key is predefined and scoped to a namespace.
        For more information, see `Resource Tags`__.

        Example: `{\"Operations\": {\"CostCenter\": \"42\"}}`

        __ https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm


        :param defined_tags: The defined_tags of this CreateOracleDbAwsKeyDetails.
        :type: dict(str, dict(str, object))
        """
        self._defined_tags = defined_tags

    def __repr__(self):
        return formatted_flat_dict(self)

    def __eq__(self, other):
        if other is None:
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not self == other
