# coding: utf-8
# Copyright (c) 2016, 2026, Oracle and/or its affiliates.  All rights reserved.
# This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.

# NOTE: This class is auto generated by OracleSDKGenerator. DO NOT EDIT. API Version: 20230801


from oci.util import formatted_flat_dict, NONE_SENTINEL, value_allowed_none_or_none_sentinel  # noqa: F401
from oci.decorators import init_model_state_from_kwargs


@init_model_state_from_kwargs
class DelegatedResourceAccessRequest(object):
    """
    A support operator raises Delegated Resource Access Request when they need access to any infrastructure resource governed by Delegation Control.
    The Delegated Resource Access Request identifies the target resource and the set of Service Provider Actions. Delegated Resource Access Request handling depends upon the Delegation Control
    that governs the target resource, and the set of Service Provider Actions listed for approval in the Delegated Resource Access Request. If all of the Service Provider Actions
    listed in the Delegated Resource Access Request are in the pre-approved list in the Delegation Control that governs the target resource, then the Delegated Resource Access Request is
    automatically approved. If not, then the Delegated Resource Access Request requires explicit approval from the approver group specified by the Delegation Control governing the target resource.

    You can approve or reject a Delegated Resource Access Request. You can also revoke the approval of an already approved Delegated Resource Access Request. While creating a Delegated Resource Access Request,
    the support operator specifies the duration of access. You have the option to approve the entire duration or reduce or even increase the time duration.
    A support operator can also request for an extension. The approval for such an extension is processed the same way the original Delegated Resource Access Request was processed.
    """

    #: A constant which can be used with the resource_type property of a DelegatedResourceAccessRequest.
    #: This constant has a value of "VMCLUSTER"
    RESOURCE_TYPE_VMCLUSTER = "VMCLUSTER"

    #: A constant which can be used with the resource_type property of a DelegatedResourceAccessRequest.
    #: This constant has a value of "CLOUDVMCLUSTER"
    RESOURCE_TYPE_CLOUDVMCLUSTER = "CLOUDVMCLUSTER"

    #: A constant which can be used with the requester_type property of a DelegatedResourceAccessRequest.
    #: This constant has a value of "OPERATOR"
    REQUESTER_TYPE_OPERATOR = "OPERATOR"

    #: A constant which can be used with the requester_type property of a DelegatedResourceAccessRequest.
    #: This constant has a value of "CUSTOMER"
    REQUESTER_TYPE_CUSTOMER = "CUSTOMER"

    #: A constant which can be used with the requester_type property of a DelegatedResourceAccessRequest.
    #: This constant has a value of "SYSTEM"
    REQUESTER_TYPE_SYSTEM = "SYSTEM"

    #: A constant which can be used with the provided_service_types property of a DelegatedResourceAccessRequest.
    #: This constant has a value of "TROUBLESHOOTING"
    PROVIDED_SERVICE_TYPES_TROUBLESHOOTING = "TROUBLESHOOTING"

    #: A constant which can be used with the provided_service_types property of a DelegatedResourceAccessRequest.
    #: This constant has a value of "ASSISTED_PATCHING"
    PROVIDED_SERVICE_TYPES_ASSISTED_PATCHING = "ASSISTED_PATCHING"

    #: A constant which can be used with the severity property of a DelegatedResourceAccessRequest.
    #: This constant has a value of "S1"
    SEVERITY_S1 = "S1"

    #: A constant which can be used with the severity property of a DelegatedResourceAccessRequest.
    #: This constant has a value of "S2"
    SEVERITY_S2 = "S2"

    #: A constant which can be used with the severity property of a DelegatedResourceAccessRequest.
    #: This constant has a value of "S3"
    SEVERITY_S3 = "S3"

    #: A constant which can be used with the severity property of a DelegatedResourceAccessRequest.
    #: This constant has a value of "S4"
    SEVERITY_S4 = "S4"

    #: A constant which can be used with the lifecycle_state property of a DelegatedResourceAccessRequest.
    #: This constant has a value of "ACCEPTED"
    LIFECYCLE_STATE_ACCEPTED = "ACCEPTED"

    #: A constant which can be used with the lifecycle_state property of a DelegatedResourceAccessRequest.
    #: This constant has a value of "IN_PROGRESS"
    LIFECYCLE_STATE_IN_PROGRESS = "IN_PROGRESS"

    #: A constant which can be used with the lifecycle_state property of a DelegatedResourceAccessRequest.
    #: This constant has a value of "WAITING"
    LIFECYCLE_STATE_WAITING = "WAITING"

    #: A constant which can be used with the lifecycle_state property of a DelegatedResourceAccessRequest.
    #: This constant has a value of "FAILED"
    LIFECYCLE_STATE_FAILED = "FAILED"

    #: A constant which can be used with the lifecycle_state property of a DelegatedResourceAccessRequest.
    #: This constant has a value of "SUCCEEDED"
    LIFECYCLE_STATE_SUCCEEDED = "SUCCEEDED"

    #: A constant which can be used with the lifecycle_state property of a DelegatedResourceAccessRequest.
    #: This constant has a value of "CANCELING"
    LIFECYCLE_STATE_CANCELING = "CANCELING"

    #: A constant which can be used with the lifecycle_state property of a DelegatedResourceAccessRequest.
    #: This constant has a value of "CANCELED"
    LIFECYCLE_STATE_CANCELED = "CANCELED"

    #: A constant which can be used with the lifecycle_state property of a DelegatedResourceAccessRequest.
    #: This constant has a value of "NEEDS_ATTENTION"
    LIFECYCLE_STATE_NEEDS_ATTENTION = "NEEDS_ATTENTION"

    #: A constant which can be used with the request_status property of a DelegatedResourceAccessRequest.
    #: This constant has a value of "CREATED"
    REQUEST_STATUS_CREATED = "CREATED"

    #: A constant which can be used with the request_status property of a DelegatedResourceAccessRequest.
    #: This constant has a value of "APPROVAL_WAITING"
    REQUEST_STATUS_APPROVAL_WAITING = "APPROVAL_WAITING"

    #: A constant which can be used with the request_status property of a DelegatedResourceAccessRequest.
    #: This constant has a value of "OPERATOR_ASSIGNMENT_WAITING"
    REQUEST_STATUS_OPERATOR_ASSIGNMENT_WAITING = "OPERATOR_ASSIGNMENT_WAITING"

    #: A constant which can be used with the request_status property of a DelegatedResourceAccessRequest.
    #: This constant has a value of "PREAPPROVED"
    REQUEST_STATUS_PREAPPROVED = "PREAPPROVED"

    #: A constant which can be used with the request_status property of a DelegatedResourceAccessRequest.
    #: This constant has a value of "APPROVED"
    REQUEST_STATUS_APPROVED = "APPROVED"

    #: A constant which can be used with the request_status property of a DelegatedResourceAccessRequest.
    #: This constant has a value of "APPROVED_FOR_FUTURE"
    REQUEST_STATUS_APPROVED_FOR_FUTURE = "APPROVED_FOR_FUTURE"

    #: A constant which can be used with the request_status property of a DelegatedResourceAccessRequest.
    #: This constant has a value of "REJECTED"
    REQUEST_STATUS_REJECTED = "REJECTED"

    #: A constant which can be used with the request_status property of a DelegatedResourceAccessRequest.
    #: This constant has a value of "DEPLOYED"
    REQUEST_STATUS_DEPLOYED = "DEPLOYED"

    #: A constant which can be used with the request_status property of a DelegatedResourceAccessRequest.
    #: This constant has a value of "DEPLOY_FAILED"
    REQUEST_STATUS_DEPLOY_FAILED = "DEPLOY_FAILED"

    #: A constant which can be used with the request_status property of a DelegatedResourceAccessRequest.
    #: This constant has a value of "UNDEPLOYED"
    REQUEST_STATUS_UNDEPLOYED = "UNDEPLOYED"

    #: A constant which can be used with the request_status property of a DelegatedResourceAccessRequest.
    #: This constant has a value of "UNDEPLOY_FAILED"
    REQUEST_STATUS_UNDEPLOY_FAILED = "UNDEPLOY_FAILED"

    #: A constant which can be used with the request_status property of a DelegatedResourceAccessRequest.
    #: This constant has a value of "CLOSE_FAILED"
    REQUEST_STATUS_CLOSE_FAILED = "CLOSE_FAILED"

    #: A constant which can be used with the request_status property of a DelegatedResourceAccessRequest.
    #: This constant has a value of "REVOKE_FAILED"
    REQUEST_STATUS_REVOKE_FAILED = "REVOKE_FAILED"

    #: A constant which can be used with the request_status property of a DelegatedResourceAccessRequest.
    #: This constant has a value of "EXPIRY_FAILED"
    REQUEST_STATUS_EXPIRY_FAILED = "EXPIRY_FAILED"

    #: A constant which can be used with the request_status property of a DelegatedResourceAccessRequest.
    #: This constant has a value of "REVOKING"
    REQUEST_STATUS_REVOKING = "REVOKING"

    #: A constant which can be used with the request_status property of a DelegatedResourceAccessRequest.
    #: This constant has a value of "REVOKED"
    REQUEST_STATUS_REVOKED = "REVOKED"

    #: A constant which can be used with the request_status property of a DelegatedResourceAccessRequest.
    #: This constant has a value of "EXTENDING"
    REQUEST_STATUS_EXTENDING = "EXTENDING"

    #: A constant which can be used with the request_status property of a DelegatedResourceAccessRequest.
    #: This constant has a value of "EXTENDED"
    REQUEST_STATUS_EXTENDED = "EXTENDED"

    #: A constant which can be used with the request_status property of a DelegatedResourceAccessRequest.
    #: This constant has a value of "EXTENSION_REJECTED"
    REQUEST_STATUS_EXTENSION_REJECTED = "EXTENSION_REJECTED"

    #: A constant which can be used with the request_status property of a DelegatedResourceAccessRequest.
    #: This constant has a value of "EXTENSION_FAILED"
    REQUEST_STATUS_EXTENSION_FAILED = "EXTENSION_FAILED"

    #: A constant which can be used with the request_status property of a DelegatedResourceAccessRequest.
    #: This constant has a value of "COMPLETING"
    REQUEST_STATUS_COMPLETING = "COMPLETING"

    #: A constant which can be used with the request_status property of a DelegatedResourceAccessRequest.
    #: This constant has a value of "COMPLETED"
    REQUEST_STATUS_COMPLETED = "COMPLETED"

    #: A constant which can be used with the request_status property of a DelegatedResourceAccessRequest.
    #: This constant has a value of "EXPIRED"
    REQUEST_STATUS_EXPIRED = "EXPIRED"

    #: A constant which can be used with the audit_types property of a DelegatedResourceAccessRequest.
    #: This constant has a value of "COMMAND_AUDIT"
    AUDIT_TYPES_COMMAND_AUDIT = "COMMAND_AUDIT"

    #: A constant which can be used with the audit_types property of a DelegatedResourceAccessRequest.
    #: This constant has a value of "COMMAND_KEYSTROKE_AUDIT"
    AUDIT_TYPES_COMMAND_KEYSTROKE_AUDIT = "COMMAND_KEYSTROKE_AUDIT"

    def __init__(self, **kwargs):
        """
        Initializes a new DelegatedResourceAccessRequest object with values from keyword arguments.
        The following keyword arguments are supported (corresponding to the getters/setters of this class):

        :param id:
            The value to assign to the id property of this DelegatedResourceAccessRequest.
        :type id: str

        :param compartment_id:
            The value to assign to the compartment_id property of this DelegatedResourceAccessRequest.
        :type compartment_id: str

        :param display_name:
            The value to assign to the display_name property of this DelegatedResourceAccessRequest.
        :type display_name: str

        :param ticket_numbers:
            The value to assign to the ticket_numbers property of this DelegatedResourceAccessRequest.
        :type ticket_numbers: list[str]

        :param reason_for_request:
            The value to assign to the reason_for_request property of this DelegatedResourceAccessRequest.
        :type reason_for_request: str

        :param description:
            The value to assign to the description property of this DelegatedResourceAccessRequest.
        :type description: str

        :param time_access_requested:
            The value to assign to the time_access_requested property of this DelegatedResourceAccessRequest.
        :type time_access_requested: datetime

        :param resource_id:
            The value to assign to the resource_id property of this DelegatedResourceAccessRequest.
        :type resource_id: str

        :param resource_name:
            The value to assign to the resource_name property of this DelegatedResourceAccessRequest.
        :type resource_name: str

        :param resource_type:
            The value to assign to the resource_type property of this DelegatedResourceAccessRequest.
            Allowed values for this property are: "VMCLUSTER", "CLOUDVMCLUSTER", 'UNKNOWN_ENUM_VALUE'.
            Any unrecognized values returned by a service will be mapped to 'UNKNOWN_ENUM_VALUE'.
        :type resource_type: str

        :param requester_type:
            The value to assign to the requester_type property of this DelegatedResourceAccessRequest.
            Allowed values for this property are: "OPERATOR", "CUSTOMER", "SYSTEM", 'UNKNOWN_ENUM_VALUE'.
            Any unrecognized values returned by a service will be mapped to 'UNKNOWN_ENUM_VALUE'.
        :type requester_type: str

        :param requested_action_names:
            The value to assign to the requested_action_names property of this DelegatedResourceAccessRequest.
        :type requested_action_names: list[str]

        :param database_name_list:
            The value to assign to the database_name_list property of this DelegatedResourceAccessRequest.
        :type database_name_list: list[str]

        :param provided_service_types:
            The value to assign to the provided_service_types property of this DelegatedResourceAccessRequest.
            Allowed values for items in this list are: "TROUBLESHOOTING", "ASSISTED_PATCHING", 'UNKNOWN_ENUM_VALUE'.
            Any unrecognized values returned by a service will be mapped to 'UNKNOWN_ENUM_VALUE'.
        :type provided_service_types: list[str]

        :param delegation_subscription_ids:
            The value to assign to the delegation_subscription_ids property of this DelegatedResourceAccessRequest.
        :type delegation_subscription_ids: list[str]

        :param severity:
            The value to assign to the severity property of this DelegatedResourceAccessRequest.
            Allowed values for this property are: "S1", "S2", "S3", "S4", 'UNKNOWN_ENUM_VALUE'.
            Any unrecognized values returned by a service will be mapped to 'UNKNOWN_ENUM_VALUE'.
        :type severity: str

        :param duration_in_hours:
            The value to assign to the duration_in_hours property of this DelegatedResourceAccessRequest.
        :type duration_in_hours: int

        :param extend_duration_in_hours:
            The value to assign to the extend_duration_in_hours property of this DelegatedResourceAccessRequest.
        :type extend_duration_in_hours: int

        :param is_auto_approved:
            The value to assign to the is_auto_approved property of this DelegatedResourceAccessRequest.
        :type is_auto_approved: bool

        :param lifecycle_state:
            The value to assign to the lifecycle_state property of this DelegatedResourceAccessRequest.
            Allowed values for this property are: "ACCEPTED", "IN_PROGRESS", "WAITING", "FAILED", "SUCCEEDED", "CANCELING", "CANCELED", "NEEDS_ATTENTION", 'UNKNOWN_ENUM_VALUE'.
            Any unrecognized values returned by a service will be mapped to 'UNKNOWN_ENUM_VALUE'.
        :type lifecycle_state: str

        :param lifecycle_state_details:
            The value to assign to the lifecycle_state_details property of this DelegatedResourceAccessRequest.
        :type lifecycle_state_details: str

        :param request_status:
            The value to assign to the request_status property of this DelegatedResourceAccessRequest.
            Allowed values for this property are: "CREATED", "APPROVAL_WAITING", "OPERATOR_ASSIGNMENT_WAITING", "PREAPPROVED", "APPROVED", "APPROVED_FOR_FUTURE", "REJECTED", "DEPLOYED", "DEPLOY_FAILED", "UNDEPLOYED", "UNDEPLOY_FAILED", "CLOSE_FAILED", "REVOKE_FAILED", "EXPIRY_FAILED", "REVOKING", "REVOKED", "EXTENDING", "EXTENDED", "EXTENSION_REJECTED", "EXTENSION_FAILED", "COMPLETING", "COMPLETED", "EXPIRED", 'UNKNOWN_ENUM_VALUE'.
            Any unrecognized values returned by a service will be mapped to 'UNKNOWN_ENUM_VALUE'.
        :type request_status: str

        :param time_created:
            The value to assign to the time_created property of this DelegatedResourceAccessRequest.
        :type time_created: datetime

        :param time_updated:
            The value to assign to the time_updated property of this DelegatedResourceAccessRequest.
        :type time_updated: datetime

        :param num_initial_approvals:
            The value to assign to the num_initial_approvals property of this DelegatedResourceAccessRequest.
        :type num_initial_approvals: int

        :param num_extension_approvals:
            The value to assign to the num_extension_approvals property of this DelegatedResourceAccessRequest.
        :type num_extension_approvals: int

        :param approval_info:
            The value to assign to the approval_info property of this DelegatedResourceAccessRequest.
        :type approval_info: list[oci.delegate_access_control.models.DelegatedResourceAccessRequestApprovalDetails]

        :param closure_comment:
            The value to assign to the closure_comment property of this DelegatedResourceAccessRequest.
        :type closure_comment: str

        :param delegation_control_id:
            The value to assign to the delegation_control_id property of this DelegatedResourceAccessRequest.
        :type delegation_control_id: str

        :param audit_types:
            The value to assign to the audit_types property of this DelegatedResourceAccessRequest.
            Allowed values for items in this list are: "COMMAND_AUDIT", "COMMAND_KEYSTROKE_AUDIT", 'UNKNOWN_ENUM_VALUE'.
            Any unrecognized values returned by a service will be mapped to 'UNKNOWN_ENUM_VALUE'.
        :type audit_types: list[str]

        :param is_pending_more_info:
            The value to assign to the is_pending_more_info property of this DelegatedResourceAccessRequest.
        :type is_pending_more_info: bool

        :param freeform_tags:
            The value to assign to the freeform_tags property of this DelegatedResourceAccessRequest.
        :type freeform_tags: dict(str, str)

        :param defined_tags:
            The value to assign to the defined_tags property of this DelegatedResourceAccessRequest.
        :type defined_tags: dict(str, dict(str, object))

        :param system_tags:
            The value to assign to the system_tags property of this DelegatedResourceAccessRequest.
        :type system_tags: dict(str, dict(str, object))

        """
        self.swagger_types = {
            'id': 'str',
            'compartment_id': 'str',
            'display_name': 'str',
            'ticket_numbers': 'list[str]',
            'reason_for_request': 'str',
            'description': 'str',
            'time_access_requested': 'datetime',
            'resource_id': 'str',
            'resource_name': 'str',
            'resource_type': 'str',
            'requester_type': 'str',
            'requested_action_names': 'list[str]',
            'database_name_list': 'list[str]',
            'provided_service_types': 'list[str]',
            'delegation_subscription_ids': 'list[str]',
            'severity': 'str',
            'duration_in_hours': 'int',
            'extend_duration_in_hours': 'int',
            'is_auto_approved': 'bool',
            'lifecycle_state': 'str',
            'lifecycle_state_details': 'str',
            'request_status': 'str',
            'time_created': 'datetime',
            'time_updated': 'datetime',
            'num_initial_approvals': 'int',
            'num_extension_approvals': 'int',
            'approval_info': 'list[DelegatedResourceAccessRequestApprovalDetails]',
            'closure_comment': 'str',
            'delegation_control_id': 'str',
            'audit_types': 'list[str]',
            'is_pending_more_info': 'bool',
            'freeform_tags': 'dict(str, str)',
            'defined_tags': 'dict(str, dict(str, object))',
            'system_tags': 'dict(str, dict(str, object))'
        }
        self.attribute_map = {
            'id': 'id',
            'compartment_id': 'compartmentId',
            'display_name': 'displayName',
            'ticket_numbers': 'ticketNumbers',
            'reason_for_request': 'reasonForRequest',
            'description': 'description',
            'time_access_requested': 'timeAccessRequested',
            'resource_id': 'resourceId',
            'resource_name': 'resourceName',
            'resource_type': 'resourceType',
            'requester_type': 'requesterType',
            'requested_action_names': 'requestedActionNames',
            'database_name_list': 'databaseNameList',
            'provided_service_types': 'providedServiceTypes',
            'delegation_subscription_ids': 'delegationSubscriptionIds',
            'severity': 'severity',
            'duration_in_hours': 'durationInHours',
            'extend_duration_in_hours': 'extendDurationInHours',
            'is_auto_approved': 'isAutoApproved',
            'lifecycle_state': 'lifecycleState',
            'lifecycle_state_details': 'lifecycleStateDetails',
            'request_status': 'requestStatus',
            'time_created': 'timeCreated',
            'time_updated': 'timeUpdated',
            'num_initial_approvals': 'numInitialApprovals',
            'num_extension_approvals': 'numExtensionApprovals',
            'approval_info': 'approvalInfo',
            'closure_comment': 'closureComment',
            'delegation_control_id': 'delegationControlId',
            'audit_types': 'auditTypes',
            'is_pending_more_info': 'isPendingMoreInfo',
            'freeform_tags': 'freeformTags',
            'defined_tags': 'definedTags',
            'system_tags': 'systemTags'
        }
        self._id = None
        self._compartment_id = None
        self._display_name = None
        self._ticket_numbers = None
        self._reason_for_request = None
        self._description = None
        self._time_access_requested = None
        self._resource_id = None
        self._resource_name = None
        self._resource_type = None
        self._requester_type = None
        self._requested_action_names = None
        self._database_name_list = None
        self._provided_service_types = None
        self._delegation_subscription_ids = None
        self._severity = None
        self._duration_in_hours = None
        self._extend_duration_in_hours = None
        self._is_auto_approved = None
        self._lifecycle_state = None
        self._lifecycle_state_details = None
        self._request_status = None
        self._time_created = None
        self._time_updated = None
        self._num_initial_approvals = None
        self._num_extension_approvals = None
        self._approval_info = None
        self._closure_comment = None
        self._delegation_control_id = None
        self._audit_types = None
        self._is_pending_more_info = None
        self._freeform_tags = None
        self._defined_tags = None
        self._system_tags = None

    @property
    def id(self):
        """
        **[Required]** Gets the id of this DelegatedResourceAccessRequest.
        The OCID of the Delegated Resource Access Request.


        :return: The id of this DelegatedResourceAccessRequest.
        :rtype: str
        """
        return self._id

    @id.setter
    def id(self, id):
        """
        Sets the id of this DelegatedResourceAccessRequest.
        The OCID of the Delegated Resource Access Request.


        :param id: The id of this DelegatedResourceAccessRequest.
        :type: str
        """
        self._id = id

    @property
    def compartment_id(self):
        """
        **[Required]** Gets the compartment_id of this DelegatedResourceAccessRequest.
        The OCID of the compartment that contains the Delegated Resource Access Request.


        :return: The compartment_id of this DelegatedResourceAccessRequest.
        :rtype: str
        """
        return self._compartment_id

    @compartment_id.setter
    def compartment_id(self, compartment_id):
        """
        Sets the compartment_id of this DelegatedResourceAccessRequest.
        The OCID of the compartment that contains the Delegated Resource Access Request.


        :param compartment_id: The compartment_id of this DelegatedResourceAccessRequest.
        :type: str
        """
        self._compartment_id = compartment_id

    @property
    def display_name(self):
        """
        Gets the display_name of this DelegatedResourceAccessRequest.
        Display name. This is generated by the system automatically.


        :return: The display_name of this DelegatedResourceAccessRequest.
        :rtype: str
        """
        return self._display_name

    @display_name.setter
    def display_name(self, display_name):
        """
        Sets the display_name of this DelegatedResourceAccessRequest.
        Display name. This is generated by the system automatically.


        :param display_name: The display_name of this DelegatedResourceAccessRequest.
        :type: str
        """
        self._display_name = display_name

    @property
    def ticket_numbers(self):
        """
        Gets the ticket_numbers of this DelegatedResourceAccessRequest.
        A list of ticket numbers related to this Delegated Resource Access Request, e.g. Service Request (SR) number and JIRA ticket number.


        :return: The ticket_numbers of this DelegatedResourceAccessRequest.
        :rtype: list[str]
        """
        return self._ticket_numbers

    @ticket_numbers.setter
    def ticket_numbers(self, ticket_numbers):
        """
        Sets the ticket_numbers of this DelegatedResourceAccessRequest.
        A list of ticket numbers related to this Delegated Resource Access Request, e.g. Service Request (SR) number and JIRA ticket number.


        :param ticket_numbers: The ticket_numbers of this DelegatedResourceAccessRequest.
        :type: list[str]
        """
        self._ticket_numbers = ticket_numbers

    @property
    def reason_for_request(self):
        """
        **[Required]** Gets the reason_for_request of this DelegatedResourceAccessRequest.
        A short description explaining why this Delegated Resource Access Request is needed by the support operator.


        :return: The reason_for_request of this DelegatedResourceAccessRequest.
        :rtype: str
        """
        return self._reason_for_request

    @reason_for_request.setter
    def reason_for_request(self, reason_for_request):
        """
        Sets the reason_for_request of this DelegatedResourceAccessRequest.
        A short description explaining why this Delegated Resource Access Request is needed by the support operator.


        :param reason_for_request: The reason_for_request of this DelegatedResourceAccessRequest.
        :type: str
        """
        self._reason_for_request = reason_for_request

    @property
    def description(self):
        """
        **[Required]** Gets the description of this DelegatedResourceAccessRequest.
        Detailed description of this Delegated Resource Access Request.


        :return: The description of this DelegatedResourceAccessRequest.
        :rtype: str
        """
        return self._description

    @description.setter
    def description(self, description):
        """
        Sets the description of this DelegatedResourceAccessRequest.
        Detailed description of this Delegated Resource Access Request.


        :param description: The description of this DelegatedResourceAccessRequest.
        :type: str
        """
        self._description = description

    @property
    def time_access_requested(self):
        """
        Gets the time_access_requested of this DelegatedResourceAccessRequest.
        Requested access start time in UTC.


        :return: The time_access_requested of this DelegatedResourceAccessRequest.
        :rtype: datetime
        """
        return self._time_access_requested

    @time_access_requested.setter
    def time_access_requested(self, time_access_requested):
        """
        Sets the time_access_requested of this DelegatedResourceAccessRequest.
        Requested access start time in UTC.


        :param time_access_requested: The time_access_requested of this DelegatedResourceAccessRequest.
        :type: datetime
        """
        self._time_access_requested = time_access_requested

    @property
    def resource_id(self):
        """
        **[Required]** Gets the resource_id of this DelegatedResourceAccessRequest.
        The OCID of the target resource associated with the Delegated Resource Access Request. The support operator raises a Delegated Resource Access Request to get approval to
        access the target resource.


        :return: The resource_id of this DelegatedResourceAccessRequest.
        :rtype: str
        """
        return self._resource_id

    @resource_id.setter
    def resource_id(self, resource_id):
        """
        Sets the resource_id of this DelegatedResourceAccessRequest.
        The OCID of the target resource associated with the Delegated Resource Access Request. The support operator raises a Delegated Resource Access Request to get approval to
        access the target resource.


        :param resource_id: The resource_id of this DelegatedResourceAccessRequest.
        :type: str
        """
        self._resource_id = resource_id

    @property
    def resource_name(self):
        """
        Gets the resource_name of this DelegatedResourceAccessRequest.
        The name of the target resource associated with the Delegated Resource Access Request. The support operator raises a Delegated Resource Access Request to get approval to
        access the target resource.


        :return: The resource_name of this DelegatedResourceAccessRequest.
        :rtype: str
        """
        return self._resource_name

    @resource_name.setter
    def resource_name(self, resource_name):
        """
        Sets the resource_name of this DelegatedResourceAccessRequest.
        The name of the target resource associated with the Delegated Resource Access Request. The support operator raises a Delegated Resource Access Request to get approval to
        access the target resource.


        :param resource_name: The resource_name of this DelegatedResourceAccessRequest.
        :type: str
        """
        self._resource_name = resource_name

    @property
    def resource_type(self):
        """
        Gets the resource_type of this DelegatedResourceAccessRequest.
        Resource type for which the associated Delegation Control is applicable to.

        Allowed values for this property are: "VMCLUSTER", "CLOUDVMCLUSTER", 'UNKNOWN_ENUM_VALUE'.
        Any unrecognized values returned by a service will be mapped to 'UNKNOWN_ENUM_VALUE'.


        :return: The resource_type of this DelegatedResourceAccessRequest.
        :rtype: str
        """
        return self._resource_type

    @resource_type.setter
    def resource_type(self, resource_type):
        """
        Sets the resource_type of this DelegatedResourceAccessRequest.
        Resource type for which the associated Delegation Control is applicable to.


        :param resource_type: The resource_type of this DelegatedResourceAccessRequest.
        :type: str
        """
        allowed_values = ["VMCLUSTER", "CLOUDVMCLUSTER"]
        if not value_allowed_none_or_none_sentinel(resource_type, allowed_values):
            resource_type = 'UNKNOWN_ENUM_VALUE'
        self._resource_type = resource_type

    @property
    def requester_type(self):
        """
        Gets the requester_type of this DelegatedResourceAccessRequest.
        Requester type

        Allowed values for this property are: "OPERATOR", "CUSTOMER", "SYSTEM", 'UNKNOWN_ENUM_VALUE'.
        Any unrecognized values returned by a service will be mapped to 'UNKNOWN_ENUM_VALUE'.


        :return: The requester_type of this DelegatedResourceAccessRequest.
        :rtype: str
        """
        return self._requester_type

    @requester_type.setter
    def requester_type(self, requester_type):
        """
        Sets the requester_type of this DelegatedResourceAccessRequest.
        Requester type


        :param requester_type: The requester_type of this DelegatedResourceAccessRequest.
        :type: str
        """
        allowed_values = ["OPERATOR", "CUSTOMER", "SYSTEM"]
        if not value_allowed_none_or_none_sentinel(requester_type, allowed_values):
            requester_type = 'UNKNOWN_ENUM_VALUE'
        self._requester_type = requester_type

    @property
    def requested_action_names(self):
        """
        Gets the requested_action_names of this DelegatedResourceAccessRequest.
        List of Service Provider Action names for which approval is sought by the support operator user. The list of pre-defined Service Provider Actions can be obtained from the ListServiceProviderActions API.


        :return: The requested_action_names of this DelegatedResourceAccessRequest.
        :rtype: list[str]
        """
        return self._requested_action_names

    @requested_action_names.setter
    def requested_action_names(self, requested_action_names):
        """
        Sets the requested_action_names of this DelegatedResourceAccessRequest.
        List of Service Provider Action names for which approval is sought by the support operator user. The list of pre-defined Service Provider Actions can be obtained from the ListServiceProviderActions API.


        :param requested_action_names: The requested_action_names of this DelegatedResourceAccessRequest.
        :type: list[str]
        """
        self._requested_action_names = requested_action_names

    @property
    def database_name_list(self):
        """
        Gets the database_name_list of this DelegatedResourceAccessRequest.
        List of Database unique names for which access is requested. This parameter is required for DLGT_MGMT_SYS_MAINT_ACCESS cage when database access in needed.


        :return: The database_name_list of this DelegatedResourceAccessRequest.
        :rtype: list[str]
        """
        return self._database_name_list

    @database_name_list.setter
    def database_name_list(self, database_name_list):
        """
        Sets the database_name_list of this DelegatedResourceAccessRequest.
        List of Database unique names for which access is requested. This parameter is required for DLGT_MGMT_SYS_MAINT_ACCESS cage when database access in needed.


        :param database_name_list: The database_name_list of this DelegatedResourceAccessRequest.
        :type: list[str]
        """
        self._database_name_list = database_name_list

    @property
    def provided_service_types(self):
        """
        Gets the provided_service_types of this DelegatedResourceAccessRequest.
        List of Service Provider Service Types being provided by the support operator user.

        Allowed values for items in this list are: "TROUBLESHOOTING", "ASSISTED_PATCHING", 'UNKNOWN_ENUM_VALUE'.
        Any unrecognized values returned by a service will be mapped to 'UNKNOWN_ENUM_VALUE'.


        :return: The provided_service_types of this DelegatedResourceAccessRequest.
        :rtype: list[str]
        """
        return self._provided_service_types

    @provided_service_types.setter
    def provided_service_types(self, provided_service_types):
        """
        Sets the provided_service_types of this DelegatedResourceAccessRequest.
        List of Service Provider Service Types being provided by the support operator user.


        :param provided_service_types: The provided_service_types of this DelegatedResourceAccessRequest.
        :type: list[str]
        """
        allowed_values = ["TROUBLESHOOTING", "ASSISTED_PATCHING"]
        if provided_service_types:
            provided_service_types[:] = ['UNKNOWN_ENUM_VALUE' if not value_allowed_none_or_none_sentinel(x, allowed_values) else x for x in provided_service_types]
        self._provided_service_types = provided_service_types

    @property
    def delegation_subscription_ids(self):
        """
        Gets the delegation_subscription_ids of this DelegatedResourceAccessRequest.
        List of Delegation Subscription OCID that are associated with this Delegated Resource Access Request based on the service types being requested.


        :return: The delegation_subscription_ids of this DelegatedResourceAccessRequest.
        :rtype: list[str]
        """
        return self._delegation_subscription_ids

    @delegation_subscription_ids.setter
    def delegation_subscription_ids(self, delegation_subscription_ids):
        """
        Sets the delegation_subscription_ids of this DelegatedResourceAccessRequest.
        List of Delegation Subscription OCID that are associated with this Delegated Resource Access Request based on the service types being requested.


        :param delegation_subscription_ids: The delegation_subscription_ids of this DelegatedResourceAccessRequest.
        :type: list[str]
        """
        self._delegation_subscription_ids = delegation_subscription_ids

    @property
    def severity(self):
        """
        Gets the severity of this DelegatedResourceAccessRequest.
        Priority assigned to the Delegated Resource Access Request by the support operator

        Allowed values for this property are: "S1", "S2", "S3", "S4", 'UNKNOWN_ENUM_VALUE'.
        Any unrecognized values returned by a service will be mapped to 'UNKNOWN_ENUM_VALUE'.


        :return: The severity of this DelegatedResourceAccessRequest.
        :rtype: str
        """
        return self._severity

    @severity.setter
    def severity(self, severity):
        """
        Sets the severity of this DelegatedResourceAccessRequest.
        Priority assigned to the Delegated Resource Access Request by the support operator


        :param severity: The severity of this DelegatedResourceAccessRequest.
        :type: str
        """
        allowed_values = ["S1", "S2", "S3", "S4"]
        if not value_allowed_none_or_none_sentinel(severity, allowed_values):
            severity = 'UNKNOWN_ENUM_VALUE'
        self._severity = severity

    @property
    def duration_in_hours(self):
        """
        Gets the duration_in_hours of this DelegatedResourceAccessRequest.
        Duration in hours for which access is sought on the target resource.


        :return: The duration_in_hours of this DelegatedResourceAccessRequest.
        :rtype: int
        """
        return self._duration_in_hours

    @duration_in_hours.setter
    def duration_in_hours(self, duration_in_hours):
        """
        Sets the duration_in_hours of this DelegatedResourceAccessRequest.
        Duration in hours for which access is sought on the target resource.


        :param duration_in_hours: The duration_in_hours of this DelegatedResourceAccessRequest.
        :type: int
        """
        self._duration_in_hours = duration_in_hours

    @property
    def extend_duration_in_hours(self):
        """
        Gets the extend_duration_in_hours of this DelegatedResourceAccessRequest.
        Duration in hours for which extension access is sought on the target resource.


        :return: The extend_duration_in_hours of this DelegatedResourceAccessRequest.
        :rtype: int
        """
        return self._extend_duration_in_hours

    @extend_duration_in_hours.setter
    def extend_duration_in_hours(self, extend_duration_in_hours):
        """
        Sets the extend_duration_in_hours of this DelegatedResourceAccessRequest.
        Duration in hours for which extension access is sought on the target resource.


        :param extend_duration_in_hours: The extend_duration_in_hours of this DelegatedResourceAccessRequest.
        :type: int
        """
        self._extend_duration_in_hours = extend_duration_in_hours

    @property
    def is_auto_approved(self):
        """
        Gets the is_auto_approved of this DelegatedResourceAccessRequest.
        Set to true if the request is approved automatically based on preApprovedServiceProviderActionNames or isAutoApproveDuringMaintenance in the associated Delegation Control.


        :return: The is_auto_approved of this DelegatedResourceAccessRequest.
        :rtype: bool
        """
        return self._is_auto_approved

    @is_auto_approved.setter
    def is_auto_approved(self, is_auto_approved):
        """
        Sets the is_auto_approved of this DelegatedResourceAccessRequest.
        Set to true if the request is approved automatically based on preApprovedServiceProviderActionNames or isAutoApproveDuringMaintenance in the associated Delegation Control.


        :param is_auto_approved: The is_auto_approved of this DelegatedResourceAccessRequest.
        :type: bool
        """
        self._is_auto_approved = is_auto_approved

    @property
    def lifecycle_state(self):
        """
        Gets the lifecycle_state of this DelegatedResourceAccessRequest.
        The current lifecycle state of the Delegated Resource Access Request.

        Allowed values for this property are: "ACCEPTED", "IN_PROGRESS", "WAITING", "FAILED", "SUCCEEDED", "CANCELING", "CANCELED", "NEEDS_ATTENTION", 'UNKNOWN_ENUM_VALUE'.
        Any unrecognized values returned by a service will be mapped to 'UNKNOWN_ENUM_VALUE'.


        :return: The lifecycle_state of this DelegatedResourceAccessRequest.
        :rtype: str
        """
        return self._lifecycle_state

    @lifecycle_state.setter
    def lifecycle_state(self, lifecycle_state):
        """
        Sets the lifecycle_state of this DelegatedResourceAccessRequest.
        The current lifecycle state of the Delegated Resource Access Request.


        :param lifecycle_state: The lifecycle_state of this DelegatedResourceAccessRequest.
        :type: str
        """
        allowed_values = ["ACCEPTED", "IN_PROGRESS", "WAITING", "FAILED", "SUCCEEDED", "CANCELING", "CANCELED", "NEEDS_ATTENTION"]
        if not value_allowed_none_or_none_sentinel(lifecycle_state, allowed_values):
            lifecycle_state = 'UNKNOWN_ENUM_VALUE'
        self._lifecycle_state = lifecycle_state

    @property
    def lifecycle_state_details(self):
        """
        Gets the lifecycle_state_details of this DelegatedResourceAccessRequest.
        Description of the current lifecycle state in more detail.


        :return: The lifecycle_state_details of this DelegatedResourceAccessRequest.
        :rtype: str
        """
        return self._lifecycle_state_details

    @lifecycle_state_details.setter
    def lifecycle_state_details(self, lifecycle_state_details):
        """
        Sets the lifecycle_state_details of this DelegatedResourceAccessRequest.
        Description of the current lifecycle state in more detail.


        :param lifecycle_state_details: The lifecycle_state_details of this DelegatedResourceAccessRequest.
        :type: str
        """
        self._lifecycle_state_details = lifecycle_state_details

    @property
    def request_status(self):
        """
        Gets the request_status of this DelegatedResourceAccessRequest.
        The current status of the Delegated Resource Access Request.

        Allowed values for this property are: "CREATED", "APPROVAL_WAITING", "OPERATOR_ASSIGNMENT_WAITING", "PREAPPROVED", "APPROVED", "APPROVED_FOR_FUTURE", "REJECTED", "DEPLOYED", "DEPLOY_FAILED", "UNDEPLOYED", "UNDEPLOY_FAILED", "CLOSE_FAILED", "REVOKE_FAILED", "EXPIRY_FAILED", "REVOKING", "REVOKED", "EXTENDING", "EXTENDED", "EXTENSION_REJECTED", "EXTENSION_FAILED", "COMPLETING", "COMPLETED", "EXPIRED", 'UNKNOWN_ENUM_VALUE'.
        Any unrecognized values returned by a service will be mapped to 'UNKNOWN_ENUM_VALUE'.


        :return: The request_status of this DelegatedResourceAccessRequest.
        :rtype: str
        """
        return self._request_status

    @request_status.setter
    def request_status(self, request_status):
        """
        Sets the request_status of this DelegatedResourceAccessRequest.
        The current status of the Delegated Resource Access Request.


        :param request_status: The request_status of this DelegatedResourceAccessRequest.
        :type: str
        """
        allowed_values = ["CREATED", "APPROVAL_WAITING", "OPERATOR_ASSIGNMENT_WAITING", "PREAPPROVED", "APPROVED", "APPROVED_FOR_FUTURE", "REJECTED", "DEPLOYED", "DEPLOY_FAILED", "UNDEPLOYED", "UNDEPLOY_FAILED", "CLOSE_FAILED", "REVOKE_FAILED", "EXPIRY_FAILED", "REVOKING", "REVOKED", "EXTENDING", "EXTENDED", "EXTENSION_REJECTED", "EXTENSION_FAILED", "COMPLETING", "COMPLETED", "EXPIRED"]
        if not value_allowed_none_or_none_sentinel(request_status, allowed_values):
            request_status = 'UNKNOWN_ENUM_VALUE'
        self._request_status = request_status

    @property
    def time_created(self):
        """
        Gets the time_created of this DelegatedResourceAccessRequest.
        Time when the Delegated Resource Access Request was created in `RFC 3339`__timestamp format, e.g. '2020-05-22T21:10:29.600Z'.

        __ https://tools.ietf.org/html/rfc3339


        :return: The time_created of this DelegatedResourceAccessRequest.
        :rtype: datetime
        """
        return self._time_created

    @time_created.setter
    def time_created(self, time_created):
        """
        Sets the time_created of this DelegatedResourceAccessRequest.
        Time when the Delegated Resource Access Request was created in `RFC 3339`__timestamp format, e.g. '2020-05-22T21:10:29.600Z'.

        __ https://tools.ietf.org/html/rfc3339


        :param time_created: The time_created of this DelegatedResourceAccessRequest.
        :type: datetime
        """
        self._time_created = time_created

    @property
    def time_updated(self):
        """
        Gets the time_updated of this DelegatedResourceAccessRequest.
        Time when the Delegated Resource Access Request was last modified in `RFC 3339`__timestamp format, e.g. '2020-05-22T21:10:29.600Z'.

        __ https://tools.ietf.org/html/rfc3339


        :return: The time_updated of this DelegatedResourceAccessRequest.
        :rtype: datetime
        """
        return self._time_updated

    @time_updated.setter
    def time_updated(self, time_updated):
        """
        Sets the time_updated of this DelegatedResourceAccessRequest.
        Time when the Delegated Resource Access Request was last modified in `RFC 3339`__timestamp format, e.g. '2020-05-22T21:10:29.600Z'.

        __ https://tools.ietf.org/html/rfc3339


        :param time_updated: The time_updated of this DelegatedResourceAccessRequest.
        :type: datetime
        """
        self._time_updated = time_updated

    @property
    def num_initial_approvals(self):
        """
        Gets the num_initial_approvals of this DelegatedResourceAccessRequest.
        Number of initial approvals that have been obtained so far.


        :return: The num_initial_approvals of this DelegatedResourceAccessRequest.
        :rtype: int
        """
        return self._num_initial_approvals

    @num_initial_approvals.setter
    def num_initial_approvals(self, num_initial_approvals):
        """
        Sets the num_initial_approvals of this DelegatedResourceAccessRequest.
        Number of initial approvals that have been obtained so far.


        :param num_initial_approvals: The num_initial_approvals of this DelegatedResourceAccessRequest.
        :type: int
        """
        self._num_initial_approvals = num_initial_approvals

    @property
    def num_extension_approvals(self):
        """
        Gets the num_extension_approvals of this DelegatedResourceAccessRequest.
        Number of extension approvals that have been obtained so far.


        :return: The num_extension_approvals of this DelegatedResourceAccessRequest.
        :rtype: int
        """
        return self._num_extension_approvals

    @num_extension_approvals.setter
    def num_extension_approvals(self, num_extension_approvals):
        """
        Sets the num_extension_approvals of this DelegatedResourceAccessRequest.
        Number of extension approvals that have been obtained so far.


        :param num_extension_approvals: The num_extension_approvals of this DelegatedResourceAccessRequest.
        :type: int
        """
        self._num_extension_approvals = num_extension_approvals

    @property
    def approval_info(self):
        """
        Gets the approval_info of this DelegatedResourceAccessRequest.
        In case of single approval, this will have only one item. Else, a list of approvals.


        :return: The approval_info of this DelegatedResourceAccessRequest.
        :rtype: list[oci.delegate_access_control.models.DelegatedResourceAccessRequestApprovalDetails]
        """
        return self._approval_info

    @approval_info.setter
    def approval_info(self, approval_info):
        """
        Sets the approval_info of this DelegatedResourceAccessRequest.
        In case of single approval, this will have only one item. Else, a list of approvals.


        :param approval_info: The approval_info of this DelegatedResourceAccessRequest.
        :type: list[oci.delegate_access_control.models.DelegatedResourceAccessRequestApprovalDetails]
        """
        self._approval_info = approval_info

    @property
    def closure_comment(self):
        """
        Gets the closure_comment of this DelegatedResourceAccessRequest.
        The comment entered by the support operator while closing the request.


        :return: The closure_comment of this DelegatedResourceAccessRequest.
        :rtype: str
        """
        return self._closure_comment

    @closure_comment.setter
    def closure_comment(self, closure_comment):
        """
        Sets the closure_comment of this DelegatedResourceAccessRequest.
        The comment entered by the support operator while closing the request.


        :param closure_comment: The closure_comment of this DelegatedResourceAccessRequest.
        :type: str
        """
        self._closure_comment = closure_comment

    @property
    def delegation_control_id(self):
        """
        Gets the delegation_control_id of this DelegatedResourceAccessRequest.
        The OCID of the Delegation Control governing the target resource.


        :return: The delegation_control_id of this DelegatedResourceAccessRequest.
        :rtype: str
        """
        return self._delegation_control_id

    @delegation_control_id.setter
    def delegation_control_id(self, delegation_control_id):
        """
        Sets the delegation_control_id of this DelegatedResourceAccessRequest.
        The OCID of the Delegation Control governing the target resource.


        :param delegation_control_id: The delegation_control_id of this DelegatedResourceAccessRequest.
        :type: str
        """
        self._delegation_control_id = delegation_control_id

    @property
    def audit_types(self):
        """
        Gets the audit_types of this DelegatedResourceAccessRequest.
        Specifies the type of auditing to be enabled. There are two levels of auditing: command-level and keystroke-level.
        By default, both command-level and keystroke-level auditing are enabled, i.e. commands and key strokes issued by the support operator are logged.

        Allowed values for items in this list are: "COMMAND_AUDIT", "COMMAND_KEYSTROKE_AUDIT", 'UNKNOWN_ENUM_VALUE'.
        Any unrecognized values returned by a service will be mapped to 'UNKNOWN_ENUM_VALUE'.


        :return: The audit_types of this DelegatedResourceAccessRequest.
        :rtype: list[str]
        """
        return self._audit_types

    @audit_types.setter
    def audit_types(self, audit_types):
        """
        Sets the audit_types of this DelegatedResourceAccessRequest.
        Specifies the type of auditing to be enabled. There are two levels of auditing: command-level and keystroke-level.
        By default, both command-level and keystroke-level auditing are enabled, i.e. commands and key strokes issued by the support operator are logged.


        :param audit_types: The audit_types of this DelegatedResourceAccessRequest.
        :type: list[str]
        """
        allowed_values = ["COMMAND_AUDIT", "COMMAND_KEYSTROKE_AUDIT"]
        if audit_types:
            audit_types[:] = ['UNKNOWN_ENUM_VALUE' if not value_allowed_none_or_none_sentinel(x, allowed_values) else x for x in audit_types]
        self._audit_types = audit_types

    @property
    def is_pending_more_info(self):
        """
        Gets the is_pending_more_info of this DelegatedResourceAccessRequest.
        Indicates if the delegated resource access request is waiting on more information from the operator


        :return: The is_pending_more_info of this DelegatedResourceAccessRequest.
        :rtype: bool
        """
        return self._is_pending_more_info

    @is_pending_more_info.setter
    def is_pending_more_info(self, is_pending_more_info):
        """
        Sets the is_pending_more_info of this DelegatedResourceAccessRequest.
        Indicates if the delegated resource access request is waiting on more information from the operator


        :param is_pending_more_info: The is_pending_more_info of this DelegatedResourceAccessRequest.
        :type: bool
        """
        self._is_pending_more_info = is_pending_more_info

    @property
    def freeform_tags(self):
        """
        Gets the freeform_tags of this DelegatedResourceAccessRequest.
        Free-form tags for this resource. Each tag is a simple key-value pair with no predefined name, type, or namespace.
        For more information, see `Resource Tags`__.

        Example: `{\"Department\": \"Finance\"}`

        __ https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm


        :return: The freeform_tags of this DelegatedResourceAccessRequest.
        :rtype: dict(str, str)
        """
        return self._freeform_tags

    @freeform_tags.setter
    def freeform_tags(self, freeform_tags):
        """
        Sets the freeform_tags of this DelegatedResourceAccessRequest.
        Free-form tags for this resource. Each tag is a simple key-value pair with no predefined name, type, or namespace.
        For more information, see `Resource Tags`__.

        Example: `{\"Department\": \"Finance\"}`

        __ https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm


        :param freeform_tags: The freeform_tags of this DelegatedResourceAccessRequest.
        :type: dict(str, str)
        """
        self._freeform_tags = freeform_tags

    @property
    def defined_tags(self):
        """
        Gets the defined_tags of this DelegatedResourceAccessRequest.
        Defined tags for this resource. Each key is predefined and scoped to a namespace.
        For more information, see `Resource Tags`__.

        Example: `{\"Operations\": {\"CostCenter\": \"42\"}}`

        __ https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm


        :return: The defined_tags of this DelegatedResourceAccessRequest.
        :rtype: dict(str, dict(str, object))
        """
        return self._defined_tags

    @defined_tags.setter
    def defined_tags(self, defined_tags):
        """
        Sets the defined_tags of this DelegatedResourceAccessRequest.
        Defined tags for this resource. Each key is predefined and scoped to a namespace.
        For more information, see `Resource Tags`__.

        Example: `{\"Operations\": {\"CostCenter\": \"42\"}}`

        __ https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm


        :param defined_tags: The defined_tags of this DelegatedResourceAccessRequest.
        :type: dict(str, dict(str, object))
        """
        self._defined_tags = defined_tags

    @property
    def system_tags(self):
        """
        Gets the system_tags of this DelegatedResourceAccessRequest.
        System tags for this resource. Each key is predefined and scoped to a namespace.

        Example: `{\"orcl-cloud\": {\"free-tier-retained\": \"true\"}}`


        :return: The system_tags of this DelegatedResourceAccessRequest.
        :rtype: dict(str, dict(str, object))
        """
        return self._system_tags

    @system_tags.setter
    def system_tags(self, system_tags):
        """
        Sets the system_tags of this DelegatedResourceAccessRequest.
        System tags for this resource. Each key is predefined and scoped to a namespace.

        Example: `{\"orcl-cloud\": {\"free-tier-retained\": \"true\"}}`


        :param system_tags: The system_tags of this DelegatedResourceAccessRequest.
        :type: dict(str, dict(str, object))
        """
        self._system_tags = system_tags

    def __repr__(self):
        return formatted_flat_dict(self)

    def __eq__(self, other):
        if other is None:
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not self == other
