# coding: utf-8
# Copyright (c) 2016, 2026, Oracle and/or its affiliates.  All rights reserved.
# This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.

# NOTE: This class is auto generated by OracleSDKGenerator. DO NOT EDIT. API Version: 20210630

from .pull_request_activity_summary import PullRequestActivitySummary
from oci.util import formatted_flat_dict, NONE_SENTINEL, value_allowed_none_or_none_sentinel  # noqa: F401
from oci.decorators import init_model_state_from_kwargs


@init_model_state_from_kwargs
class CommitActivitySummary(PullRequestActivitySummary):
    """
    activity describing commit updates to a pull request
    """

    def __init__(self, **kwargs):
        """
        Initializes a new CommitActivitySummary object with values from keyword arguments. The default value of the :py:attr:`~oci.devops.models.CommitActivitySummary.activity_type` attribute
        of this class is ``COMMIT`` and it should not be changed.
        The following keyword arguments are supported (corresponding to the getters/setters of this class):

        :param id:
            The value to assign to the id property of this CommitActivitySummary.
        :type id: str

        :param principal:
            The value to assign to the principal property of this CommitActivitySummary.
        :type principal: oci.devops.models.PrincipalDetails

        :param pull_request_id:
            The value to assign to the pull_request_id property of this CommitActivitySummary.
        :type pull_request_id: str

        :param time_occurred:
            The value to assign to the time_occurred property of this CommitActivitySummary.
        :type time_occurred: datetime

        :param activity_type:
            The value to assign to the activity_type property of this CommitActivitySummary.
            Allowed values for this property are: "LIFECYCLE", "APPROVAL", "COMMIT", "REVIEWER", "COMMENT"
        :type activity_type: str

        :param commits_added:
            The value to assign to the commits_added property of this CommitActivitySummary.
        :type commits_added: list[oci.devops.models.RepositoryCommit]

        :param commits_removed:
            The value to assign to the commits_removed property of this CommitActivitySummary.
        :type commits_removed: list[oci.devops.models.RepositoryCommit]

        """
        self.swagger_types = {
            'id': 'str',
            'principal': 'PrincipalDetails',
            'pull_request_id': 'str',
            'time_occurred': 'datetime',
            'activity_type': 'str',
            'commits_added': 'list[RepositoryCommit]',
            'commits_removed': 'list[RepositoryCommit]'
        }
        self.attribute_map = {
            'id': 'id',
            'principal': 'principal',
            'pull_request_id': 'pullRequestId',
            'time_occurred': 'timeOccurred',
            'activity_type': 'activityType',
            'commits_added': 'commitsAdded',
            'commits_removed': 'commitsRemoved'
        }
        self._id = None
        self._principal = None
        self._pull_request_id = None
        self._time_occurred = None
        self._activity_type = None
        self._commits_added = None
        self._commits_removed = None
        self._activity_type = 'COMMIT'

    @property
    def commits_added(self):
        """
        **[Required]** Gets the commits_added of this CommitActivitySummary.
        list of commits added to a PR source branch after git push


        :return: The commits_added of this CommitActivitySummary.
        :rtype: list[oci.devops.models.RepositoryCommit]
        """
        return self._commits_added

    @commits_added.setter
    def commits_added(self, commits_added):
        """
        Sets the commits_added of this CommitActivitySummary.
        list of commits added to a PR source branch after git push


        :param commits_added: The commits_added of this CommitActivitySummary.
        :type: list[oci.devops.models.RepositoryCommit]
        """
        self._commits_added = commits_added

    @property
    def commits_removed(self):
        """
        **[Required]** Gets the commits_removed of this CommitActivitySummary.
        list of commits removed from a PR source branch after git push


        :return: The commits_removed of this CommitActivitySummary.
        :rtype: list[oci.devops.models.RepositoryCommit]
        """
        return self._commits_removed

    @commits_removed.setter
    def commits_removed(self, commits_removed):
        """
        Sets the commits_removed of this CommitActivitySummary.
        list of commits removed from a PR source branch after git push


        :param commits_removed: The commits_removed of this CommitActivitySummary.
        :type: list[oci.devops.models.RepositoryCommit]
        """
        self._commits_removed = commits_removed

    def __repr__(self):
        return formatted_flat_dict(self)

    def __eq__(self, other):
        if other is None:
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not self == other
