# coding: utf-8
# Copyright (c) 2016, 2026, Oracle and/or its affiliates.  All rights reserved.
# This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.

# NOTE: This class is auto generated by OracleSDKGenerator. DO NOT EDIT. API Version: 20210630


from oci.util import formatted_flat_dict, NONE_SENTINEL, value_allowed_none_or_none_sentinel  # noqa: F401
from oci.decorators import init_model_state_from_kwargs


@init_model_state_from_kwargs
class RepositoryPathCommitDetails(object):
    """
    Details about the last commit that modified a repository path.
    """

    def __init__(self, **kwargs):
        """
        Initializes a new RepositoryPathCommitDetails object with values from keyword arguments.
        The following keyword arguments are supported (corresponding to the getters/setters of this class):

        :param commit_id:
            The value to assign to the commit_id property of this RepositoryPathCommitDetails.
        :type commit_id: str

        :param message:
            The value to assign to the message property of this RepositoryPathCommitDetails.
        :type message: str

        :param author:
            The value to assign to the author property of this RepositoryPathCommitDetails.
        :type author: oci.devops.models.PrincipalDetails

        :param time_updated:
            The value to assign to the time_updated property of this RepositoryPathCommitDetails.
        :type time_updated: datetime

        """
        self.swagger_types = {
            'commit_id': 'str',
            'message': 'str',
            'author': 'PrincipalDetails',
            'time_updated': 'datetime'
        }
        self.attribute_map = {
            'commit_id': 'commitId',
            'message': 'message',
            'author': 'author',
            'time_updated': 'timeUpdated'
        }
        self._commit_id = None
        self._message = None
        self._author = None
        self._time_updated = None

    @property
    def commit_id(self):
        """
        Gets the commit_id of this RepositoryPathCommitDetails.
        The commit hash of the last commit.


        :return: The commit_id of this RepositoryPathCommitDetails.
        :rtype: str
        """
        return self._commit_id

    @commit_id.setter
    def commit_id(self, commit_id):
        """
        Sets the commit_id of this RepositoryPathCommitDetails.
        The commit hash of the last commit.


        :param commit_id: The commit_id of this RepositoryPathCommitDetails.
        :type: str
        """
        self._commit_id = commit_id

    @property
    def message(self):
        """
        Gets the message of this RepositoryPathCommitDetails.
        The commit message of the last commit.


        :return: The message of this RepositoryPathCommitDetails.
        :rtype: str
        """
        return self._message

    @message.setter
    def message(self, message):
        """
        Sets the message of this RepositoryPathCommitDetails.
        The commit message of the last commit.


        :param message: The message of this RepositoryPathCommitDetails.
        :type: str
        """
        self._message = message

    @property
    def author(self):
        """
        Gets the author of this RepositoryPathCommitDetails.

        :return: The author of this RepositoryPathCommitDetails.
        :rtype: oci.devops.models.PrincipalDetails
        """
        return self._author

    @author.setter
    def author(self, author):
        """
        Sets the author of this RepositoryPathCommitDetails.

        :param author: The author of this RepositoryPathCommitDetails.
        :type: oci.devops.models.PrincipalDetails
        """
        self._author = author

    @property
    def time_updated(self):
        """
        Gets the time_updated of this RepositoryPathCommitDetails.
        Timestamp when this commit was made.


        :return: The time_updated of this RepositoryPathCommitDetails.
        :rtype: datetime
        """
        return self._time_updated

    @time_updated.setter
    def time_updated(self, time_updated):
        """
        Sets the time_updated of this RepositoryPathCommitDetails.
        Timestamp when this commit was made.


        :param time_updated: The time_updated of this RepositoryPathCommitDetails.
        :type: datetime
        """
        self._time_updated = time_updated

    def __repr__(self):
        return formatted_flat_dict(self)

    def __eq__(self, other):
        if other is None:
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not self == other
