# coding: utf-8
# Copyright (c) 2016, 2026, Oracle and/or its affiliates.  All rights reserved.
# This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.

# NOTE: This class is auto generated by OracleSDKGenerator. DO NOT EDIT. API Version: 20210630

from .pull_request_activity_summary import PullRequestActivitySummary
from oci.util import formatted_flat_dict, NONE_SENTINEL, value_allowed_none_or_none_sentinel  # noqa: F401
from oci.decorators import init_model_state_from_kwargs


@init_model_state_from_kwargs
class ReviewerActivitySummary(PullRequestActivitySummary):
    """
    activity describing reviewer updates to a pull request
    """

    def __init__(self, **kwargs):
        """
        Initializes a new ReviewerActivitySummary object with values from keyword arguments. The default value of the :py:attr:`~oci.devops.models.ReviewerActivitySummary.activity_type` attribute
        of this class is ``REVIEWER`` and it should not be changed.
        The following keyword arguments are supported (corresponding to the getters/setters of this class):

        :param id:
            The value to assign to the id property of this ReviewerActivitySummary.
        :type id: str

        :param principal:
            The value to assign to the principal property of this ReviewerActivitySummary.
        :type principal: oci.devops.models.PrincipalDetails

        :param pull_request_id:
            The value to assign to the pull_request_id property of this ReviewerActivitySummary.
        :type pull_request_id: str

        :param time_occurred:
            The value to assign to the time_occurred property of this ReviewerActivitySummary.
        :type time_occurred: datetime

        :param activity_type:
            The value to assign to the activity_type property of this ReviewerActivitySummary.
            Allowed values for this property are: "LIFECYCLE", "APPROVAL", "COMMIT", "REVIEWER", "COMMENT"
        :type activity_type: str

        :param reviewers_added:
            The value to assign to the reviewers_added property of this ReviewerActivitySummary.
        :type reviewers_added: list[oci.devops.models.PrincipalDetails]

        :param reviewers_removed:
            The value to assign to the reviewers_removed property of this ReviewerActivitySummary.
        :type reviewers_removed: list[oci.devops.models.PrincipalDetails]

        """
        self.swagger_types = {
            'id': 'str',
            'principal': 'PrincipalDetails',
            'pull_request_id': 'str',
            'time_occurred': 'datetime',
            'activity_type': 'str',
            'reviewers_added': 'list[PrincipalDetails]',
            'reviewers_removed': 'list[PrincipalDetails]'
        }
        self.attribute_map = {
            'id': 'id',
            'principal': 'principal',
            'pull_request_id': 'pullRequestId',
            'time_occurred': 'timeOccurred',
            'activity_type': 'activityType',
            'reviewers_added': 'reviewersAdded',
            'reviewers_removed': 'reviewersRemoved'
        }
        self._id = None
        self._principal = None
        self._pull_request_id = None
        self._time_occurred = None
        self._activity_type = None
        self._reviewers_added = None
        self._reviewers_removed = None
        self._activity_type = 'REVIEWER'

    @property
    def reviewers_added(self):
        """
        **[Required]** Gets the reviewers_added of this ReviewerActivitySummary.
        list of reviewers added to a pull request


        :return: The reviewers_added of this ReviewerActivitySummary.
        :rtype: list[oci.devops.models.PrincipalDetails]
        """
        return self._reviewers_added

    @reviewers_added.setter
    def reviewers_added(self, reviewers_added):
        """
        Sets the reviewers_added of this ReviewerActivitySummary.
        list of reviewers added to a pull request


        :param reviewers_added: The reviewers_added of this ReviewerActivitySummary.
        :type: list[oci.devops.models.PrincipalDetails]
        """
        self._reviewers_added = reviewers_added

    @property
    def reviewers_removed(self):
        """
        **[Required]** Gets the reviewers_removed of this ReviewerActivitySummary.
        list of reviewers removed from a pull request


        :return: The reviewers_removed of this ReviewerActivitySummary.
        :rtype: list[oci.devops.models.PrincipalDetails]
        """
        return self._reviewers_removed

    @reviewers_removed.setter
    def reviewers_removed(self, reviewers_removed):
        """
        Sets the reviewers_removed of this ReviewerActivitySummary.
        list of reviewers removed from a pull request


        :param reviewers_removed: The reviewers_removed of this ReviewerActivitySummary.
        :type: list[oci.devops.models.PrincipalDetails]
        """
        self._reviewers_removed = reviewers_removed

    def __repr__(self):
        return formatted_flat_dict(self)

    def __eq__(self, other):
        if other is None:
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not self == other
