# coding: utf-8
# Copyright (c) 2016, 2026, Oracle and/or its affiliates.  All rights reserved.
# This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.

# NOTE: This class is auto generated by OracleSDKGenerator. DO NOT EDIT. API Version: 20250830


from oci.util import formatted_flat_dict, NONE_SENTINEL, value_allowed_none_or_none_sentinel  # noqa: F401
from oci.decorators import init_model_state_from_kwargs


@init_model_state_from_kwargs
class GgcsSourceDetail(object):
    """
    GGCS source configuration for creating or updating existing extracts.
    """

    #: A constant which can be used with the action property of a GgcsSourceDetail.
    #: This constant has a value of "CREATE"
    ACTION_CREATE = "CREATE"

    #: A constant which can be used with the action property of a GgcsSourceDetail.
    #: This constant has a value of "UPDATE"
    ACTION_UPDATE = "UPDATE"

    def __init__(self, **kwargs):
        """
        Initializes a new GgcsSourceDetail object with values from keyword arguments.
        The following keyword arguments are supported (corresponding to the getters/setters of this class):

        :param source_id:
            The value to assign to the source_id property of this GgcsSourceDetail.
        :type source_id: str

        :param action:
            The value to assign to the action property of this GgcsSourceDetail.
            Allowed values for this property are: "CREATE", "UPDATE"
        :type action: str

        :param should_start_source_operations:
            The value to assign to the should_start_source_operations property of this GgcsSourceDetail.
        :type should_start_source_operations: bool

        :param target_uri:
            The value to assign to the target_uri property of this GgcsSourceDetail.
        :type target_uri: str

        :param target_connection_name:
            The value to assign to the target_connection_name property of this GgcsSourceDetail.
        :type target_connection_name: str

        """
        self.swagger_types = {
            'source_id': 'str',
            'action': 'str',
            'should_start_source_operations': 'bool',
            'target_uri': 'str',
            'target_connection_name': 'str'
        }
        self.attribute_map = {
            'source_id': 'sourceId',
            'action': 'action',
            'should_start_source_operations': 'shouldStartSourceOperations',
            'target_uri': 'targetUri',
            'target_connection_name': 'targetConnectionName'
        }
        self._source_id = None
        self._action = None
        self._should_start_source_operations = None
        self._target_uri = None
        self._target_connection_name = None

    @property
    def source_id(self):
        """
        **[Required]** Gets the source_id of this GgcsSourceDetail.
        Ggcs source artifact id.


        :return: The source_id of this GgcsSourceDetail.
        :rtype: str
        """
        return self._source_id

    @source_id.setter
    def source_id(self, source_id):
        """
        Sets the source_id of this GgcsSourceDetail.
        Ggcs source artifact id.


        :param source_id: The source_id of this GgcsSourceDetail.
        :type: str
        """
        self._source_id = source_id

    @property
    def action(self):
        """
        **[Required]** Gets the action of this GgcsSourceDetail.
        Action to be done over the user. Allowed values are \"CREATE\" or \"UPDATE\".

        Allowed values for this property are: "CREATE", "UPDATE"


        :return: The action of this GgcsSourceDetail.
        :rtype: str
        """
        return self._action

    @action.setter
    def action(self, action):
        """
        Sets the action of this GgcsSourceDetail.
        Action to be done over the user. Allowed values are \"CREATE\" or \"UPDATE\".


        :param action: The action of this GgcsSourceDetail.
        :type: str
        """
        allowed_values = ["CREATE", "UPDATE"]
        if not value_allowed_none_or_none_sentinel(action, allowed_values):
            raise ValueError(
                f"Invalid value for `action`, must be None or one of {allowed_values}"
            )
        self._action = action

    @property
    def should_start_source_operations(self):
        """
        **[Required]** Gets the should_start_source_operations of this GgcsSourceDetail.
        Boolean value that determines source operations should start or not.


        :return: The should_start_source_operations of this GgcsSourceDetail.
        :rtype: bool
        """
        return self._should_start_source_operations

    @should_start_source_operations.setter
    def should_start_source_operations(self, should_start_source_operations):
        """
        Sets the should_start_source_operations of this GgcsSourceDetail.
        Boolean value that determines source operations should start or not.


        :param should_start_source_operations: The should_start_source_operations of this GgcsSourceDetail.
        :type: bool
        """
        self._should_start_source_operations = should_start_source_operations

    @property
    def target_uri(self):
        """
        Gets the target_uri of this GgcsSourceDetail.
        Target uri for the GoldenGate deployment where distribution path needs to be configured.


        :return: The target_uri of this GgcsSourceDetail.
        :rtype: str
        """
        return self._target_uri

    @target_uri.setter
    def target_uri(self, target_uri):
        """
        Sets the target_uri of this GgcsSourceDetail.
        Target uri for the GoldenGate deployment where distribution path needs to be configured.


        :param target_uri: The target_uri of this GgcsSourceDetail.
        :type: str
        """
        self._target_uri = target_uri

    @property
    def target_connection_name(self):
        """
        Gets the target_connection_name of this GgcsSourceDetail.
        Name of assigned connection for the source.


        :return: The target_connection_name of this GgcsSourceDetail.
        :rtype: str
        """
        return self._target_connection_name

    @target_connection_name.setter
    def target_connection_name(self, target_connection_name):
        """
        Sets the target_connection_name of this GgcsSourceDetail.
        Name of assigned connection for the source.


        :param target_connection_name: The target_connection_name of this GgcsSourceDetail.
        :type: str
        """
        self._target_connection_name = target_connection_name

    def __repr__(self):
        return formatted_flat_dict(self)

    def __eq__(self, other):
        if other is None:
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not self == other
