# coding: utf-8
# Copyright (c) 2016, 2026, Oracle and/or its affiliates.  All rights reserved.
# This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.

# NOTE: This class is auto generated by OracleSDKGenerator. DO NOT EDIT. API Version: 20250830


from oci.util import formatted_flat_dict, NONE_SENTINEL, value_allowed_none_or_none_sentinel  # noqa: F401
from oci.decorators import init_model_state_from_kwargs


@init_model_state_from_kwargs
class Stack(object):
    """
    A Stack is a collection of a templates and services.

    To use any of the API operations, you must be authorized in an IAM policy. If you're not authorized, talk to
    an administrator. If you're an administrator who needs to write policies to give users access, see
    `Getting Started with Policies`__.

    __ https://docs.cloud.oracle.com/iaas/Content/Identity/policiesgs/get-started-with-policies.htm
    """

    #: A constant which can be used with the stack_templates property of a Stack.
    #: This constant has a value of "DATALAKE"
    STACK_TEMPLATES_DATALAKE = "DATALAKE"

    #: A constant which can be used with the stack_templates property of a Stack.
    #: This constant has a value of "DATAPIPELINE"
    STACK_TEMPLATES_DATAPIPELINE = "DATAPIPELINE"

    #: A constant which can be used with the stack_templates property of a Stack.
    #: This constant has a value of "AISERVICES"
    STACK_TEMPLATES_AISERVICES = "AISERVICES"

    #: A constant which can be used with the stack_templates property of a Stack.
    #: This constant has a value of "DATATRANSFORMATION"
    STACK_TEMPLATES_DATATRANSFORMATION = "DATATRANSFORMATION"

    #: A constant which can be used with the services property of a Stack.
    #: This constant has a value of "ADB"
    SERVICES_ADB = "ADB"

    #: A constant which can be used with the services property of a Stack.
    #: This constant has a value of "GGCS"
    SERVICES_GGCS = "GGCS"

    #: A constant which can be used with the services property of a Stack.
    #: This constant has a value of "OBJECTSTORAGE"
    SERVICES_OBJECTSTORAGE = "OBJECTSTORAGE"

    #: A constant which can be used with the services property of a Stack.
    #: This constant has a value of "GENAI"
    SERVICES_GENAI = "GENAI"

    #: A constant which can be used with the services property of a Stack.
    #: This constant has a value of "DATAFLOW"
    SERVICES_DATAFLOW = "DATAFLOW"

    #: A constant which can be used with the lifecycle_state property of a Stack.
    #: This constant has a value of "CREATING"
    LIFECYCLE_STATE_CREATING = "CREATING"

    #: A constant which can be used with the lifecycle_state property of a Stack.
    #: This constant has a value of "UPDATING"
    LIFECYCLE_STATE_UPDATING = "UPDATING"

    #: A constant which can be used with the lifecycle_state property of a Stack.
    #: This constant has a value of "ACTIVE"
    LIFECYCLE_STATE_ACTIVE = "ACTIVE"

    #: A constant which can be used with the lifecycle_state property of a Stack.
    #: This constant has a value of "DELETING"
    LIFECYCLE_STATE_DELETING = "DELETING"

    #: A constant which can be used with the lifecycle_state property of a Stack.
    #: This constant has a value of "DELETED"
    LIFECYCLE_STATE_DELETED = "DELETED"

    #: A constant which can be used with the lifecycle_state property of a Stack.
    #: This constant has a value of "FAILED"
    LIFECYCLE_STATE_FAILED = "FAILED"

    #: A constant which can be used with the lifecycle_state property of a Stack.
    #: This constant has a value of "NEEDS_ATTENTION"
    LIFECYCLE_STATE_NEEDS_ATTENTION = "NEEDS_ATTENTION"

    def __init__(self, **kwargs):
        """
        Initializes a new Stack object with values from keyword arguments.
        The following keyword arguments are supported (corresponding to the getters/setters of this class):

        :param id:
            The value to assign to the id property of this Stack.
        :type id: str

        :param display_name:
            The value to assign to the display_name property of this Stack.
        :type display_name: str

        :param compartment_id:
            The value to assign to the compartment_id property of this Stack.
        :type compartment_id: str

        :param notification_email:
            The value to assign to the notification_email property of this Stack.
        :type notification_email: str

        :param stack_templates:
            The value to assign to the stack_templates property of this Stack.
            Allowed values for items in this list are: "DATALAKE", "DATAPIPELINE", "AISERVICES", "DATATRANSFORMATION", 'UNKNOWN_ENUM_VALUE'.
            Any unrecognized values returned by a service will be mapped to 'UNKNOWN_ENUM_VALUE'.
        :type stack_templates: list[str]

        :param services:
            The value to assign to the services property of this Stack.
            Allowed values for items in this list are: "ADB", "GGCS", "OBJECTSTORAGE", "GENAI", "DATAFLOW", 'UNKNOWN_ENUM_VALUE'.
            Any unrecognized values returned by a service will be mapped to 'UNKNOWN_ENUM_VALUE'.
        :type services: list[str]

        :param adb:
            The value to assign to the adb property of this Stack.
        :type adb: list[oci.dif.models.AdbDetail]

        :param ggcs:
            The value to assign to the ggcs property of this Stack.
        :type ggcs: list[oci.dif.models.GgcsDetail]

        :param dataflow:
            The value to assign to the dataflow property of this Stack.
        :type dataflow: list[oci.dif.models.DataflowDetail]

        :param objectstorage:
            The value to assign to the objectstorage property of this Stack.
        :type objectstorage: list[oci.dif.models.ObjectStorageDetail]

        :param genai:
            The value to assign to the genai property of this Stack.
        :type genai: list[oci.dif.models.GenAiDetail]

        :param service_details:
            The value to assign to the service_details property of this Stack.
        :type service_details: list[oci.dif.models.ServiceDetailResponse]

        :param time_created:
            The value to assign to the time_created property of this Stack.
        :type time_created: datetime

        :param time_updated:
            The value to assign to the time_updated property of this Stack.
        :type time_updated: datetime

        :param lifecycle_state:
            The value to assign to the lifecycle_state property of this Stack.
            Allowed values for this property are: "CREATING", "UPDATING", "ACTIVE", "DELETING", "DELETED", "FAILED", "NEEDS_ATTENTION", 'UNKNOWN_ENUM_VALUE'.
            Any unrecognized values returned by a service will be mapped to 'UNKNOWN_ENUM_VALUE'.
        :type lifecycle_state: str

        :param lifecycle_details:
            The value to assign to the lifecycle_details property of this Stack.
        :type lifecycle_details: str

        :param freeform_tags:
            The value to assign to the freeform_tags property of this Stack.
        :type freeform_tags: dict(str, str)

        :param defined_tags:
            The value to assign to the defined_tags property of this Stack.
        :type defined_tags: dict(str, dict(str, object))

        :param system_tags:
            The value to assign to the system_tags property of this Stack.
        :type system_tags: dict(str, dict(str, object))

        """
        self.swagger_types = {
            'id': 'str',
            'display_name': 'str',
            'compartment_id': 'str',
            'notification_email': 'str',
            'stack_templates': 'list[str]',
            'services': 'list[str]',
            'adb': 'list[AdbDetail]',
            'ggcs': 'list[GgcsDetail]',
            'dataflow': 'list[DataflowDetail]',
            'objectstorage': 'list[ObjectStorageDetail]',
            'genai': 'list[GenAiDetail]',
            'service_details': 'list[ServiceDetailResponse]',
            'time_created': 'datetime',
            'time_updated': 'datetime',
            'lifecycle_state': 'str',
            'lifecycle_details': 'str',
            'freeform_tags': 'dict(str, str)',
            'defined_tags': 'dict(str, dict(str, object))',
            'system_tags': 'dict(str, dict(str, object))'
        }
        self.attribute_map = {
            'id': 'id',
            'display_name': 'displayName',
            'compartment_id': 'compartmentId',
            'notification_email': 'notificationEmail',
            'stack_templates': 'stackTemplates',
            'services': 'services',
            'adb': 'adb',
            'ggcs': 'ggcs',
            'dataflow': 'dataflow',
            'objectstorage': 'objectstorage',
            'genai': 'genai',
            'service_details': 'serviceDetails',
            'time_created': 'timeCreated',
            'time_updated': 'timeUpdated',
            'lifecycle_state': 'lifecycleState',
            'lifecycle_details': 'lifecycleDetails',
            'freeform_tags': 'freeformTags',
            'defined_tags': 'definedTags',
            'system_tags': 'systemTags'
        }
        self._id = None
        self._display_name = None
        self._compartment_id = None
        self._notification_email = None
        self._stack_templates = None
        self._services = None
        self._adb = None
        self._ggcs = None
        self._dataflow = None
        self._objectstorage = None
        self._genai = None
        self._service_details = None
        self._time_created = None
        self._time_updated = None
        self._lifecycle_state = None
        self._lifecycle_details = None
        self._freeform_tags = None
        self._defined_tags = None
        self._system_tags = None

    @property
    def id(self):
        """
        **[Required]** Gets the id of this Stack.
        The `OCID`__ of the Stack.

        __ https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm


        :return: The id of this Stack.
        :rtype: str
        """
        return self._id

    @id.setter
    def id(self, id):
        """
        Sets the id of this Stack.
        The `OCID`__ of the Stack.

        __ https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm


        :param id: The id of this Stack.
        :type: str
        """
        self._id = id

    @property
    def display_name(self):
        """
        **[Required]** Gets the display_name of this Stack.
        A user-friendly name. Does not have to be unique, and it's changeable.


        :return: The display_name of this Stack.
        :rtype: str
        """
        return self._display_name

    @display_name.setter
    def display_name(self, display_name):
        """
        Sets the display_name of this Stack.
        A user-friendly name. Does not have to be unique, and it's changeable.


        :param display_name: The display_name of this Stack.
        :type: str
        """
        self._display_name = display_name

    @property
    def compartment_id(self):
        """
        **[Required]** Gets the compartment_id of this Stack.
        The `OCID`__ of the compartment.

        __ https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm


        :return: The compartment_id of this Stack.
        :rtype: str
        """
        return self._compartment_id

    @compartment_id.setter
    def compartment_id(self, compartment_id):
        """
        Sets the compartment_id of this Stack.
        The `OCID`__ of the compartment.

        __ https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm


        :param compartment_id: The compartment_id of this Stack.
        :type: str
        """
        self._compartment_id = compartment_id

    @property
    def notification_email(self):
        """
        Gets the notification_email of this Stack.
        email id to which the stack notifications would be sent.


        :return: The notification_email of this Stack.
        :rtype: str
        """
        return self._notification_email

    @notification_email.setter
    def notification_email(self, notification_email):
        """
        Sets the notification_email of this Stack.
        email id to which the stack notifications would be sent.


        :param notification_email: The notification_email of this Stack.
        :type: str
        """
        self._notification_email = notification_email

    @property
    def stack_templates(self):
        """
        **[Required]** Gets the stack_templates of this Stack.
        List of templates to be onboarded for the stack.

        Allowed values for items in this list are: "DATALAKE", "DATAPIPELINE", "AISERVICES", "DATATRANSFORMATION", 'UNKNOWN_ENUM_VALUE'.
        Any unrecognized values returned by a service will be mapped to 'UNKNOWN_ENUM_VALUE'.


        :return: The stack_templates of this Stack.
        :rtype: list[str]
        """
        return self._stack_templates

    @stack_templates.setter
    def stack_templates(self, stack_templates):
        """
        Sets the stack_templates of this Stack.
        List of templates to be onboarded for the stack.


        :param stack_templates: The stack_templates of this Stack.
        :type: list[str]
        """
        allowed_values = ["DATALAKE", "DATAPIPELINE", "AISERVICES", "DATATRANSFORMATION"]
        if stack_templates:
            stack_templates[:] = ['UNKNOWN_ENUM_VALUE' if not value_allowed_none_or_none_sentinel(x, allowed_values) else x for x in stack_templates]
        self._stack_templates = stack_templates

    @property
    def services(self):
        """
        **[Required]** Gets the services of this Stack.
        List of services to be onboarded for the stack.

        Allowed values for items in this list are: "ADB", "GGCS", "OBJECTSTORAGE", "GENAI", "DATAFLOW", 'UNKNOWN_ENUM_VALUE'.
        Any unrecognized values returned by a service will be mapped to 'UNKNOWN_ENUM_VALUE'.


        :return: The services of this Stack.
        :rtype: list[str]
        """
        return self._services

    @services.setter
    def services(self, services):
        """
        Sets the services of this Stack.
        List of services to be onboarded for the stack.


        :param services: The services of this Stack.
        :type: list[str]
        """
        allowed_values = ["ADB", "GGCS", "OBJECTSTORAGE", "GENAI", "DATAFLOW"]
        if services:
            services[:] = ['UNKNOWN_ENUM_VALUE' if not value_allowed_none_or_none_sentinel(x, allowed_values) else x for x in services]
        self._services = services

    @property
    def adb(self):
        """
        Gets the adb of this Stack.
        ADB details if adb is included in the services.


        :return: The adb of this Stack.
        :rtype: list[oci.dif.models.AdbDetail]
        """
        return self._adb

    @adb.setter
    def adb(self, adb):
        """
        Sets the adb of this Stack.
        ADB details if adb is included in the services.


        :param adb: The adb of this Stack.
        :type: list[oci.dif.models.AdbDetail]
        """
        self._adb = adb

    @property
    def ggcs(self):
        """
        Gets the ggcs of this Stack.
        GGCS details if ggcs is included in the services.


        :return: The ggcs of this Stack.
        :rtype: list[oci.dif.models.GgcsDetail]
        """
        return self._ggcs

    @ggcs.setter
    def ggcs(self, ggcs):
        """
        Sets the ggcs of this Stack.
        GGCS details if ggcs is included in the services.


        :param ggcs: The ggcs of this Stack.
        :type: list[oci.dif.models.GgcsDetail]
        """
        self._ggcs = ggcs

    @property
    def dataflow(self):
        """
        Gets the dataflow of this Stack.
        DATAFLOW details if dataflow is included in the services.


        :return: The dataflow of this Stack.
        :rtype: list[oci.dif.models.DataflowDetail]
        """
        return self._dataflow

    @dataflow.setter
    def dataflow(self, dataflow):
        """
        Sets the dataflow of this Stack.
        DATAFLOW details if dataflow is included in the services.


        :param dataflow: The dataflow of this Stack.
        :type: list[oci.dif.models.DataflowDetail]
        """
        self._dataflow = dataflow

    @property
    def objectstorage(self):
        """
        Gets the objectstorage of this Stack.
        Object Storage Details if object storage is included in services.


        :return: The objectstorage of this Stack.
        :rtype: list[oci.dif.models.ObjectStorageDetail]
        """
        return self._objectstorage

    @objectstorage.setter
    def objectstorage(self, objectstorage):
        """
        Sets the objectstorage of this Stack.
        Object Storage Details if object storage is included in services.


        :param objectstorage: The objectstorage of this Stack.
        :type: list[oci.dif.models.ObjectStorageDetail]
        """
        self._objectstorage = objectstorage

    @property
    def genai(self):
        """
        Gets the genai of this Stack.
        GenAI Details if genai is included in services.


        :return: The genai of this Stack.
        :rtype: list[oci.dif.models.GenAiDetail]
        """
        return self._genai

    @genai.setter
    def genai(self, genai):
        """
        Sets the genai of this Stack.
        GenAI Details if genai is included in services.


        :param genai: The genai of this Stack.
        :type: list[oci.dif.models.GenAiDetail]
        """
        self._genai = genai

    @property
    def service_details(self):
        """
        Gets the service_details of this Stack.
        Details of the service onboarded for the data intelligence stack.


        :return: The service_details of this Stack.
        :rtype: list[oci.dif.models.ServiceDetailResponse]
        """
        return self._service_details

    @service_details.setter
    def service_details(self, service_details):
        """
        Sets the service_details of this Stack.
        Details of the service onboarded for the data intelligence stack.


        :param service_details: The service_details of this Stack.
        :type: list[oci.dif.models.ServiceDetailResponse]
        """
        self._service_details = service_details

    @property
    def time_created(self):
        """
        **[Required]** Gets the time_created of this Stack.
        The date and time the Stack was created, in the format defined by `RFC 3339`__.

        Example: `2016-08-25T21:10:29.600Z`

        __ https://tools.ietf.org/html/rfc3339


        :return: The time_created of this Stack.
        :rtype: datetime
        """
        return self._time_created

    @time_created.setter
    def time_created(self, time_created):
        """
        Sets the time_created of this Stack.
        The date and time the Stack was created, in the format defined by `RFC 3339`__.

        Example: `2016-08-25T21:10:29.600Z`

        __ https://tools.ietf.org/html/rfc3339


        :param time_created: The time_created of this Stack.
        :type: datetime
        """
        self._time_created = time_created

    @property
    def time_updated(self):
        """
        Gets the time_updated of this Stack.
        The date and time the Stack was updated, in the format defined by `RFC 3339`__.

        Example: `2016-08-25T21:10:29.600Z`

        __ https://tools.ietf.org/html/rfc3339


        :return: The time_updated of this Stack.
        :rtype: datetime
        """
        return self._time_updated

    @time_updated.setter
    def time_updated(self, time_updated):
        """
        Sets the time_updated of this Stack.
        The date and time the Stack was updated, in the format defined by `RFC 3339`__.

        Example: `2016-08-25T21:10:29.600Z`

        __ https://tools.ietf.org/html/rfc3339


        :param time_updated: The time_updated of this Stack.
        :type: datetime
        """
        self._time_updated = time_updated

    @property
    def lifecycle_state(self):
        """
        **[Required]** Gets the lifecycle_state of this Stack.
        The current state of the Stack.

        Allowed values for this property are: "CREATING", "UPDATING", "ACTIVE", "DELETING", "DELETED", "FAILED", "NEEDS_ATTENTION", 'UNKNOWN_ENUM_VALUE'.
        Any unrecognized values returned by a service will be mapped to 'UNKNOWN_ENUM_VALUE'.


        :return: The lifecycle_state of this Stack.
        :rtype: str
        """
        return self._lifecycle_state

    @lifecycle_state.setter
    def lifecycle_state(self, lifecycle_state):
        """
        Sets the lifecycle_state of this Stack.
        The current state of the Stack.


        :param lifecycle_state: The lifecycle_state of this Stack.
        :type: str
        """
        allowed_values = ["CREATING", "UPDATING", "ACTIVE", "DELETING", "DELETED", "FAILED", "NEEDS_ATTENTION"]
        if not value_allowed_none_or_none_sentinel(lifecycle_state, allowed_values):
            lifecycle_state = 'UNKNOWN_ENUM_VALUE'
        self._lifecycle_state = lifecycle_state

    @property
    def lifecycle_details(self):
        """
        Gets the lifecycle_details of this Stack.
        A message that describes the current state of the Stack in more detail. For example,
        can be used to provide actionable information for a resource in the Failed state.


        :return: The lifecycle_details of this Stack.
        :rtype: str
        """
        return self._lifecycle_details

    @lifecycle_details.setter
    def lifecycle_details(self, lifecycle_details):
        """
        Sets the lifecycle_details of this Stack.
        A message that describes the current state of the Stack in more detail. For example,
        can be used to provide actionable information for a resource in the Failed state.


        :param lifecycle_details: The lifecycle_details of this Stack.
        :type: str
        """
        self._lifecycle_details = lifecycle_details

    @property
    def freeform_tags(self):
        """
        **[Required]** Gets the freeform_tags of this Stack.
        Free-form tags for this resource. Each tag is a simple key-value pair with no predefined name, type, or namespace.
        For more information, see `Resource Tags`__.

        Example: `{\"Department\": \"Finance\"}`

        __ https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm


        :return: The freeform_tags of this Stack.
        :rtype: dict(str, str)
        """
        return self._freeform_tags

    @freeform_tags.setter
    def freeform_tags(self, freeform_tags):
        """
        Sets the freeform_tags of this Stack.
        Free-form tags for this resource. Each tag is a simple key-value pair with no predefined name, type, or namespace.
        For more information, see `Resource Tags`__.

        Example: `{\"Department\": \"Finance\"}`

        __ https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm


        :param freeform_tags: The freeform_tags of this Stack.
        :type: dict(str, str)
        """
        self._freeform_tags = freeform_tags

    @property
    def defined_tags(self):
        """
        **[Required]** Gets the defined_tags of this Stack.
        Defined tags for this resource. Each key is predefined and scoped to a namespace.
        For more information, see `Resource Tags`__.

        Example: `{\"Operations\": {\"CostCenter\": \"42\"}}`

        __ https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm


        :return: The defined_tags of this Stack.
        :rtype: dict(str, dict(str, object))
        """
        return self._defined_tags

    @defined_tags.setter
    def defined_tags(self, defined_tags):
        """
        Sets the defined_tags of this Stack.
        Defined tags for this resource. Each key is predefined and scoped to a namespace.
        For more information, see `Resource Tags`__.

        Example: `{\"Operations\": {\"CostCenter\": \"42\"}}`

        __ https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm


        :param defined_tags: The defined_tags of this Stack.
        :type: dict(str, dict(str, object))
        """
        self._defined_tags = defined_tags

    @property
    def system_tags(self):
        """
        Gets the system_tags of this Stack.
        System tags for this resource. Each key is predefined and scoped to a namespace.

        Example: `{\"orcl-cloud\": {\"free-tier-retained\": \"true\"}}`


        :return: The system_tags of this Stack.
        :rtype: dict(str, dict(str, object))
        """
        return self._system_tags

    @system_tags.setter
    def system_tags(self, system_tags):
        """
        Sets the system_tags of this Stack.
        System tags for this resource. Each key is predefined and scoped to a namespace.

        Example: `{\"orcl-cloud\": {\"free-tier-retained\": \"true\"}}`


        :param system_tags: The system_tags of this Stack.
        :type: dict(str, dict(str, object))
        """
        self._system_tags = system_tags

    def __repr__(self):
        return formatted_flat_dict(self)

    def __eq__(self, other):
        if other is None:
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not self == other
