# coding: utf-8
# Copyright (c) 2016, 2026, Oracle and/or its affiliates.  All rights reserved.
# This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.

# NOTE: This class is auto generated by OracleSDKGenerator. DO NOT EDIT. API Version: 20220125


from oci.util import formatted_flat_dict, NONE_SENTINEL, value_allowed_none_or_none_sentinel  # noqa: F401
from oci.decorators import init_model_state_from_kwargs


@init_model_state_from_kwargs
class AutomaticExecutionDetails(object):
    """
    The details of the event that started the automatic DR plan execution.
    """

    def __init__(self, **kwargs):
        """
        Initializes a new AutomaticExecutionDetails object with values from keyword arguments.
        The following keyword arguments are supported (corresponding to the getters/setters of this class):

        :param event_name:
            The value to assign to the event_name property of this AutomaticExecutionDetails.
        :type event_name: str

        :param member_id:
            The value to assign to the member_id property of this AutomaticExecutionDetails.
        :type member_id: str

        """
        self.swagger_types = {
            'event_name': 'str',
            'member_id': 'str'
        }
        self.attribute_map = {
            'event_name': 'eventName',
            'member_id': 'memberId'
        }
        self._event_name = None
        self._member_id = None

    @property
    def event_name(self):
        """
        **[Required]** Gets the event_name of this AutomaticExecutionDetails.
        The name of the OCI event that started the automatic DR plan execution.

        Example: `SwitchoverAutonomousDatabase`


        :return: The event_name of this AutomaticExecutionDetails.
        :rtype: str
        """
        return self._event_name

    @event_name.setter
    def event_name(self, event_name):
        """
        Sets the event_name of this AutomaticExecutionDetails.
        The name of the OCI event that started the automatic DR plan execution.

        Example: `SwitchoverAutonomousDatabase`


        :param event_name: The event_name of this AutomaticExecutionDetails.
        :type: str
        """
        self._event_name = event_name

    @property
    def member_id(self):
        """
        **[Required]** Gets the member_id of this AutomaticExecutionDetails.
        The OCID of the member that emitted the event that started the automatic DR plan execution.

        Example: \"ocid1.autonomousdatabase.oc1..uniqueID\"


        :return: The member_id of this AutomaticExecutionDetails.
        :rtype: str
        """
        return self._member_id

    @member_id.setter
    def member_id(self, member_id):
        """
        Sets the member_id of this AutomaticExecutionDetails.
        The OCID of the member that emitted the event that started the automatic DR plan execution.

        Example: \"ocid1.autonomousdatabase.oc1..uniqueID\"


        :param member_id: The member_id of this AutomaticExecutionDetails.
        :type: str
        """
        self._member_id = member_id

    def __repr__(self):
        return formatted_flat_dict(self)

    def __eq__(self, other):
        if other is None:
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not self == other
