# coding: utf-8
# Copyright (c) 2016, 2026, Oracle and/or its affiliates.  All rights reserved.
# This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.

# NOTE: This class is auto generated by OracleSDKGenerator. DO NOT EDIT. API Version: 20220125


from oci.util import formatted_flat_dict, NONE_SENTINEL, value_allowed_none_or_none_sentinel  # noqa: F401
from oci.decorators import init_model_state_from_kwargs


@init_model_state_from_kwargs
class CreateAutomaticDrConfigurationDetails(object):
    """
    The details for creating an Automatic DR configuration.
    """

    def __init__(self, **kwargs):
        """
        Initializes a new CreateAutomaticDrConfigurationDetails object with values from keyword arguments.
        The following keyword arguments are supported (corresponding to the getters/setters of this class):

        :param display_name:
            The value to assign to the display_name property of this CreateAutomaticDrConfigurationDetails.
        :type display_name: str

        :param dr_protection_group_id:
            The value to assign to the dr_protection_group_id property of this CreateAutomaticDrConfigurationDetails.
        :type dr_protection_group_id: str

        :param members:
            The value to assign to the members property of this CreateAutomaticDrConfigurationDetails.
        :type members: list[oci.disaster_recovery.models.CreateAutomaticDrConfigurationMemberDetails]

        :param default_switchover_dr_plan_id:
            The value to assign to the default_switchover_dr_plan_id property of this CreateAutomaticDrConfigurationDetails.
        :type default_switchover_dr_plan_id: str

        :param default_failover_dr_plan_id:
            The value to assign to the default_failover_dr_plan_id property of this CreateAutomaticDrConfigurationDetails.
        :type default_failover_dr_plan_id: str

        :param freeform_tags:
            The value to assign to the freeform_tags property of this CreateAutomaticDrConfigurationDetails.
        :type freeform_tags: dict(str, str)

        :param defined_tags:
            The value to assign to the defined_tags property of this CreateAutomaticDrConfigurationDetails.
        :type defined_tags: dict(str, dict(str, object))

        """
        self.swagger_types = {
            'display_name': 'str',
            'dr_protection_group_id': 'str',
            'members': 'list[CreateAutomaticDrConfigurationMemberDetails]',
            'default_switchover_dr_plan_id': 'str',
            'default_failover_dr_plan_id': 'str',
            'freeform_tags': 'dict(str, str)',
            'defined_tags': 'dict(str, dict(str, object))'
        }
        self.attribute_map = {
            'display_name': 'displayName',
            'dr_protection_group_id': 'drProtectionGroupId',
            'members': 'members',
            'default_switchover_dr_plan_id': 'defaultSwitchoverDrPlanId',
            'default_failover_dr_plan_id': 'defaultFailoverDrPlanId',
            'freeform_tags': 'freeformTags',
            'defined_tags': 'definedTags'
        }
        self._display_name = None
        self._dr_protection_group_id = None
        self._members = None
        self._default_switchover_dr_plan_id = None
        self._default_failover_dr_plan_id = None
        self._freeform_tags = None
        self._defined_tags = None

    @property
    def display_name(self):
        """
        **[Required]** Gets the display_name of this CreateAutomaticDrConfigurationDetails.
        The display name of the Automatic DR configuration being created.

        Example: `Automatic DR Configuration`


        :return: The display_name of this CreateAutomaticDrConfigurationDetails.
        :rtype: str
        """
        return self._display_name

    @display_name.setter
    def display_name(self, display_name):
        """
        Sets the display_name of this CreateAutomaticDrConfigurationDetails.
        The display name of the Automatic DR configuration being created.

        Example: `Automatic DR Configuration`


        :param display_name: The display_name of this CreateAutomaticDrConfigurationDetails.
        :type: str
        """
        self._display_name = display_name

    @property
    def dr_protection_group_id(self):
        """
        **[Required]** Gets the dr_protection_group_id of this CreateAutomaticDrConfigurationDetails.
        The OCID of the DR protection group to which this Automatic DR configuration belongs.

        Example: `ocid1.drprotectiongroup.oc1..uniqueID`


        :return: The dr_protection_group_id of this CreateAutomaticDrConfigurationDetails.
        :rtype: str
        """
        return self._dr_protection_group_id

    @dr_protection_group_id.setter
    def dr_protection_group_id(self, dr_protection_group_id):
        """
        Sets the dr_protection_group_id of this CreateAutomaticDrConfigurationDetails.
        The OCID of the DR protection group to which this Automatic DR configuration belongs.

        Example: `ocid1.drprotectiongroup.oc1..uniqueID`


        :param dr_protection_group_id: The dr_protection_group_id of this CreateAutomaticDrConfigurationDetails.
        :type: str
        """
        self._dr_protection_group_id = dr_protection_group_id

    @property
    def members(self):
        """
        **[Required]** Gets the members of this CreateAutomaticDrConfigurationDetails.
        A list of members for Automatic DR configuration.


        :return: The members of this CreateAutomaticDrConfigurationDetails.
        :rtype: list[oci.disaster_recovery.models.CreateAutomaticDrConfigurationMemberDetails]
        """
        return self._members

    @members.setter
    def members(self, members):
        """
        Sets the members of this CreateAutomaticDrConfigurationDetails.
        A list of members for Automatic DR configuration.


        :param members: The members of this CreateAutomaticDrConfigurationDetails.
        :type: list[oci.disaster_recovery.models.CreateAutomaticDrConfigurationMemberDetails]
        """
        self._members = members

    @property
    def default_switchover_dr_plan_id(self):
        """
        Gets the default_switchover_dr_plan_id of this CreateAutomaticDrConfigurationDetails.
        The unique id of a Switchover DR Plan.

        Example: `ocid1.drplan.oc1..uniqueID`


        :return: The default_switchover_dr_plan_id of this CreateAutomaticDrConfigurationDetails.
        :rtype: str
        """
        return self._default_switchover_dr_plan_id

    @default_switchover_dr_plan_id.setter
    def default_switchover_dr_plan_id(self, default_switchover_dr_plan_id):
        """
        Sets the default_switchover_dr_plan_id of this CreateAutomaticDrConfigurationDetails.
        The unique id of a Switchover DR Plan.

        Example: `ocid1.drplan.oc1..uniqueID`


        :param default_switchover_dr_plan_id: The default_switchover_dr_plan_id of this CreateAutomaticDrConfigurationDetails.
        :type: str
        """
        self._default_switchover_dr_plan_id = default_switchover_dr_plan_id

    @property
    def default_failover_dr_plan_id(self):
        """
        Gets the default_failover_dr_plan_id of this CreateAutomaticDrConfigurationDetails.
        The unique id of a Failover DR Plan.

        Example: `ocid1.drplan.oc1..uniqueID`


        :return: The default_failover_dr_plan_id of this CreateAutomaticDrConfigurationDetails.
        :rtype: str
        """
        return self._default_failover_dr_plan_id

    @default_failover_dr_plan_id.setter
    def default_failover_dr_plan_id(self, default_failover_dr_plan_id):
        """
        Sets the default_failover_dr_plan_id of this CreateAutomaticDrConfigurationDetails.
        The unique id of a Failover DR Plan.

        Example: `ocid1.drplan.oc1..uniqueID`


        :param default_failover_dr_plan_id: The default_failover_dr_plan_id of this CreateAutomaticDrConfigurationDetails.
        :type: str
        """
        self._default_failover_dr_plan_id = default_failover_dr_plan_id

    @property
    def freeform_tags(self):
        """
        Gets the freeform_tags of this CreateAutomaticDrConfigurationDetails.
        Simple key-value pair that is applied without any predefined name, type or scope. Exists for cross-compatibility only.

        Example: `{\"Department\": \"Finance\"}`


        :return: The freeform_tags of this CreateAutomaticDrConfigurationDetails.
        :rtype: dict(str, str)
        """
        return self._freeform_tags

    @freeform_tags.setter
    def freeform_tags(self, freeform_tags):
        """
        Sets the freeform_tags of this CreateAutomaticDrConfigurationDetails.
        Simple key-value pair that is applied without any predefined name, type or scope. Exists for cross-compatibility only.

        Example: `{\"Department\": \"Finance\"}`


        :param freeform_tags: The freeform_tags of this CreateAutomaticDrConfigurationDetails.
        :type: dict(str, str)
        """
        self._freeform_tags = freeform_tags

    @property
    def defined_tags(self):
        """
        Gets the defined_tags of this CreateAutomaticDrConfigurationDetails.
        Defined tags for this resource. Each key is predefined and scoped to a namespace.

        Example: `{\"Operations\": {\"CostCenter\": \"42\"}}`


        :return: The defined_tags of this CreateAutomaticDrConfigurationDetails.
        :rtype: dict(str, dict(str, object))
        """
        return self._defined_tags

    @defined_tags.setter
    def defined_tags(self, defined_tags):
        """
        Sets the defined_tags of this CreateAutomaticDrConfigurationDetails.
        Defined tags for this resource. Each key is predefined and scoped to a namespace.

        Example: `{\"Operations\": {\"CostCenter\": \"42\"}}`


        :param defined_tags: The defined_tags of this CreateAutomaticDrConfigurationDetails.
        :type: dict(str, dict(str, object))
        """
        self._defined_tags = defined_tags

    def __repr__(self):
        return formatted_flat_dict(self)

    def __eq__(self, other):
        if other is None:
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not self == other
