# coding: utf-8
# Copyright (c) 2016, 2026, Oracle and/or its affiliates.  All rights reserved.
# This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.

# NOTE: This class is auto generated by OracleSDKGenerator. DO NOT EDIT. API Version: 20220125


from oci.util import formatted_flat_dict, NONE_SENTINEL, value_allowed_none_or_none_sentinel  # noqa: F401
from oci.decorators import init_model_state_from_kwargs


@init_model_state_from_kwargs
class DrPlanExecutionRemainingStepStatusCounts(object):
    """
    A summary of remaining steps in a DR plan execution, including queued, paused, and in-progress steps.
    """

    def __init__(self, **kwargs):
        """
        Initializes a new DrPlanExecutionRemainingStepStatusCounts object with values from keyword arguments.
        The following keyword arguments are supported (corresponding to the getters/setters of this class):

        :param total_remaining:
            The value to assign to the total_remaining property of this DrPlanExecutionRemainingStepStatusCounts.
        :type total_remaining: int

        :param queued:
            The value to assign to the queued property of this DrPlanExecutionRemainingStepStatusCounts.
        :type queued: int

        :param paused:
            The value to assign to the paused property of this DrPlanExecutionRemainingStepStatusCounts.
        :type paused: int

        :param in_progress:
            The value to assign to the in_progress property of this DrPlanExecutionRemainingStepStatusCounts.
        :type in_progress: int

        """
        self.swagger_types = {
            'total_remaining': 'int',
            'queued': 'int',
            'paused': 'int',
            'in_progress': 'int'
        }
        self.attribute_map = {
            'total_remaining': 'totalRemaining',
            'queued': 'queued',
            'paused': 'paused',
            'in_progress': 'inProgress'
        }
        self._total_remaining = None
        self._queued = None
        self._paused = None
        self._in_progress = None

    @property
    def total_remaining(self):
        """
        **[Required]** Gets the total_remaining of this DrPlanExecutionRemainingStepStatusCounts.
        The total number of remaining steps in a DR plan execution.


        :return: The total_remaining of this DrPlanExecutionRemainingStepStatusCounts.
        :rtype: int
        """
        return self._total_remaining

    @total_remaining.setter
    def total_remaining(self, total_remaining):
        """
        Sets the total_remaining of this DrPlanExecutionRemainingStepStatusCounts.
        The total number of remaining steps in a DR plan execution.


        :param total_remaining: The total_remaining of this DrPlanExecutionRemainingStepStatusCounts.
        :type: int
        """
        self._total_remaining = total_remaining

    @property
    def queued(self):
        """
        **[Required]** Gets the queued of this DrPlanExecutionRemainingStepStatusCounts.
        The total number of queued steps in a DR plan execution.


        :return: The queued of this DrPlanExecutionRemainingStepStatusCounts.
        :rtype: int
        """
        return self._queued

    @queued.setter
    def queued(self, queued):
        """
        Sets the queued of this DrPlanExecutionRemainingStepStatusCounts.
        The total number of queued steps in a DR plan execution.


        :param queued: The queued of this DrPlanExecutionRemainingStepStatusCounts.
        :type: int
        """
        self._queued = queued

    @property
    def paused(self):
        """
        **[Required]** Gets the paused of this DrPlanExecutionRemainingStepStatusCounts.
        The total number of paused steps in a DR plan execution.


        :return: The paused of this DrPlanExecutionRemainingStepStatusCounts.
        :rtype: int
        """
        return self._paused

    @paused.setter
    def paused(self, paused):
        """
        Sets the paused of this DrPlanExecutionRemainingStepStatusCounts.
        The total number of paused steps in a DR plan execution.


        :param paused: The paused of this DrPlanExecutionRemainingStepStatusCounts.
        :type: int
        """
        self._paused = paused

    @property
    def in_progress(self):
        """
        **[Required]** Gets the in_progress of this DrPlanExecutionRemainingStepStatusCounts.
        The total number of steps in progress during a DR plan execution.


        :return: The in_progress of this DrPlanExecutionRemainingStepStatusCounts.
        :rtype: int
        """
        return self._in_progress

    @in_progress.setter
    def in_progress(self, in_progress):
        """
        Sets the in_progress of this DrPlanExecutionRemainingStepStatusCounts.
        The total number of steps in progress during a DR plan execution.


        :param in_progress: The in_progress of this DrPlanExecutionRemainingStepStatusCounts.
        :type: int
        """
        self._in_progress = in_progress

    def __repr__(self):
        return formatted_flat_dict(self)

    def __eq__(self, other):
        if other is None:
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not self == other
