# coding: utf-8
# Copyright (c) 2016, 2026, Oracle and/or its affiliates.  All rights reserved.
# This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.

# NOTE: This class is auto generated by OracleSDKGenerator. DO NOT EDIT. API Version: 20220125


from oci.util import formatted_flat_dict, NONE_SENTINEL, value_allowed_none_or_none_sentinel  # noqa: F401
from oci.decorators import init_model_state_from_kwargs


@init_model_state_from_kwargs
class UpdateOkeClusterResourceModifierMappingDetails(object):
    """
    Update a mapping of OKE namespaces to config maps for an OKE member.
    """

    def __init__(self, **kwargs):
        """
        Initializes a new UpdateOkeClusterResourceModifierMappingDetails object with values from keyword arguments.
        The following keyword arguments are supported (corresponding to the getters/setters of this class):

        :param namespace:
            The value to assign to the namespace property of this UpdateOkeClusterResourceModifierMappingDetails.
        :type namespace: str

        :param config_map:
            The value to assign to the config_map property of this UpdateOkeClusterResourceModifierMappingDetails.
        :type config_map: str

        """
        self.swagger_types = {
            'namespace': 'str',
            'config_map': 'str'
        }
        self.attribute_map = {
            'namespace': 'namespace',
            'config_map': 'configMap'
        }
        self._namespace = None
        self._config_map = None

    @property
    def namespace(self):
        """
        **[Required]** Gets the namespace of this UpdateOkeClusterResourceModifierMappingDetails.
        The OKE namespace where the configmap resides.
        Example: `bar`


        :return: The namespace of this UpdateOkeClusterResourceModifierMappingDetails.
        :rtype: str
        """
        return self._namespace

    @namespace.setter
    def namespace(self, namespace):
        """
        Sets the namespace of this UpdateOkeClusterResourceModifierMappingDetails.
        The OKE namespace where the configmap resides.
        Example: `bar`


        :param namespace: The namespace of this UpdateOkeClusterResourceModifierMappingDetails.
        :type: str
        """
        self._namespace = namespace

    @property
    def config_map(self):
        """
        **[Required]** Gets the config_map of this UpdateOkeClusterResourceModifierMappingDetails.
        The name of the config map containing resource modification details.
        Example: `resource-modifier`


        :return: The config_map of this UpdateOkeClusterResourceModifierMappingDetails.
        :rtype: str
        """
        return self._config_map

    @config_map.setter
    def config_map(self, config_map):
        """
        Sets the config_map of this UpdateOkeClusterResourceModifierMappingDetails.
        The name of the config map containing resource modification details.
        Example: `resource-modifier`


        :param config_map: The config_map of this UpdateOkeClusterResourceModifierMappingDetails.
        :type: str
        """
        self._config_map = config_map

    def __repr__(self):
        return formatted_flat_dict(self)

    def __eq__(self, other):
        if other is None:
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not self == other
