# coding: utf-8
# Copyright (c) 2016, 2026, Oracle and/or its affiliates.  All rights reserved.
# This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.

# NOTE: This class is auto generated by OracleSDKGenerator. DO NOT EDIT. API Version: 20250101


from oci.util import formatted_flat_dict, NONE_SENTINEL, value_allowed_none_or_none_sentinel  # noqa: F401
from oci.decorators import init_model_state_from_kwargs


@init_model_state_from_kwargs
class ChangeDistributedDbBackupConfigDetails(object):
    """
    Details of the DbBackupConfig to be updated for the Globally distreibuted database.
    """

    def __init__(self, **kwargs):
        """
        Initializes a new ChangeDistributedDbBackupConfigDetails object with values from keyword arguments.
        The following keyword arguments are supported (corresponding to the getters/setters of this class):

        :param db_backup_config:
            The value to assign to the db_backup_config property of this ChangeDistributedDbBackupConfigDetails.
        :type db_backup_config: oci.distributed_database.models.DistributedDbBackupConfig

        """
        self.swagger_types = {
            'db_backup_config': 'DistributedDbBackupConfig'
        }
        self.attribute_map = {
            'db_backup_config': 'dbBackupConfig'
        }
        self._db_backup_config = None

    @property
    def db_backup_config(self):
        """
        **[Required]** Gets the db_backup_config of this ChangeDistributedDbBackupConfigDetails.

        :return: The db_backup_config of this ChangeDistributedDbBackupConfigDetails.
        :rtype: oci.distributed_database.models.DistributedDbBackupConfig
        """
        return self._db_backup_config

    @db_backup_config.setter
    def db_backup_config(self, db_backup_config):
        """
        Sets the db_backup_config of this ChangeDistributedDbBackupConfigDetails.

        :param db_backup_config: The db_backup_config of this ChangeDistributedDbBackupConfigDetails.
        :type: oci.distributed_database.models.DistributedDbBackupConfig
        """
        self._db_backup_config = db_backup_config

    def __repr__(self):
        return formatted_flat_dict(self)

    def __eq__(self, other):
        if other is None:
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not self == other
