# coding: utf-8
# Copyright (c) 2016, 2026, Oracle and/or its affiliates.  All rights reserved.
# This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.

# NOTE: This class is auto generated by OracleSDKGenerator. DO NOT EDIT. API Version: 20250101

from .create_distributed_database_catalog_details import CreateDistributedDatabaseCatalogDetails
from oci.util import formatted_flat_dict, NONE_SENTINEL, value_allowed_none_or_none_sentinel  # noqa: F401
from oci.decorators import init_model_state_from_kwargs


@init_model_state_from_kwargs
class CreateDistributedDatabaseCatalogWithExadbXsDetails(CreateDistributedDatabaseCatalogDetails):
    """
    Globally distributed database catalog based on exadbxs.
    """

    def __init__(self, **kwargs):
        """
        Initializes a new CreateDistributedDatabaseCatalogWithExadbXsDetails object with values from keyword arguments. The default value of the :py:attr:`~oci.distributed_database.models.CreateDistributedDatabaseCatalogWithExadbXsDetails.source` attribute
        of this class is ``EXADB_XS`` and it should not be changed.
        The following keyword arguments are supported (corresponding to the getters/setters of this class):

        :param source:
            The value to assign to the source property of this CreateDistributedDatabaseCatalogWithExadbXsDetails.
            Allowed values for this property are: "EXADB_XS"
        :type source: str

        :param vm_cluster_id:
            The value to assign to the vm_cluster_id property of this CreateDistributedDatabaseCatalogWithExadbXsDetails.
        :type vm_cluster_id: str

        :param admin_password:
            The value to assign to the admin_password property of this CreateDistributedDatabaseCatalogWithExadbXsDetails.
        :type admin_password: str

        :param peer_vm_cluster_ids:
            The value to assign to the peer_vm_cluster_ids property of this CreateDistributedDatabaseCatalogWithExadbXsDetails.
        :type peer_vm_cluster_ids: list[str]

        :param peer_details:
            The value to assign to the peer_details property of this CreateDistributedDatabaseCatalogWithExadbXsDetails.
        :type peer_details: list[oci.distributed_database.models.CreateCatalogPeerWithExadbXsDetails]

        :param shard_space:
            The value to assign to the shard_space property of this CreateDistributedDatabaseCatalogWithExadbXsDetails.
        :type shard_space: str

        :param vault_id:
            The value to assign to the vault_id property of this CreateDistributedDatabaseCatalogWithExadbXsDetails.
        :type vault_id: str

        :param kms_key_id:
            The value to assign to the kms_key_id property of this CreateDistributedDatabaseCatalogWithExadbXsDetails.
        :type kms_key_id: str

        :param kms_key_version_id:
            The value to assign to the kms_key_version_id property of this CreateDistributedDatabaseCatalogWithExadbXsDetails.
        :type kms_key_version_id: str

        """
        self.swagger_types = {
            'source': 'str',
            'vm_cluster_id': 'str',
            'admin_password': 'str',
            'peer_vm_cluster_ids': 'list[str]',
            'peer_details': 'list[CreateCatalogPeerWithExadbXsDetails]',
            'shard_space': 'str',
            'vault_id': 'str',
            'kms_key_id': 'str',
            'kms_key_version_id': 'str'
        }
        self.attribute_map = {
            'source': 'source',
            'vm_cluster_id': 'vmClusterId',
            'admin_password': 'adminPassword',
            'peer_vm_cluster_ids': 'peerVmClusterIds',
            'peer_details': 'peerDetails',
            'shard_space': 'shardSpace',
            'vault_id': 'vaultId',
            'kms_key_id': 'kmsKeyId',
            'kms_key_version_id': 'kmsKeyVersionId'
        }
        self._source = None
        self._vm_cluster_id = None
        self._admin_password = None
        self._peer_vm_cluster_ids = None
        self._peer_details = None
        self._shard_space = None
        self._vault_id = None
        self._kms_key_id = None
        self._kms_key_version_id = None
        self._source = 'EXADB_XS'

    @property
    def vm_cluster_id(self):
        """
        **[Required]** Gets the vm_cluster_id of this CreateDistributedDatabaseCatalogWithExadbXsDetails.
        The `OCID`__ of the VmCluster.

        __ https://docs.cloud.oracle.com/Content/General/Concepts/identifiers.htm


        :return: The vm_cluster_id of this CreateDistributedDatabaseCatalogWithExadbXsDetails.
        :rtype: str
        """
        return self._vm_cluster_id

    @vm_cluster_id.setter
    def vm_cluster_id(self, vm_cluster_id):
        """
        Sets the vm_cluster_id of this CreateDistributedDatabaseCatalogWithExadbXsDetails.
        The `OCID`__ of the VmCluster.

        __ https://docs.cloud.oracle.com/Content/General/Concepts/identifiers.htm


        :param vm_cluster_id: The vm_cluster_id of this CreateDistributedDatabaseCatalogWithExadbXsDetails.
        :type: str
        """
        self._vm_cluster_id = vm_cluster_id

    @property
    def admin_password(self):
        """
        **[Required]** Gets the admin_password of this CreateDistributedDatabaseCatalogWithExadbXsDetails.
        The admin password for the cataog associated with Globally distributed database.


        :return: The admin_password of this CreateDistributedDatabaseCatalogWithExadbXsDetails.
        :rtype: str
        """
        return self._admin_password

    @admin_password.setter
    def admin_password(self, admin_password):
        """
        Sets the admin_password of this CreateDistributedDatabaseCatalogWithExadbXsDetails.
        The admin password for the cataog associated with Globally distributed database.


        :param admin_password: The admin_password of this CreateDistributedDatabaseCatalogWithExadbXsDetails.
        :type: str
        """
        self._admin_password = admin_password

    @property
    def peer_vm_cluster_ids(self):
        """
        Gets the peer_vm_cluster_ids of this CreateDistributedDatabaseCatalogWithExadbXsDetails.
        This field is deprecated. This should not be used while creation of new distributed database. To set the peers
        on catalog of distributed database please use peerDetails.


        :return: The peer_vm_cluster_ids of this CreateDistributedDatabaseCatalogWithExadbXsDetails.
        :rtype: list[str]
        """
        return self._peer_vm_cluster_ids

    @peer_vm_cluster_ids.setter
    def peer_vm_cluster_ids(self, peer_vm_cluster_ids):
        """
        Sets the peer_vm_cluster_ids of this CreateDistributedDatabaseCatalogWithExadbXsDetails.
        This field is deprecated. This should not be used while creation of new distributed database. To set the peers
        on catalog of distributed database please use peerDetails.


        :param peer_vm_cluster_ids: The peer_vm_cluster_ids of this CreateDistributedDatabaseCatalogWithExadbXsDetails.
        :type: list[str]
        """
        self._peer_vm_cluster_ids = peer_vm_cluster_ids

    @property
    def peer_details(self):
        """
        Gets the peer_details of this CreateDistributedDatabaseCatalogWithExadbXsDetails.
        The details required for creation of the peer for the ExadbXs infrastructure based catalog.


        :return: The peer_details of this CreateDistributedDatabaseCatalogWithExadbXsDetails.
        :rtype: list[oci.distributed_database.models.CreateCatalogPeerWithExadbXsDetails]
        """
        return self._peer_details

    @peer_details.setter
    def peer_details(self, peer_details):
        """
        Sets the peer_details of this CreateDistributedDatabaseCatalogWithExadbXsDetails.
        The details required for creation of the peer for the ExadbXs infrastructure based catalog.


        :param peer_details: The peer_details of this CreateDistributedDatabaseCatalogWithExadbXsDetails.
        :type: list[oci.distributed_database.models.CreateCatalogPeerWithExadbXsDetails]
        """
        self._peer_details = peer_details

    @property
    def shard_space(self):
        """
        Gets the shard_space of this CreateDistributedDatabaseCatalogWithExadbXsDetails.
        The shard space name for the Globally distributed database. Shard space for existing shard cannot be changed, once shard is created.
        Shard space name shall be used while creation of new shards.


        :return: The shard_space of this CreateDistributedDatabaseCatalogWithExadbXsDetails.
        :rtype: str
        """
        return self._shard_space

    @shard_space.setter
    def shard_space(self, shard_space):
        """
        Sets the shard_space of this CreateDistributedDatabaseCatalogWithExadbXsDetails.
        The shard space name for the Globally distributed database. Shard space for existing shard cannot be changed, once shard is created.
        Shard space name shall be used while creation of new shards.


        :param shard_space: The shard_space of this CreateDistributedDatabaseCatalogWithExadbXsDetails.
        :type: str
        """
        self._shard_space = shard_space

    @property
    def vault_id(self):
        """
        Gets the vault_id of this CreateDistributedDatabaseCatalogWithExadbXsDetails.
        The `OCID`__ of the Oracle Cloud Infrastructure `vault`__. This parameter and `kmsKeyId` are required for Customer Managed Keys.

        __ https://docs.cloud.oracle.com/Content/General/Concepts/identifiers.htm
        __ https://docs.cloud.oracle.com/Content/KeyManagement/Concepts/keyoverview.htm#concepts


        :return: The vault_id of this CreateDistributedDatabaseCatalogWithExadbXsDetails.
        :rtype: str
        """
        return self._vault_id

    @vault_id.setter
    def vault_id(self, vault_id):
        """
        Sets the vault_id of this CreateDistributedDatabaseCatalogWithExadbXsDetails.
        The `OCID`__ of the Oracle Cloud Infrastructure `vault`__. This parameter and `kmsKeyId` are required for Customer Managed Keys.

        __ https://docs.cloud.oracle.com/Content/General/Concepts/identifiers.htm
        __ https://docs.cloud.oracle.com/Content/KeyManagement/Concepts/keyoverview.htm#concepts


        :param vault_id: The vault_id of this CreateDistributedDatabaseCatalogWithExadbXsDetails.
        :type: str
        """
        self._vault_id = vault_id

    @property
    def kms_key_id(self):
        """
        Gets the kms_key_id of this CreateDistributedDatabaseCatalogWithExadbXsDetails.
        The OCID of the key container that is used as the master encryption key in database transparent data encryption (TDE) operations.


        :return: The kms_key_id of this CreateDistributedDatabaseCatalogWithExadbXsDetails.
        :rtype: str
        """
        return self._kms_key_id

    @kms_key_id.setter
    def kms_key_id(self, kms_key_id):
        """
        Sets the kms_key_id of this CreateDistributedDatabaseCatalogWithExadbXsDetails.
        The OCID of the key container that is used as the master encryption key in database transparent data encryption (TDE) operations.


        :param kms_key_id: The kms_key_id of this CreateDistributedDatabaseCatalogWithExadbXsDetails.
        :type: str
        """
        self._kms_key_id = kms_key_id

    @property
    def kms_key_version_id(self):
        """
        Gets the kms_key_version_id of this CreateDistributedDatabaseCatalogWithExadbXsDetails.
        The OCID of the key container version that is used in database transparent data encryption (TDE) operations KMS Key can have multiple key versions.


        :return: The kms_key_version_id of this CreateDistributedDatabaseCatalogWithExadbXsDetails.
        :rtype: str
        """
        return self._kms_key_version_id

    @kms_key_version_id.setter
    def kms_key_version_id(self, kms_key_version_id):
        """
        Sets the kms_key_version_id of this CreateDistributedDatabaseCatalogWithExadbXsDetails.
        The OCID of the key container version that is used in database transparent data encryption (TDE) operations KMS Key can have multiple key versions.


        :param kms_key_version_id: The kms_key_version_id of this CreateDistributedDatabaseCatalogWithExadbXsDetails.
        :type: str
        """
        self._kms_key_version_id = kms_key_version_id

    def __repr__(self):
        return formatted_flat_dict(self)

    def __eq__(self, other):
        if other is None:
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not self == other
