# coding: utf-8
# Copyright (c) 2016, 2026, Oracle and/or its affiliates.  All rights reserved.
# This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.

# NOTE: This class is auto generated by OracleSDKGenerator. DO NOT EDIT. API Version: 20170907


from oci.util import formatted_flat_dict, NONE_SENTINEL, value_allowed_none_or_none_sentinel  # noqa: F401
from oci.decorators import init_model_state_from_kwargs


@init_model_state_from_kwargs
class RemoveEmailOutboundIpDetails(object):
    """
    Outbound IP details to be unassigned from the IpPool.
    """

    def __init__(self, **kwargs):
        """
        Initializes a new RemoveEmailOutboundIpDetails object with values from keyword arguments.
        The following keyword arguments are supported (corresponding to the getters/setters of this class):

        :param outbound_ips:
            The value to assign to the outbound_ips property of this RemoveEmailOutboundIpDetails.
        :type outbound_ips: list[str]

        """
        self.swagger_types = {
            'outbound_ips': 'list[str]'
        }
        self.attribute_map = {
            'outbound_ips': 'outboundIps'
        }
        self._outbound_ips = None

    @property
    def outbound_ips(self):
        """
        **[Required]** Gets the outbound_ips of this RemoveEmailOutboundIpDetails.
        List of public IPs to REMOVE from the IpPool.
        After a public IP is unassigned, it will be marked as AVAILABLE and can be assigned to another IpPool.
        The last IP removed from the Pool will be deleted from the IP Pool after 24 hours.


        :return: The outbound_ips of this RemoveEmailOutboundIpDetails.
        :rtype: list[str]
        """
        return self._outbound_ips

    @outbound_ips.setter
    def outbound_ips(self, outbound_ips):
        """
        Sets the outbound_ips of this RemoveEmailOutboundIpDetails.
        List of public IPs to REMOVE from the IpPool.
        After a public IP is unassigned, it will be marked as AVAILABLE and can be assigned to another IpPool.
        The last IP removed from the Pool will be deleted from the IP Pool after 24 hours.


        :param outbound_ips: The outbound_ips of this RemoveEmailOutboundIpDetails.
        :type: list[str]
        """
        self._outbound_ips = outbound_ips

    def __repr__(self):
        return formatted_flat_dict(self)

    def __eq__(self, other):
        if other is None:
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not self == other
