# coding: utf-8
# Copyright (c) 2016, 2026, Oracle and/or its affiliates.  All rights reserved.
# This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.

# NOTE: This class is auto generated by OracleSDKGenerator. DO NOT EDIT. API Version: 20171215


from oci.util import formatted_flat_dict, NONE_SENTINEL, value_allowed_none_or_none_sentinel  # noqa: F401
from oci.decorators import init_model_state_from_kwargs


@init_model_state_from_kwargs
class UpdateExportDetails(object):
    """
    Details for updating the export.
    """

    def __init__(self, **kwargs):
        """
        Initializes a new UpdateExportDetails object with values from keyword arguments.
        The following keyword arguments are supported (corresponding to the getters/setters of this class):

        :param is_idmap_groups_for_sys_auth:
            The value to assign to the is_idmap_groups_for_sys_auth property of this UpdateExportDetails.
        :type is_idmap_groups_for_sys_auth: bool

        :param export_options:
            The value to assign to the export_options property of this UpdateExportDetails.
        :type export_options: list[oci.file_storage.models.ClientOptions]

        """
        self.swagger_types = {
            'is_idmap_groups_for_sys_auth': 'bool',
            'export_options': 'list[ClientOptions]'
        }
        self.attribute_map = {
            'is_idmap_groups_for_sys_auth': 'isIdmapGroupsForSysAuth',
            'export_options': 'exportOptions'
        }
        self._is_idmap_groups_for_sys_auth = None
        self._export_options = None

    @property
    def is_idmap_groups_for_sys_auth(self):
        """
        Gets the is_idmap_groups_for_sys_auth of this UpdateExportDetails.
        Whether or not the export should use ID mapping for Unix groups rather than the group list provided within an NFS request's RPC header. When this flag is true the Unix UID from the RPC header is used to retrieve the list of secondary groups from a the ID mapping subsystem. The primary GID is always taken from the RPC header. If ID mapping is not configured, incorrectly configured, unavailable, or cannot be used to determine a list of secondary groups then an empty secondary group list is used for authorization. If the number of groups exceeds the limit of 256 groups, the list retrieved from LDAP is truncated to the first 256 groups read.


        :return: The is_idmap_groups_for_sys_auth of this UpdateExportDetails.
        :rtype: bool
        """
        return self._is_idmap_groups_for_sys_auth

    @is_idmap_groups_for_sys_auth.setter
    def is_idmap_groups_for_sys_auth(self, is_idmap_groups_for_sys_auth):
        """
        Sets the is_idmap_groups_for_sys_auth of this UpdateExportDetails.
        Whether or not the export should use ID mapping for Unix groups rather than the group list provided within an NFS request's RPC header. When this flag is true the Unix UID from the RPC header is used to retrieve the list of secondary groups from a the ID mapping subsystem. The primary GID is always taken from the RPC header. If ID mapping is not configured, incorrectly configured, unavailable, or cannot be used to determine a list of secondary groups then an empty secondary group list is used for authorization. If the number of groups exceeds the limit of 256 groups, the list retrieved from LDAP is truncated to the first 256 groups read.


        :param is_idmap_groups_for_sys_auth: The is_idmap_groups_for_sys_auth of this UpdateExportDetails.
        :type: bool
        """
        self._is_idmap_groups_for_sys_auth = is_idmap_groups_for_sys_auth

    @property
    def export_options(self):
        """
        Gets the export_options of this UpdateExportDetails.
        New export options for the export.

        **Setting to the empty array will make the export invisible to all clients.**

        Leaving unset will leave the `exportOptions` unchanged.


        :return: The export_options of this UpdateExportDetails.
        :rtype: list[oci.file_storage.models.ClientOptions]
        """
        return self._export_options

    @export_options.setter
    def export_options(self, export_options):
        """
        Sets the export_options of this UpdateExportDetails.
        New export options for the export.

        **Setting to the empty array will make the export invisible to all clients.**

        Leaving unset will leave the `exportOptions` unchanged.


        :param export_options: The export_options of this UpdateExportDetails.
        :type: list[oci.file_storage.models.ClientOptions]
        """
        self._export_options = export_options

    def __repr__(self):
        return formatted_flat_dict(self)

    def __eq__(self, other):
        if other is None:
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not self == other
