# coding: utf-8
# Copyright (c) 2016, 2026, Oracle and/or its affiliates.  All rights reserved.
# This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.

# NOTE: This class is auto generated by OracleSDKGenerator. DO NOT EDIT. API Version: 20250228


from oci.util import formatted_flat_dict, NONE_SENTINEL, value_allowed_none_or_none_sentinel  # noqa: F401
from oci.decorators import init_model_state_from_kwargs


@init_model_state_from_kwargs
class CatalogItemSummary(object):
    """
    Summary information about a CatalogItem.
    """

    def __init__(self, **kwargs):
        """
        Initializes a new CatalogItemSummary object with values from keyword arguments.
        The following keyword arguments are supported (corresponding to the getters/setters of this class):

        :param id:
            The value to assign to the id property of this CatalogItemSummary.
        :type id: str

        :param compartment_id:
            The value to assign to the compartment_id property of this CatalogItemSummary.
        :type compartment_id: str

        :param config_source_type:
            The value to assign to the config_source_type property of this CatalogItemSummary.
        :type config_source_type: str

        :param description:
            The value to assign to the description property of this CatalogItemSummary.
        :type description: str

        :param catalog_source_payload:
            The value to assign to the catalog_source_payload property of this CatalogItemSummary.
        :type catalog_source_payload: oci.fleet_apps_management.models.CatalogSourcePayload

        :param catalog_result_payload:
            The value to assign to the catalog_result_payload property of this CatalogItemSummary.
        :type catalog_result_payload: oci.fleet_apps_management.models.CatalogResultPayload

        :param listing_id:
            The value to assign to the listing_id property of this CatalogItemSummary.
        :type listing_id: str

        :param listing_version:
            The value to assign to the listing_version property of this CatalogItemSummary.
        :type listing_version: str

        :param display_name:
            The value to assign to the display_name property of this CatalogItemSummary.
        :type display_name: str

        :param package_type:
            The value to assign to the package_type property of this CatalogItemSummary.
        :type package_type: str

        :param lifecycle_state:
            The value to assign to the lifecycle_state property of this CatalogItemSummary.
        :type lifecycle_state: str

        :param lifecycle_details:
            The value to assign to the lifecycle_details property of this CatalogItemSummary.
        :type lifecycle_details: str

        :param time_created:
            The value to assign to the time_created property of this CatalogItemSummary.
        :type time_created: datetime

        :param time_updated:
            The value to assign to the time_updated property of this CatalogItemSummary.
        :type time_updated: datetime

        :param version_description:
            The value to assign to the version_description property of this CatalogItemSummary.
        :type version_description: str

        :param short_description:
            The value to assign to the short_description property of this CatalogItemSummary.
        :type short_description: str

        :param time_released:
            The value to assign to the time_released property of this CatalogItemSummary.
        :type time_released: datetime

        :param is_item_locked:
            The value to assign to the is_item_locked property of this CatalogItemSummary.
        :type is_item_locked: bool

        :param freeform_tags:
            The value to assign to the freeform_tags property of this CatalogItemSummary.
        :type freeform_tags: dict(str, str)

        :param defined_tags:
            The value to assign to the defined_tags property of this CatalogItemSummary.
        :type defined_tags: dict(str, dict(str, object))

        :param system_tags:
            The value to assign to the system_tags property of this CatalogItemSummary.
        :type system_tags: dict(str, dict(str, object))

        """
        self.swagger_types = {
            'id': 'str',
            'compartment_id': 'str',
            'config_source_type': 'str',
            'description': 'str',
            'catalog_source_payload': 'CatalogSourcePayload',
            'catalog_result_payload': 'CatalogResultPayload',
            'listing_id': 'str',
            'listing_version': 'str',
            'display_name': 'str',
            'package_type': 'str',
            'lifecycle_state': 'str',
            'lifecycle_details': 'str',
            'time_created': 'datetime',
            'time_updated': 'datetime',
            'version_description': 'str',
            'short_description': 'str',
            'time_released': 'datetime',
            'is_item_locked': 'bool',
            'freeform_tags': 'dict(str, str)',
            'defined_tags': 'dict(str, dict(str, object))',
            'system_tags': 'dict(str, dict(str, object))'
        }
        self.attribute_map = {
            'id': 'id',
            'compartment_id': 'compartmentId',
            'config_source_type': 'configSourceType',
            'description': 'description',
            'catalog_source_payload': 'catalogSourcePayload',
            'catalog_result_payload': 'catalogResultPayload',
            'listing_id': 'listingId',
            'listing_version': 'listingVersion',
            'display_name': 'displayName',
            'package_type': 'packageType',
            'lifecycle_state': 'lifecycleState',
            'lifecycle_details': 'lifecycleDetails',
            'time_created': 'timeCreated',
            'time_updated': 'timeUpdated',
            'version_description': 'versionDescription',
            'short_description': 'shortDescription',
            'time_released': 'timeReleased',
            'is_item_locked': 'isItemLocked',
            'freeform_tags': 'freeformTags',
            'defined_tags': 'definedTags',
            'system_tags': 'systemTags'
        }
        self._id = None
        self._compartment_id = None
        self._config_source_type = None
        self._description = None
        self._catalog_source_payload = None
        self._catalog_result_payload = None
        self._listing_id = None
        self._listing_version = None
        self._display_name = None
        self._package_type = None
        self._lifecycle_state = None
        self._lifecycle_details = None
        self._time_created = None
        self._time_updated = None
        self._version_description = None
        self._short_description = None
        self._time_released = None
        self._is_item_locked = None
        self._freeform_tags = None
        self._defined_tags = None
        self._system_tags = None

    @property
    def id(self):
        """
        **[Required]** Gets the id of this CatalogItemSummary.
        The `OCID`__ of the catalog.

        __ https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm


        :return: The id of this CatalogItemSummary.
        :rtype: str
        """
        return self._id

    @id.setter
    def id(self, id):
        """
        Sets the id of this CatalogItemSummary.
        The `OCID`__ of the catalog.

        __ https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm


        :param id: The id of this CatalogItemSummary.
        :type: str
        """
        self._id = id

    @property
    def compartment_id(self):
        """
        **[Required]** Gets the compartment_id of this CatalogItemSummary.
        The `OCID`__ of the compartment.

        __ https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm


        :return: The compartment_id of this CatalogItemSummary.
        :rtype: str
        """
        return self._compartment_id

    @compartment_id.setter
    def compartment_id(self, compartment_id):
        """
        Sets the compartment_id of this CatalogItemSummary.
        The `OCID`__ of the compartment.

        __ https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm


        :param compartment_id: The compartment_id of this CatalogItemSummary.
        :type: str
        """
        self._compartment_id = compartment_id

    @property
    def config_source_type(self):
        """
        **[Required]** Gets the config_source_type of this CatalogItemSummary.
        Config source type Eg: STACK_TEMPLATE_CATALOG_SOURCE, PAR_CATALOG_SOURCE, GIT_CATALOG_SOURCE, MARKETPLACE_CATALOG_SOURCE.


        :return: The config_source_type of this CatalogItemSummary.
        :rtype: str
        """
        return self._config_source_type

    @config_source_type.setter
    def config_source_type(self, config_source_type):
        """
        Sets the config_source_type of this CatalogItemSummary.
        Config source type Eg: STACK_TEMPLATE_CATALOG_SOURCE, PAR_CATALOG_SOURCE, GIT_CATALOG_SOURCE, MARKETPLACE_CATALOG_SOURCE.


        :param config_source_type: The config_source_type of this CatalogItemSummary.
        :type: str
        """
        self._config_source_type = config_source_type

    @property
    def description(self):
        """
        **[Required]** Gets the description of this CatalogItemSummary.
        The description of the catalogItem.


        :return: The description of this CatalogItemSummary.
        :rtype: str
        """
        return self._description

    @description.setter
    def description(self, description):
        """
        Sets the description of this CatalogItemSummary.
        The description of the catalogItem.


        :param description: The description of this CatalogItemSummary.
        :type: str
        """
        self._description = description

    @property
    def catalog_source_payload(self):
        """
        Gets the catalog_source_payload of this CatalogItemSummary.

        :return: The catalog_source_payload of this CatalogItemSummary.
        :rtype: oci.fleet_apps_management.models.CatalogSourcePayload
        """
        return self._catalog_source_payload

    @catalog_source_payload.setter
    def catalog_source_payload(self, catalog_source_payload):
        """
        Sets the catalog_source_payload of this CatalogItemSummary.

        :param catalog_source_payload: The catalog_source_payload of this CatalogItemSummary.
        :type: oci.fleet_apps_management.models.CatalogSourcePayload
        """
        self._catalog_source_payload = catalog_source_payload

    @property
    def catalog_result_payload(self):
        """
        Gets the catalog_result_payload of this CatalogItemSummary.

        :return: The catalog_result_payload of this CatalogItemSummary.
        :rtype: oci.fleet_apps_management.models.CatalogResultPayload
        """
        return self._catalog_result_payload

    @catalog_result_payload.setter
    def catalog_result_payload(self, catalog_result_payload):
        """
        Sets the catalog_result_payload of this CatalogItemSummary.

        :param catalog_result_payload: The catalog_result_payload of this CatalogItemSummary.
        :type: oci.fleet_apps_management.models.CatalogResultPayload
        """
        self._catalog_result_payload = catalog_result_payload

    @property
    def listing_id(self):
        """
        **[Required]** Gets the listing_id of this CatalogItemSummary.
        The catalog listing Id.


        :return: The listing_id of this CatalogItemSummary.
        :rtype: str
        """
        return self._listing_id

    @listing_id.setter
    def listing_id(self, listing_id):
        """
        Sets the listing_id of this CatalogItemSummary.
        The catalog listing Id.


        :param listing_id: The listing_id of this CatalogItemSummary.
        :type: str
        """
        self._listing_id = listing_id

    @property
    def listing_version(self):
        """
        **[Required]** Gets the listing_version of this CatalogItemSummary.
        The catalog package version.


        :return: The listing_version of this CatalogItemSummary.
        :rtype: str
        """
        return self._listing_version

    @listing_version.setter
    def listing_version(self, listing_version):
        """
        Sets the listing_version of this CatalogItemSummary.
        The catalog package version.


        :param listing_version: The listing_version of this CatalogItemSummary.
        :type: str
        """
        self._listing_version = listing_version

    @property
    def display_name(self):
        """
        **[Required]** Gets the display_name of this CatalogItemSummary.
        A user-friendly name. Does not have to be unique, and it's changeable. Avoid entering confidential information.


        :return: The display_name of this CatalogItemSummary.
        :rtype: str
        """
        return self._display_name

    @display_name.setter
    def display_name(self, display_name):
        """
        Sets the display_name of this CatalogItemSummary.
        A user-friendly name. Does not have to be unique, and it's changeable. Avoid entering confidential information.


        :param display_name: The display_name of this CatalogItemSummary.
        :type: str
        """
        self._display_name = display_name

    @property
    def package_type(self):
        """
        **[Required]** Gets the package_type of this CatalogItemSummary.
        Config package type Eg: BASE_PACKAGE, EXTENSION_PACKAGE.


        :return: The package_type of this CatalogItemSummary.
        :rtype: str
        """
        return self._package_type

    @package_type.setter
    def package_type(self, package_type):
        """
        Sets the package_type of this CatalogItemSummary.
        Config package type Eg: BASE_PACKAGE, EXTENSION_PACKAGE.


        :param package_type: The package_type of this CatalogItemSummary.
        :type: str
        """
        self._package_type = package_type

    @property
    def lifecycle_state(self):
        """
        **[Required]** Gets the lifecycle_state of this CatalogItemSummary.
        The current state of the CatalogItem.


        :return: The lifecycle_state of this CatalogItemSummary.
        :rtype: str
        """
        return self._lifecycle_state

    @lifecycle_state.setter
    def lifecycle_state(self, lifecycle_state):
        """
        Sets the lifecycle_state of this CatalogItemSummary.
        The current state of the CatalogItem.


        :param lifecycle_state: The lifecycle_state of this CatalogItemSummary.
        :type: str
        """
        self._lifecycle_state = lifecycle_state

    @property
    def lifecycle_details(self):
        """
        **[Required]** Gets the lifecycle_details of this CatalogItemSummary.
        The details of lifecycle state CatalogItem.


        :return: The lifecycle_details of this CatalogItemSummary.
        :rtype: str
        """
        return self._lifecycle_details

    @lifecycle_details.setter
    def lifecycle_details(self, lifecycle_details):
        """
        Sets the lifecycle_details of this CatalogItemSummary.
        The details of lifecycle state CatalogItem.


        :param lifecycle_details: The lifecycle_details of this CatalogItemSummary.
        :type: str
        """
        self._lifecycle_details = lifecycle_details

    @property
    def time_created(self):
        """
        **[Required]** Gets the time_created of this CatalogItemSummary.
        The date and time the CatalogItem was created, in the format defined by
        `RFC 3339`__.
        Example: `2016-08-25T21:10:29.600Z`

        __ https://tools.ietf.org/html/rfc3339


        :return: The time_created of this CatalogItemSummary.
        :rtype: datetime
        """
        return self._time_created

    @time_created.setter
    def time_created(self, time_created):
        """
        Sets the time_created of this CatalogItemSummary.
        The date and time the CatalogItem was created, in the format defined by
        `RFC 3339`__.
        Example: `2016-08-25T21:10:29.600Z`

        __ https://tools.ietf.org/html/rfc3339


        :param time_created: The time_created of this CatalogItemSummary.
        :type: datetime
        """
        self._time_created = time_created

    @property
    def time_updated(self):
        """
        **[Required]** Gets the time_updated of this CatalogItemSummary.
        The date and time the CatalogItem was updated, in the format defined by
        `RFC 3339`__.
        Example: `2016-08-25T21:10:29.600Z`

        __ https://tools.ietf.org/html/rfc3339


        :return: The time_updated of this CatalogItemSummary.
        :rtype: datetime
        """
        return self._time_updated

    @time_updated.setter
    def time_updated(self, time_updated):
        """
        Sets the time_updated of this CatalogItemSummary.
        The date and time the CatalogItem was updated, in the format defined by
        `RFC 3339`__.
        Example: `2016-08-25T21:10:29.600Z`

        __ https://tools.ietf.org/html/rfc3339


        :param time_updated: The time_updated of this CatalogItemSummary.
        :type: datetime
        """
        self._time_updated = time_updated

    @property
    def version_description(self):
        """
        **[Required]** Gets the version_description of this CatalogItemSummary.
        Version description about the catalog item.


        :return: The version_description of this CatalogItemSummary.
        :rtype: str
        """
        return self._version_description

    @version_description.setter
    def version_description(self, version_description):
        """
        Sets the version_description of this CatalogItemSummary.
        Version description about the catalog item.


        :param version_description: The version_description of this CatalogItemSummary.
        :type: str
        """
        self._version_description = version_description

    @property
    def short_description(self):
        """
        **[Required]** Gets the short_description of this CatalogItemSummary.
        Short description about the catalog item.


        :return: The short_description of this CatalogItemSummary.
        :rtype: str
        """
        return self._short_description

    @short_description.setter
    def short_description(self, short_description):
        """
        Sets the short_description of this CatalogItemSummary.
        Short description about the catalog item.


        :param short_description: The short_description of this CatalogItemSummary.
        :type: str
        """
        self._short_description = short_description

    @property
    def time_released(self):
        """
        **[Required]** Gets the time_released of this CatalogItemSummary.
        The date and time the CatalogItem was released, in the format defined by
        `RFC 3339`__.
        Example: `2016-08-25T21:10:29.600Z`

        __ https://tools.ietf.org/html/rfc3339


        :return: The time_released of this CatalogItemSummary.
        :rtype: datetime
        """
        return self._time_released

    @time_released.setter
    def time_released(self, time_released):
        """
        Sets the time_released of this CatalogItemSummary.
        The date and time the CatalogItem was released, in the format defined by
        `RFC 3339`__.
        Example: `2016-08-25T21:10:29.600Z`

        __ https://tools.ietf.org/html/rfc3339


        :param time_released: The time_released of this CatalogItemSummary.
        :type: datetime
        """
        self._time_released = time_released

    @property
    def is_item_locked(self):
        """
        Gets the is_item_locked of this CatalogItemSummary.
        Indicates if the CatalogItem is immutable or not.


        :return: The is_item_locked of this CatalogItemSummary.
        :rtype: bool
        """
        return self._is_item_locked

    @is_item_locked.setter
    def is_item_locked(self, is_item_locked):
        """
        Sets the is_item_locked of this CatalogItemSummary.
        Indicates if the CatalogItem is immutable or not.


        :param is_item_locked: The is_item_locked of this CatalogItemSummary.
        :type: bool
        """
        self._is_item_locked = is_item_locked

    @property
    def freeform_tags(self):
        """
        Gets the freeform_tags of this CatalogItemSummary.
        Simple key-value pair that is applied without any predefined name, type or scope. Exists for cross-compatibility only.
        Example: `{\"bar-key\": \"value\"}`


        :return: The freeform_tags of this CatalogItemSummary.
        :rtype: dict(str, str)
        """
        return self._freeform_tags

    @freeform_tags.setter
    def freeform_tags(self, freeform_tags):
        """
        Sets the freeform_tags of this CatalogItemSummary.
        Simple key-value pair that is applied without any predefined name, type or scope. Exists for cross-compatibility only.
        Example: `{\"bar-key\": \"value\"}`


        :param freeform_tags: The freeform_tags of this CatalogItemSummary.
        :type: dict(str, str)
        """
        self._freeform_tags = freeform_tags

    @property
    def defined_tags(self):
        """
        Gets the defined_tags of this CatalogItemSummary.
        Defined tags for this resource. Each key is predefined and scoped to a namespace.
        Example: `{\"foo-namespace\": {\"bar-key\": \"value\"}}`


        :return: The defined_tags of this CatalogItemSummary.
        :rtype: dict(str, dict(str, object))
        """
        return self._defined_tags

    @defined_tags.setter
    def defined_tags(self, defined_tags):
        """
        Sets the defined_tags of this CatalogItemSummary.
        Defined tags for this resource. Each key is predefined and scoped to a namespace.
        Example: `{\"foo-namespace\": {\"bar-key\": \"value\"}}`


        :param defined_tags: The defined_tags of this CatalogItemSummary.
        :type: dict(str, dict(str, object))
        """
        self._defined_tags = defined_tags

    @property
    def system_tags(self):
        """
        Gets the system_tags of this CatalogItemSummary.
        System tags for this resource. Each key is predefined and scoped to a namespace.
        Example: `{\"orcl-cloud\": {\"free-tier-retained\": \"true\"}}`


        :return: The system_tags of this CatalogItemSummary.
        :rtype: dict(str, dict(str, object))
        """
        return self._system_tags

    @system_tags.setter
    def system_tags(self, system_tags):
        """
        Sets the system_tags of this CatalogItemSummary.
        System tags for this resource. Each key is predefined and scoped to a namespace.
        Example: `{\"orcl-cloud\": {\"free-tier-retained\": \"true\"}}`


        :param system_tags: The system_tags of this CatalogItemSummary.
        :type: dict(str, dict(str, object))
        """
        self._system_tags = system_tags

    def __repr__(self):
        return formatted_flat_dict(self)

    def __eq__(self, other):
        if other is None:
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not self == other
