# coding: utf-8
# Copyright (c) 2016, 2026, Oracle and/or its affiliates.  All rights reserved.
# This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.

# NOTE: This class is auto generated by OracleSDKGenerator. DO NOT EDIT. API Version: 20250228


from oci.util import formatted_flat_dict, NONE_SENTINEL, value_allowed_none_or_none_sentinel  # noqa: F401
from oci.decorators import init_model_state_from_kwargs


@init_model_state_from_kwargs
class ComplianceRecord(object):
    """
    The compliance status reports.
    """

    #: A constant which can be used with the compliance_state property of a ComplianceRecord.
    #: This constant has a value of "UNKNOWN"
    COMPLIANCE_STATE_UNKNOWN = "UNKNOWN"

    #: A constant which can be used with the compliance_state property of a ComplianceRecord.
    #: This constant has a value of "COMPLIANT"
    COMPLIANCE_STATE_COMPLIANT = "COMPLIANT"

    #: A constant which can be used with the compliance_state property of a ComplianceRecord.
    #: This constant has a value of "NON_COMPLIANT"
    COMPLIANCE_STATE_NON_COMPLIANT = "NON_COMPLIANT"

    #: A constant which can be used with the compliance_state property of a ComplianceRecord.
    #: This constant has a value of "WARNING"
    COMPLIANCE_STATE_WARNING = "WARNING"

    #: A constant which can be used with the lifecycle_state property of a ComplianceRecord.
    #: This constant has a value of "ACTIVE"
    LIFECYCLE_STATE_ACTIVE = "ACTIVE"

    #: A constant which can be used with the lifecycle_state property of a ComplianceRecord.
    #: This constant has a value of "DELETED"
    LIFECYCLE_STATE_DELETED = "DELETED"

    #: A constant which can be used with the lifecycle_state property of a ComplianceRecord.
    #: This constant has a value of "FAILED"
    LIFECYCLE_STATE_FAILED = "FAILED"

    def __init__(self, **kwargs):
        """
        Initializes a new ComplianceRecord object with values from keyword arguments.
        The following keyword arguments are supported (corresponding to the getters/setters of this class):

        :param id:
            The value to assign to the id property of this ComplianceRecord.
        :type id: str

        :param entity_id:
            The value to assign to the entity_id property of this ComplianceRecord.
        :type entity_id: str

        :param entity_display_name:
            The value to assign to the entity_display_name property of this ComplianceRecord.
        :type entity_display_name: str

        :param compartment_id:
            The value to assign to the compartment_id property of this ComplianceRecord.
        :type compartment_id: str

        :param policy:
            The value to assign to the policy property of this ComplianceRecord.
        :type policy: oci.fleet_apps_management.models.ComplianceDetailPolicy

        :param resource:
            The value to assign to the resource property of this ComplianceRecord.
        :type resource: oci.fleet_apps_management.models.ComplianceDetailResource

        :param target:
            The value to assign to the target property of this ComplianceRecord.
        :type target: oci.fleet_apps_management.models.ComplianceDetailTarget

        :param patch:
            The value to assign to the patch property of this ComplianceRecord.
        :type patch: oci.fleet_apps_management.models.CompliancePatchDetail

        :param compliance_state:
            The value to assign to the compliance_state property of this ComplianceRecord.
            Allowed values for this property are: "UNKNOWN", "COMPLIANT", "NON_COMPLIANT", "WARNING", 'UNKNOWN_ENUM_VALUE'.
            Any unrecognized values returned by a service will be mapped to 'UNKNOWN_ENUM_VALUE'.
        :type compliance_state: str

        :param time_created:
            The value to assign to the time_created property of this ComplianceRecord.
        :type time_created: datetime

        :param time_updated:
            The value to assign to the time_updated property of this ComplianceRecord.
        :type time_updated: datetime

        :param lifecycle_state:
            The value to assign to the lifecycle_state property of this ComplianceRecord.
            Allowed values for this property are: "ACTIVE", "DELETED", "FAILED", 'UNKNOWN_ENUM_VALUE'.
            Any unrecognized values returned by a service will be mapped to 'UNKNOWN_ENUM_VALUE'.
        :type lifecycle_state: str

        :param freeform_tags:
            The value to assign to the freeform_tags property of this ComplianceRecord.
        :type freeform_tags: dict(str, str)

        :param defined_tags:
            The value to assign to the defined_tags property of this ComplianceRecord.
        :type defined_tags: dict(str, dict(str, object))

        :param system_tags:
            The value to assign to the system_tags property of this ComplianceRecord.
        :type system_tags: dict(str, dict(str, object))

        """
        self.swagger_types = {
            'id': 'str',
            'entity_id': 'str',
            'entity_display_name': 'str',
            'compartment_id': 'str',
            'policy': 'ComplianceDetailPolicy',
            'resource': 'ComplianceDetailResource',
            'target': 'ComplianceDetailTarget',
            'patch': 'CompliancePatchDetail',
            'compliance_state': 'str',
            'time_created': 'datetime',
            'time_updated': 'datetime',
            'lifecycle_state': 'str',
            'freeform_tags': 'dict(str, str)',
            'defined_tags': 'dict(str, dict(str, object))',
            'system_tags': 'dict(str, dict(str, object))'
        }
        self.attribute_map = {
            'id': 'id',
            'entity_id': 'entityId',
            'entity_display_name': 'entityDisplayName',
            'compartment_id': 'compartmentId',
            'policy': 'policy',
            'resource': 'resource',
            'target': 'target',
            'patch': 'patch',
            'compliance_state': 'complianceState',
            'time_created': 'timeCreated',
            'time_updated': 'timeUpdated',
            'lifecycle_state': 'lifecycleState',
            'freeform_tags': 'freeformTags',
            'defined_tags': 'definedTags',
            'system_tags': 'systemTags'
        }
        self._id = None
        self._entity_id = None
        self._entity_display_name = None
        self._compartment_id = None
        self._policy = None
        self._resource = None
        self._target = None
        self._patch = None
        self._compliance_state = None
        self._time_created = None
        self._time_updated = None
        self._lifecycle_state = None
        self._freeform_tags = None
        self._defined_tags = None
        self._system_tags = None

    @property
    def id(self):
        """
        **[Required]** Gets the id of this ComplianceRecord.
        The OCID of the ComplianceRecord.


        :return: The id of this ComplianceRecord.
        :rtype: str
        """
        return self._id

    @id.setter
    def id(self, id):
        """
        Sets the id of this ComplianceRecord.
        The OCID of the ComplianceRecord.


        :param id: The id of this ComplianceRecord.
        :type: str
        """
        self._id = id

    @property
    def entity_id(self):
        """
        **[Required]** Gets the entity_id of this ComplianceRecord.
        The OCID of the entity for which the compliance is calculated.Ex.FleetId


        :return: The entity_id of this ComplianceRecord.
        :rtype: str
        """
        return self._entity_id

    @entity_id.setter
    def entity_id(self, entity_id):
        """
        Sets the entity_id of this ComplianceRecord.
        The OCID of the entity for which the compliance is calculated.Ex.FleetId


        :param entity_id: The entity_id of this ComplianceRecord.
        :type: str
        """
        self._entity_id = entity_id

    @property
    def entity_display_name(self):
        """
        **[Required]** Gets the entity_display_name of this ComplianceRecord.
        The displayName of the entity for which the compliance is calculated.Ex.DisplayName for the Fleet


        :return: The entity_display_name of this ComplianceRecord.
        :rtype: str
        """
        return self._entity_display_name

    @entity_display_name.setter
    def entity_display_name(self, entity_display_name):
        """
        Sets the entity_display_name of this ComplianceRecord.
        The displayName of the entity for which the compliance is calculated.Ex.DisplayName for the Fleet


        :param entity_display_name: The entity_display_name of this ComplianceRecord.
        :type: str
        """
        self._entity_display_name = entity_display_name

    @property
    def compartment_id(self):
        """
        Gets the compartment_id of this ComplianceRecord.
        The OCID of the compartment.


        :return: The compartment_id of this ComplianceRecord.
        :rtype: str
        """
        return self._compartment_id

    @compartment_id.setter
    def compartment_id(self, compartment_id):
        """
        Sets the compartment_id of this ComplianceRecord.
        The OCID of the compartment.


        :param compartment_id: The compartment_id of this ComplianceRecord.
        :type: str
        """
        self._compartment_id = compartment_id

    @property
    def policy(self):
        """
        Gets the policy of this ComplianceRecord.

        :return: The policy of this ComplianceRecord.
        :rtype: oci.fleet_apps_management.models.ComplianceDetailPolicy
        """
        return self._policy

    @policy.setter
    def policy(self, policy):
        """
        Sets the policy of this ComplianceRecord.

        :param policy: The policy of this ComplianceRecord.
        :type: oci.fleet_apps_management.models.ComplianceDetailPolicy
        """
        self._policy = policy

    @property
    def resource(self):
        """
        **[Required]** Gets the resource of this ComplianceRecord.

        :return: The resource of this ComplianceRecord.
        :rtype: oci.fleet_apps_management.models.ComplianceDetailResource
        """
        return self._resource

    @resource.setter
    def resource(self, resource):
        """
        Sets the resource of this ComplianceRecord.

        :param resource: The resource of this ComplianceRecord.
        :type: oci.fleet_apps_management.models.ComplianceDetailResource
        """
        self._resource = resource

    @property
    def target(self):
        """
        **[Required]** Gets the target of this ComplianceRecord.

        :return: The target of this ComplianceRecord.
        :rtype: oci.fleet_apps_management.models.ComplianceDetailTarget
        """
        return self._target

    @target.setter
    def target(self, target):
        """
        Sets the target of this ComplianceRecord.

        :param target: The target of this ComplianceRecord.
        :type: oci.fleet_apps_management.models.ComplianceDetailTarget
        """
        self._target = target

    @property
    def patch(self):
        """
        Gets the patch of this ComplianceRecord.

        :return: The patch of this ComplianceRecord.
        :rtype: oci.fleet_apps_management.models.CompliancePatchDetail
        """
        return self._patch

    @patch.setter
    def patch(self, patch):
        """
        Sets the patch of this ComplianceRecord.

        :param patch: The patch of this ComplianceRecord.
        :type: oci.fleet_apps_management.models.CompliancePatchDetail
        """
        self._patch = patch

    @property
    def compliance_state(self):
        """
        Gets the compliance_state of this ComplianceRecord.
        Last known compliance state of target.

        Allowed values for this property are: "UNKNOWN", "COMPLIANT", "NON_COMPLIANT", "WARNING", 'UNKNOWN_ENUM_VALUE'.
        Any unrecognized values returned by a service will be mapped to 'UNKNOWN_ENUM_VALUE'.


        :return: The compliance_state of this ComplianceRecord.
        :rtype: str
        """
        return self._compliance_state

    @compliance_state.setter
    def compliance_state(self, compliance_state):
        """
        Sets the compliance_state of this ComplianceRecord.
        Last known compliance state of target.


        :param compliance_state: The compliance_state of this ComplianceRecord.
        :type: str
        """
        allowed_values = ["UNKNOWN", "COMPLIANT", "NON_COMPLIANT", "WARNING"]
        if not value_allowed_none_or_none_sentinel(compliance_state, allowed_values):
            compliance_state = 'UNKNOWN_ENUM_VALUE'
        self._compliance_state = compliance_state

    @property
    def time_created(self):
        """
        Gets the time_created of this ComplianceRecord.
        The date and time the ComplianceRecord was created, in the format defined by `RFC 3339`__.

        Example: `2016-08-25T21:10:29.600Z`

        __ https://tools.ietf.org/html/rfc3339


        :return: The time_created of this ComplianceRecord.
        :rtype: datetime
        """
        return self._time_created

    @time_created.setter
    def time_created(self, time_created):
        """
        Sets the time_created of this ComplianceRecord.
        The date and time the ComplianceRecord was created, in the format defined by `RFC 3339`__.

        Example: `2016-08-25T21:10:29.600Z`

        __ https://tools.ietf.org/html/rfc3339


        :param time_created: The time_created of this ComplianceRecord.
        :type: datetime
        """
        self._time_created = time_created

    @property
    def time_updated(self):
        """
        Gets the time_updated of this ComplianceRecord.
        The date and time the ComplianceRecord was updated, in the format defined by `RFC 3339`__.

        Example: `2016-08-25T21:10:29.600Z`

        __ https://tools.ietf.org/html/rfc3339


        :return: The time_updated of this ComplianceRecord.
        :rtype: datetime
        """
        return self._time_updated

    @time_updated.setter
    def time_updated(self, time_updated):
        """
        Sets the time_updated of this ComplianceRecord.
        The date and time the ComplianceRecord was updated, in the format defined by `RFC 3339`__.

        Example: `2016-08-25T21:10:29.600Z`

        __ https://tools.ietf.org/html/rfc3339


        :param time_updated: The time_updated of this ComplianceRecord.
        :type: datetime
        """
        self._time_updated = time_updated

    @property
    def lifecycle_state(self):
        """
        Gets the lifecycle_state of this ComplianceRecord.
        The current state of the ComplianceRecord.

        Allowed values for this property are: "ACTIVE", "DELETED", "FAILED", 'UNKNOWN_ENUM_VALUE'.
        Any unrecognized values returned by a service will be mapped to 'UNKNOWN_ENUM_VALUE'.


        :return: The lifecycle_state of this ComplianceRecord.
        :rtype: str
        """
        return self._lifecycle_state

    @lifecycle_state.setter
    def lifecycle_state(self, lifecycle_state):
        """
        Sets the lifecycle_state of this ComplianceRecord.
        The current state of the ComplianceRecord.


        :param lifecycle_state: The lifecycle_state of this ComplianceRecord.
        :type: str
        """
        allowed_values = ["ACTIVE", "DELETED", "FAILED"]
        if not value_allowed_none_or_none_sentinel(lifecycle_state, allowed_values):
            lifecycle_state = 'UNKNOWN_ENUM_VALUE'
        self._lifecycle_state = lifecycle_state

    @property
    def freeform_tags(self):
        """
        Gets the freeform_tags of this ComplianceRecord.
        Simple key-value pair that is applied without any predefined name, type or scope. Exists for cross-compatibility only.
        Example: `{\"bar-key\": \"value\"}`


        :return: The freeform_tags of this ComplianceRecord.
        :rtype: dict(str, str)
        """
        return self._freeform_tags

    @freeform_tags.setter
    def freeform_tags(self, freeform_tags):
        """
        Sets the freeform_tags of this ComplianceRecord.
        Simple key-value pair that is applied without any predefined name, type or scope. Exists for cross-compatibility only.
        Example: `{\"bar-key\": \"value\"}`


        :param freeform_tags: The freeform_tags of this ComplianceRecord.
        :type: dict(str, str)
        """
        self._freeform_tags = freeform_tags

    @property
    def defined_tags(self):
        """
        Gets the defined_tags of this ComplianceRecord.
        Defined tags for this resource. Each key is predefined and scoped to a namespace.
        Example: `{\"foo-namespace\": {\"bar-key\": \"value\"}}`


        :return: The defined_tags of this ComplianceRecord.
        :rtype: dict(str, dict(str, object))
        """
        return self._defined_tags

    @defined_tags.setter
    def defined_tags(self, defined_tags):
        """
        Sets the defined_tags of this ComplianceRecord.
        Defined tags for this resource. Each key is predefined and scoped to a namespace.
        Example: `{\"foo-namespace\": {\"bar-key\": \"value\"}}`


        :param defined_tags: The defined_tags of this ComplianceRecord.
        :type: dict(str, dict(str, object))
        """
        self._defined_tags = defined_tags

    @property
    def system_tags(self):
        """
        Gets the system_tags of this ComplianceRecord.
        System tags for this resource. Each key is predefined and scoped to a namespace.
        Example: `{\"orcl-cloud\": {\"free-tier-retained\": \"true\"}}`


        :return: The system_tags of this ComplianceRecord.
        :rtype: dict(str, dict(str, object))
        """
        return self._system_tags

    @system_tags.setter
    def system_tags(self, system_tags):
        """
        Sets the system_tags of this ComplianceRecord.
        System tags for this resource. Each key is predefined and scoped to a namespace.
        Example: `{\"orcl-cloud\": {\"free-tier-retained\": \"true\"}}`


        :param system_tags: The system_tags of this ComplianceRecord.
        :type: dict(str, dict(str, object))
        """
        self._system_tags = system_tags

    def __repr__(self):
        return formatted_flat_dict(self)

    def __eq__(self, other):
        if other is None:
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not self == other
