# coding: utf-8
# Copyright (c) 2016, 2026, Oracle and/or its affiliates.  All rights reserved.
# This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.

# NOTE: This class is auto generated by OracleSDKGenerator. DO NOT EDIT. API Version: 20250228


from oci.util import formatted_flat_dict, NONE_SENTINEL, value_allowed_none_or_none_sentinel  # noqa: F401
from oci.decorators import init_model_state_from_kwargs


@init_model_state_from_kwargs
class ExportRunbookDetails(object):
    """
    Request to Export Runbook.
    """

    #: A constant which can be used with the export_as property of a ExportRunbookDetails.
    #: This constant has a value of "TERRAFORM"
    EXPORT_AS_TERRAFORM = "TERRAFORM"

    #: A constant which can be used with the export_as property of a ExportRunbookDetails.
    #: This constant has a value of "NON_TERRAFORM"
    EXPORT_AS_NON_TERRAFORM = "NON_TERRAFORM"

    def __init__(self, **kwargs):
        """
        Initializes a new ExportRunbookDetails object with values from keyword arguments.
        The following keyword arguments are supported (corresponding to the getters/setters of this class):

        :param content_destination:
            The value to assign to the content_destination property of this ExportRunbookDetails.
        :type content_destination: oci.fleet_apps_management.models.TransferRunbookContentDetails

        :param export_as:
            The value to assign to the export_as property of this ExportRunbookDetails.
            Allowed values for this property are: "TERRAFORM", "NON_TERRAFORM"
        :type export_as: str

        """
        self.swagger_types = {
            'content_destination': 'TransferRunbookContentDetails',
            'export_as': 'str'
        }
        self.attribute_map = {
            'content_destination': 'contentDestination',
            'export_as': 'exportAs'
        }
        self._content_destination = None
        self._export_as = None

    @property
    def content_destination(self):
        """
        **[Required]** Gets the content_destination of this ExportRunbookDetails.

        :return: The content_destination of this ExportRunbookDetails.
        :rtype: oci.fleet_apps_management.models.TransferRunbookContentDetails
        """
        return self._content_destination

    @content_destination.setter
    def content_destination(self, content_destination):
        """
        Sets the content_destination of this ExportRunbookDetails.

        :param content_destination: The content_destination of this ExportRunbookDetails.
        :type: oci.fleet_apps_management.models.TransferRunbookContentDetails
        """
        self._content_destination = content_destination

    @property
    def export_as(self):
        """
        Gets the export_as of this ExportRunbookDetails.
        Export Runbook As Type.

        Allowed values for this property are: "TERRAFORM", "NON_TERRAFORM"


        :return: The export_as of this ExportRunbookDetails.
        :rtype: str
        """
        return self._export_as

    @export_as.setter
    def export_as(self, export_as):
        """
        Sets the export_as of this ExportRunbookDetails.
        Export Runbook As Type.


        :param export_as: The export_as of this ExportRunbookDetails.
        :type: str
        """
        allowed_values = ["TERRAFORM", "NON_TERRAFORM"]
        if not value_allowed_none_or_none_sentinel(export_as, allowed_values):
            raise ValueError(
                f"Invalid value for `export_as`, must be None or one of {allowed_values}"
            )
        self._export_as = export_as

    def __repr__(self):
        return formatted_flat_dict(self)

    def __eq__(self, other):
        if other is None:
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not self == other
