# coding: utf-8
# Copyright (c) 2016, 2026, Oracle and/or its affiliates.  All rights reserved.
# This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.

# NOTE: This class is auto generated by OracleSDKGenerator. DO NOT EDIT. API Version: 20250228


from oci.util import formatted_flat_dict, NONE_SENTINEL, value_allowed_none_or_none_sentinel  # noqa: F401
from oci.decorators import init_model_state_from_kwargs


@init_model_state_from_kwargs
class InstanceShapeVariableDependsOn(object):
    """
    Depends on object.
    """

    def __init__(self, **kwargs):
        """
        Initializes a new InstanceShapeVariableDependsOn object with values from keyword arguments.
        The following keyword arguments are supported (corresponding to the getters/setters of this class):

        :param image_id:
            The value to assign to the image_id property of this InstanceShapeVariableDependsOn.
        :type image_id: str

        :param compartment_id:
            The value to assign to the compartment_id property of this InstanceShapeVariableDependsOn.
        :type compartment_id: str

        :param availability_domain:
            The value to assign to the availability_domain property of this InstanceShapeVariableDependsOn.
        :type availability_domain: str

        """
        self.swagger_types = {
            'image_id': 'str',
            'compartment_id': 'str',
            'availability_domain': 'str'
        }
        self.attribute_map = {
            'image_id': 'imageId',
            'compartment_id': 'compartmentId',
            'availability_domain': 'availabilityDomain'
        }
        self._image_id = None
        self._compartment_id = None
        self._availability_domain = None

    @property
    def image_id(self):
        """
        Gets the image_id of this InstanceShapeVariableDependsOn.
        OCID of the image to use.


        :return: The image_id of this InstanceShapeVariableDependsOn.
        :rtype: str
        """
        return self._image_id

    @image_id.setter
    def image_id(self, image_id):
        """
        Sets the image_id of this InstanceShapeVariableDependsOn.
        OCID of the image to use.


        :param image_id: The image_id of this InstanceShapeVariableDependsOn.
        :type: str
        """
        self._image_id = image_id

    @property
    def compartment_id(self):
        """
        **[Required]** Gets the compartment_id of this InstanceShapeVariableDependsOn.
        OCID of the Compartment.


        :return: The compartment_id of this InstanceShapeVariableDependsOn.
        :rtype: str
        """
        return self._compartment_id

    @compartment_id.setter
    def compartment_id(self, compartment_id):
        """
        Sets the compartment_id of this InstanceShapeVariableDependsOn.
        OCID of the Compartment.


        :param compartment_id: The compartment_id of this InstanceShapeVariableDependsOn.
        :type: str
        """
        self._compartment_id = compartment_id

    @property
    def availability_domain(self):
        """
        Gets the availability_domain of this InstanceShapeVariableDependsOn.
        Name of the Availability domain.


        :return: The availability_domain of this InstanceShapeVariableDependsOn.
        :rtype: str
        """
        return self._availability_domain

    @availability_domain.setter
    def availability_domain(self, availability_domain):
        """
        Sets the availability_domain of this InstanceShapeVariableDependsOn.
        Name of the Availability domain.


        :param availability_domain: The availability_domain of this InstanceShapeVariableDependsOn.
        :type: str
        """
        self._availability_domain = availability_domain

    def __repr__(self):
        return formatted_flat_dict(self)

    def __eq__(self, other):
        if other is None:
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not self == other
