# coding: utf-8
# Copyright (c) 2016, 2026, Oracle and/or its affiliates.  All rights reserved.
# This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.

# NOTE: This class is auto generated by OracleSDKGenerator. DO NOT EDIT. API Version: 20250228


from oci.util import formatted_flat_dict, NONE_SENTINEL, value_allowed_none_or_none_sentinel  # noqa: F401
from oci.decorators import init_model_state_from_kwargs


@init_model_state_from_kwargs
class KubernetesVersionsVariableDependsOn(object):
    """
    Depends on object.
    """

    def __init__(self, **kwargs):
        """
        Initializes a new KubernetesVersionsVariableDependsOn object with values from keyword arguments.
        The following keyword arguments are supported (corresponding to the getters/setters of this class):

        :param cluster_option_id:
            The value to assign to the cluster_option_id property of this KubernetesVersionsVariableDependsOn.
        :type cluster_option_id: str

        :param compartment_id:
            The value to assign to the compartment_id property of this KubernetesVersionsVariableDependsOn.
        :type compartment_id: str

        """
        self.swagger_types = {
            'cluster_option_id': 'str',
            'compartment_id': 'str'
        }
        self.attribute_map = {
            'cluster_option_id': 'clusterOptionId',
            'compartment_id': 'compartmentId'
        }
        self._cluster_option_id = None
        self._compartment_id = None

    @property
    def cluster_option_id(self):
        """
        **[Required]** Gets the cluster_option_id of this KubernetesVersionsVariableDependsOn.
        OCID of the cluster option.


        :return: The cluster_option_id of this KubernetesVersionsVariableDependsOn.
        :rtype: str
        """
        return self._cluster_option_id

    @cluster_option_id.setter
    def cluster_option_id(self, cluster_option_id):
        """
        Sets the cluster_option_id of this KubernetesVersionsVariableDependsOn.
        OCID of the cluster option.


        :param cluster_option_id: The cluster_option_id of this KubernetesVersionsVariableDependsOn.
        :type: str
        """
        self._cluster_option_id = cluster_option_id

    @property
    def compartment_id(self):
        """
        **[Required]** Gets the compartment_id of this KubernetesVersionsVariableDependsOn.
        OCID of the compartment.


        :return: The compartment_id of this KubernetesVersionsVariableDependsOn.
        :rtype: str
        """
        return self._compartment_id

    @compartment_id.setter
    def compartment_id(self, compartment_id):
        """
        Sets the compartment_id of this KubernetesVersionsVariableDependsOn.
        OCID of the compartment.


        :param compartment_id: The compartment_id of this KubernetesVersionsVariableDependsOn.
        :type: str
        """
        self._compartment_id = compartment_id

    def __repr__(self):
        return formatted_flat_dict(self)

    def __eq__(self, other):
        if other is None:
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not self == other
