# coding: utf-8
# Copyright (c) 2016, 2026, Oracle and/or its affiliates.  All rights reserved.
# This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.

# NOTE: This class is auto generated by OracleSDKGenerator. DO NOT EDIT. API Version: 20250228


from oci.util import formatted_flat_dict, NONE_SENTINEL, value_allowed_none_or_none_sentinel  # noqa: F401
from oci.decorators import init_model_state_from_kwargs


@init_model_state_from_kwargs
class OrderClause(object):
    """
    report filters.
    """

    #: A constant which can be used with the sort_order property of a OrderClause.
    #: This constant has a value of "ASC"
    SORT_ORDER_ASC = "ASC"

    #: A constant which can be used with the sort_order property of a OrderClause.
    #: This constant has a value of "DESC"
    SORT_ORDER_DESC = "DESC"

    def __init__(self, **kwargs):
        """
        Initializes a new OrderClause object with values from keyword arguments.
        The following keyword arguments are supported (corresponding to the getters/setters of this class):

        :param sort_by:
            The value to assign to the sort_by property of this OrderClause.
        :type sort_by: str

        :param sort_order:
            The value to assign to the sort_order property of this OrderClause.
            Allowed values for this property are: "ASC", "DESC", 'UNKNOWN_ENUM_VALUE'.
            Any unrecognized values returned by a service will be mapped to 'UNKNOWN_ENUM_VALUE'.
        :type sort_order: str

        """
        self.swagger_types = {
            'sort_by': 'str',
            'sort_order': 'str'
        }
        self.attribute_map = {
            'sort_by': 'sortBy',
            'sort_order': 'sortOrder'
        }
        self._sort_by = None
        self._sort_order = None

    @property
    def sort_by(self):
        """
        **[Required]** Gets the sort_by of this OrderClause.
        Sort By.


        :return: The sort_by of this OrderClause.
        :rtype: str
        """
        return self._sort_by

    @sort_by.setter
    def sort_by(self, sort_by):
        """
        Sets the sort_by of this OrderClause.
        Sort By.


        :param sort_by: The sort_by of this OrderClause.
        :type: str
        """
        self._sort_by = sort_by

    @property
    def sort_order(self):
        """
        Gets the sort_order of this OrderClause.
        Sort Order.

        Allowed values for this property are: "ASC", "DESC", 'UNKNOWN_ENUM_VALUE'.
        Any unrecognized values returned by a service will be mapped to 'UNKNOWN_ENUM_VALUE'.


        :return: The sort_order of this OrderClause.
        :rtype: str
        """
        return self._sort_order

    @sort_order.setter
    def sort_order(self, sort_order):
        """
        Sets the sort_order of this OrderClause.
        Sort Order.


        :param sort_order: The sort_order of this OrderClause.
        :type: str
        """
        allowed_values = ["ASC", "DESC"]
        if not value_allowed_none_or_none_sentinel(sort_order, allowed_values):
            sort_order = 'UNKNOWN_ENUM_VALUE'
        self._sort_order = sort_order

    def __repr__(self):
        return formatted_flat_dict(self)

    def __eq__(self, other):
        if other is None:
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not self == other
