# coding: utf-8
# Copyright (c) 2016, 2026, Oracle and/or its affiliates.  All rights reserved.
# This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.

# NOTE: This class is auto generated by OracleSDKGenerator. DO NOT EDIT. API Version: 20250228


from oci.util import formatted_flat_dict, NONE_SENTINEL, value_allowed_none_or_none_sentinel  # noqa: F401
from oci.decorators import init_model_state_from_kwargs


@init_model_state_from_kwargs
class RunbookTransferDependencySummary(object):
    """
    Summary of the Runbook transfer dependencies.
    """

    def __init__(self, **kwargs):
        """
        Initializes a new RunbookTransferDependencySummary object with values from keyword arguments.
        The following keyword arguments are supported (corresponding to the getters/setters of this class):

        :param count:
            The value to assign to the count property of this RunbookTransferDependencySummary.
        :type count: int

        :param entity:
            The value to assign to the entity property of this RunbookTransferDependencySummary.
        :type entity: str

        :param dependency:
            The value to assign to the dependency property of this RunbookTransferDependencySummary.
        :type dependency: oci.fleet_apps_management.models.RunbookTransferDependency

        """
        self.swagger_types = {
            'count': 'int',
            'entity': 'str',
            'dependency': 'RunbookTransferDependency'
        }
        self.attribute_map = {
            'count': 'count',
            'entity': 'entity',
            'dependency': 'dependency'
        }
        self._count = None
        self._entity = None
        self._dependency = None

    @property
    def count(self):
        """
        **[Required]** Gets the count of this RunbookTransferDependencySummary.
        Count.


        :return: The count of this RunbookTransferDependencySummary.
        :rtype: int
        """
        return self._count

    @count.setter
    def count(self, count):
        """
        Sets the count of this RunbookTransferDependencySummary.
        Count.


        :param count: The count of this RunbookTransferDependencySummary.
        :type: int
        """
        self._count = count

    @property
    def entity(self):
        """
        **[Required]** Gets the entity of this RunbookTransferDependencySummary.
        Entity name.


        :return: The entity of this RunbookTransferDependencySummary.
        :rtype: str
        """
        return self._entity

    @entity.setter
    def entity(self, entity):
        """
        Sets the entity of this RunbookTransferDependencySummary.
        Entity name.


        :param entity: The entity of this RunbookTransferDependencySummary.
        :type: str
        """
        self._entity = entity

    @property
    def dependency(self):
        """
        **[Required]** Gets the dependency of this RunbookTransferDependencySummary.

        :return: The dependency of this RunbookTransferDependencySummary.
        :rtype: oci.fleet_apps_management.models.RunbookTransferDependency
        """
        return self._dependency

    @dependency.setter
    def dependency(self, dependency):
        """
        Sets the dependency of this RunbookTransferDependencySummary.

        :param dependency: The dependency of this RunbookTransferDependencySummary.
        :type: oci.fleet_apps_management.models.RunbookTransferDependency
        """
        self._dependency = dependency

    def __repr__(self):
        return formatted_flat_dict(self)

    def __eq__(self, other):
        if other is None:
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not self == other
