# coding: utf-8
# Copyright (c) 2016, 2026, Oracle and/or its affiliates.  All rights reserved.
# This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.

# NOTE: This class is auto generated by OracleSDKGenerator. DO NOT EDIT. API Version: 20250228

from .run_on_details import RunOnDetails
from oci.util import formatted_flat_dict, NONE_SENTINEL, value_allowed_none_or_none_sentinel  # noqa: F401
from oci.decorators import init_model_state_from_kwargs


@init_model_state_from_kwargs
class SelfHostedInstanceRunOnDetails(RunOnDetails):
    """
    Self Hosted Instance Run On Details.
    """

    def __init__(self, **kwargs):
        """
        Initializes a new SelfHostedInstanceRunOnDetails object with values from keyword arguments. The default value of the :py:attr:`~oci.fleet_apps_management.models.SelfHostedInstanceRunOnDetails.kind` attribute
        of this class is ``SELF_HOSTED_INSTANCES`` and it should not be changed.
        The following keyword arguments are supported (corresponding to the getters/setters of this class):

        :param kind:
            The value to assign to the kind property of this SelfHostedInstanceRunOnDetails.
            Allowed values for this property are: "SCHEDULED_INSTANCES", "SELF_HOSTED_INSTANCES", "PREVIOUS_TASK_INSTANCES", "SCHEDULE_INSTANCE_TARGETS"
        :type kind: str

        :param host:
            The value to assign to the host property of this SelfHostedInstanceRunOnDetails.
        :type host: str

        """
        self.swagger_types = {
            'kind': 'str',
            'host': 'str'
        }
        self.attribute_map = {
            'kind': 'kind',
            'host': 'host'
        }
        self._kind = None
        self._host = None
        self._kind = 'SELF_HOSTED_INSTANCES'

    @property
    def host(self):
        """
        **[Required]** Gets the host of this SelfHostedInstanceRunOnDetails.
        OCID of the self hosted instance.


        :return: The host of this SelfHostedInstanceRunOnDetails.
        :rtype: str
        """
        return self._host

    @host.setter
    def host(self, host):
        """
        Sets the host of this SelfHostedInstanceRunOnDetails.
        OCID of the self hosted instance.


        :param host: The host of this SelfHostedInstanceRunOnDetails.
        :type: str
        """
        self._host = host

    def __repr__(self):
        return formatted_flat_dict(self)

    def __eq__(self, other):
        if other is None:
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not self == other
