# coding: utf-8
# Copyright (c) 2016, 2026, Oracle and/or its affiliates.  All rights reserved.
# This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.

# NOTE: This class is auto generated by OracleSDKGenerator. DO NOT EDIT. API Version: 20220528

from .guest_os_goal_version_details import GuestOsGoalVersionDetails
from oci.util import formatted_flat_dict, NONE_SENTINEL, value_allowed_none_or_none_sentinel  # noqa: F401
from oci.decorators import init_model_state_from_kwargs


@init_model_state_from_kwargs
class OracleGuestOsGoalVersionDetails(GuestOsGoalVersionDetails):
    """
    Details of a goal Oracle released 'GI' software image.
    """

    def __init__(self, **kwargs):
        """
        Initializes a new OracleGuestOsGoalVersionDetails object with values from keyword arguments. The default value of the :py:attr:`~oci.fleet_software_update.models.OracleGuestOsGoalVersionDetails.goal_type` attribute
        of this class is ``GUEST_OS_ORACLE_IMAGE`` and it should not be changed.
        The following keyword arguments are supported (corresponding to the getters/setters of this class):

        :param goal_type:
            The value to assign to the goal_type property of this OracleGuestOsGoalVersionDetails.
            Allowed values for this property are: "GUEST_OS_ORACLE_IMAGE"
        :type goal_type: str

        :param goal_version:
            The value to assign to the goal_version property of this OracleGuestOsGoalVersionDetails.
        :type goal_version: str

        """
        self.swagger_types = {
            'goal_type': 'str',
            'goal_version': 'str'
        }
        self.attribute_map = {
            'goal_type': 'goalType',
            'goal_version': 'goalVersion'
        }
        self._goal_type = None
        self._goal_version = None
        self._goal_type = 'GUEST_OS_ORACLE_IMAGE'

    @property
    def goal_version(self):
        """
        **[Required]** Gets the goal_version of this OracleGuestOsGoalVersionDetails.
        Goal version string matching an Oracle released 'GUEST_OS' software image.


        :return: The goal_version of this OracleGuestOsGoalVersionDetails.
        :rtype: str
        """
        return self._goal_version

    @goal_version.setter
    def goal_version(self, goal_version):
        """
        Sets the goal_version of this OracleGuestOsGoalVersionDetails.
        Goal version string matching an Oracle released 'GUEST_OS' software image.


        :param goal_version: The goal_version of this OracleGuestOsGoalVersionDetails.
        :type: str
        """
        self._goal_version = goal_version

    def __repr__(self):
        return formatted_flat_dict(self)

    def __eq__(self, other):
        if other is None:
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not self == other
