# coding: utf-8
# Copyright (c) 2016, 2026, Oracle and/or its affiliates.  All rights reserved.
# This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.

# NOTE: This class is auto generated by OracleSDKGenerator. DO NOT EDIT. API Version: 20240531

from __future__ import absolute_import

from .agent import Agent
from .agent_collection import AgentCollection
from .agent_endpoint import AgentEndpoint
from .agent_endpoint_collection import AgentEndpointCollection
from .agent_endpoint_summary import AgentEndpointSummary
from .agent_summary import AgentSummary
from .agent_tool_config import AgentToolConfig
from .api_schema_inline_input_location import ApiSchemaInlineInputLocation
from .api_schema_input_location import ApiSchemaInputLocation
from .api_schema_object_storage_input_location import ApiSchemaObjectStorageInputLocation
from .basic_auth_secret import BasicAuthSecret
from .change_agent_compartment_details import ChangeAgentCompartmentDetails
from .change_agent_endpoint_compartment_details import ChangeAgentEndpointCompartmentDetails
from .change_knowledge_base_compartment_details import ChangeKnowledgeBaseCompartmentDetails
from .content_moderation_config import ContentModerationConfig
from .content_moderation_guardrail_config import ContentModerationGuardrailConfig
from .create_agent_details import CreateAgentDetails
from .create_agent_endpoint_details import CreateAgentEndpointDetails
from .create_data_ingestion_job_details import CreateDataIngestionJobDetails
from .create_data_source_details import CreateDataSourceDetails
from .create_knowledge_base_details import CreateKnowledgeBaseDetails
from .create_tool_details import CreateToolDetails
from .data_ingestion_job import DataIngestionJob
from .data_ingestion_job_collection import DataIngestionJobCollection
from .data_ingestion_job_statistics import DataIngestionJobStatistics
from .data_ingestion_job_summary import DataIngestionJobSummary
from .data_ingestion_job_type import DataIngestionJobType
from .data_source import DataSource
from .data_source_collection import DataSourceCollection
from .data_source_config import DataSourceConfig
from .data_source_summary import DataSourceSummary
from .database_connection import DatabaseConnection
from .database_function import DatabaseFunction
from .database_tool_connection import DatabaseToolConnection
from .default_index_config import DefaultIndexConfig
from .function import Function
from .function_calling_tool_config import FunctionCallingToolConfig
from .guardrail_config import GuardrailConfig
from .http_endpoint_api_key_auth_scope_config import HttpEndpointApiKeyAuthScopeConfig
from .http_endpoint_auth_config import HttpEndpointAuthConfig
from .http_endpoint_auth_scope_config import HttpEndpointAuthScopeConfig
from .http_endpoint_auth_source import HttpEndpointAuthSource
from .http_endpoint_basic_auth_scope_config import HttpEndpointBasicAuthScopeConfig
from .http_endpoint_bearer_auth_scope_config import HttpEndpointBearerAuthScopeConfig
from .http_endpoint_idcs_auth_scope_config import HttpEndpointIdcsAuthScopeConfig
from .http_endpoint_no_auth_scope_config import HttpEndpointNoAuthScopeConfig
from .http_endpoint_oci_auth_scope_config import HttpEndpointOciAuthScopeConfig
from .http_endpoint_tool_config import HttpEndpointToolConfig
from .human_input_config import HumanInputConfig
from .idcs_secret import IdcsSecret
from .index import Index
from .index_config import IndexConfig
from .index_schema import IndexSchema
from .inline_input_location import InlineInputLocation
from .input_location import InputLocation
from .knowledge_base import KnowledgeBase
from .knowledge_base_collection import KnowledgeBaseCollection
from .knowledge_base_config import KnowledgeBaseConfig
from .knowledge_base_statistics import KnowledgeBaseStatistics
from .knowledge_base_summary import KnowledgeBaseSummary
from .llm_config import LlmConfig
from .llm_customization import LlmCustomization
from .object_storage_input_location import ObjectStorageInputLocation
from .object_storage_prefix import ObjectStoragePrefix
from .object_storage_prefix_output_location import ObjectStoragePrefixOutputLocation
from .oci_database_config import OciDatabaseConfig
from .oci_object_storage_data_source_config import OciObjectStorageDataSourceConfig
from .oci_open_search_index_config import OciOpenSearchIndexConfig
from .output_config import OutputConfig
from .output_location import OutputLocation
from .personally_identifiable_information_guardrail_config import PersonallyIdentifiableInformationGuardrailConfig
from .prompt_injection_guardrail_config import PromptInjectionGuardrailConfig
from .rag_tool_config import RagToolConfig
from .secret_detail import SecretDetail
from .session_config import SessionConfig
from .sql_tool_config import SqlToolConfig
from .tool import Tool
from .tool_collection import ToolCollection
from .tool_config import ToolConfig
from .tool_summary import ToolSummary
from .update_agent_details import UpdateAgentDetails
from .update_agent_endpoint_details import UpdateAgentEndpointDetails
from .update_data_source_details import UpdateDataSourceDetails
from .update_knowledge_base_details import UpdateKnowledgeBaseDetails
from .update_tool_details import UpdateToolDetails
from .work_request import WorkRequest
from .work_request_error import WorkRequestError
from .work_request_error_collection import WorkRequestErrorCollection
from .work_request_log_entry import WorkRequestLogEntry
from .work_request_log_entry_collection import WorkRequestLogEntryCollection
from .work_request_resource import WorkRequestResource
from .work_request_summary import WorkRequestSummary
from .work_request_summary_collection import WorkRequestSummaryCollection

# Maps type names to classes for generative_ai_agent services.
generative_ai_agent_type_mapping = {
    "Agent": Agent,
    "AgentCollection": AgentCollection,
    "AgentEndpoint": AgentEndpoint,
    "AgentEndpointCollection": AgentEndpointCollection,
    "AgentEndpointSummary": AgentEndpointSummary,
    "AgentSummary": AgentSummary,
    "AgentToolConfig": AgentToolConfig,
    "ApiSchemaInlineInputLocation": ApiSchemaInlineInputLocation,
    "ApiSchemaInputLocation": ApiSchemaInputLocation,
    "ApiSchemaObjectStorageInputLocation": ApiSchemaObjectStorageInputLocation,
    "BasicAuthSecret": BasicAuthSecret,
    "ChangeAgentCompartmentDetails": ChangeAgentCompartmentDetails,
    "ChangeAgentEndpointCompartmentDetails": ChangeAgentEndpointCompartmentDetails,
    "ChangeKnowledgeBaseCompartmentDetails": ChangeKnowledgeBaseCompartmentDetails,
    "ContentModerationConfig": ContentModerationConfig,
    "ContentModerationGuardrailConfig": ContentModerationGuardrailConfig,
    "CreateAgentDetails": CreateAgentDetails,
    "CreateAgentEndpointDetails": CreateAgentEndpointDetails,
    "CreateDataIngestionJobDetails": CreateDataIngestionJobDetails,
    "CreateDataSourceDetails": CreateDataSourceDetails,
    "CreateKnowledgeBaseDetails": CreateKnowledgeBaseDetails,
    "CreateToolDetails": CreateToolDetails,
    "DataIngestionJob": DataIngestionJob,
    "DataIngestionJobCollection": DataIngestionJobCollection,
    "DataIngestionJobStatistics": DataIngestionJobStatistics,
    "DataIngestionJobSummary": DataIngestionJobSummary,
    "DataIngestionJobType": DataIngestionJobType,
    "DataSource": DataSource,
    "DataSourceCollection": DataSourceCollection,
    "DataSourceConfig": DataSourceConfig,
    "DataSourceSummary": DataSourceSummary,
    "DatabaseConnection": DatabaseConnection,
    "DatabaseFunction": DatabaseFunction,
    "DatabaseToolConnection": DatabaseToolConnection,
    "DefaultIndexConfig": DefaultIndexConfig,
    "Function": Function,
    "FunctionCallingToolConfig": FunctionCallingToolConfig,
    "GuardrailConfig": GuardrailConfig,
    "HttpEndpointApiKeyAuthScopeConfig": HttpEndpointApiKeyAuthScopeConfig,
    "HttpEndpointAuthConfig": HttpEndpointAuthConfig,
    "HttpEndpointAuthScopeConfig": HttpEndpointAuthScopeConfig,
    "HttpEndpointAuthSource": HttpEndpointAuthSource,
    "HttpEndpointBasicAuthScopeConfig": HttpEndpointBasicAuthScopeConfig,
    "HttpEndpointBearerAuthScopeConfig": HttpEndpointBearerAuthScopeConfig,
    "HttpEndpointIdcsAuthScopeConfig": HttpEndpointIdcsAuthScopeConfig,
    "HttpEndpointNoAuthScopeConfig": HttpEndpointNoAuthScopeConfig,
    "HttpEndpointOciAuthScopeConfig": HttpEndpointOciAuthScopeConfig,
    "HttpEndpointToolConfig": HttpEndpointToolConfig,
    "HumanInputConfig": HumanInputConfig,
    "IdcsSecret": IdcsSecret,
    "Index": Index,
    "IndexConfig": IndexConfig,
    "IndexSchema": IndexSchema,
    "InlineInputLocation": InlineInputLocation,
    "InputLocation": InputLocation,
    "KnowledgeBase": KnowledgeBase,
    "KnowledgeBaseCollection": KnowledgeBaseCollection,
    "KnowledgeBaseConfig": KnowledgeBaseConfig,
    "KnowledgeBaseStatistics": KnowledgeBaseStatistics,
    "KnowledgeBaseSummary": KnowledgeBaseSummary,
    "LlmConfig": LlmConfig,
    "LlmCustomization": LlmCustomization,
    "ObjectStorageInputLocation": ObjectStorageInputLocation,
    "ObjectStoragePrefix": ObjectStoragePrefix,
    "ObjectStoragePrefixOutputLocation": ObjectStoragePrefixOutputLocation,
    "OciDatabaseConfig": OciDatabaseConfig,
    "OciObjectStorageDataSourceConfig": OciObjectStorageDataSourceConfig,
    "OciOpenSearchIndexConfig": OciOpenSearchIndexConfig,
    "OutputConfig": OutputConfig,
    "OutputLocation": OutputLocation,
    "PersonallyIdentifiableInformationGuardrailConfig": PersonallyIdentifiableInformationGuardrailConfig,
    "PromptInjectionGuardrailConfig": PromptInjectionGuardrailConfig,
    "RagToolConfig": RagToolConfig,
    "SecretDetail": SecretDetail,
    "SessionConfig": SessionConfig,
    "SqlToolConfig": SqlToolConfig,
    "Tool": Tool,
    "ToolCollection": ToolCollection,
    "ToolConfig": ToolConfig,
    "ToolSummary": ToolSummary,
    "UpdateAgentDetails": UpdateAgentDetails,
    "UpdateAgentEndpointDetails": UpdateAgentEndpointDetails,
    "UpdateDataSourceDetails": UpdateDataSourceDetails,
    "UpdateKnowledgeBaseDetails": UpdateKnowledgeBaseDetails,
    "UpdateToolDetails": UpdateToolDetails,
    "WorkRequest": WorkRequest,
    "WorkRequestError": WorkRequestError,
    "WorkRequestErrorCollection": WorkRequestErrorCollection,
    "WorkRequestLogEntry": WorkRequestLogEntry,
    "WorkRequestLogEntryCollection": WorkRequestLogEntryCollection,
    "WorkRequestResource": WorkRequestResource,
    "WorkRequestSummary": WorkRequestSummary,
    "WorkRequestSummaryCollection": WorkRequestSummaryCollection
}
