# coding: utf-8
# Copyright (c) 2016, 2026, Oracle and/or its affiliates.  All rights reserved.
# This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.

# NOTE: This class is auto generated by OracleSDKGenerator. DO NOT EDIT. API Version: 20240531

from .api_schema_input_location import ApiSchemaInputLocation
from oci.util import formatted_flat_dict, NONE_SENTINEL, value_allowed_none_or_none_sentinel  # noqa: F401
from oci.decorators import init_model_state_from_kwargs


@init_model_state_from_kwargs
class ApiSchemaInlineInputLocation(ApiSchemaInputLocation):
    """
    The details of inline input of Api schema.
    """

    def __init__(self, **kwargs):
        """
        Initializes a new ApiSchemaInlineInputLocation object with values from keyword arguments. The default value of the :py:attr:`~oci.generative_ai_agent.models.ApiSchemaInlineInputLocation.api_schema_input_location_type` attribute
        of this class is ``INLINE`` and it should not be changed.
        The following keyword arguments are supported (corresponding to the getters/setters of this class):

        :param api_schema_input_location_type:
            The value to assign to the api_schema_input_location_type property of this ApiSchemaInlineInputLocation.
            Allowed values for this property are: "INLINE", "OBJECT_STORAGE_LOCATION"
        :type api_schema_input_location_type: str

        :param content:
            The value to assign to the content property of this ApiSchemaInlineInputLocation.
        :type content: str

        """
        self.swagger_types = {
            'api_schema_input_location_type': 'str',
            'content': 'str'
        }
        self.attribute_map = {
            'api_schema_input_location_type': 'apiSchemaInputLocationType',
            'content': 'content'
        }
        self._api_schema_input_location_type = None
        self._content = None
        self._api_schema_input_location_type = 'INLINE'

    @property
    def content(self):
        """
        **[Required]** Gets the content of this ApiSchemaInlineInputLocation.
        Inline content as input.


        :return: The content of this ApiSchemaInlineInputLocation.
        :rtype: str
        """
        return self._content

    @content.setter
    def content(self, content):
        """
        Sets the content of this ApiSchemaInlineInputLocation.
        Inline content as input.


        :param content: The content of this ApiSchemaInlineInputLocation.
        :type: str
        """
        self._content = content

    def __repr__(self):
        return formatted_flat_dict(self)

    def __eq__(self, other):
        if other is None:
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not self == other
