# coding: utf-8
# Copyright (c) 2016, 2026, Oracle and/or its affiliates.  All rights reserved.
# This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.

# NOTE: This class is auto generated by OracleSDKGenerator. DO NOT EDIT. API Version: 20240531


from oci.util import formatted_flat_dict, NONE_SENTINEL, value_allowed_none_or_none_sentinel  # noqa: F401
from oci.decorators import init_model_state_from_kwargs


@init_model_state_from_kwargs
class ModelDetails(object):
    """
    Model details.
    """

    def __init__(self, **kwargs):
        """
        Initializes a new ModelDetails object with values from keyword arguments.
        The following keyword arguments are supported (corresponding to the getters/setters of this class):

        :param model_name:
            The value to assign to the model_name property of this ModelDetails.
        :type model_name: str

        :param model_version:
            The value to assign to the model_version property of this ModelDetails.
        :type model_version: str

        :param model_params:
            The value to assign to the model_params property of this ModelDetails.
        :type model_params: oci.generative_ai_agent_runtime.models.ModelParams

        """
        self.swagger_types = {
            'model_name': 'str',
            'model_version': 'str',
            'model_params': 'ModelParams'
        }
        self.attribute_map = {
            'model_name': 'modelName',
            'model_version': 'modelVersion',
            'model_params': 'modelParams'
        }
        self._model_name = None
        self._model_version = None
        self._model_params = None

    @property
    def model_name(self):
        """
        Gets the model_name of this ModelDetails.
        Name of the model.


        :return: The model_name of this ModelDetails.
        :rtype: str
        """
        return self._model_name

    @model_name.setter
    def model_name(self, model_name):
        """
        Sets the model_name of this ModelDetails.
        Name of the model.


        :param model_name: The model_name of this ModelDetails.
        :type: str
        """
        self._model_name = model_name

    @property
    def model_version(self):
        """
        Gets the model_version of this ModelDetails.
        Version of the model.


        :return: The model_version of this ModelDetails.
        :rtype: str
        """
        return self._model_version

    @model_version.setter
    def model_version(self, model_version):
        """
        Sets the model_version of this ModelDetails.
        Version of the model.


        :param model_version: The model_version of this ModelDetails.
        :type: str
        """
        self._model_version = model_version

    @property
    def model_params(self):
        """
        Gets the model_params of this ModelDetails.

        :return: The model_params of this ModelDetails.
        :rtype: oci.generative_ai_agent_runtime.models.ModelParams
        """
        return self._model_params

    @model_params.setter
    def model_params(self, model_params):
        """
        Sets the model_params of this ModelDetails.

        :param model_params: The model_params of this ModelDetails.
        :type: oci.generative_ai_agent_runtime.models.ModelParams
        """
        self._model_params = model_params

    def __repr__(self):
        return formatted_flat_dict(self)

    def __eq__(self, other):
        if other is None:
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not self == other
