# coding: utf-8
# Copyright (c) 2016, 2026, Oracle and/or its affiliates.  All rights reserved.
# This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.

# NOTE: This class is auto generated by OracleSDKGenerator. DO NOT EDIT. API Version: 20231130

from .base_chat_response import BaseChatResponse
from oci.util import formatted_flat_dict, NONE_SENTINEL, value_allowed_none_or_none_sentinel  # noqa: F401
from oci.decorators import init_model_state_from_kwargs


@init_model_state_from_kwargs
class CohereChatResponseV2(BaseChatResponse):
    """
    The response to the chat conversation.
    """

    #: A constant which can be used with the finish_reason property of a CohereChatResponseV2.
    #: This constant has a value of "COMPLETE"
    FINISH_REASON_COMPLETE = "COMPLETE"

    #: A constant which can be used with the finish_reason property of a CohereChatResponseV2.
    #: This constant has a value of "STOP_SEQUENCE"
    FINISH_REASON_STOP_SEQUENCE = "STOP_SEQUENCE"

    #: A constant which can be used with the finish_reason property of a CohereChatResponseV2.
    #: This constant has a value of "MAX_TOKENS"
    FINISH_REASON_MAX_TOKENS = "MAX_TOKENS"

    #: A constant which can be used with the finish_reason property of a CohereChatResponseV2.
    #: This constant has a value of "TOOL_CALL"
    FINISH_REASON_TOOL_CALL = "TOOL_CALL"

    #: A constant which can be used with the finish_reason property of a CohereChatResponseV2.
    #: This constant has a value of "ERROR"
    FINISH_REASON_ERROR = "ERROR"

    def __init__(self, **kwargs):
        """
        Initializes a new CohereChatResponseV2 object with values from keyword arguments. The default value of the :py:attr:`~oci.generative_ai_inference.models.CohereChatResponseV2.api_format` attribute
        of this class is ``COHEREV2`` and it should not be changed.
        The following keyword arguments are supported (corresponding to the getters/setters of this class):

        :param api_format:
            The value to assign to the api_format property of this CohereChatResponseV2.
            Allowed values for this property are: "COHERE", "GENERIC", "COHEREV2", 'UNKNOWN_ENUM_VALUE'.
            Any unrecognized values returned by a service will be mapped to 'UNKNOWN_ENUM_VALUE'.
        :type api_format: str

        :param id:
            The value to assign to the id property of this CohereChatResponseV2.
        :type id: str

        :param message:
            The value to assign to the message property of this CohereChatResponseV2.
        :type message: oci.generative_ai_inference.models.CohereAssistantMessageV2

        :param finish_reason:
            The value to assign to the finish_reason property of this CohereChatResponseV2.
            Allowed values for this property are: "COMPLETE", "STOP_SEQUENCE", "MAX_TOKENS", "TOOL_CALL", "ERROR", 'UNKNOWN_ENUM_VALUE'.
            Any unrecognized values returned by a service will be mapped to 'UNKNOWN_ENUM_VALUE'.
        :type finish_reason: str

        :param log_probabilities:
            The value to assign to the log_probabilities property of this CohereChatResponseV2.
        :type log_probabilities: list[oci.generative_ai_inference.models.LogProbability]

        :param error_message:
            The value to assign to the error_message property of this CohereChatResponseV2.
        :type error_message: str

        :param usage:
            The value to assign to the usage property of this CohereChatResponseV2.
        :type usage: oci.generative_ai_inference.models.Usage

        """
        self.swagger_types = {
            'api_format': 'str',
            'id': 'str',
            'message': 'CohereAssistantMessageV2',
            'finish_reason': 'str',
            'log_probabilities': 'list[LogProbability]',
            'error_message': 'str',
            'usage': 'Usage'
        }
        self.attribute_map = {
            'api_format': 'apiFormat',
            'id': 'id',
            'message': 'message',
            'finish_reason': 'finishReason',
            'log_probabilities': 'logProbabilities',
            'error_message': 'errorMessage',
            'usage': 'usage'
        }
        self._api_format = None
        self._id = None
        self._message = None
        self._finish_reason = None
        self._log_probabilities = None
        self._error_message = None
        self._usage = None
        self._api_format = 'COHEREV2'

    @property
    def id(self):
        """
        **[Required]** Gets the id of this CohereChatResponseV2.
        Unique identifier for the generated reply


        :return: The id of this CohereChatResponseV2.
        :rtype: str
        """
        return self._id

    @id.setter
    def id(self, id):
        """
        Sets the id of this CohereChatResponseV2.
        Unique identifier for the generated reply


        :param id: The id of this CohereChatResponseV2.
        :type: str
        """
        self._id = id

    @property
    def message(self):
        """
        **[Required]** Gets the message of this CohereChatResponseV2.

        :return: The message of this CohereChatResponseV2.
        :rtype: oci.generative_ai_inference.models.CohereAssistantMessageV2
        """
        return self._message

    @message.setter
    def message(self, message):
        """
        Sets the message of this CohereChatResponseV2.

        :param message: The message of this CohereChatResponseV2.
        :type: oci.generative_ai_inference.models.CohereAssistantMessageV2
        """
        self._message = message

    @property
    def finish_reason(self):
        """
        **[Required]** Gets the finish_reason of this CohereChatResponseV2.
        Why the generation stopped.

        Allowed values for this property are: "COMPLETE", "STOP_SEQUENCE", "MAX_TOKENS", "TOOL_CALL", "ERROR", 'UNKNOWN_ENUM_VALUE'.
        Any unrecognized values returned by a service will be mapped to 'UNKNOWN_ENUM_VALUE'.


        :return: The finish_reason of this CohereChatResponseV2.
        :rtype: str
        """
        return self._finish_reason

    @finish_reason.setter
    def finish_reason(self, finish_reason):
        """
        Sets the finish_reason of this CohereChatResponseV2.
        Why the generation stopped.


        :param finish_reason: The finish_reason of this CohereChatResponseV2.
        :type: str
        """
        allowed_values = ["COMPLETE", "STOP_SEQUENCE", "MAX_TOKENS", "TOOL_CALL", "ERROR"]
        if not value_allowed_none_or_none_sentinel(finish_reason, allowed_values):
            finish_reason = 'UNKNOWN_ENUM_VALUE'
        self._finish_reason = finish_reason

    @property
    def log_probabilities(self):
        """
        Gets the log_probabilities of this CohereChatResponseV2.
        The log probabilities of the generated tokens.


        :return: The log_probabilities of this CohereChatResponseV2.
        :rtype: list[oci.generative_ai_inference.models.LogProbability]
        """
        return self._log_probabilities

    @log_probabilities.setter
    def log_probabilities(self, log_probabilities):
        """
        Sets the log_probabilities of this CohereChatResponseV2.
        The log probabilities of the generated tokens.


        :param log_probabilities: The log_probabilities of this CohereChatResponseV2.
        :type: list[oci.generative_ai_inference.models.LogProbability]
        """
        self._log_probabilities = log_probabilities

    @property
    def error_message(self):
        """
        Gets the error_message of this CohereChatResponseV2.
        If there is an error during the streaming scenario, then the `errorMessage` parameter contains details for the error.


        :return: The error_message of this CohereChatResponseV2.
        :rtype: str
        """
        return self._error_message

    @error_message.setter
    def error_message(self, error_message):
        """
        Sets the error_message of this CohereChatResponseV2.
        If there is an error during the streaming scenario, then the `errorMessage` parameter contains details for the error.


        :param error_message: The error_message of this CohereChatResponseV2.
        :type: str
        """
        self._error_message = error_message

    @property
    def usage(self):
        """
        Gets the usage of this CohereChatResponseV2.

        :return: The usage of this CohereChatResponseV2.
        :rtype: oci.generative_ai_inference.models.Usage
        """
        return self._usage

    @usage.setter
    def usage(self, usage):
        """
        Sets the usage of this CohereChatResponseV2.

        :param usage: The usage of this CohereChatResponseV2.
        :type: oci.generative_ai_inference.models.Usage
        """
        self._usage = usage

    def __repr__(self):
        return formatted_flat_dict(self)

    def __eq__(self, other):
        if other is None:
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not self == other
