# coding: utf-8
# Copyright (c) 2016, 2026, Oracle and/or its affiliates.  All rights reserved.
# This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.

# NOTE: This class is auto generated by OracleSDKGenerator. DO NOT EDIT. API Version: 20231130

from .tool_definition import ToolDefinition
from oci.util import formatted_flat_dict, NONE_SENTINEL, value_allowed_none_or_none_sentinel  # noqa: F401
from oci.decorators import init_model_state_from_kwargs


@init_model_state_from_kwargs
class FunctionDefinition(ToolDefinition):
    """
    A function the model may call.
    """

    def __init__(self, **kwargs):
        """
        Initializes a new FunctionDefinition object with values from keyword arguments. The default value of the :py:attr:`~oci.generative_ai_inference.models.FunctionDefinition.type` attribute
        of this class is ``FUNCTION`` and it should not be changed.
        The following keyword arguments are supported (corresponding to the getters/setters of this class):

        :param type:
            The value to assign to the type property of this FunctionDefinition.
            Allowed values for this property are: "FUNCTION"
        :type type: str

        :param name:
            The value to assign to the name property of this FunctionDefinition.
        :type name: str

        :param description:
            The value to assign to the description property of this FunctionDefinition.
        :type description: str

        :param parameters:
            The value to assign to the parameters property of this FunctionDefinition.
        :type parameters: object

        """
        self.swagger_types = {
            'type': 'str',
            'name': 'str',
            'description': 'str',
            'parameters': 'object'
        }
        self.attribute_map = {
            'type': 'type',
            'name': 'name',
            'description': 'description',
            'parameters': 'parameters'
        }
        self._type = None
        self._name = None
        self._description = None
        self._parameters = None
        self._type = 'FUNCTION'

    @property
    def name(self):
        """
        Gets the name of this FunctionDefinition.
        The name of the function to be called. Must be a-z, A-Z, 0-9, or contain underscores and dashes, with a maximum length of 64.


        :return: The name of this FunctionDefinition.
        :rtype: str
        """
        return self._name

    @name.setter
    def name(self, name):
        """
        Sets the name of this FunctionDefinition.
        The name of the function to be called. Must be a-z, A-Z, 0-9, or contain underscores and dashes, with a maximum length of 64.


        :param name: The name of this FunctionDefinition.
        :type: str
        """
        self._name = name

    @property
    def description(self):
        """
        Gets the description of this FunctionDefinition.
        A description of what the function does, used by the model to choose when and how to call the function.


        :return: The description of this FunctionDefinition.
        :rtype: str
        """
        return self._description

    @description.setter
    def description(self, description):
        """
        Sets the description of this FunctionDefinition.
        A description of what the function does, used by the model to choose when and how to call the function.


        :param description: The description of this FunctionDefinition.
        :type: str
        """
        self._description = description

    @property
    def parameters(self):
        """
        Gets the parameters of this FunctionDefinition.
        The parameters the functions accepts, described as a JSON Schema object. Omitting parameters defines a function with an empty parameter list.


        :return: The parameters of this FunctionDefinition.
        :rtype: object
        """
        return self._parameters

    @parameters.setter
    def parameters(self, parameters):
        """
        Sets the parameters of this FunctionDefinition.
        The parameters the functions accepts, described as a JSON Schema object. Omitting parameters defines a function with an empty parameter list.


        :param parameters: The parameters of this FunctionDefinition.
        :type: object
        """
        self._parameters = parameters

    def __repr__(self):
        return formatted_flat_dict(self)

    def __eq__(self, other):
        if other is None:
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not self == other
