# coding: utf-8
# Copyright (c) 2016, 2026, Oracle and/or its affiliates.  All rights reserved.
# This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.

# NOTE: This class is auto generated by OracleSDKGenerator. DO NOT EDIT. API Version: 20231130

from .base_chat_request import BaseChatRequest
from oci.util import formatted_flat_dict, NONE_SENTINEL, value_allowed_none_or_none_sentinel  # noqa: F401
from oci.decorators import init_model_state_from_kwargs


@init_model_state_from_kwargs
class GenericChatRequest(BaseChatRequest):
    """
    Details for the chat request.
    """

    #: A constant which can be used with the reasoning_effort property of a GenericChatRequest.
    #: This constant has a value of "NONE"
    REASONING_EFFORT_NONE = "NONE"

    #: A constant which can be used with the reasoning_effort property of a GenericChatRequest.
    #: This constant has a value of "MINIMAL"
    REASONING_EFFORT_MINIMAL = "MINIMAL"

    #: A constant which can be used with the reasoning_effort property of a GenericChatRequest.
    #: This constant has a value of "LOW"
    REASONING_EFFORT_LOW = "LOW"

    #: A constant which can be used with the reasoning_effort property of a GenericChatRequest.
    #: This constant has a value of "MEDIUM"
    REASONING_EFFORT_MEDIUM = "MEDIUM"

    #: A constant which can be used with the reasoning_effort property of a GenericChatRequest.
    #: This constant has a value of "HIGH"
    REASONING_EFFORT_HIGH = "HIGH"

    #: A constant which can be used with the verbosity property of a GenericChatRequest.
    #: This constant has a value of "LOW"
    VERBOSITY_LOW = "LOW"

    #: A constant which can be used with the verbosity property of a GenericChatRequest.
    #: This constant has a value of "MEDIUM"
    VERBOSITY_MEDIUM = "MEDIUM"

    #: A constant which can be used with the verbosity property of a GenericChatRequest.
    #: This constant has a value of "HIGH"
    VERBOSITY_HIGH = "HIGH"

    #: A constant which can be used with the service_tier property of a GenericChatRequest.
    #: This constant has a value of "AUTO"
    SERVICE_TIER_AUTO = "AUTO"

    #: A constant which can be used with the service_tier property of a GenericChatRequest.
    #: This constant has a value of "DEFAULT"
    SERVICE_TIER_DEFAULT = "DEFAULT"

    #: A constant which can be used with the service_tier property of a GenericChatRequest.
    #: This constant has a value of "PRIORITY"
    SERVICE_TIER_PRIORITY = "PRIORITY"

    def __init__(self, **kwargs):
        """
        Initializes a new GenericChatRequest object with values from keyword arguments. The default value of the :py:attr:`~oci.generative_ai_inference.models.GenericChatRequest.api_format` attribute
        of this class is ``GENERIC`` and it should not be changed.
        The following keyword arguments are supported (corresponding to the getters/setters of this class):

        :param api_format:
            The value to assign to the api_format property of this GenericChatRequest.
            Allowed values for this property are: "COHERE", "COHEREV2", "GENERIC"
        :type api_format: str

        :param messages:
            The value to assign to the messages property of this GenericChatRequest.
        :type messages: list[oci.generative_ai_inference.models.Message]

        :param reasoning_effort:
            The value to assign to the reasoning_effort property of this GenericChatRequest.
            Allowed values for this property are: "NONE", "MINIMAL", "LOW", "MEDIUM", "HIGH"
        :type reasoning_effort: str

        :param verbosity:
            The value to assign to the verbosity property of this GenericChatRequest.
            Allowed values for this property are: "LOW", "MEDIUM", "HIGH"
        :type verbosity: str

        :param metadata:
            The value to assign to the metadata property of this GenericChatRequest.
        :type metadata: object

        :param is_stream:
            The value to assign to the is_stream property of this GenericChatRequest.
        :type is_stream: bool

        :param stream_options:
            The value to assign to the stream_options property of this GenericChatRequest.
        :type stream_options: oci.generative_ai_inference.models.StreamOptions

        :param num_generations:
            The value to assign to the num_generations property of this GenericChatRequest.
        :type num_generations: int

        :param seed:
            The value to assign to the seed property of this GenericChatRequest.
        :type seed: int

        :param is_echo:
            The value to assign to the is_echo property of this GenericChatRequest.
        :type is_echo: bool

        :param top_k:
            The value to assign to the top_k property of this GenericChatRequest.
        :type top_k: int

        :param top_p:
            The value to assign to the top_p property of this GenericChatRequest.
        :type top_p: float

        :param temperature:
            The value to assign to the temperature property of this GenericChatRequest.
        :type temperature: float

        :param frequency_penalty:
            The value to assign to the frequency_penalty property of this GenericChatRequest.
        :type frequency_penalty: float

        :param presence_penalty:
            The value to assign to the presence_penalty property of this GenericChatRequest.
        :type presence_penalty: float

        :param stop:
            The value to assign to the stop property of this GenericChatRequest.
        :type stop: list[str]

        :param log_probs:
            The value to assign to the log_probs property of this GenericChatRequest.
        :type log_probs: int

        :param max_tokens:
            The value to assign to the max_tokens property of this GenericChatRequest.
        :type max_tokens: int

        :param max_completion_tokens:
            The value to assign to the max_completion_tokens property of this GenericChatRequest.
        :type max_completion_tokens: int

        :param logit_bias:
            The value to assign to the logit_bias property of this GenericChatRequest.
        :type logit_bias: object

        :param prediction:
            The value to assign to the prediction property of this GenericChatRequest.
        :type prediction: oci.generative_ai_inference.models.Prediction

        :param response_format:
            The value to assign to the response_format property of this GenericChatRequest.
        :type response_format: oci.generative_ai_inference.models.ResponseFormat

        :param tool_choice:
            The value to assign to the tool_choice property of this GenericChatRequest.
        :type tool_choice: oci.generative_ai_inference.models.ToolChoice

        :param is_parallel_tool_calls:
            The value to assign to the is_parallel_tool_calls property of this GenericChatRequest.
        :type is_parallel_tool_calls: bool

        :param tools:
            The value to assign to the tools property of this GenericChatRequest.
        :type tools: list[oci.generative_ai_inference.models.ToolDefinition]

        :param web_search_options:
            The value to assign to the web_search_options property of this GenericChatRequest.
        :type web_search_options: oci.generative_ai_inference.models.WebSearchOptions

        :param service_tier:
            The value to assign to the service_tier property of this GenericChatRequest.
            Allowed values for this property are: "AUTO", "DEFAULT", "PRIORITY"
        :type service_tier: str

        """
        self.swagger_types = {
            'api_format': 'str',
            'messages': 'list[Message]',
            'reasoning_effort': 'str',
            'verbosity': 'str',
            'metadata': 'object',
            'is_stream': 'bool',
            'stream_options': 'StreamOptions',
            'num_generations': 'int',
            'seed': 'int',
            'is_echo': 'bool',
            'top_k': 'int',
            'top_p': 'float',
            'temperature': 'float',
            'frequency_penalty': 'float',
            'presence_penalty': 'float',
            'stop': 'list[str]',
            'log_probs': 'int',
            'max_tokens': 'int',
            'max_completion_tokens': 'int',
            'logit_bias': 'object',
            'prediction': 'Prediction',
            'response_format': 'ResponseFormat',
            'tool_choice': 'ToolChoice',
            'is_parallel_tool_calls': 'bool',
            'tools': 'list[ToolDefinition]',
            'web_search_options': 'WebSearchOptions',
            'service_tier': 'str'
        }
        self.attribute_map = {
            'api_format': 'apiFormat',
            'messages': 'messages',
            'reasoning_effort': 'reasoningEffort',
            'verbosity': 'verbosity',
            'metadata': 'metadata',
            'is_stream': 'isStream',
            'stream_options': 'streamOptions',
            'num_generations': 'numGenerations',
            'seed': 'seed',
            'is_echo': 'isEcho',
            'top_k': 'topK',
            'top_p': 'topP',
            'temperature': 'temperature',
            'frequency_penalty': 'frequencyPenalty',
            'presence_penalty': 'presencePenalty',
            'stop': 'stop',
            'log_probs': 'logProbs',
            'max_tokens': 'maxTokens',
            'max_completion_tokens': 'maxCompletionTokens',
            'logit_bias': 'logitBias',
            'prediction': 'prediction',
            'response_format': 'responseFormat',
            'tool_choice': 'toolChoice',
            'is_parallel_tool_calls': 'isParallelToolCalls',
            'tools': 'tools',
            'web_search_options': 'webSearchOptions',
            'service_tier': 'serviceTier'
        }
        self._api_format = None
        self._messages = None
        self._reasoning_effort = None
        self._verbosity = None
        self._metadata = None
        self._is_stream = None
        self._stream_options = None
        self._num_generations = None
        self._seed = None
        self._is_echo = None
        self._top_k = None
        self._top_p = None
        self._temperature = None
        self._frequency_penalty = None
        self._presence_penalty = None
        self._stop = None
        self._log_probs = None
        self._max_tokens = None
        self._max_completion_tokens = None
        self._logit_bias = None
        self._prediction = None
        self._response_format = None
        self._tool_choice = None
        self._is_parallel_tool_calls = None
        self._tools = None
        self._web_search_options = None
        self._service_tier = None
        self._api_format = 'GENERIC'

    @property
    def messages(self):
        """
        Gets the messages of this GenericChatRequest.
        The series of messages in a chat request. Includes the previous messages in a conversation. Each message includes a role (`USER` or the `CHATBOT`) and content.


        :return: The messages of this GenericChatRequest.
        :rtype: list[oci.generative_ai_inference.models.Message]
        """
        return self._messages

    @messages.setter
    def messages(self, messages):
        """
        Sets the messages of this GenericChatRequest.
        The series of messages in a chat request. Includes the previous messages in a conversation. Each message includes a role (`USER` or the `CHATBOT`) and content.


        :param messages: The messages of this GenericChatRequest.
        :type: list[oci.generative_ai_inference.models.Message]
        """
        self._messages = messages

    @property
    def reasoning_effort(self):
        """
        Gets the reasoning_effort of this GenericChatRequest.
        Constrains effort on reasoning for reasoning models. Currently supported values are minimal, low, medium, and high. Reducing reasoning effort can result in faster responses and fewer tokens used on reasoning in a response.

        Allowed values for this property are: "NONE", "MINIMAL", "LOW", "MEDIUM", "HIGH"


        :return: The reasoning_effort of this GenericChatRequest.
        :rtype: str
        """
        return self._reasoning_effort

    @reasoning_effort.setter
    def reasoning_effort(self, reasoning_effort):
        """
        Sets the reasoning_effort of this GenericChatRequest.
        Constrains effort on reasoning for reasoning models. Currently supported values are minimal, low, medium, and high. Reducing reasoning effort can result in faster responses and fewer tokens used on reasoning in a response.


        :param reasoning_effort: The reasoning_effort of this GenericChatRequest.
        :type: str
        """
        allowed_values = ["NONE", "MINIMAL", "LOW", "MEDIUM", "HIGH"]
        if not value_allowed_none_or_none_sentinel(reasoning_effort, allowed_values):
            raise ValueError(
                f"Invalid value for `reasoning_effort`, must be None or one of {allowed_values}"
            )
        self._reasoning_effort = reasoning_effort

    @property
    def verbosity(self):
        """
        Gets the verbosity of this GenericChatRequest.
        Constrains the verbosity of the model's response. Lower values will result in more concise responses, while higher values will result in more verbose responses.

        Allowed values for this property are: "LOW", "MEDIUM", "HIGH"


        :return: The verbosity of this GenericChatRequest.
        :rtype: str
        """
        return self._verbosity

    @verbosity.setter
    def verbosity(self, verbosity):
        """
        Sets the verbosity of this GenericChatRequest.
        Constrains the verbosity of the model's response. Lower values will result in more concise responses, while higher values will result in more verbose responses.


        :param verbosity: The verbosity of this GenericChatRequest.
        :type: str
        """
        allowed_values = ["LOW", "MEDIUM", "HIGH"]
        if not value_allowed_none_or_none_sentinel(verbosity, allowed_values):
            raise ValueError(
                f"Invalid value for `verbosity`, must be None or one of {allowed_values}"
            )
        self._verbosity = verbosity

    @property
    def metadata(self):
        """
        Gets the metadata of this GenericChatRequest.
        Set of 16 key-value pairs that can be attached to an object. This can be useful for storing additional information about the object in a structured format, and querying for objects via API or the dashboard.

        Keys are strings with a maximum length of 64 characters. Values are strings with a maximum length of 512 characters.


        :return: The metadata of this GenericChatRequest.
        :rtype: object
        """
        return self._metadata

    @metadata.setter
    def metadata(self, metadata):
        """
        Sets the metadata of this GenericChatRequest.
        Set of 16 key-value pairs that can be attached to an object. This can be useful for storing additional information about the object in a structured format, and querying for objects via API or the dashboard.

        Keys are strings with a maximum length of 64 characters. Values are strings with a maximum length of 512 characters.


        :param metadata: The metadata of this GenericChatRequest.
        :type: object
        """
        self._metadata = metadata

    @property
    def is_stream(self):
        """
        Gets the is_stream of this GenericChatRequest.
        Whether to stream back partial progress. If set to true, as tokens become available, they are sent as data-only server-sent events.


        :return: The is_stream of this GenericChatRequest.
        :rtype: bool
        """
        return self._is_stream

    @is_stream.setter
    def is_stream(self, is_stream):
        """
        Sets the is_stream of this GenericChatRequest.
        Whether to stream back partial progress. If set to true, as tokens become available, they are sent as data-only server-sent events.


        :param is_stream: The is_stream of this GenericChatRequest.
        :type: bool
        """
        self._is_stream = is_stream

    @property
    def stream_options(self):
        """
        Gets the stream_options of this GenericChatRequest.

        :return: The stream_options of this GenericChatRequest.
        :rtype: oci.generative_ai_inference.models.StreamOptions
        """
        return self._stream_options

    @stream_options.setter
    def stream_options(self, stream_options):
        """
        Sets the stream_options of this GenericChatRequest.

        :param stream_options: The stream_options of this GenericChatRequest.
        :type: oci.generative_ai_inference.models.StreamOptions
        """
        self._stream_options = stream_options

    @property
    def num_generations(self):
        """
        Gets the num_generations of this GenericChatRequest.
        The number of of generated texts that will be returned.


        :return: The num_generations of this GenericChatRequest.
        :rtype: int
        """
        return self._num_generations

    @num_generations.setter
    def num_generations(self, num_generations):
        """
        Sets the num_generations of this GenericChatRequest.
        The number of of generated texts that will be returned.


        :param num_generations: The num_generations of this GenericChatRequest.
        :type: int
        """
        self._num_generations = num_generations

    @property
    def seed(self):
        """
        Gets the seed of this GenericChatRequest.
        If specified, the backend will make a best effort to sample tokens deterministically, so that repeated requests with the same seed and parameters yield the same result. However, determinism cannot be fully guaranteed.


        :return: The seed of this GenericChatRequest.
        :rtype: int
        """
        return self._seed

    @seed.setter
    def seed(self, seed):
        """
        Sets the seed of this GenericChatRequest.
        If specified, the backend will make a best effort to sample tokens deterministically, so that repeated requests with the same seed and parameters yield the same result. However, determinism cannot be fully guaranteed.


        :param seed: The seed of this GenericChatRequest.
        :type: int
        """
        self._seed = seed

    @property
    def is_echo(self):
        """
        Gets the is_echo of this GenericChatRequest.
        Whether to include the user prompt in the response. Applies only to non-stream results.


        :return: The is_echo of this GenericChatRequest.
        :rtype: bool
        """
        return self._is_echo

    @is_echo.setter
    def is_echo(self, is_echo):
        """
        Sets the is_echo of this GenericChatRequest.
        Whether to include the user prompt in the response. Applies only to non-stream results.


        :param is_echo: The is_echo of this GenericChatRequest.
        :type: bool
        """
        self._is_echo = is_echo

    @property
    def top_k(self):
        """
        Gets the top_k of this GenericChatRequest.
        An integer that sets up the model to use only the top k most likely tokens in the generated output. A higher k introduces more randomness into the output making the output text sound more natural. Default value is -1 which means to consider all tokens. Setting to 0 disables this method and considers all tokens.

        If also using top p, then the model considers only the top tokens whose probabilities add up to p percent and ignores the rest of the k tokens. For example, if k is 20, but the probabilities of the top 10 add up to .75, then only the top 10 tokens are chosen.


        :return: The top_k of this GenericChatRequest.
        :rtype: int
        """
        return self._top_k

    @top_k.setter
    def top_k(self, top_k):
        """
        Sets the top_k of this GenericChatRequest.
        An integer that sets up the model to use only the top k most likely tokens in the generated output. A higher k introduces more randomness into the output making the output text sound more natural. Default value is -1 which means to consider all tokens. Setting to 0 disables this method and considers all tokens.

        If also using top p, then the model considers only the top tokens whose probabilities add up to p percent and ignores the rest of the k tokens. For example, if k is 20, but the probabilities of the top 10 add up to .75, then only the top 10 tokens are chosen.


        :param top_k: The top_k of this GenericChatRequest.
        :type: int
        """
        self._top_k = top_k

    @property
    def top_p(self):
        """
        Gets the top_p of this GenericChatRequest.
        If set to a probability 0.0 < p < 1.0, it ensures that only the most likely tokens, with total probability mass of p, are considered for generation at each step.

        To eliminate tokens with low likelihood, assign p a minimum percentage for the next token's likelihood. For example, when p is set to 0.75, the model eliminates the bottom 25 percent for the next token. Set to 1 to consider all tokens and set to 0 to disable. If both k and p are enabled, p acts after k.


        :return: The top_p of this GenericChatRequest.
        :rtype: float
        """
        return self._top_p

    @top_p.setter
    def top_p(self, top_p):
        """
        Sets the top_p of this GenericChatRequest.
        If set to a probability 0.0 < p < 1.0, it ensures that only the most likely tokens, with total probability mass of p, are considered for generation at each step.

        To eliminate tokens with low likelihood, assign p a minimum percentage for the next token's likelihood. For example, when p is set to 0.75, the model eliminates the bottom 25 percent for the next token. Set to 1 to consider all tokens and set to 0 to disable. If both k and p are enabled, p acts after k.


        :param top_p: The top_p of this GenericChatRequest.
        :type: float
        """
        self._top_p = top_p

    @property
    def temperature(self):
        """
        Gets the temperature of this GenericChatRequest.
        A number that sets the randomness of the generated output. A lower temperature means a less random generations.

        Use lower numbers for tasks with a correct answer such as question answering or summarizing. High temperatures can generate hallucinations or factually incorrect information. Start with temperatures lower than 1.0 and increase the temperature for more creative outputs, as you regenerate the prompts to refine the outputs.


        :return: The temperature of this GenericChatRequest.
        :rtype: float
        """
        return self._temperature

    @temperature.setter
    def temperature(self, temperature):
        """
        Sets the temperature of this GenericChatRequest.
        A number that sets the randomness of the generated output. A lower temperature means a less random generations.

        Use lower numbers for tasks with a correct answer such as question answering or summarizing. High temperatures can generate hallucinations or factually incorrect information. Start with temperatures lower than 1.0 and increase the temperature for more creative outputs, as you regenerate the prompts to refine the outputs.


        :param temperature: The temperature of this GenericChatRequest.
        :type: float
        """
        self._temperature = temperature

    @property
    def frequency_penalty(self):
        """
        Gets the frequency_penalty of this GenericChatRequest.
        To reduce repetitiveness of generated tokens, this number penalizes new tokens based on their frequency in the generated text so far. Values > 0 encourage the model to use new tokens and values < 0 encourage the model to repeat tokens. Set to 0 to disable.


        :return: The frequency_penalty of this GenericChatRequest.
        :rtype: float
        """
        return self._frequency_penalty

    @frequency_penalty.setter
    def frequency_penalty(self, frequency_penalty):
        """
        Sets the frequency_penalty of this GenericChatRequest.
        To reduce repetitiveness of generated tokens, this number penalizes new tokens based on their frequency in the generated text so far. Values > 0 encourage the model to use new tokens and values < 0 encourage the model to repeat tokens. Set to 0 to disable.


        :param frequency_penalty: The frequency_penalty of this GenericChatRequest.
        :type: float
        """
        self._frequency_penalty = frequency_penalty

    @property
    def presence_penalty(self):
        """
        Gets the presence_penalty of this GenericChatRequest.
        To reduce repetitiveness of generated tokens, this number penalizes new tokens based on whether they've appeared in the generated text so far. Values > 0 encourage the model to use new tokens and values < 0 encourage the model to repeat tokens.

        Similar to frequency penalty, a penalty is applied to previously present tokens, except that this penalty is applied equally to all tokens that have already appeared, regardless of how many times they've appeared. Set to 0 to disable.


        :return: The presence_penalty of this GenericChatRequest.
        :rtype: float
        """
        return self._presence_penalty

    @presence_penalty.setter
    def presence_penalty(self, presence_penalty):
        """
        Sets the presence_penalty of this GenericChatRequest.
        To reduce repetitiveness of generated tokens, this number penalizes new tokens based on whether they've appeared in the generated text so far. Values > 0 encourage the model to use new tokens and values < 0 encourage the model to repeat tokens.

        Similar to frequency penalty, a penalty is applied to previously present tokens, except that this penalty is applied equally to all tokens that have already appeared, regardless of how many times they've appeared. Set to 0 to disable.


        :param presence_penalty: The presence_penalty of this GenericChatRequest.
        :type: float
        """
        self._presence_penalty = presence_penalty

    @property
    def stop(self):
        """
        Gets the stop of this GenericChatRequest.
        List of strings that stop the generation if they are generated for the response text. The returned output will not contain the stop strings.


        :return: The stop of this GenericChatRequest.
        :rtype: list[str]
        """
        return self._stop

    @stop.setter
    def stop(self, stop):
        """
        Sets the stop of this GenericChatRequest.
        List of strings that stop the generation if they are generated for the response text. The returned output will not contain the stop strings.


        :param stop: The stop of this GenericChatRequest.
        :type: list[str]
        """
        self._stop = stop

    @property
    def log_probs(self):
        """
        Gets the log_probs of this GenericChatRequest.
        Includes the logarithmic probabilities for the most likely output tokens and the chosen tokens.

        For example, if the log probability is 5, the API returns a list of the 5 most likely tokens. The API returns the log probability of the sampled token, so there might be up to logprobs+1 elements in the response.


        :return: The log_probs of this GenericChatRequest.
        :rtype: int
        """
        return self._log_probs

    @log_probs.setter
    def log_probs(self, log_probs):
        """
        Sets the log_probs of this GenericChatRequest.
        Includes the logarithmic probabilities for the most likely output tokens and the chosen tokens.

        For example, if the log probability is 5, the API returns a list of the 5 most likely tokens. The API returns the log probability of the sampled token, so there might be up to logprobs+1 elements in the response.


        :param log_probs: The log_probs of this GenericChatRequest.
        :type: int
        """
        self._log_probs = log_probs

    @property
    def max_tokens(self):
        """
        Gets the max_tokens of this GenericChatRequest.
        The maximum number of tokens that can be generated per output sequence. The token count of your prompt plus maxTokens must not exceed the model's context length. For on-demand inferencing, the response length is capped at 4,000 tokens for each run.


        :return: The max_tokens of this GenericChatRequest.
        :rtype: int
        """
        return self._max_tokens

    @max_tokens.setter
    def max_tokens(self, max_tokens):
        """
        Sets the max_tokens of this GenericChatRequest.
        The maximum number of tokens that can be generated per output sequence. The token count of your prompt plus maxTokens must not exceed the model's context length. For on-demand inferencing, the response length is capped at 4,000 tokens for each run.


        :param max_tokens: The max_tokens of this GenericChatRequest.
        :type: int
        """
        self._max_tokens = max_tokens

    @property
    def max_completion_tokens(self):
        """
        Gets the max_completion_tokens of this GenericChatRequest.
        An upper bound for the number of tokens that can be generated for a completion, including visible output tokens and reasoning tokens.


        :return: The max_completion_tokens of this GenericChatRequest.
        :rtype: int
        """
        return self._max_completion_tokens

    @max_completion_tokens.setter
    def max_completion_tokens(self, max_completion_tokens):
        """
        Sets the max_completion_tokens of this GenericChatRequest.
        An upper bound for the number of tokens that can be generated for a completion, including visible output tokens and reasoning tokens.


        :param max_completion_tokens: The max_completion_tokens of this GenericChatRequest.
        :type: int
        """
        self._max_completion_tokens = max_completion_tokens

    @property
    def logit_bias(self):
        """
        Gets the logit_bias of this GenericChatRequest.
        Modifies the likelihood of specified tokens that appear in the completion.

        Example: '{\"6395\": 2, \"8134\": 1, \"21943\": 0.5, \"5923\": -100}'


        :return: The logit_bias of this GenericChatRequest.
        :rtype: object
        """
        return self._logit_bias

    @logit_bias.setter
    def logit_bias(self, logit_bias):
        """
        Sets the logit_bias of this GenericChatRequest.
        Modifies the likelihood of specified tokens that appear in the completion.

        Example: '{\"6395\": 2, \"8134\": 1, \"21943\": 0.5, \"5923\": -100}'


        :param logit_bias: The logit_bias of this GenericChatRequest.
        :type: object
        """
        self._logit_bias = logit_bias

    @property
    def prediction(self):
        """
        Gets the prediction of this GenericChatRequest.

        :return: The prediction of this GenericChatRequest.
        :rtype: oci.generative_ai_inference.models.Prediction
        """
        return self._prediction

    @prediction.setter
    def prediction(self, prediction):
        """
        Sets the prediction of this GenericChatRequest.

        :param prediction: The prediction of this GenericChatRequest.
        :type: oci.generative_ai_inference.models.Prediction
        """
        self._prediction = prediction

    @property
    def response_format(self):
        """
        Gets the response_format of this GenericChatRequest.

        :return: The response_format of this GenericChatRequest.
        :rtype: oci.generative_ai_inference.models.ResponseFormat
        """
        return self._response_format

    @response_format.setter
    def response_format(self, response_format):
        """
        Sets the response_format of this GenericChatRequest.

        :param response_format: The response_format of this GenericChatRequest.
        :type: oci.generative_ai_inference.models.ResponseFormat
        """
        self._response_format = response_format

    @property
    def tool_choice(self):
        """
        Gets the tool_choice of this GenericChatRequest.

        :return: The tool_choice of this GenericChatRequest.
        :rtype: oci.generative_ai_inference.models.ToolChoice
        """
        return self._tool_choice

    @tool_choice.setter
    def tool_choice(self, tool_choice):
        """
        Sets the tool_choice of this GenericChatRequest.

        :param tool_choice: The tool_choice of this GenericChatRequest.
        :type: oci.generative_ai_inference.models.ToolChoice
        """
        self._tool_choice = tool_choice

    @property
    def is_parallel_tool_calls(self):
        """
        Gets the is_parallel_tool_calls of this GenericChatRequest.
        Whether to enable parallel function calling during tool use.


        :return: The is_parallel_tool_calls of this GenericChatRequest.
        :rtype: bool
        """
        return self._is_parallel_tool_calls

    @is_parallel_tool_calls.setter
    def is_parallel_tool_calls(self, is_parallel_tool_calls):
        """
        Sets the is_parallel_tool_calls of this GenericChatRequest.
        Whether to enable parallel function calling during tool use.


        :param is_parallel_tool_calls: The is_parallel_tool_calls of this GenericChatRequest.
        :type: bool
        """
        self._is_parallel_tool_calls = is_parallel_tool_calls

    @property
    def tools(self):
        """
        Gets the tools of this GenericChatRequest.
        A list of tools the model may call. Use this to provide a list of functions the model may generate JSON inputs for. A max of 128 functions are supported.


        :return: The tools of this GenericChatRequest.
        :rtype: list[oci.generative_ai_inference.models.ToolDefinition]
        """
        return self._tools

    @tools.setter
    def tools(self, tools):
        """
        Sets the tools of this GenericChatRequest.
        A list of tools the model may call. Use this to provide a list of functions the model may generate JSON inputs for. A max of 128 functions are supported.


        :param tools: The tools of this GenericChatRequest.
        :type: list[oci.generative_ai_inference.models.ToolDefinition]
        """
        self._tools = tools

    @property
    def web_search_options(self):
        """
        Gets the web_search_options of this GenericChatRequest.

        :return: The web_search_options of this GenericChatRequest.
        :rtype: oci.generative_ai_inference.models.WebSearchOptions
        """
        return self._web_search_options

    @web_search_options.setter
    def web_search_options(self, web_search_options):
        """
        Sets the web_search_options of this GenericChatRequest.

        :param web_search_options: The web_search_options of this GenericChatRequest.
        :type: oci.generative_ai_inference.models.WebSearchOptions
        """
        self._web_search_options = web_search_options

    @property
    def service_tier(self):
        """
        Gets the service_tier of this GenericChatRequest.
        Specifies the processing type used for serving the request.

        Allowed values for this property are: "AUTO", "DEFAULT", "PRIORITY"


        :return: The service_tier of this GenericChatRequest.
        :rtype: str
        """
        return self._service_tier

    @service_tier.setter
    def service_tier(self, service_tier):
        """
        Sets the service_tier of this GenericChatRequest.
        Specifies the processing type used for serving the request.


        :param service_tier: The service_tier of this GenericChatRequest.
        :type: str
        """
        allowed_values = ["AUTO", "DEFAULT", "PRIORITY"]
        if not value_allowed_none_or_none_sentinel(service_tier, allowed_values):
            raise ValueError(
                f"Invalid value for `service_tier`, must be None or one of {allowed_values}"
            )
        self._service_tier = service_tier

    def __repr__(self):
        return formatted_flat_dict(self)

    def __eq__(self, other):
        if other is None:
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not self == other
