# coding: utf-8
# Copyright (c) 2016, 2026, Oracle and/or its affiliates.  All rights reserved.
# This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.

# NOTE: This class is auto generated by OracleSDKGenerator. DO NOT EDIT. API Version: 20231130

from .prediction import Prediction
from oci.util import formatted_flat_dict, NONE_SENTINEL, value_allowed_none_or_none_sentinel  # noqa: F401
from oci.decorators import init_model_state_from_kwargs


@init_model_state_from_kwargs
class StaticContent(Prediction):
    """
    Static predicted output content, such as the content of a text file that is being regenerated.
    """

    def __init__(self, **kwargs):
        """
        Initializes a new StaticContent object with values from keyword arguments. The default value of the :py:attr:`~oci.generative_ai_inference.models.StaticContent.type` attribute
        of this class is ``CONTENT`` and it should not be changed.
        The following keyword arguments are supported (corresponding to the getters/setters of this class):

        :param type:
            The value to assign to the type property of this StaticContent.
            Allowed values for this property are: "CONTENT"
        :type type: str

        :param content:
            The value to assign to the content property of this StaticContent.
        :type content: list[oci.generative_ai_inference.models.TextContent]

        """
        self.swagger_types = {
            'type': 'str',
            'content': 'list[TextContent]'
        }
        self.attribute_map = {
            'type': 'type',
            'content': 'content'
        }
        self._type = None
        self._content = None
        self._type = 'CONTENT'

    @property
    def content(self):
        """
        Gets the content of this StaticContent.
        The content that should be matched when generating a model response. If generated tokens would match this content, the entire model response can be returned much more quickly.


        :return: The content of this StaticContent.
        :rtype: list[oci.generative_ai_inference.models.TextContent]
        """
        return self._content

    @content.setter
    def content(self, content):
        """
        Sets the content of this StaticContent.
        The content that should be matched when generating a model response. If generated tokens would match this content, the entire model response can be returned much more quickly.


        :param content: The content of this StaticContent.
        :type: list[oci.generative_ai_inference.models.TextContent]
        """
        self._content = content

    def __repr__(self):
        return formatted_flat_dict(self)

    def __eq__(self, other):
        if other is None:
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not self == other
